/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.rule.parsers;

import eu.kliegr.ac1.data.Attribute;
import eu.kliegr.ac1.data.AttributeType;
import eu.kliegr.ac1.data.AttributeValue;
import eu.kliegr.ac1.data.AttributeValueType;
import eu.kliegr.ac1.rule.Antecedent;
import eu.kliegr.ac1.rule.AttributeNotFoundException;
import eu.kliegr.ac1.rule.Consequent;
import eu.kliegr.ac1.rule.Data;
import eu.kliegr.ac1.rule.Rule;
import eu.kliegr.ac1.rule.RuleMultiItem;
import eu.kliegr.ac1.rule.RuleQuality;
import eu.kliegr.ac1.rule.extend.ExtendRule;
import eu.kliegr.ac1.rule.extend.ExtendRules;
import eu.kliegr.ac1.rule.parsers.InvalidAttributeTypeException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ArulesParser {
    private final Pattern pattern = Pattern.compile("([^,]*?)=([^,]*)");
    private final Pattern intervalPattern = Pattern.compile("(\\[|\\()( ?-?(?:Inf|Infinity|\\d+(?:(?:\\.\\d+)?(?:[Ee][-+]?\\d+)?)?)); ?(-?(?:Inf|Infinity|(?:\\d+(?:(?:\\.\\d+)?(?:[Ee][-+]?\\d+)?)?)))(\\]|\\))");
    private final Data data;
    private static final Logger LOG = Logger.getLogger(ArulesParser.class.getName());

    public ArulesParser(Data data) {
        this.data = data;
    }

    public static String normInfinity(String numericalValue) {
        if (numericalValue.contains("Infinity")) {
            return numericalValue;
        }
        if (numericalValue.contains("Inf")) {
            return numericalValue.replace("Inf", "Infinity");
        }
        return numericalValue;
    }

    public static void saveRules(ExtendRules rules, String path) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        FileOutputStream os = new FileOutputStream(new File(path));
        OutputStreamWriter o = new OutputStreamWriter((OutputStream)os, "utf-8");
        BufferedWriter writer = new BufferedWriter(o);
        int i = 1;
        writer.write("\"\",\"rules\",\"support\",\"confidence\"\n");
        for (ExtendRule r : rules.getExtendedRules()) {
            writer.write("\"" + i++ + "\",\"" + r.getRule().getRuleAsArulesString() + "\"," + Double.toString(r.getRuleQuality().getRelativeSupport()) + "," + Double.toString(r.getRuleQuality().getConfidence()) + "\n");
        }
        ((Writer)writer).flush();
        ((OutputStream)os).close();
    }

    public ArrayList<Rule> parseFileForRules(String path) throws FileNotFoundException, IOException, Exception {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        BufferedReader br = new BufferedReader(new FileReader(path));
        String line = br.readLine();
        while (line != null) {
            line = br.readLine();
            Rule r = this.parseRule(line);
            if (r == null) continue;
            rules.add(r);
        }
        br.close();
        return rules;
    }

    public Rule parseRule(String text) throws Exception {
        if (text == null || text.length() == 0) {
            return null;
        }
        String[] parts = text.split("\",");
        if (parts.length < 2 | parts.length > 3) {
            return null;
        }
        int offset = 0;
        if (parts.length == 3) {
            offset = 1;
        }
        int ruleid = Integer.parseInt(parts[0].replace("\"", ""));
        String[] ruleparts = parts[0 + offset].replace("\"", "").split("\\} => \\{");
        for (int i = 0; i < ruleparts.length; ++i) {
            ruleparts[i] = ruleparts[i].replace("{", "").replace("}", "").trim();
        }
        ArrayList<RuleMultiItem> antParts = this.parseRulePart(ruleparts[0]);
        Antecedent ant = new Antecedent(antParts);
        ArrayList<RuleMultiItem> conParts = this.parseRulePart(ruleparts[1]);
        Consequent con = new Consequent(conParts.get(0));
        String[] ruleQualityParts = parts[1 + offset].split(",");
        float support = Float.parseFloat(ruleQualityParts[0]);
        float confidence = Float.parseFloat(ruleQualityParts[1]);
        RuleQuality qm = new RuleQuality(support, confidence, this.data.getDataTable().getCurrentTransactionCount());
        Rule r = new Rule(ant, con, qm, null, ruleid, null, this.data);
        return r;
    }

    public Rule parseRule(String rule, float confidence, float support, int ruleid) throws AttributeNotFoundException, InvalidAttributeTypeException {
        LOG.log(Level.FINEST, "Starting to parse rule: {0}, confidence={1}, support={2}", new Object[]{rule, Float.valueOf(confidence), Float.valueOf(support)});
        LOG.finest(rule);
        String[] ruleparts = rule.replace("\"", "").split("\\} => \\{");
        for (int i = 0; i < ruleparts.length; ++i) {
            ruleparts[i] = ruleparts[i].replace("{", "").replace("}", "").trim();
        }
        ArrayList<RuleMultiItem> antParts = this.parseRulePart(ruleparts[0]);
        Antecedent ant = new Antecedent(antParts);
        ArrayList<RuleMultiItem> conParts = this.parseRulePart(ruleparts[1]);
        Consequent con = new Consequent(conParts.get(0));
        RuleQuality qm = new RuleQuality(support, confidence, this.data.getDataTable().getCurrentTransactionCount());
        Rule r = new Rule(ant, con, qm, null, ruleid, null, this.data);
        return r;
    }

    private ArrayList<RuleMultiItem> parseRulePart(String part) throws AttributeNotFoundException, InvalidAttributeTypeException {
        String[] attrs;
        ArrayList<RuleMultiItem> out = new ArrayList<RuleMultiItem>();
        for (String attr : attrs = part.split(",")) {
            ArrayList<AttributeValue> values;
            Matcher matcher = this.pattern.matcher(attr);
            if (!matcher.matches()) continue;
            String attname = matcher.group(1);
            Attribute att = this.data.getDataTable().getAttribute(attname);
            String value = matcher.group(2);
            Matcher intervalMatcher = this.intervalPattern.matcher(value);
            AttributeType attType = att.getType();
            boolean matchesNumeric = intervalMatcher.matches();
            if (attType == AttributeType.nominal && matchesNumeric) {
                String message = "Passed attribute value looks like interval, but the attribute is nominal!. \n Offending attribute:" + attname + "\n Rule part:" + part;
                throw new InvalidAttributeTypeException(message);
            }
            if (matchesNumeric) {
                float rightMargin;
                boolean fromInclusive = intervalMatcher.group(1).equals("[");
                boolean toInclusive = intervalMatcher.group(4).equals("]");
                float leftMargin = Float.parseFloat(ArulesParser.normInfinity(intervalMatcher.group(2)));
                values = new ArrayList<AttributeValue>(this.data.getValuesInRange(attname, leftMargin, fromInclusive, rightMargin = Float.parseFloat(ArulesParser.normInfinity(intervalMatcher.group(3))), toInclusive, false));
                if (values.size() > 1) {
                    if (leftMargin == Float.NEGATIVE_INFINITY) {
                        LOG.info("Detecting negative infinity boundary on attribute " + attname);
                        this.data.getDataTable().getAttribute(attname);
                        AttributeValue negInf = att.getAdjacentLower(values.get(0));
                        if (negInf == null) {
                            negInf = att.addNewValue(String.valueOf(Float.NEGATIVE_INFINITY), null, AttributeValueType.breakpoint);
                        }
                        values.add(0, negInf);
                    }
                    if (rightMargin == Float.POSITIVE_INFINITY) {
                        LOG.info("Detecting positivie infinity boundary on attribute " + attname);
                        this.data.getDataTable().getAttribute(attname);
                        AttributeValue posInf = att.getAdjacentHigher(values.get(values.size() - 1));
                        if (posInf == null) {
                            posInf = att.addNewValue(String.valueOf(Float.POSITIVE_INFINITY), null, AttributeValueType.breakpoint);
                        }
                        values.add(posInf);
                    }
                }
            } else {
                AttributeValue val = this.data.getValue(attname, value, AttributeValueType.breakpoint);
                values = new ArrayList<AttributeValue>();
                values.add(val);
            }
            RuleMultiItem rmi = this.data.makeRuleItem(values, attname);
            out.add(rmi);
        }
        return out;
    }
}

