/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import opennlp.tools.postag.POSSample;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordTagSampleStream
extends FilterObjectStream<String, POSSample> {
    private static Logger logger = Logger.getLogger(WordTagSampleStream.class.getName());

    public WordTagSampleStream(Reader sentences) throws IOException {
        super(new PlainTextByLineStream(sentences));
    }

    public WordTagSampleStream(ObjectStream<String> sentences) {
        super(sentences);
    }

    @Override
    public POSSample read() throws IOException {
        String sentence = (String)this.samples.read();
        if (sentence != null) {
            POSSample sample;
            try {
                sample = POSSample.parse(sentence);
            }
            catch (InvalidFormatException e) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.warning("Error during parsing, ignoring sentence: " + sentence);
                }
                sample = new POSSample(new String[0], new String[0]);
            }
            return sample;
        }
        return null;
    }
}

