/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import java.io.PrintWriter;
import java.io.Writer;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.ext.EdgeNameProvider;
import org.jgrapht.ext.IntegerEdgeNameProvider;
import org.jgrapht.ext.IntegerNameProvider;
import org.jgrapht.ext.VertexNameProvider;

public class GmlExporter<V, E> {
    private static final String creator = "JGraphT GML Exporter";
    private static final String version = "1";
    private static final String delim = " ";
    private static final String tab1 = "\t";
    private static final String tab2 = "\t\t";
    public static final Integer PRINT_NO_LABELS = 1;
    public static final Integer PRINT_EDGE_LABELS = 2;
    public static final Integer PRINT_EDGE_VERTEX_LABELS = 3;
    public static final Integer PRINT_VERTEX_LABELS = 4;
    private Integer printLabels = PRINT_NO_LABELS;
    private VertexNameProvider<V> vertexIDProvider;
    private VertexNameProvider<V> vertexLabelProvider;
    private EdgeNameProvider<E> edgeIDProvider;
    private EdgeNameProvider<E> edgeLabelProvider;

    public GmlExporter() {
        this(new IntegerNameProvider(), null, new IntegerEdgeNameProvider(), null);
    }

    public GmlExporter(VertexNameProvider<V> vertexNameProvider, VertexNameProvider<V> vertexNameProvider2, EdgeNameProvider<E> edgeNameProvider, EdgeNameProvider<E> edgeNameProvider2) {
        this.vertexIDProvider = vertexNameProvider;
        this.vertexLabelProvider = vertexNameProvider2;
        this.edgeIDProvider = edgeNameProvider;
        this.edgeLabelProvider = edgeNameProvider2;
    }

    private String quoted(String string) {
        return "\"" + string + "\"";
    }

    private void exportHeader(PrintWriter printWriter) {
        printWriter.println("Creator " + this.quoted(creator));
        printWriter.println("Version 1");
    }

    private void exportVertices(PrintWriter printWriter, Graph<V, E> graph) {
        for (V v : graph.vertexSet()) {
            printWriter.println("\tnode");
            printWriter.println("\t[");
            printWriter.println("\t\tid " + this.vertexIDProvider.getVertexName(v));
            if (this.printLabels == PRINT_VERTEX_LABELS || this.printLabels == PRINT_EDGE_VERTEX_LABELS) {
                String string = this.vertexLabelProvider == null ? v.toString() : this.vertexLabelProvider.getVertexName(v);
                printWriter.println("\t\tlabel " + this.quoted(string));
            }
            printWriter.println("\t]");
        }
    }

    private void exportEdges(PrintWriter printWriter, Graph<V, E> graph) {
        for (E e : graph.edgeSet()) {
            printWriter.println("\tedge");
            printWriter.println("\t[");
            String string = this.edgeIDProvider.getEdgeName(e);
            printWriter.println("\t\tid " + string);
            String string2 = this.vertexIDProvider.getVertexName(graph.getEdgeSource(e));
            printWriter.println("\t\tsource " + string2);
            String string3 = this.vertexIDProvider.getVertexName(graph.getEdgeTarget(e));
            printWriter.println("\t\ttarget " + string3);
            if (this.printLabels == PRINT_EDGE_LABELS || this.printLabels == PRINT_EDGE_VERTEX_LABELS) {
                String string4 = this.edgeLabelProvider == null ? e.toString() : this.edgeLabelProvider.getEdgeName(e);
                printWriter.println("\t\tlabel " + this.quoted(string4));
            }
            printWriter.println("\t]");
        }
    }

    private void export(Writer writer, Graph<V, E> graph, boolean bl) {
        PrintWriter printWriter = new PrintWriter(writer);
        for (V v : graph.vertexSet()) {
            this.vertexIDProvider.getVertexName(v);
        }
        this.exportHeader(printWriter);
        printWriter.println("graph");
        printWriter.println("[");
        printWriter.println("\tlabel " + this.quoted(""));
        if (bl) {
            printWriter.println("\tdirected 1");
        } else {
            printWriter.println("\tdirected 0");
        }
        this.exportVertices(printWriter, graph);
        this.exportEdges(printWriter, graph);
        printWriter.println("]");
        printWriter.flush();
    }

    public void export(Writer writer, UndirectedGraph<V, E> undirectedGraph) {
        this.export(writer, undirectedGraph, false);
    }

    public void export(Writer writer, DirectedGraph<V, E> directedGraph) {
        this.export(writer, directedGraph, true);
    }

    public void setPrintLabels(Integer n) {
        if (n != PRINT_NO_LABELS && n != PRINT_EDGE_LABELS && n != PRINT_EDGE_VERTEX_LABELS && n != PRINT_VERTEX_LABELS) {
            throw new IllegalArgumentException("Non-supported parameter value: " + Integer.toString(n));
        }
        this.printLabels = n;
    }

    public Integer getPrintLabels() {
        return this.printLabels;
    }
}

