/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.integer.AbstractBinIntSConstraint;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class NotEqualXYC
extends AbstractBinIntSConstraint {
    protected final int cste;

    public NotEqualXYC(IntDomainVar x0, IntDomainVar x1, int c) {
        super(x0, x1);
        this.cste = c;
    }

    @Override
    public int getFilteredEventMask(int idx) {
        IntDomainVar v = idx == 0 ? this.v1 : this.v0;
        return v.hasEnumeratedDomain() ? 8 : 11;
    }

    private void removeValV0() throws ContradictionException {
        if (this.v0.removeVal(this.v1.getVal() + this.cste, this, false)) {
            this.setEntailed();
        } else if (!this.v0.canBeInstantiatedTo(this.v1.getVal() + this.cste)) {
            this.setEntailed();
        }
    }

    private void removeValV1() throws ContradictionException {
        if (this.v1.removeVal(this.v0.getVal() - this.cste, this, false)) {
            this.setEntailed();
        } else if (!this.v1.canBeInstantiatedTo(this.v0.getVal() - this.cste)) {
            this.setEntailed();
        }
    }

    @Override
    public final void propagate() throws ContradictionException {
        if (this.v0.isInstantiated()) {
            this.removeValV1();
        } else if (this.v1.isInstantiated()) {
            this.removeValV0();
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        this.propagate();
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        this.propagate();
    }

    @Override
    public final void awakeOnInst(int idx) throws ContradictionException {
        if (idx == 0) {
            this.removeValV1();
        } else {
            assert (idx == 1);
            this.removeValV0();
        }
    }

    @Override
    public void awakeOnRem(int varIdx, int val) throws ContradictionException {
    }

    @Override
    public void awakeOnRemovals(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
    }

    @Override
    public Boolean isEntailed() {
        if (this.v0.getSup() < this.v1.getInf() + this.cste || this.v1.getSup() < this.v0.getInf() - this.cste) {
            return Boolean.TRUE;
        }
        if (this.v0.isInstantiated() && this.v1.isInstantiated() && this.v0.getInf() == this.v1.getInf() + this.cste) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return tuple[0] != tuple[1] + this.cste;
    }

    @Override
    public boolean isConsistent() {
        return this.v0.isInstantiated() ? (this.v1.hasEnumeratedDomain() ? !this.v1.canBeInstantiatedTo(this.v0.getVal()) : this.v1.getInf() != this.v0.getVal() && this.v1.getSup() != this.v0.getVal()) : !this.v1.isInstantiated() || (this.v0.hasEnumeratedDomain() ? !this.v0.canBeInstantiatedTo(this.v1.getVal()) : this.v0.getInf() != this.v1.getVal() && this.v0.getSup() != this.v1.getVal());
    }

    @Override
    public AbstractSConstraint<IntDomainVar> opposite(Solver solver) {
        return (AbstractSConstraint)solver.eq((IntExp)this.v0, solver.plus((IntExp)this.v1, this.cste));
    }

    @Override
    public String pretty() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.v0).append(" != ");
        sb.append(this.v1).append(StringUtils.pretty(this.cste));
        return sb.toString();
    }
}

