/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.geost.util;

import choco.cp.solver.constraints.global.geost.Constants;
import choco.cp.solver.constraints.global.geost.Setup;
import choco.cp.solver.constraints.global.geost.geometricPrim.Obj;
import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.model.variables.geost.ShiftedBox;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class VRMLwriter {
    protected static final Logger LOGGER = ChocoLogging.getEngineLogger();
    public static final String VRML_OUTPUT_FOLDER = "";

    private VRMLwriter() {
    }

    public static boolean printVRML3D(Setup s, Constants c, String name) {
        return VRMLwriter.printVRML3D(s, c, VRML_OUTPUT_FOLDER, name);
    }

    public static boolean printVRML3D(Setup s, Constants c, String outPut, String name) {
        String str = VRML_OUTPUT_FOLDER + outPut + name + ".wrl";
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(str));
            LOGGER.log(Level.INFO, "writing the VRML to : {0}", str);
            Iterator<Integer> itr = s.objects.keySet().iterator();
            int kdim = 0;
            kdim = c.getDIM() == 2 ? 2 : (c.getDIM() == 3 ? 3 : 0);
            out.write("#VRML V2.0 utf8\n");
            if (kdim > 1 && kdim < 4) {
                while (itr.hasNext()) {
                    int id = itr.next();
                    Obj o = s.getObject(id);
                    StringBuilder temp = new StringBuilder();
                    for (int i = 0; i < c.getDIM(); ++i) {
                        temp.append(o.getCoord(i).getInf()).append(" ");
                    }
                    if (kdim == 2) {
                        temp.append(" 0.0 ");
                    }
                    out.write("Transform { translation " + temp.toString() + '\n');
                    out.write("children [ \n");
                    List<ShiftedBox> sb = s.shapes.get(o.getShapeId().getInf());
                    Random rnd = new Random();
                    float fDiff1 = rnd.nextFloat();
                    float fDiff2 = rnd.nextFloat();
                    float fDiff3 = rnd.nextFloat();
                    float fSpec1 = rnd.nextFloat();
                    float fSpec2 = rnd.nextFloat();
                    float fSpec3 = rnd.nextFloat();
                    float shine = rnd.nextFloat();
                    String appearance = "appearance  Appearance {material  Material {  ambientIntensity  0.25  diffuseColor  " + fDiff1 + " " + fDiff2 + " " + fDiff3 + " " + " specularColor  " + fSpec1 + " " + fSpec2 + " " + fSpec3 + " " + " emissiveColor  0 0 0 " + " shininess  " + shine + " " + " transparency  0.40 }} ";
                    double sizeOnZOfFirstShiftedBoxOfObject = 0.0;
                    for (int i = 0; i < sb.size(); ++i) {
                        int j;
                        temp.setLength(0);
                        for (j = 0; j < c.getDIM(); ++j) {
                            double k = (float)sb.get(i).getOffset(j) + (float)sb.get(i).getSize(j) / 2.0f;
                            temp.append(VRML_OUTPUT_FOLDER).append(k).append(" ");
                        }
                        sizeOnZOfFirstShiftedBoxOfObject = sb.get(0).getSize(c.getDIM() - 1);
                        if (kdim == 2) {
                            temp.append(" 0.0 ");
                        }
                        out.write("Transform { translation " + temp.toString() + '\n');
                        out.write("children [ ");
                        temp.setLength(0);
                        for (j = 0; j < c.getDIM(); ++j) {
                            int k = sb.get(i).getSize(j);
                            temp.append(VRML_OUTPUT_FOLDER).append(k).append(" ");
                        }
                        if (kdim == 2) {
                            temp.append(" 0.0 ");
                        }
                        out.write("Shape { " + appearance);
                        out.write(" geometry Box { size " + temp.toString() + "}}]}" + '\n');
                    }
                    out.write(" Transform { translation .0 .0 " + sizeOnZOfFirstShiftedBoxOfObject + " \n");
                    out.write("children [ ");
                    out.write("   Shape {appearance Appearance { material Material { diffuseColor .0 .0 .0  transparency  0}} geometry Text { string [ \" " + o.getObjectId() + "\" ");
                    out.write("]  fontStyle FontStyle { style \"BOLD\" size 2.0 }}}\n");
                    out.write(" ]} \n");
                    out.write(" ]} \n");
                }
                StringBuilder temp = new StringBuilder();
                if (kdim == 3) {
                    temp.append(" 25.0 0.1 0.1 ");
                    out.write("Transform { translation " + temp.toString() + '\n');
                    out.write("children [ ");
                    out.write("Shape { appearance  Appearance {material  Material {  diffuseColor  1.0 0.0 0.0 }} ");
                    out.write(" geometry Box { size 50.0 0.2 0.2 }}]}\n");
                    temp.setLength(0);
                    temp.append(" 0.1 25.0 0.1 ");
                    out.write("Transform { translation " + temp.toString() + '\n');
                    out.write("children [ ");
                    out.write("Shape { appearance  Appearance {material  Material {  diffuseColor  0.0 1.0 0.0 }} ");
                    out.write(" geometry Box { size 0.2 50.0 0.2 }}]}\n");
                    temp.setLength(0);
                    temp.append(" 0.1 0.1 25.0 ");
                    out.write("Transform { translation " + temp.toString() + '\n');
                    out.write("children [ ");
                    out.write("Shape { appearance  Appearance {material  Material {  diffuseColor  0.0 0.0 1.0 }} ");
                    out.write(" geometry Box { size 0.2 0.2 50.0 }}]}\n");
                } else if (kdim == 2) {
                    temp.setLength(0);
                    temp.append(" 25.0 0.1 0.0 ");
                    out.write("Transform { translation " + temp.toString() + '\n');
                    out.write("children [ ");
                    out.write("Shape { appearance  Appearance {material  Material {  diffuseColor  1.0 0.0 0.0 }} ");
                    out.write(" geometry Box { size 50.0 0.2 0.0 }}]}\n");
                    temp.setLength(0);
                    temp.append(" 0.1 25.0 0.0 ");
                    out.write("Transform { translation " + temp.toString() + '\n');
                    out.write("children [ ");
                    out.write("Shape { appearance  Appearance {material  Material {  diffuseColor  0.0 1.0 0.0 }} ");
                    out.write(" geometry Box { size 0.2 50.0 0.0 }}]}\n");
                }
                out.close();
            } else {
                LOGGER.severe("Dimension is not 2 nor 3 therefore no VRML file was written.");
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "ERROR; Couldn't write VRML file");
        }
        return true;
    }

    public static boolean printVRML3D(Setup s, Constants c, String prefix, int solNb) {
        String str = MessageFormat.format("{0}_{1}", prefix, solNb);
        return VRMLwriter.printVRML3D(s, c, str);
    }

    public static boolean printVRML3D(Setup s, Constants c, String output, String prefix, int solNb) {
        String str = MessageFormat.format("{0}_{1}", prefix, solNb);
        return VRMLwriter.printVRML3D(s, c, output, str);
    }
}

