/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.preprocessor;

import choco.cp.common.util.preprocessor.AbstractDetector;
import choco.cp.common.util.preprocessor.DetectorFactory;
import choco.cp.common.util.preprocessor.detector.AbstractIntegerVariableEqualitiesDetector;
import choco.cp.common.util.preprocessor.detector.AbstractTaskVariableEqualitiesDetector;
import choco.cp.common.util.preprocessor.detector.AnalysisModelDetector;
import choco.cp.common.util.preprocessor.detector.CliquesModelDetector;
import choco.cp.common.util.preprocessor.detector.scheduling.ClauseFromDisjointModelDetector;
import choco.cp.common.util.preprocessor.detector.scheduling.DisjFromCumulModelDetector;
import choco.cp.common.util.preprocessor.detector.scheduling.DisjointFromCumulModelDetector;
import choco.cp.common.util.preprocessor.detector.scheduling.DisjointFromUnaryModelDetector;
import choco.cp.common.util.preprocessor.detector.scheduling.DisjointModelDetector;
import choco.cp.common.util.preprocessor.detector.scheduling.DisjunctiveModel;
import choco.cp.common.util.preprocessor.detector.scheduling.PrecFromDisjointModelDetector;
import choco.cp.common.util.preprocessor.detector.scheduling.PrecFromImpliedModelDetector;
import choco.cp.common.util.preprocessor.detector.scheduling.PrecFromReifiedModelDetector;
import choco.cp.common.util.preprocessor.detector.scheduling.PrecFromTimeWindowModelDetector;
import choco.cp.common.util.preprocessor.detector.scheduling.PrecReductionModelDetector;
import choco.cp.common.util.preprocessor.detector.scheduling.RmUnaryModelDetector;
import choco.cp.model.CPModel;
import choco.kernel.common.util.tools.ArrayUtils;

public final class ModelDetectorFactory
extends DetectorFactory {
    public static void run(CPModel model, AbstractDetector ... detectors) {
        ModelDetectorFactory.associateIndexes(model);
        for (AbstractDetector detector : detectors) {
            detector.applyThenCommit();
        }
        ModelDetectorFactory.resetIndexes(model);
    }

    public static AbstractDetector analysis(CPModel m) {
        return new AnalysisModelDetector(m);
    }

    public static AbstractDetector intVarEqDet(CPModel m) {
        return new AbstractIntegerVariableEqualitiesDetector.IntegerVariableEqualitiesModelDetector(m);
    }

    public static AbstractDetector taskVarEqDet(CPModel m) {
        return new AbstractTaskVariableEqualitiesDetector.TaskVariableEqualitiesModelDetector(m);
    }

    public static AbstractDetector cliqueDetector(CPModel m, boolean breakSymetries) {
        return new CliquesModelDetector(m, breakSymetries);
    }

    public static AbstractDetector disjFromCumulDetector(CPModel m) {
        return new DisjFromCumulModelDetector(m);
    }

    public static AbstractDetector precFromImpliedDetector(CPModel m, DisjunctiveModel disjMod) {
        return new PrecFromImpliedModelDetector(m, disjMod);
    }

    public static AbstractDetector precFromReifiedDetector(CPModel m, DisjunctiveModel disjMod) {
        return new PrecFromReifiedModelDetector(m, disjMod);
    }

    public static AbstractDetector precFromTimeWindowDetector(CPModel m, DisjunctiveModel disjMod) {
        return new PrecFromTimeWindowModelDetector(m, disjMod);
    }

    public static AbstractDetector precFromDisjointDetector(CPModel m, DisjunctiveModel disjMod) {
        return new PrecFromDisjointModelDetector(m, disjMod);
    }

    public static AbstractDetector disjointDetector(CPModel m, DisjunctiveModel disjMod) {
        return new DisjointModelDetector(m, disjMod);
    }

    public static AbstractDetector disjointFromUnaryDetector(CPModel m, DisjunctiveModel disjMod) {
        return new DisjointFromUnaryModelDetector(m, disjMod);
    }

    public static AbstractDetector disjointFromCumulDetector(CPModel m, DisjunctiveModel disjMod) {
        return new DisjointFromCumulModelDetector(m, disjMod);
    }

    public static AbstractDetector clauseFromDisjointDetector(CPModel m, DisjunctiveModel disjMod) {
        return new ClauseFromDisjointModelDetector(m, disjMod);
    }

    public static AbstractDetector precReductionDetector(CPModel m, DisjunctiveModel disjMod) {
        return new PrecReductionModelDetector(m, disjMod);
    }

    public static AbstractDetector rmDisjDetector(CPModel m) {
        return new RmUnaryModelDetector(m);
    }

    public static AbstractDetector[] disjunctiveModelDetectors(CPModel m, DisjunctiveModel disjMod, boolean generateClauses) {
        AbstractDetector[] abstractDetectorArray;
        if (generateClauses) {
            AbstractDetector[] abstractDetectorArray2 = new AbstractDetector[8];
            abstractDetectorArray2[0] = ModelDetectorFactory.precFromImpliedDetector(m, disjMod);
            abstractDetectorArray2[1] = ModelDetectorFactory.precFromReifiedDetector(m, disjMod);
            abstractDetectorArray2[2] = ModelDetectorFactory.precFromDisjointDetector(m, disjMod);
            abstractDetectorArray2[3] = ModelDetectorFactory.disjointDetector(m, disjMod);
            abstractDetectorArray2[4] = ModelDetectorFactory.disjointFromUnaryDetector(m, disjMod);
            abstractDetectorArray2[5] = ModelDetectorFactory.disjointFromCumulDetector(m, disjMod);
            abstractDetectorArray2[6] = ModelDetectorFactory.clauseFromDisjointDetector(m, disjMod);
            abstractDetectorArray = abstractDetectorArray2;
            abstractDetectorArray2[7] = ModelDetectorFactory.precReductionDetector(m, disjMod);
        } else {
            AbstractDetector[] abstractDetectorArray3 = new AbstractDetector[7];
            abstractDetectorArray3[0] = ModelDetectorFactory.precFromImpliedDetector(m, disjMod);
            abstractDetectorArray3[1] = ModelDetectorFactory.precFromReifiedDetector(m, disjMod);
            abstractDetectorArray3[2] = ModelDetectorFactory.precFromDisjointDetector(m, disjMod);
            abstractDetectorArray3[3] = ModelDetectorFactory.disjointDetector(m, disjMod);
            abstractDetectorArray3[4] = ModelDetectorFactory.disjointFromUnaryDetector(m, disjMod);
            abstractDetectorArray3[5] = ModelDetectorFactory.disjointFromCumulDetector(m, disjMod);
            abstractDetectorArray = abstractDetectorArray3;
            abstractDetectorArray3[6] = ModelDetectorFactory.precReductionDetector(m, disjMod);
        }
        return abstractDetectorArray;
    }

    public static AbstractDetector[] allSchedulingModelDetectors(CPModel m, DisjunctiveModel disjMod) {
        return ArrayUtils.append({ModelDetectorFactory.precFromTimeWindowDetector(m, disjMod), ModelDetectorFactory.disjFromCumulDetector(m)}, ModelDetectorFactory.disjunctiveModelDetectors(m, disjMod, true), {ModelDetectorFactory.rmDisjDetector(m)});
    }
}

