/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive;

import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.stat.descriptive.UnivariateStatistic;

public abstract class AbstractUnivariateStatistic
implements UnivariateStatistic {
    public double evaluate(double[] values) {
        this.test(values, 0, 0);
        return this.evaluate(values, 0, values.length);
    }

    public abstract double evaluate(double[] var1, int var2, int var3);

    public abstract UnivariateStatistic copy();

    protected boolean test(double[] values, int begin, int length) {
        if (values == null) {
            throw MathRuntimeException.createIllegalArgumentException("input values array is null", new Object[0]);
        }
        if (begin < 0) {
            throw MathRuntimeException.createIllegalArgumentException("start position cannot be negative ({0})", begin);
        }
        if (length < 0) {
            throw MathRuntimeException.createIllegalArgumentException("length cannot be negative ({0})", length);
        }
        if (begin + length > values.length) {
            throw MathRuntimeException.createIllegalArgumentException("subarray ends after array end", new Object[0]);
        }
        return length != 0;
    }

    protected boolean test(double[] values, double[] weights, int begin, int length) {
        if (weights == null) {
            throw MathRuntimeException.createIllegalArgumentException("input weights array is null", new Object[0]);
        }
        if (weights.length != values.length) {
            throw MathRuntimeException.createIllegalArgumentException("Different number of weights and values", new Object[0]);
        }
        boolean containsPositiveWeight = false;
        for (int i = begin; i < begin + length; ++i) {
            if (Double.isNaN(weights[i])) {
                throw MathRuntimeException.createIllegalArgumentException("NaN weight at index {0}", i);
            }
            if (Double.isInfinite(weights[i])) {
                throw MathRuntimeException.createIllegalArgumentException("Infinite weight at index {0}", i);
            }
            if (weights[i] < 0.0) {
                throw MathRuntimeException.createIllegalArgumentException("negative weight {0} at index {1} ", weights[i], i);
            }
            if (containsPositiveWeight || !(weights[i] > 0.0)) continue;
            containsPositiveWeight = true;
        }
        if (!containsPositiveWeight) {
            throw MathRuntimeException.createIllegalArgumentException("weight array must contain at least one non-zero value", new Object[0]);
        }
        return this.test(values, begin, length);
    }
}

