#' Leaf angle distribution data measured in two sites of Ku-ringgai Chase National Park, Sydney, Australia
#' and provided by Dr. D.S. Falster of Macquarie University, Australia
#' @description Leaf angle distribution data measured in two sites of Ku-ringgai Chase National Park, Sydney, Australia
#' and provided by Dr. D.S. Falster of Macquarie University, Australia.
#' @references  Falster, D. and Westoby, M., 2003. 
#' Leaf size and angle vary widely across species: what consequences for light interception? New Phytol.158, 509–525.


Falster <- structure(list(Speciesnames = c("acaflo", "acamyr", "acasua", 
"anghis", "astflo", "banmar", "banobl", "borpin", "breobl", "conlon", 
"epapul", "eriaus", "eucgum", "euchae", "gomlat", "grebux", "grespe", 
"hakdac", "hibbra", "isoane", "kunpar", "lamfor", "lasfer", "lepspp", 
"leptri", "leumic", "lomsil", "perlan", "perlev", "phyphy", "pomfur", 
"puldap", "pulell", "pulsti", "rapvar", "syngla", "synglo", "treasp"
), acaflo = c(81, 89, 89, 81, 37, 88, 80, 68, 81, 58, 77, 66, 
57, 22, 48, 26, 73, 19, 62, 84, 58, 62, 58, 83, 77, 24, 25, 49, 
25, 39, 78, 72, 82, 11, 85, 71, 56, 74, 82, 48, 65, 24, 10, 50, 
49, 79, 50, 81, 85, 80, 89, 80, 85, 82, 82, 85, 33, 54, 35, 56, 
70, 85, 57, 62, 44, 10, 19, 62, 90, 65, 14, 76, 76, 76, 87, 74, 
80, 39, 32, 75, 33, 58, 63, 32, 59, 58, 76, 72, 70, 70, 65, 86, 
42, 70, 82, 82, 87, 46, 58, 83, 14, 73, 64, 74, 54, 24, 80, 43, 
57, 63, 20, 6, 34, 51, 85, 88, 79, 35, 52, 39, 66, 59, 14, 17, 
75, 54, 18, 66, 43, 34, 65, 80, 21, 63, 46, 82, 29, 10, 65, 33, 
88, 30, 6, 40, 13, 36, 33, 72, 48, 79, 62, 6, 46, 79, 53, 81, 
85, 75, 76, 31, 67, 78, 58, 12, 22, 10, 42, 54, 53, 20, 86, 18, 
64, 67, 83, 62, 65, 39, 87, 34, 81, 30, 79, 64, 29, 15, 75, 15, 
43, 41, 57, 53, 62, 72, 53, 69, 79, 53, 40, 77, 32, 44, 65, 77, 
39, 24, 53, 26, 84, 36, 59, 17, 75, 25, 62, 43, 37, 80, 75, 49, 
57, 62, 41, 9, 23, 32, 69, 60, 18, 24, 59, 34, 82, 46, 16, 55, 
16, 86, 36, 3, 66, 86, 40, 54, 49, 88, 45, 74, 79, 74, 78, 81, 
84, 42, 41, 39, 48, 48, 27, 31, 38, 87, 31, 17, 44, 58, 10, 26, 
61, 38, 61, 75, 16, 25, 79, 23, 31, 31, 39, 75, 47, 2, 29, 68, 
49, 81, 23, 86, 55, 41, 83, 52, 79, 72, 70, 76, 69, 34, 74, 86, 
29, 36, 68, 55, 79, 84, 34, 59, 70, 74, 80, 32, 3, 51, 70, 44, 
22, 88, 30, 26, 26, 61, 60, 83, 89, 83, 77, 69, 68, 24, 84, 79, 
60, 80, 56, 67, 72, 78, 72, 82, 34, 50, 22, 66, 54, 78, 86, 21, 
74, 72, 82, 76, 83, 79, 63, 68, 79, 57, 70, 69, 72, 39, 89, 42, 
84, 65, 83, 14, 29, 58, 58, 26, 46, 64, 64, 45, 33, 9, 87, 29, 
19, 16, 39, 26, 50, 52, 14, 67, 86, 15, 71, 39, 14, 84, 88, 63, 
64, 66, 50, 69, 64, 88, 51, 57, 38, 41, 47, 38, 47, 37, 72, 70, 
88, 65, 41, 79, 53, 52, 58, 69, 62, 52, 52, 47, 66, 47, 54, 18, 
17, 61, 66, 83, 63, 65, 71, 47, 68, 73, 54, 88, 66, 11, 87, 44, 
18, 32, 52, 25, 56, 62, 74, 74, 49, 68, 28, 44, 73, 30, 61, 37, 
44, 79, 80, 57, 48, 51, 87, 64, 52, 86, 87, 31, 22, 82, 12, 23, 
13, 42, 81, 71, 55, 40, 52, 37, 86, 41, 82, 81, 34, 10, 31, 74, 
83, 10, 72, 28, 32, 52, 9, 69, 31, 51, 68, 84, 41, 73, 68, 83, 
48, 47, 54, 63, 49, 37, 47, 53, 77, 37, 61, 43, 29, 86, 75, 27, 
50, 73, 43, 33, 13, 13, 72, 87, 13, 56, 63, 35, 73, 85, 40, 76, 
61, 62, 15, 9, 39, 55, 38, 31, 87, 66, 29, 63, 53, 76, 79, 58, 
72, 72, 76, 76, 73, 72, 80, 46, 33, 25, 28, 26, 87, 23, 34, 26, 
23, 24, 23, 62, 40, 66, 79, 32, 32, 39, 27, 75, 41, 38, 58, 45, 
12, 8, 14, 32, 86, 29, 74, 67, 53, 40, 74, 37, 83, 58, 67, 62, 
28, 72, 75, 6, 71, 4, 60, 63, 85, 57, 7, 71, 44, 66, 39, 63, 
32, 59, 40, 79, 52, 48, 40, 37, 47, 72, 58, 34, 33, 57, 52, 37, 
63, 27, 47, 36, 85, 67, 54, 53, 51, 45, 12, 81, 90, 37, 65, 10, 
80, 75, 30, 41, 64, 45, 59, 57, 45, 9, 57, 9, 81, 24, 2, 66, 
14, 85, 71, 73, 21, 49, 53, 65, 61, 52, 49, 80, 86, 48, 25, 77, 
31, 11, 58, 65, 71, 38, 50, 42, 29, 72, 28, 77, 88, 90, 33, 51, 
52, 48, 33, 16, 52, 43, 37, 17, 75, 82, 57, 53, 53, 75, 53, 57, 
85, 68, 68, 66, 69, 66, 86, 72, 67, 72, 64, 25, 46, 26, 24, 77, 
9, 68, 73, 29, 43, 34, 72, 12, 18, 82, 17, 69, 55, 30, 81, 29, 
48, 52, 68, 24, 70, 59, 89, 64, 60, 60, 71, 64, 83, 35, 35, 34, 
17, 79, 77, 12, 89, 78, 75, 67, 80, 35, 84, 90, 46, 60, 78, 40, 
86, 61, 68, 61, 61, 79, 80, 88, 86, 42, 28, 45, 59, 82, 67, 44, 
72, 71, 75, 57, 62, 78, 81, 64, 82, 82, 82, 45, 46, 78, 85, 68, 
16, 81, 52, 73, 87, 78, 54, 5, 51, 46, 37, 90, 68, 39, 37, 55, 
49, 33, 41, 54, 55, 66, 85, 78, 80, 61, 83, 89, 70, 76, 72, 78, 
86, 78, 65, 87, 85, 63, 66, 69, 66, 71, 41, 28, 68, 88, 85, 89, 
72, 78, 78, 88, 11, 11, 58, 36, 56, 57, 34, 46, 58, 41, 72, 42, 
36, 58, 75, 59, 40, 61, 28, 76, 82, 79, 80, 79, 90, 87, 77, 37, 
75, 75, 27, 13, 29, 81, 71, 70, 26, 82, 45, 89, 61, 44, 42, 37, 
68, 38, 67, 39, 23, 89, 71, 89, 43, 87, 84, 2, 46, 65, 82, 82, 
65, 40, 33, 10, 67, 67, 80, 55, 27, 89, 50, 71, 15, 47, 52, 16, 
38, 67, 89, 51, 75, 27, 22, 80, 80, 40, 83, 26, 8, 60, 85, 36, 
28, 60, 56, 88, 26, 64, 46, 34, 80, 26, 14, 19, 19, 68, 26, 69, 
8, 81, 62, 76, 40, 54, 71, 11, 46, 26, 89, 75, 81, 70, 78, 88, 
80, 65, 81, 70, 76, 72, 48, 66, 49, 71, 55, 66, 56, 47, 74, 58, 
87, 89, 86, 88, 87, 86, 86, 73, 84, 70, 84, 72, 70, 56, 82, 68, 
38, 77, 61, 38, 35, 83, 10, 78, 90, 62, 67, 80, 85, 60, 47, 81, 
62, 67, 74, 60, 71, 60, 69, 65, 28, 71, 59, 59, 60, 89, 76, 87, 
59, 78, 73, 72, 73, 79, 79, 85, 80, 87, 89, 62, 71, 57, 26, 31, 
60, 89, 32, 59, 59, 55, 77, 51, 47, 67, 65, 90, 40, 44, 82, 54, 
78, 27, 66, 62, 32, 73, 89, 62, 67, 90, 76, 62, 74, 62, 81, 86, 
84, 88, 82, 82, 83, 76, 64, 65, 57, 57, 67, 72, 51, 50, 84, 65, 
9, 82, 84, 81, 82, 86, 86, 81, 85, 82, 86, 86, 81, 84, 82, 83, 
89, 78, 70, 52, 61, 52, 57, 72, 61, 79, 71, 78, 56, 81, 85, 59, 
67, 64, 7, 88, 13, 43, 82, 56, 67, 49, 60, 67, 57, 43, 88, 85, 
76, 90, 60, 62, 49, 77, 48, 49, 38, 14, 19, 6, 65, 65, 85, 45, 
65, 49, 69, 63, 67, 58, 64, 61, 44, 88, 58, 73, 44, 45, 81, 46, 
87, 33, 74, 77, 74, 75, 81, 85, 81, 74, 74, 76, 74, 75, 86, 87, 
89, 84, 83, 84, 86, 84, 90, 83, 88, 83, 19, 20, 64, 76, 48, 17, 
68, 57, 20, 37, 18, 62, 50, 35, 88, 62, 64, 62, 75, 40, 63, 63, 
89, 67, 50, 40, 70, 61, 26, 86, 68, 28, 17, 75, 34, 47, 54, 46, 
77, 64, 11, 18, 56, 84, 84, 82, 58, 60, 73, 55, 55, 59, 68, 30, 
51, 51, 60, 79, 66, 56, 61, 8, 63, 15, 81, 57, 78, 31, 42, 28, 
19, 23, 22, 28, 42, 87, 23, 33, 73, 35, 81, 88, 63, 77, 59, 61, 
67, 83, 87, 80, 59, 65, 60, 74, 59, 59, 75, 87, 64, 62, 85, 58, 
64, 54, 58, 63, 51, 65, 56, 80, 53, 75, 88, 68, 87, 59, 51, 64, 
86, 67, 79, 66, 60, 75, 58, 89, 89, 87, 86, 85, 78, 48, 17, 60, 
32, 59, 53, 73, 25, 52, 66, 38, 44, 24, 50, 22, 24, 48, 22, 56, 
60, 49, 85, 48, 88, 88, 52, 53, 24, 48, 41, 49, 56, 52, 48, 33, 
26, 54, 51, 71, 51, 22, 33, 87, 75, 52, 78, 18, 48, 61, 31, 56, 
39, 14, 37, 81, 17, 60, 17, 37, 34, 37, 35, 47, 15, 26, 42, 55, 
52, 14, 18, 73, 75, 35, 89, 28, 21, 66, 24, 71, 46, 17, 33, 37, 
32, 10, 11, 76, 44, 82, 82, 73, 45, 21, 38, 80, 72, 47, 40, 8, 
47, 8, 17, 18, 34, 44, 60, 31, 84, 76, 87, 86, 84, 65, 34, 89, 
40, 35, 35, 66, 84, 89, 87, 87, 89, 84, 88, 88, 86, 84, 84, 84, 
86, 84, 87, 86, 89, 86, 88, 88, 86, 86, 14, 57, 65, 42, 90, 44, 
40, 67, 88, 65, 71, 84, 68, 65, 73, 87, 80, 65, 70, 66, 84, 89, 
67, 64, 66, 81, 66, 41, 76, 28, 77, 45, 76, 67, 56, 87, 40, 84, 
82, 84, 87, 8, 52, 85, 66, 61, 83, 81, 76, 47, 37, 40, 70, 82, 
32, 32, 83, 26, 87, 52, 38, 76, 35, 43, 90, 89, 88, 89, 89, 88, 
88, 89, 40, 67, 45, 85, 40, 62, 65, 54, 61, 47, 26, 89, 82, 69, 
77, 67, 81, 89, 54, 74, 32, 22, 33, 75, 15, 37, 57, 54, 63, 64, 
49, 79, 71, 86, 63, 67, 70, 61, 59, 51, 53, 88, 22, 3, 55, 73, 
28, 62, 11, 67, 51, 51, 37, 78, 79, 88, 16, 57, 55, 48, 79, 30, 
29, 20, 32, 53, 70, 81, 75, 83, 49, 89, 56, 37, 29, 67, 69, 44, 
78, 24, 49, 38, 84, 42, 51, 57, 67, 10, 26, 76, 44, 35, 28, 84, 
74, 34, 39, 22, 34, 42, 23, 89, 83, 41, 43, 68, 71, 82, 61, 65, 
33, 65, 77, 50, 42, 85, 62, 22, 41, 71, 51, 49, 80, 49, 62, 41, 
33, 40, 82, 70, 70, 76, 80, 77, 75, 77, 87, 27, 85, 25, 83, 85, 
63, 62, 70, 64, 64, 78, 86, 90, 68, 65, 33, 56, 78, 87, 54, 46, 
79, 53, 43, 54, 43, 71, 82, 83, 72, 60, 59, 67, 62, 21, 77, 20, 
85, 28, 45, 32, 41, 53, 81, 79, 74, 57, 81, 66, 58, 81, 61, 89, 
59, 31, 47, 42, 18, 35, 45, 54, 74, 80, 67, 83, 44, 45, 76, 78, 
66, 63, 54, 77, 50, 46, 79, 44, 81, 52, 44, 43, 48, 68, 70, 80, 
69, 85, 35, 78, 70, 62, 35, 66, 60, 60, 30, 60, 85, 29, 52, 70, 
89, 78, 70, 77, 67, 60, 69, 76, 61, 78, 65, 60, 81, 57, 53, 33, 
26, 28, 25, 89), acamyr = c(22, 89, 88, 55, 22, 82, 28, 63, 70, 
9, 66, 25, 85, 81, 61, 90, 43, 53, 89, 79, 85, 85, 30, 77, 48, 
43, 77, 62, 57, 55, 19, 36, 52, 54, 62, 80, 65, 42, 80, 75, 30, 
75, 60, 83, 86, 79, 15, 77, 75, 84, 52, 60, 68, 41, 71, 68, 74, 
82, 54, 56, 77, 45, 69, 51, 79, 69, 70, 21, 80, 79, 43, 86, 66, 
54, 48, 63, 26, 31, 80, 38, 87, 56, 88, 45, 54, 59, 77, 58, 76, 
59, 68, 59, 89, 84, 73, 86, 81, 38, 73, 90, 42, 57, 83, 66, 67, 
52, 28, 36, 48, 52, 88, 76, 65, 70, 78, 87, 81, 83, 87, 89, 87, 
62, 76, 67, 56, 76, 56, 76, 68, 30, 54, 34, 23, 70, 66, 85, 54, 
64, 82, 66, 78, 66, 63, 42, 77, 77, 64, 86, 80, 51, 81, 63, 79, 
80, 65, 80, 88, 65, 85, 89, 74, 73, 85, 77, 82, 55, 9, 80, 85, 
38, 78, 50, 65, 80, 57, 72, 78, 61, 83, 54), acasua = c(89, 78, 
83, 87, 55, 68, 89, 81, 86, 62, 88, 82, 86, 88, 71, 82, 84, 90, 
83, 69, 60, 84, 87, 77, 77, 72, 85, 68, 87, 83, 88, 86, 75, 90, 
77, 63, 76, 73, 70, 70, 69, 61, 68, 66, 61, 86, 87, 71, 86, 83, 
85, 90, 85, 86, 84, 81, 75, 84, 82, 78, 82, 86, 89, 87, 87, 78, 
66, 84, 67, 88, 67, 79, 76, 62, 67, 85, 90, 74, 74, 88, 71, 66, 
81, 41, 81, 60, 78, 89, 51, 79, 82, 74, 45, 66, 81, 55, 54, 53, 
76, 64, 64, 45, 74, 27, 63, 13, 78, 90, 85, 72, 21, 36, 88, 80, 
76, 49, 81, 22, 50, 56, 21, 76, 76), anghis = c(20, 41, 17, 75, 
62, 76, 71, 59, 29, 66, 83, 44, 55, 85, 82, 14, 21, 63, 38, 45, 
66, 85, 45, 64, 16, 81, 68, 18, 61, 43, 8, 82, 45, 63, 59, 48, 
58, 7, 76, 16, 26, 43, 68, 64, 37, 48, 37, 43, 68, 13, 65, 24, 
33, 33, 7, 66, 34, 33, 51, 74, 50, 60, 90, 68, 63, 60, 69, 11, 
33, 33, 65, 73, 81, 53, 56, 77, 41, 81, 47, 23, 72, 25, 67, 47, 
56, 52, 31, 52, 68, 53, 41, 75, 35, 53, 57), astflo = c(65, 37, 
47, 13, 39, 38, 5, 26, 33, 52, 28, 31, 29, 33, 60, 13, 40, 26, 
42, 33, 20, 11, 30, 44, 25, 23, 10, 36, 43, 38, 30, 32, 33, 41, 
32, 23, 32, 22, 29, 18, 34, 25, 48, 34, 44, 89), banmar = c(50, 
45, 84, 17, 54, 42, 78, 39, 62, 40, 71, 46, 63, 76, 87, 74, 76, 
17, 20, 85, 89, 61, 15, 77, 65, 48, 81, 12, 36, 62, 44, 45, 84, 
78, 21, 48, 31, 66, 19, 68, 47, 32, 50, 46, 57, 42, 38, 76, 57, 
52, 34, 59, 79, 7, 45, 50, 34, 28, 44, 46, 86, 27, 28, 20, 62, 
84, 65, 8, 79, 62, 84, 84, 76, 62, 51, 72, 44, 56, 73, 48, 27, 
77, 57, 85, 80, 79, 70, 34, 79, 64, 10, 33, 35, 14, 61, 88, 69, 
74, 43, 49, 45, 70, 79, 28, 83, 71, 53, 79, 62, 65, 45, 39, 78, 
62, 51, 87, 61, 86, 87, 45, 51, 63, 88, 82, 62, 65, 35, 77, 62, 
84, 32, 33, 20, 58, 83, 79, 15, 57, 65, 39, 44, 50, 70, 81, 84, 
50, 76, 18, 61, 42, 63, 48, 73, 76, 51, 52, 25, 63, 40, 40, 36, 
74, 67, 63, 21, 78, 23, 34, 12, 46, 88, 72, 57, 53, 45, 41, 13, 
17, 49, 43, 71, 41, 39, 48, 38, 8, 19, 32, 11, 80, 22, 43, 69, 
77, 86, 62, 32, 25, 29, 75, 65, 32, 2, 8, 52, 30, 26, 25, 88, 
28, 12, 55, 46, 38, 24, 55, 29, 25, 37, 67, 50, 32, 28, 20, 72, 
84, 52, 8, 82, 67, 52, 26, 78, 19, 38, 9, 40, 18, 12, 63, 37, 
33, 56, 19, 25, 88, 22, 8, 31, 88, 79, 43, 81, 20, 34, 68, 45, 
64, 29, 22, 32, 42, 33, 84, 4, 1, 72, 83, 28, 30, 79, 18, 29, 
52, 34, 25, 79, 78, 12, 29, 23, 25, 14, 76, 29, 27, 12, 23, 72, 
34, 43, 65, 63, 71, 74, 81, 24, 53, 84, 41, 45, 87, 60, 6, 58, 
20, 30, 89, 14, 40, 38, 43, 31, 48, 38, 27, 30, 59, 28, 41, 39, 
51, 34, 76, 45, 42, 68, 38, 58, 40, 30, 38, 62, 40, 43, 29, 89, 
52, 41, 80, 50, 57, 58, 23, 87, 67, 52, 47, 49, 78, 35, 89, 29, 
30, 22, 20, 87, 39, 35, 52, 73, 15, 39, 8, 26, 44, 61, 62, 35, 
16, 24, 88, 48, 42, 50, 60, 60, 16, 55, 17, 10, 58, 34, 24, 7, 
17, 50, 14, 33, 27, 56, 34, 42, 42, 22, 69, 49, 31, 16, 52, 60, 
60, 42, 20, 64, 45, 15, 31, 20, 73, 36, 40, 71, 64, 19, 21, 47, 
12, 61, 21, 46, 33, 30, 57, 43, 61, 62, 49, 61, 27, 17, 52, 59, 
51, 20, 47, 46, 85, 39, 47, 19, 29, 80, 19, 29, 61, 42, 9, 43, 
48, 49, 10, 10, 59, 63, 19, 43, 30, 36, 89, 63, 48, 31, 64, 37, 
26, 43, 31, 46, 2, 46, 35, 46, 59, 50, 23, 45, 63, 40, 41, 19, 
80, 79, 69, 54, 37, 7, 74, 83, 34, 35, 13, 46, 61, 62, 10, 23, 
41, 43, 82, 78, 22, 24, 88, 58, 45, 37, 15, 29, 75, 47, 56, 69, 
77, 61, 55, 66, 71, 53, 20, 64, 67, 60, 78, 69, 17, 39, 54, 50, 
75, 8, 48, 75, 12, 62, 51, 54, 31, 76, 10, 55, 50, 24, 78, 55, 
42, 59, 89, 38, 37, 59, 22, 63, 68, 55, 81, 61, 27, 62, 54, 41, 
16, 54, 23, 20, 65, 31, 53, 6, 32, 21, 64, 30, 61, 28, 24, 53, 
52, 30, 57, 59, 39, 41, 45, 33, 82, 50, 32, 9, 26, 20, 66, 66, 
29, 50, 25, 46, 37, 45, 56, 51, 45, 16, 81, 45, 62, 80, 49, 24, 
55, 76, 89, 57, 78, 32, 68, 17, 83, 50, 48, 50, 68, 58, 40, 60, 
46, 37, 73, 62, 14, 29, 45, 44, 31, 59, 54, 31, 17, 36, 62, 83, 
89, 69, 89, 88, 65, 81, 54, 43, 69, 64, 37, 56, 70, 52, 65, 32, 
39, 38, 82, 65, 65, 67, 26, 66, 29, 65, 65, 87, 64, 41, 88, 79, 
60, 72, 34, 60, 47, 77, 61, 67, 85, 65, 63, 64, 53, 39, 16, 73, 
20, 56, 67, 81, 64, 89, 58, 66, 79, 75, 52, 83, 82, 78, 46, 81, 
61, 87, 84, 63, 56, 84, 74, 62, 89, 83, 41, 69, 58, 41, 66, 75, 
77, 84, 88, 37, 68, 77, 46, 86, 67, 17, 52, 35, 45, 56, 86, 70, 
36, 54, 89, 79, 29, 61, 81, 73, 68, 77, 56, 70, 78, 46, 34, 88, 
64, 37, 86, 81, 22, 62, 12, 87, 82, 45, 79, 58, 73, 41, 78, 54, 
62, 40, 40, 88, 38, 64, 86, 85, 70, 80, 76, 75, 58, 68, 39, 73, 
70, 66, 60, 68, 44, 69, 58, 41, 74, 84, 76, 87, 57, 48, 77, 13, 
52, 63, 64, 83, 77, 40, 56, 64, 89, 66, 50, 78, 87, 79, 64, 72, 
76, 71, 85, 57, 79, 70, 29, 90, 62, 86, 73, 56, 68, 70, 87, 87, 
64, 86, 74, 84, 62, 83, 82, 89, 30, 64, 87, 42, 62, 84, 79, 83, 
89, 87, 54, 74, 22, 59, 37, 25, 81, 61, 28, 79, 84, 51, 77, 57, 
84, 49), banobl = c(88, 20, 53, 41, 36, 83, 46, 15, 41, 39, 20, 
45, 84, 56, 36, 29, 61, 85, 59, 83, 87, 57, 54, 46, 60, 39, 64, 
57, 54, 28, 39, 43, 40, 56, 45, 27, 33, 43, 54, 41, 76, 19, 65, 
22, 73, 10, 49, 84, 63, 11, 46, 1, 63, 68, 23, 65, 69, 21, 48, 
70, 68, 41, 10, 66, 61, 31, 62, 36, 25, 23, 14, 51, 61, 14, 33, 
58, 19, 15, 21, 87, 76, 22, 36, 35, 70, 57, 46, 15, 50, 28, 71, 
15, 79, 48, 29, 68, 29), borpin = c(42, 66, 21, 46, 38, 38, 27, 
35, 35, 37, 53, 47, 32, 62, 29, 11, 31, 48, 49, 62, 37, 50, 49, 
55, 44, 52, 35, 27, 45, 45, 39, 62, 24, 55, 40, 60, 53, 52, 44, 
56, 3, 40, 18, 66, 22, 41, 79, 55, 42, 15, 54, 49, 36, 59, 40, 
56, 35, 42, 43, 37, 39, 73, 73, 22, 62, 82, 48, 57, 38, 14, 61, 
46, 48, 35, 41, 59, 57, 76, 20, 31, 20, 66, 40, 43, 42, 37, 18, 
67, 50, 36, 42, 41, 37, 15, 63, 36, 58, 49, 55, 25, 46, 35, 47, 
26, 41, 44, 43, 26, 49, 40, 30, 29, 45, 29, 31, 25, 12, 30, 47, 
15, 69, 34, 47, 78, 88, 42, 29, 79, 82, 63, 75, 56, 80, 49, 28, 
46, 27, 41, 21, 41, 71, 76, 44, 61, 37, 75, 30, 46, 31, 35, 40, 
89, 38, 10, 48, 51, 80, 46, 47, 19, 32, 32, 50, 53, 79, 30, 31, 
59, 84, 80, 51, 34, 28, 48, 33, 24, 25, 49, 28, 33, 63, 52, 40, 
62, 31, 78, 26, 50, 25, 41, 34, 17, 26, 60, 71, 16, 47, 22, 17, 
52, 18, 10, 5, 24, 56, 19, 49, 27, 35, 41, 15, 22, 16, 35, 30, 
68, 17, 29, 26, 59, 23, 55, 21, 28, 28, 29, 26, 62, 35, 34, 23, 
29, 26, 66, 13, 57, 39, 86, 80, 30, 76, 56, 49, 41, 37, 41, 18, 
37, 83, 59, 30, 42, 25, 63, 22, 26, 47, 45, 67, 35, 25, 60, 74, 
32, 36, 49, 54, 23, 8, 7, 14, 47, 8, 47, 65, 41, 81, 13, 20, 
44, 45, 59, 72, 37, 77, 31, 30, 65, 28, 62, 90, 88, 57, 29, 41, 
34, 66, 20, 23, 28, 41, 38, 51, 26, 55, 41, 44, 62, 63, 40, 76, 
75, 20, 82, 64, 59, 74, 47, 72, 45, 54, 71, 75, 76, 62, 51, 32, 
30, 45, 40, 22, 5, 42, 37, 56, 51, 60, 59, 30, 48, 53, 30, 22, 
16, 38, 32, 28, 30, 66, 69, 27, 26, 8, 11, 43, 58, 28, 16, 36, 
64, 26, 44, 35, 29, 44, 12, 59, 34, 28, 35, 31, 51, 51, 44, 70, 
47, 43, 11, 16, 45, 41, 21, 40, 43, 50, 29, 46, 56, 40, 11, 69, 
86, 55, 50, 51, 46, 84, 68, 66, 52, 73, 40, 81, 45, 57, 19, 64, 
29, 52, 61, 74, 50, 52, 13, 25, 46, 77, 71, 19, 82, 21, 65, 36, 
41, 23, 24, 52, 33, 49, 27, 66, 37, 61, 44, 63, 57, 6, 70, 61, 
26, 29, 53, 63, 58, 47, 36, 14, 58, 58, 51, 42, 46, 81, 57, 76, 
22, 62, 14, 52, 24, 31, 6, 47, 28, 36, 28, 73, 37, 16, 64, 22, 
18, 38, 35, 58, 73, 44, 35, 60, 48, 34, 25, 80, 24, 40, 38, 44, 
52, 72, 59, 66, 35, 45, 43, 48, 66, 36, 66, 63, 23, 41, 67, 31, 
46, 44, 20, 65, 49, 32, 34, 85, 30, 84, 47, 81, 59, 79, 32, 85, 
36, 80, 45, 86, 70, 73, 44, 25, 26, 34, 41, 41, 28, 64, 35, 81, 
51, 52, 20, 56, 35, 52, 64, 32, 17, 90, 11, 76, 48, 62, 51, 28, 
33, 64, 14, 71, 19, 55, 31, 34, 57, 65, 40, 7, 64, 63, 51, 64, 
24, 41, 13, 5, 36, 47, 41, 33, 41, 41, 29, 48, 51, 34, 23, 52, 
36, 83, 43, 50, 31, 25, 55, 58, 23, 59, 14, 4, 69, 71, 19, 52, 
25, 51, 15, 69, 74, 65, 49, 66, 53, 58, 86, 75, 60, 81, 31, 66, 
67, 35, 37, 48, 70, 50, 55, 59, 82, 80, 88, 72, 11, 42, 14, 81, 
17, 66, 72, 80, 59), breobl = c(3, 72, 35, 36, 36, 14, 45, 43, 
37, 55, 45, 52, 61, 52, 28, 22, 53, 13, 34, 34, 40, 13, 19, 24, 
18, 42, 38, 33, 25, 18, 43, 47, 43, 53, 14, 47, 19, 35, 41, 54, 
42, 26, 55, 36, 31, 51, 8, 25, 27, 29, 11, 28, 43, 28, 18, 28, 
17, 45, 57, 25, 35, 27, 32, 43, 30, 32, 32, 48, 20, 44, 26, 60, 
35, 31, 44, 69, 35, 3, 39, 16, 22, 60, 19, 41, 56, 55, 57, 34, 
54, 28, 44, 57, 44, 71, 16, 33, 24, 39, 37, 39, 31, 41, 10, 39, 
37, 36, 43, 45, 39, 50, 14, 49, 32, 46, 40, 23, 10, 45, 46, 40, 
13, 39, 19, 10, 62, 46, 31, 24, 16, 21, 29, 6, 37, 82, 31, 4, 
35, 25, 24, 28, 45, 26, 11, 32, 19, 36, 65, 28, 50, 23, 13, 26, 
13, 43, 48, 18, 51, 73, 31, 15, 29, 47, 43, 31, 22, 65, 15, 49, 
20, 42, 24, 29, 28, 58, 22, 26, 35, 38, 43, 22, 32, 34, 36, 18, 
28, 13, 37, 77, 47, 33, 57, 67, 43, 25, 56, 11, 47, 16, 32, 57, 
27, 60, 31, 21, 13, 31, 37, 55, 33, 24, 19, 28, 38, 36, 35, 26, 
5, 31, 3, 65, 53, 8, 10, 63, 22, 32, 28, 21, 27, 41, 40, 12, 
9, 31, 22, 12, 41, 16, 57, 14, 26, 13, 18, 28, 30, 25, 18, 20, 
36, 45, 46, 55, 23, 17, 13, 22, 16, 23, 31, 8, 18, 50, 64, 43, 
57, 34, 64, 24, 42, 29, 30, 21, 31, 36, 40, 60, 10, 22, 31, 32, 
31, 11, 17, 42, 44, 30, 38, 81, 36, 36, 27, 65, 44, 28, 46, 43, 
15, 65, 74, 32, 53, 34, 53, 47, 31, 35, 46, 51, 20, 49, 12, 24, 
19, 67, 31, 26, 25, 51, 42, 28, 46, 6, 54, 19, 40, 47, 25, 37, 
46, 44, 51, 54, 46, 39, 36, 62, 79, 46, 46, 61, 14, 11, 38, 26, 
21, 56, 11, 35, 34, 63, 19, 20, 30, 35, 43, 27, 49, 41, 55, 28, 
46, 26, 53, 40, 49, 14, 22, 24, 2, 6, 21, 37, 20, 17, 23, 51, 
23, 48, 51, 49, 13, 38, 41, 39, 49, 39, 36, 39, 46, 43, 38, 27, 
45, 40, 66, 34, 46, 26, 41, 37, 36, 37, 33, 36, 25, 16, 21, 30, 
21, 34, 69, 67, 45, 32, 51, 32, 67, 41, 31, 26, 26, 24, 17, 21, 
20, 35, 15, 22, 37, 32, 86, 40, 44, 29, 31, 27, 64, 45, 25, 10, 
72, 6, 39, 22, 62, 1, 17, 19, 35, 24, 13, 10, 6, 61, 4, 68, 26, 
32, 21, 30, 10, 47, 36, 7, 14, 19, 36, 22, 28, 11, 57, 35, 13, 
15, 38, 53, 26, 24, 22, 47, 66, 4, 40, 46, 38, 31, 30, 28, 28, 
22, 13, 26, 38, 39, 47, 82, 32, 8, 33, 30, 9, 28, 20, 36, 13, 
21, 21, 71, 7, 24, 46, 29, 20, 28, 45, 89, 23, 26, 21, 36, 6, 
32, 16, 49, 25, 33, 22, 17, 38, 60, 16, 19, 35, 50, 5, 35, 44, 
45, 41, 25, 20, 47, 39, 23, 23, 26, 36, 46, 1, 27, 9, 12, 33, 
19, 29, 15, 21, 24, 12, 16, 37, 55, 59, 31, 33, 25, 29, 9, 16, 
60, 67, 43, 36, 28, 27, 49, 27, 57, 37, 35, 19, 9, 36, 42, 37, 
58, 35, 18, 14, 39, 38, 5, 31, 52, 37, 32, 48, 9, 66, 53, 18, 
26, 23, 36, 33, 27, 53, 60, 43, 68, 22, 30, 33, 23, 60, 34, 82, 
44, 35, 39, 14, 15, 17, 28, 26, 23, 59, 35, 1, 32, 42, 38, 37, 
50, 27, 37, 43, 22, 38, 23, 20, 32, 44, 17, 20, 10, 62, 33, 40, 
21, 17, 75, 30, 22, 20, 44, 15, 65, 9, 32, 35, 38, 16, 34, 39, 
21, 45, 69, 61, 17, 42, 40, 59, 32, 28, 48, 14, 32, 14, 10, 41, 
5, 26, 20, 14, 19, 24, 34, 62, 22, 29, 34, 63, 10, 10, 24, 3, 
20, 34, 63, 43, 35, 83, 44, 17, 37, 43), conlon = c(77, 57, 69, 
89, 89, 51, 87, 70, 78, 85, 71, 44, 59, 80, 45, 83, 87, 67, 89, 
39, 46, 84, 35, 81, 67, 40, 71, 78, 79, 74, 83, 86, 84, 72, 87, 
70, 75, 75, 69, 83, 69, 77, 61, 70, 79, 87, 58, 66, 89, 80, 83, 
80, 64, 60, 63, 86, 86, 86, 55, 83, 55, 73, 87, 89, 82, 69, 65, 
57, 73, 75, 89, 71, 66, 41, 70, 44, 63, 79, 44, 64, 86, 69, 52, 
71, 74, 83, 80, 82, 78, 39, 68, 60, 72, 84, 83, 81, 68, 72, 84, 
86, 83, 66, 70, 75, 77, 90, 85, 68, 79, 89, 59, 87, 79, 63), 
    epapul = c(29, 32, 21, 25, 34, 15, 80, 20, 29, 46, 25, 14, 
    30, 20, 26, 32, 41, 52, 54, 31, 62, 24, 66, 41, 27, 54, 22, 
    34, 42, 51, 53, 27, 90, 65, 26, 89, 47, 66, 77, 49, 71, 20, 
    18, 32, 58, 52, 43, 41, 51, 63, 44, 38, 7, 69, 23, 38, 55, 
    46, 42, 70, 59, 10, 89, 48, 59, 46, 31, 40, 32, 19, 40, 33, 
    74, 72, 81, 78, 85, 45, 59, 47, 47, 36, 70, 77, 70, 39, 48, 
    51, 31, 46, 85, 76, 83, 54, 39, 64, 34, 88, 41, 69, 62, 8, 
    65, 64, 66, 56, 34, 66, 44, 64, 85, 48, 64, 59, 20, 85, 62, 
    81, 48, 70, 82, 42, 38, 63, 59, 43, 44, 65, 22, 72, 86, 31, 
    9, 51, 26, 59, 79, 82, 55, 29, 55, 57, 47, 55, 84, 52, 79, 
    14, 15, 63, 42, 48, 65, 63, 19, 47, 54, 79, 44, 40, 43, 77, 
    53, 61, 52, 83, 9, 58, 42, 61, 67, 50, 53, 46, 49, 73, 51, 
    59, 48, 45, 47, 56, 37, 26, 38, 32, 27, 33, 37, 34, 16, 8, 
    42, 40, 48, 28, 34, 19, 34, 28, 20, 25, 51, 16, 90, 54, 42, 
    45, 44, 63, 15, 20, 81, 65, 34, 44, 26, 59, 57, 29, 58, 54, 
    23, 43, 35, 47, 34, 37, 23, 21, 27, 14, 27, 23, 22, 23, 23, 
    24, 39, 37, 23, 33, 27, 27, 24, 17, 30, 37, 82, 31, 57, 22, 
    54, 70, 77, 28, 17, 35, 86, 68, 74, 59, 81, 44, 38, 38, 73, 
    34, 64, 7, 60, 45, 73, 20, 29, 37, 43, 37, 43, 40, 48, 69, 
    60, 34, 56, 67, 62, 59, 42, 17, 26, 19, 29, 33, 36, 17, 46, 
    70, 33, 52, 44, 46, 43, 24, 32, 27, 36, 28, 20, 30, 65, 66, 
    62, 71, 67, 55, 71, 29, 28, 40, 59, 38, 10, 49, 40, 40, 33, 
    45, 20, 38, 22, 13, 21, 23, 25, 35, 8, 69, 43, 27, 71, 40, 
    82, 37, 37, 69, 90, 42, 21, 51, 88, 27, 56, 51, 59, 63, 53, 
    61, 88, 30, 63, 53, 61, 89, 39, 12, 55, 21, 31, 28, 60, 57, 
    83, 81, 81, 57, 52, 39, 13, 55, 84, 30, 53, 48, 71, 29, 38, 
    48, 76, 63, 46, 11, 36, 56, 60, 64, 69, 58, 50, 40, 71, 67, 
    57, 50, 64, 65, 67, 42, 33, 29, 32, 39, 52, 71, 71, 62, 49, 
    31, 26, 30, 4, 6, 13, 14, 29, 29, 25, 27, 26, 15, 19, 16, 
    25, 24, 23, 19, 23, 12, 6, 32, 16, 33, 15, 19, 20, 5, 35, 
    21, 10, 6, 67, 63, 63, 62, 30, 10, 57, 22, 74, 89, 25, 41, 
    87, 54, 89, 50, 75, 86, 32, 30, 34, 21, 24, 39, 29, 47, 79, 
    68, 62, 63, 73, 87, 89, 38, 43, 43, 57, 49, 71, 29, 64, 71, 
    58, 33, 83, 51, 58, 38, 32, 22, 19, 24, 28, 56, 33, 28, 48, 
    55, 31, 17, 19, 36, 64, 71, 65, 52, 54, 36, 57, 41, 12, 9, 
    5, 7, 67, 63, 84, 55, 67, 42, 34, 63, 29, 49, 36, 19, 8, 
    16, 5, 14, 33, 32, 24, 18, 44, 31, 40, 47, 75, 69, 14, 54, 
    64, 16, 72, 54, 69, 56, 61, 61, 39, 6, 20, 57, 71, 71, 70, 
    44, 58, 70, 40, 42, 22, 26, 23, 18, 25, 24, 59, 43, 53, 42, 
    28, 55, 58, 80, 68, 89, 72, 72, 51, 49, 72, 67, 74, 56, 51, 
    88, 64, 86, 81, 69, 87, 82, 58, 52, 52, 55, 31, 53, 70, 68, 
    76, 72, 68, 73, 46, 45, 54, 42, 55, 43, 56, 57, 49, 56, 12, 
    13, 18, 4, 28, 30, 39, 34, 19, 31, 26, 29, 12, 46, 54, 54, 
    89, 51, 61, 64, 81, 65, 76, 72, 65, 49, 64, 79, 80, 89, 89, 
    78, 89, 62, 52, 49, 56, 48, 52, 40, 53, 33, 33, 46, 39, 29, 
    23, 20, 26, 41, 19, 64, 57, 42, 48, 52, 41, 30, 39, 32, 36, 
    30, 35, 33, 29, 28, 27, 19, 27, 54, 29, 32, 13, 30, 48, 47, 
    42, 17, 21, 20, 17, 22, 18, 19, 4, 4, 8, 9, 8, 28, 20, 10, 
    27, 14, 43, 53, 69, 78, 37, 49, 63, 66, 58, 44, 82, 49, 69, 
    29, 30, 48, 29, 69, 61, 87, 75, 26, 5, 46, 12, 37, 14, 29, 
    82, 26, 80, 16, 44, 76, 24, 85, 29, 76, 67, 68, 37, 36, 23, 
    42, 50, 39, 86, 89, 29, 17, 18, 30, 73, 55, 82, 55, 56, 63, 
    86, 89, 67, 23, 31, 82, 38, 23, 14, 28, 48, 52, 8, 73, 63, 
    38, 30, 72, 44, 35, 17, 9, 83, 18, 52, 86, 61, 57, 84, 86, 
    83, 77, 87, 90, 86, 88, 80, 87, 30, 78, 78, 78, 78, 59, 84, 
    86, 83, 76, 86, 66, 71, 54, 68, 60, 77, 61, 63, 69, 60, 46, 
    52, 45, 50, 46, 56, 39, 36, 50, 54, 55, 61, 55, 32, 48, 33, 
    52, 37, 21, 10, 3, 8, 16, 11, 46, 31, 41, 52, 50, 50, 51, 
    42, 54, 76, 83, 80, 83, 20, 14, 20, 14, 39, 39, 51, 70, 62, 
    51, 56, 16, 14, 16, 17, 17, 24, 16, 27, 31, 19, 35, 21, 22, 
    15, 12, 12, 15, 6, 31, 13, 10, 14, 14, 16, 10, 23, 9, 11, 
    25, 35, 42, 39, 27, 19, 12, 10, 89, 80, 83, 83, 76, 50, 49, 
    56, 45, 60, 53, 42, 44, 43, 56, 48, 69, 70, 57, 65, 37, 68, 
    36, 38, 43, 38, 38, 44, 47, 49, 28, 81, 45, 57, 83, 71, 66, 
    57, 9, 10, 21, 33, 11, 24, 9, 17, 10, 65, 45, 52, 21, 11, 
    30, 8, 21, 33, 25, 28, 19, 22, 30, 30, 6, 22, 27, 15, 19, 
    21, 3, 26, 17, 29, 20, 29, 18, 21, 22, 21, 32, 36, 14, 37, 
    36, 38, 35, 80, 69, 55, 55, 39, 64, 49, 49, 55, 39, 56, 57, 
    74, 55, 61, 60, 73, 77, 68, 49, 44, 64, 35, 48, 36, 11, 39, 
    37, 60, 34, 39, 55, 53, 21, 34, 19, 17, 47, 39, 44, 45, 20, 
    71, 73, 65, 49, 47, 36, 66, 50, 61, 80, 67, 73, 88, 79, 52, 
    48, 51, 49, 59, 61, 40, 68, 61, 41, 27, 53, 51, 64, 44, 51, 
    50, 54, 39, 32, 67, 38, 69, 90, 54, 36, 42, 48, 38, 51, 19, 
    38, 22, 4, 14, 27, 40, 16, 17, 12, 5, 19, 21, 67, 69, 77, 
    87, 60, 27, 67, 66, 20, 60, 48, 48, 62, 73, 52, 74, 87, 74, 
    54, 45, 71, 36, 88), eriaus = c(34, 43, 56, 53, 89, 53, 73, 
    78, 63, 61, 40, 61, 24, 77, 80, 24, 74, 25, 74, 61, 14, 72, 
    40, 37, 29, 72, 75, 70, 67, 87, 78, 55, 84, 77, 77, 71, 89, 
    62, 77, 66, 70, 53, 40, 52, 29, 41, 34, 30, 43, 80, 79, 67, 
    65, 85, 73, 82, 56, 49, 75, 34, 50, 48, 82, 24, 59, 87, 44, 
    56, 70, 63, 74, 71, 81, 51, 81, 89, 66, 50, 66, 24, 33, 5, 
    74, 23, 71, 77, 40, 79, 87, 88, 49, 88, 77, 78, 74, 77, 87, 
    77, 58, 38, 78, 42, 69, 39, 50, 67, 32, 76, 53, 85, 84, 30, 
    55, 89, 65, 86, 74, 69, 82, 85, 74, 75, 71, 78, 85, 75, 84, 
    87, 79, 78, 77, 83, 71, 63, 69, 76, 82, 79, 58, 77, 32, 84, 
    31, 63, 77, 54, 56, 89, 77, 85, 47, 87, 64, 39, 64, 78, 86, 
    87, 73, 67, 74, 52, 63, 19, 71, 10, 71, 71, 66, 55, 76, 82, 
    57, 52, 63, 61, 23, 67, 71, 58, 86, 67, 82, 81, 84, 73, 62, 
    65, 76, 66, 58, 84, 67, 67, 87, 84, 72, 84, 81, 66, 10, 9, 
    70, 31, 87, 79, 89, 66, 73, 64, 56, 83, 17, 88, 53, 36, 64, 
    27, 69, 35, 70, 70, 67, 69, 54, 47, 80, 28, 60, 47, 87, 78, 
    76, 89, 42, 62, 38, 88, 59, 68, 88, 62, 46, 80, 86, 69, 74, 
    11, 59, 59, 36, 27, 41, 59, 86, 34, 51, 59), eucgum = c(69, 
    83, 16, 48, 39, 77, 77, 32, 64, 89, 85, 35, 83, 88, 66, 35, 
    19, 24, 58, 51, 70, 19, 70, 47, 40, 18, 71, 38, 48, 72, 72, 
    53, 24, 89, 82, 66, 58, 64, 20, 49, 29, 55, 46, 44, 82, 77, 
    67, 79, 33, 33, 35, 31, 66, 87, 59, 28, 1, 46, 62, 59, 10, 
    70, 33, 65, 11, 53, 32, 43, 66, 41, 28, 59, 72, 63, 38, 86, 
    57, 83, 12, 49, 89, 50, 18, 86, 74, 62, 68, 38, 71, 37, 70, 
    46, 52, 80, 84, 78, 74, 86, 73, 82, 88, 67, 59, 73, 76, 53, 
    60, 58, 76), euchae = c(89, 58, 41, 86, 89, 71, 62, 47, 60, 
    81, 89, 73, 68, 43, 80, 88, 87, 81, 82, 88, 29, 77, 52, 69, 
    71, 37, 47, 70, 60, 56, 73, 74, 73, 61, 59, 63, 64, 72, 50, 
    66, 64, 59, 74, 62, 77, 75, 72, 89, 56, 76, 83, 63, 74, 61, 
    28, 69, 58, 35, 71, 77, 54, 67, 28, 85, 83, 72, 68, 65, 82, 
    78, 83, 78, 73, 84, 65, 30, 75, 76, 70, 65, 81, 36, 90, 68, 
    80, 69, 50, 31, 25, 77, 88, 19, 54, 80, 46, 61, 43, 57, 65, 
    71, 89, 49, 79, 83, 74, 63, 68, 62, 87, 36, 74, 50, 61, 64, 
    68, 60, 88, 61, 67, 49, 18, 87, 43, 54, 45, 72, 89, 40, 46, 
    30, 32, 39, 65, 86, 81, 74, 79, 80, 88, 79, 89, 55, 76, 72, 
    81, 65, 87, 43, 77, 81, 73, 81, 77, 62, 37, 85, 32, 79, 57, 
    48, 53, 72, 20, 80, 62, 80), gomlat = c(12, 16, 29, 32, 22, 
    62, 76, 52, 57, 52, 56, 42, 23, 11, 37, 25, 23, 56, 74, 38, 
    14, 25, 3, 12, 23, 47, 10, 33, 75, 82, 69, 63, 39, 33, 39, 
    44, 29, 65, 45, 36, 85, 69, 86, 17, 66, 1, 33, 6, 17, 13, 
    16, 21, 21, 12, 25, 26, 31, 15, 32, 39, 20, 25, 24, 16, 8, 
    15, 21, 22, 20, 17, 14, 33, 31, 9, 17, 24, 8, 29, 33, 18, 
    14, 17, 3, 23, 10, 24, 19, 7, 22, 20, 4, 28, 16, 8, 9, 6, 
    27, 22, 19, 14, 12, 6, 19, 70, 11, 11, 4, 77, 19, 22, 6, 
    23, 13, 5, 14, 12, 1, 14, 18, 7, 9, 3, 21, 23, 7, 5, 13, 
    28, 9, 5, 28, 8, 20, 12, 14, 10, 6, 15, 1, 12, 13, 12, 25, 
    6, 6, 7, 24, 42, 36, 31, 18, 61, 20, 39, 41, 14, 34, 18, 
    11, 67, 9, 4, 10, 13, 15, 30, 23, 24, 27, 10, 33, 42, 21, 
    26, 64, 14, 26, 2, 8, 24, 17, 30, 18, 13, 23, 14, 22, 10, 
    27, 16, 11, 8, 19, 22, 18, 29, 23, 21, 20, 10, 3, 39, 35, 
    20, 19, 24, 13, 23, 34, 21, 7, 8, 15, 27, 45, 29, 45, 29, 
    14, 36, 25, 14, 35, 43, 57, 35, 27, 23, 3, 49, 52, 45, 20, 
    15, 4, 14, 33, 23, 37, 22, 31, 9, 22, 16, 15, 10, 20, 38, 
    29, 42, 4, 34, 7, 22, 6, 17, 4, 12, 15, 9, 45, 20, 21, 18, 
    24, 26, 31, 15, 31, 5, 18, 7, 10, 13, 12, 43, 12, 18, 20, 
    25, 12, 16, 27, 19, 13, 28, 13, 11, 32, 20, 20, 28, 19, 40, 
    28, 6, 14, 17, 12, 14, 10, 19, 9, 12, 27, 11, 19, 16, 16, 
    6, 16, 15, 23, 11, 16, 3, 19, 17, 38, 65, 2), grebux = c(28, 
    24, 39, 31, 23, 22, 49, 36, 36, 65, 42, 51, 9, 14, 2, 11, 
    31, 32, 42, 33, 24, 27, 25, 16, 44, 45, 15, 15, 47, 41, 61, 
    68, 82, 60, 79, 48, 36, 86, 74, 70, 58, 52, 89, 33, 72, 83, 
    86, 82, 43, 65, 88, 85, 42, 29, 30, 76, 31, 67, 36, 42, 43, 
    40, 63, 65, 74, 64, 55, 82, 72, 48, 30, 87, 38, 47, 40, 14, 
    26, 40, 55, 26, 65, 65, 61, 48, 47, 55, 23, 53, 80, 56, 42, 
    53, 33, 56, 60, 59, 50, 59, 23, 78, 41, 33, 49, 49, 37, 54, 
    74, 62, 31, 52, 45, 25, 36, 51, 39, 20, 42, 24, 31, 33, 65, 
    56, 56, 67, 43, 81, 75, 54, 43, 7, 40, 41, 58, 44, 43, 52, 
    33, 73, 39, 54, 12, 29, 29, 28, 37, 48, 63, 25, 31, 36, 16, 
    24, 15, 24, 58, 17, 42, 38, 20, 38, 13, 72, 76, 79, 87, 53, 
    32, 61, 52, 60, 64, 77, 56, 37, 38, 55, 17, 2, 11, 53, 23, 
    52, 10, 31, 36, 7, 17, 81, 75, 77, 54, 75, 48, 67, 74, 62, 
    57, 80, 46, 51, 68, 52, 30, 57, 88, 63, 81, 89, 74, 84, 53, 
    41, 46, 18, 45, 35, 28, 9, 43, 16, 34, 43, 37, 45, 77, 79, 
    80, 86, 74, 68, 84, 71, 44, 70, 57, 37, 60, 80, 83, 69, 25, 
    64, 27, 61, 65, 53, 54, 57, 46, 76, 60, 65, 70, 64, 57, 67, 
    48, 71, 66, 69, 55, 28, 34, 32, 13, 33, 20, 45, 18, 27, 28, 
    39, 22, 20, 40, 38, 65, 9, 20, 25, 33, 34, 42, 9, 29, 11, 
    34, 8, 48, 12, 32, 80, 21, 33, 45, 11, 60, 84, 50, 37, 65, 
    42, 42, 47, 41, 57, 46, 37, 63, 15, 64, 39, 44, 46, 62, 40, 
    57, 74, 45, 36, 32, 48, 38, 39, 77, 26, 35, 37, 52, 59, 79, 
    64, 87, 71, 82, 78, 67, 62, 39, 32, 10, 15, 60, 84, 56, 30, 
    19, 23, 30, 19, 52, 70, 28, 36, 29, 43, 33, 19, 41, 52, 45, 
    49, 33, 26, 22, 61, 54, 30, 33, 46, 73, 64, 60, 51, 41, 64, 
    90, 69, 50, 50, 3, 35, 54, 87, 64, 77, 32, 50, 31, 74, 29, 
    22, 10, 36, 63, 27, 28, 65, 49, 66, 21, 54, 61, 75, 61, 68, 
    40, 48, 47, 44, 60, 82, 65, 78, 45, 42, 50, 47, 40, 39, 64, 
    71, 45, 48, 77, 60, 42, 77, 45, 44, 51, 74, 13, 46, 60, 31, 
    25, 45, 44, 13, 63, 32, 54, 29, 46, 27, 13, 12, 36, 28, 25, 
    33, 21, 19, 23, 28, 13, 46, 48, 28, 20, 30, 26, 27, 27, 19, 
    47, 57, 17, 25, 48, 37, 28, 7, 50, 18, 57, 39, 18, 37, 42, 
    18, 53, 41, 69, 66, 47, 32, 43, 37, 39, 18, 53, 34, 53, 37, 
    21, 30, 10, 45, 24, 9, 22, 61, 25, 30, 3, 24, 3, 18, 25, 
    36, 26, 38, 36, 43, 28, 11, 38, 30, 28, 66, 48, 56, 25, 65, 
    66, 22, 37, 13, 11, 28, 17, 57, 24, 22, 30, 72, 15, 82, 33, 
    51, 46, 41, 21, 43, 9, 42, 69, 86, 66, 87, 82, 60, 79, 42, 
    18, 69, 79, 72, 87, 36, 84, 77, 45, 76, 76, 63, 80, 71, 83, 
    84, 89, 44, 67, 73, 74, 81, 64, 46, 68, 3, 76, 79, 60, 49, 
    67, 61, 48, 62, 81, 41, 62, 70, 30, 53, 13, 90, 72, 58, 72, 
    54, 69, 26, 65, 82, 44, 85, 90, 64, 90, 85, 61, 31, 86, 56, 
    59, 44, 54, 40, 74, 61, 56, 85, 27, 65, 66, 65, 49, 69, 48, 
    23, 38, 32, 59, 60, 49, 84, 59, 48, 87, 54, 41, 79, 29, 67, 
    36, 71, 55, 16, 32, 23, 68, 84, 87, 57, 33, 49, 41, 73, 71, 
    54, 54, 48, 79, 60, 71, 34, 69, 37, 50, 60, 70, 51, 63, 68, 
    53, 54, 65, 87, 66, 48, 43, 57, 72, 48, 66, 43, 25, 50, 80, 
    82, 71, 33, 86, 50, 56, 30, 35, 30, 69, 78, 77, 88, 66, 39, 
    54, 41, 39, 35, 78, 76, 65, 68, 39, 25, 36, 48, 88, 39, 48, 
    19, 30, 84, 76, 87, 88, 87, 75, 52, 61, 50, 60, 64, 66, 66, 
    87, 76, 57, 62, 60, 72, 58, 56, 54, 22, 36, 28, 4, 20, 11, 
    22, 17, 33, 5, 9, 47, 31, 33, 12, 28, 36, 9, 8, 17, 40, 17, 
    9, 70, 39, 44, 62, 42, 35, 43, 6, 59, 74, 89, 64, 88, 57, 
    61, 72, 52, 54, 58, 73, 83, 62, 51, 55, 69, 57, 72, 39, 63, 
    66, 83, 64, 78, 65, 73, 54, 53, 60, 72, 25, 59, 60, 54, 59, 
    83, 73, 62, 19, 35, 80, 14, 34, 9, 44, 10, 34, 11, 32, 14, 
    15, 7, 31, 31, 30, 26, 49, 54, 52, 42, 19, 32, 13, 49, 51, 
    38, 53, 36, 26, 32, 19, 38, 17, 34, 23, 38, 48, 47, 19, 26, 
    33, 60, 35, 8, 33, 22, 27, 39, 23, 36, 24, 35, 53, 21, 35, 
    52, 51, 37, 24, 44, 22, 29, 66, 60, 57, 60, 88, 76, 56, 79, 
    78, 58, 64, 47, 57, 37, 64, 35, 32, 71, 57, 43, 83, 40, 59, 
    84, 34, 24, 50, 48, 67, 28, 45, 34, 37, 28, 34, 19, 29, 70, 
    60, 68, 82, 61, 64, 68, 63, 27, 44, 57, 52, 57, 64, 16, 35, 
    35, 19, 8, 10, 13, 52, 43, 7, 38, 23, 27, 14, 78, 25, 11, 
    14, 21, 58, 6, 45, 55, 64, 39, 57, 40, 45, 50, 54, 46, 36, 
    56, 39, 85, 39, 71, 29, 44, 56, 76, 42, 87, 64, 74, 29, 64, 
    62, 68, 49, 62, 66, 65, 61, 67, 58, 76, 58, 85, 87, 70, 73, 
    78, 22, 70, 86, 75, 80, 82, 88, 48, 83, 79, 74, 55, 67, 85, 
    42, 62, 51, 50, 47, 87, 35, 37, 54, 19, 41, 36, 58, 35, 73, 
    65, 43, 35, 19, 76, 25, 26, 79, 73, 77, 82, 70, 81, 49, 56, 
    87, 29, 52, 12, 35, 44, 67, 27, 36, 23, 23, 33, 20, 37, 76, 
    89, 84, 85, 85, 77, 46, 63, 73, 74, 82, 80, 80, 78, 68, 42, 
    27, 25, 62, 44, 20, 18, 11, 50, 17, 56, 65, 43, 36, 13, 37, 
    79, 43, 68, 46, 25, 63, 65, 67, 71, 25, 89, 62, 43, 22, 76, 
    75, 76, 73, 63, 36, 8, 69, 51, 24, 60, 47, 42, 56, 41, 62, 
    39, 70, 22, 83, 81, 75, 75, 54, 22, 75, 53, 31, 63, 69, 63, 
    76, 64, 65, 55, 58, 78, 38, 84, 52, 75, 88, 61, 49, 68, 71, 
    57, 61, 58, 42, 80, 81, 78, 56, 53, 48, 54, 33, 43, 48, 68, 
    89, 53, 17, 49, 49, 71, 54, 47, 80, 52, 35, 51, 32, 26, 59, 
    78, 79, 44, 60, 60, 82, 86, 71, 23, 71, 51, 82, 70, 45, 49, 
    25, 7, 23, 40, 75, 19, 28, 57, 3, 43, 31, 70, 39, 44, 49, 
    23, 18, 40, 59, 23, 81, 44, 50, 42, 67, 9, 44, 40, 82, 30, 
    21, 58, 47, 11, 49, 75, 37, 75, 40, 80, 75, 47, 77, 27, 51, 
    89, 52, 48, 27, 15, 21, 25, 22, 77, 24, 8, 31, 38, 30, 57, 
    32, 24, 60, 19, 56, 56, 34, 37, 33, 46, 37, 21, 68, 58, 13, 
    14, 22, 30, 37, 67, 34, 16, 30, 35, 9, 34, 9, 4, 42, 27, 
    47, 58, 55, 28, 20, 38, 21, 76, 20, 80, 49, 70, 6, 19, 25, 
    50, 5, 22, 43, 18, 33, 16, 22, 11, 31, 5, 56, 57, 75, 56, 
    56, 31, 59, 83, 22, 63, 79, 38, 88, 85, 71, 71, 90, 63, 88, 
    23, 53, 83, 47, 42, 68, 42, 40, 7, 45, 47, 24, 30, 53, 24, 
    64, 69, 32, 59, 85, 37, 59, 33, 15, 69, 39, 40, 36, 62, 46, 
    47, 41, 11, 36, 55, 16, 65, 25, 30, 22, 3, 18, 24, 38, 42, 
    12, 38, 28, 41, 25, 51, 37, 18, 33, 55, 30, 61, 36, 35, 22, 
    28, 42, 21, 9, 20, 39, 28, 26, 60, 60, 12, 54, 17, 9, 14, 
    82, 2, 59, 40, 30, 48, 42, 22, 32, 21, 48, 64, 31, 80, 68, 
    33, 65, 55, 77, 90, 71, 66, 35, 70, 39, 57, 30, 59, 64, 42, 
    68, 31, 55, 45, 42, 15, 38, 89, 80, 51, 47, 86, 78, 58, 41, 
    54, 74, 41, 67, 83, 47, 68, 33, 28, 28, 41, 35, 41, 25, 38, 
    24, 12, 31, 67, 22, 31, 89, 40, 45, 45, 52, 40, 11, 35, 15, 
    34, 67, 57, 29, 36, 82, 74, 72, 61, 79, 86, 46, 36, 62, 82, 
    58, 66, 55, 77, 68, 22, 57, 42, 15, 35, 35, 36, 5, 39, 37, 
    8, 45, 49, 14, 54, 9, 78, 31, 23, 30, 77, 63, 72, 69, 71, 
    74, 83, 65, 23, 58, 26, 20, 13, 27, 35, 45, 66, 21, 15, 35, 
    44, 54, 47, 27, 71, 81, 62, 79, 79, 86, 86, 90, 88, 73, 73, 
    13, 57, 81, 62, 42, 52, 49, 62, 46, 52, 81, 81, 18, 47, 25, 
    52, 37, 63, 45, 40, 47, 62, 26, 72, 11, 25, 28, 42, 47, 11, 
    12, 71, 18, 38, 47, 13, 81, 24, 67, 72, 66, 87, 70, 24, 65, 
    86, 38, 84, 65, 85, 50, 25, 17, 31, 38, 37, 36, 62, 27, 31, 
    29, 50, 80, 84, 89, 60, 66, 62, 19, 23, 82, 66, 90, 52, 8, 
    77, 46, 70, 67, 65, 61, 61, 86, 64, 31, 64, 17, 72, 80, 68, 
    45, 59, 41, 37, 61, 56, 35, 46, 50, 56, 49, 57, 52, 51, 42, 
    43, 74, 25, 41, 71, 42, 60, 66, 42, 53, 28, 87, 13, 50, 15, 
    5, 3, 21, 12, 38, 30, 79, 52, 20, 8, 11, 12, 25, 28, 22, 
    15, 2, 11, 12, 25, 16, 16, 21, 65, 35, 79, 85, 59, 83, 70, 
    69, 40, 79, 71, 88, 74, 71, 89, 70, 50, 74, 72, 70, 82, 59, 
    77, 83, 85, 76, 49, 68, 88, 60, 79, 60, 61, 75, 64, 63, 62, 
    42, 56, 44, 31, 61, 53, 75, 21, 85, 13, 87, 50, 69, 37, 22, 
    73, 15, 21, 34, 30, 35, 34, 32, 33, 27, 47, 8, 22, 30, 34, 
    18, 48, 45, 72, 58, 57, 51, 60, 17, 68, 47, 45, 81, 61, 56, 
    34, 68, 18, 27, 24, 38, 20, 34, 66, 20, 47, 48, 60, 44, 31, 
    44, 32, 70, 52, 11, 46, 72, 18, 56, 24, 20, 23, 17, 29, 28, 
    34, 18, 46, 17, 60, 50, 41, 12, 26, 29, 52, 47, 33, 51, 18, 
    63, 17, 58, 44, 38, 38, 46, 89, 59, 51, 84, 64, 86, 68, 83, 
    53, 44, 61, 58, 34, 73, 87, 54, 64, 74, 26, 73, 83, 60, 58, 
    78, 59, 69, 59, 54, 67, 70, 59, 38, 40, 61, 55, 90, 62, 60, 
    62, 32, 45, 61, 78, 33, 77, 76, 49, 64, 52, 70, 76, 81, 72, 
    62, 72, 38, 74, 64, 29, 9, 22, 35, 16, 46, 19, 3, 12, 13, 
    11, 5, 38, 21, 32, 47, 45, 11, 67, 68, 59, 69, 89, 68, 88, 
    70, 87, 78, 90, 84), grespe = c(40, 68, 87, 87, 64, 77, 80, 
    85, 89, 49, 23, 66, 47, 84, 49, 69, 41, 78, 66, 63, 61, 60, 
    66, 67, 83, 66, 60, 66, 87, 53, 73, 30, 83, 76, 76, 63, 79, 
    82, 52, 48, 34, 72, 54, 62, 80, 72, 74, 75, 81, 46, 46, 36, 
    73, 77, 39, 84, 79, 55, 23, 31, 75, 62, 45, 59, 80, 77, 74, 
    60, 78, 90, 79, 76, 57, 51, 58, 43, 21, 77, 65, 57, 80, 44, 
    60, 70, 68, 62, 70, 32, 69, 70, 75, 84, 80, 53, 58, 77, 45, 
    14, 67, 44, 75, 75, 34, 53, 76, 59, 64, 53, 84, 39, 84, 67, 
    74, 65, 85, 68, 87, 74, 70, 49, 72, 79, 57, 80, 57, 65, 58, 
    90, 71, 90, 67, 86, 60, 67, 41, 68, 74, 78, 78, 81, 66, 54, 
    65, 65, 58, 46, 86, 46, 39, 82, 79, 62, 75, 73, 46, 56, 90, 
    70, 68, 69, 72, 47, 31, 34, 58, 65, 52, 63, 87, 66, 56, 54, 
    48, 52, 71, 51, 62, 47, 81, 81, 62, 50, 47, 82, 85, 77, 3, 
    38, 33, 49, 22, 46, 15, 40, 88, 29, 57, 19, 18, 77, 88, 80, 
    22, 38, 64, 57, 2, 67, 48, 60, 73, 52, 11, 47, 3, 10, 73, 
    64, 30, 28, 40, 73, 54, 83, 56, 15, 78, 70, 60, 5, 48, 40, 
    32, 37, 34, 36, 39, 39, 60, 28, 17, 16, 50, 54, 27, 89, 43, 
    21, 79, 90, 78, 57, 90, 71, 84, 78, 33, 42, 78, 83, 79, 77, 
    46, 70, 80, 86, 47, 72, 66, 63, 30, 75, 38, 61, 31, 88, 58, 
    42, 53, 30, 56, 66, 51, 57, 46, 71, 89, 54, 90, 76, 90, 78, 
    49, 83, 57, 30, 16, 24, 72, 42, 43, 63, 69, 67, 88, 35, 66, 
    33, 45, 87, 34, 38, 42, 43, 58, 20, 54, 72, 44, 24, 31, 26, 
    61, 36, 40, 21, 17, 79, 51, 48, 21, 46, 39, 59, 61, 56, 49, 
    84, 37, 53, 39, 48, 59, 63, 58, 46, 84, 14, 83, 49, 8, 66, 
    33, 63, 67, 43, 80, 22, 49, 79, 79, 67, 13, 28, 81, 26, 18, 
    23, 76, 62, 55, 62, 69, 58, 32, 73, 57, 52, 37, 72, 57, 53, 
    69, 36, 54, 88, 84, 58, 57, 14, 82, 79, 64, 81, 60, 32, 47, 
    51, 61, 17, 90, 56, 78, 77, 35, 74, 85, 70, 66, 59, 27, 36, 
    78, 22, 22, 44, 43, 47, 65, 17, 52, 23, 62, 24, 38, 20, 21, 
    8, 52, 77, 85, 88, 45, 62, 69, 65, 72, 63, 39, 62, 74, 29, 
    52, 44, 77, 54, 72, 75, 85, 48, 90, 65, 51, 53, 86, 34, 74, 
    61, 71, 78, 37, 77, 67, 82, 41, 52, 47, 56, 47, 7, 64, 33, 
    43, 55, 67, 58, 86, 88, 88, 50, 29, 50, 18, 52, 31, 28, 30, 
    47, 68, 76, 79, 65, 55, 76, 67, 70, 49, 73, 72, 66, 79, 68, 
    48, 73, 65, 46, 43, 23, 48, 67, 84, 28, 37, 76, 24, 89, 59, 
    57, 79, 53, 81, 36, 80, 53, 65, 31, 63, 62, 43, 71, 49, 81, 
    61, 85, 45, 83, 75, 58, 39, 13, 45, 65, 42, 62, 35, 59, 84, 
    9, 18, 78, 79, 15, 89, 70, 74, 65, 85, 56, 58, 31, 48, 81, 
    24, 23, 63, 45, 71, 51, 70, 65, 55, 64, 47, 41, 70, 32, 55, 
    73, 81, 35, 59, 33, 35, 83, 48, 18, 64, 90, 84, 66, 83, 71, 
    73, 54, 71, 59, 84, 65, 72, 19, 33, 62, 78, 54, 37, 38, 85, 
    75, 88, 75, 66, 53, 51, 47, 59, 72, 60, 62, 55, 84, 87, 84, 
    57, 47, 82, 9, 88, 41, 88, 67, 40, 81, 57, 19, 51, 20, 81, 
    32, 55, 84, 86, 61, 87, 73, 78, 66, 85, 57, 70, 70, 51, 60, 
    67, 61, 50, 71, 70, 49, 90, 86, 74, 30, 72, 84, 8, 89, 68, 
    43, 50, 42, 89, 69, 29, 64, 78, 58, 75, 53, 38, 64, 77, 79, 
    74, 43, 70, 59, 56, 38, 83, 67, 23, 45, 40, 57, 77, 41, 56, 
    68, 60, 28, 58, 73, 80, 58, 42, 76, 82, 32, 28, 52, 52, 70, 
    67, 58, 85, 31, 9, 68, 42, 88, 37, 33, 73, 64, 85, 89, 76, 
    37, 88, 65, 74, 68, 40, 49, 87, 32, 67, 84, 39, 71, 30, 65, 
    49, 23, 79, 82, 56, 75, 64, 80, 59, 74, 48, 24, 57, 37, 48, 
    68, 79, 81, 85, 67, 88, 52, 84, 67, 61, 57, 31, 73, 72, 88, 
    66, 77, 89, 25, 59, 55, 83, 48, 49, 44, 48, 35, 30, 58, 62, 
    85, 89, 84, 68, 39, 90, 88, 88, 72, 57, 64, 85, 85, 38, 86, 
    24, 54, 76, 60, 44, 75, 24, 37, 82, 87, 78, 80, 81, 54, 82, 
    57, 87, 69, 76, 84, 71, 61, 34, 58, 87, 60, 44, 54, 81, 68, 
    49, 83, 69, 75, 76, 81, 68, 76, 66, 41, 68, 84, 56, 88, 87, 
    64, 60, 71, 82, 87, 63, 88, 34, 70, 62, 76), hakdac = c(56, 
    57, 79, 78, 39, 49, 34, 54, 79, 83, 78, 87, 60, 67, 78, 73, 
    42, 30, 90, 84, 68, 65, 42, 64, 81, 85, 71, 72, 63, 69, 69, 
    71, 70, 88, 71, 78, 52, 81, 86, 84, 65, 49, 49, 57, 42, 69, 
    71, 79, 19, 25, 77, 61, 36, 73, 58, 60, 28, 89, 72, 34, 29, 
    73, 89, 58, 10, 54, 49, 79, 6, 88, 28, 58, 82, 67, 89, 76, 
    58, 67, 49, 41, 86, 57, 81, 83, 29, 28, 83, 87, 74, 62, 85, 
    90, 71, 47, 61, 55, 63, 85, 83, 87, 69, 81, 85, 69, 65, 36, 
    44, 90, 71, 64, 10, 71, 81, 30, 90, 52, 41, 61, 78, 50, 72, 
    32, 25, 25, 58, 72, 55, 73, 48, 57, 25, 75, 39, 89, 39, 18, 
    52, 74, 82, 75, 31, 40, 40, 42, 87, 74, 20, 80, 88, 29, 62, 
    27, 26, 32, 82, 47, 73, 74, 61, 65, 43, 33, 81, 34, 50, 82, 
    39, 80, 39, 40, 38, 68, 42, 64, 82, 43, 35, 76, 64, 61, 52, 
    79, 37, 69, 85, 86, 34, 51, 63, 80, 60, 63, 19, 74, 25, 29, 
    64, 67, 65, 18, 26, 58, 77, 68, 40, 27, 18, 65, 58, 54, 64, 
    75, 58, 38, 89, 43, 80, 59, 61, 60, 79, 90, 79, 68, 45, 87, 
    80, 39, 82, 84, 78, 86, 48, 47, 89, 68, 90, 90, 84, 75, 77, 
    88, 38, 80, 61, 58, 69, 73, 84, 48, 18, 89, 58, 66, 78, 53, 
    55, 85, 32, 82, 86, 60, 32, 35, 52, 71, 82, 69, 78, 79, 46, 
    19, 73, 35, 57, 52, 16, 64, 36, 77, 53, 66, 32, 55, 87, 40, 
    71, 43, 87, 88, 75, 73, 66, 80, 60, 54, 64, 68, 59, 50, 62, 
    90, 70, 20, 75, 56, 32, 80, 66, 70, 84, 75, 56, 57, 46, 72, 
    86, 58, 79, 50, 61, 90, 77, 74, 67, 87, 55, 63, 61, 34, 78, 
    81, 48, 60, 55, 80, 54, 81, 84, 49, 85, 35, 88, 83, 70, 51, 
    52, 23, 11, 61, 69, 75, 49, 77, 83, 30, 85, 74, 65, 74, 34, 
    84, 84, 64, 23, 27, 65, 67, 69, 77, 69, 49, 51, 65, 87, 10, 
    76, 40, 63, 60, 59, 83, 32, 80, 55, 49, 72, 55, 78, 34, 84, 
    66, 86, 72, 53, 77, 75, 81, 71, 60, 71), hibbra = c(29, 76, 
    57, 51, 47, 65, 62, 77, 68, 14, 31, 49, 61, 41, 66, 6, 35, 
    83, 84, 42, 50, 67, 76, 66, 79, 23, 3, 18, 44, 43, 43, 8, 
    76, 66, 54, 48, 35, 4, 32, 54, 57, 19, 25, 67, 41, 35, 32, 
    38, 44, 42, 48, 19, 4, 2, 46, 28, 67, 27, 72, 6, 30, 24, 
    8, 88, 28, 23, 8, 43, 31, 46, 70, 56, 47, 52, 47, 51, 89, 
    30, 44, 58, 24, 46, 50, 52, 87, 54, 69, 60, 50, 37, 25, 72, 
    23, 21, 48, 31, 68, 64, 21, 27, 24, 26, 15, 16, 27, 4, 42, 
    19, 60, 15, 27, 24, 8, 40, 17, 14, 26, 81, 27, 16, 10, 19, 
    30, 36, 26, 67, 9, 24, 25, 11, 33, 60, 22, 36, 58, 41, 71, 
    60, 67, 44, 59, 53, 73, 75, 40, 49, 21, 33, 17, 21, 33, 40, 
    25, 41, 31, 88, 51, 24, 14, 64, 52, 76, 15, 78, 87, 57, 50, 
    57, 19, 52, 30, 46, 33, 49, 54, 84, 45, 48, 63, 26, 86, 40, 
    21, 9, 9, 10, 86, 80, 71, 87, 77, 65, 43, 72, 37, 30, 86, 
    23, 66, 67, 22, 88, 77, 57, 86, 74, 55, 81, 89, 15, 50, 65, 
    76, 52, 35, 31, 46, 54, 47, 82, 55, 77, 29, 38, 22, 7, 54, 
    14, 22, 50, 31, 44, 39, 29, 12, 28, 65, 28, 17, 41, 30, 20, 
    45, 75, 21, 54, 37, 86, 69, 32, 87, 13, 45, 71, 51, 45, 15, 
    60, 61, 23, 64, 42, 53, 57, 63, 87, 45, 78, 82, 61, 43, 47, 
    42, 76, 43, 44, 44, 63, 58, 35, 39, 55, 46, 83, 50, 52, 88, 
    38, 66, 15, 34, 59, 85, 27, 13, 77, 26, 65, 38, 34, 22, 77, 
    26, 59, 33, 13, 65, 62, 39, 40, 78, 25, 83, 29, 40, 19, 66, 
    34, 13, 15, 40, 11, 29, 79, 19, 45, 68, 51, 75, 76, 67, 57, 
    63, 86, 31, 45, 83, 51, 86, 61, 58, 22, 66, 82, 62, 84, 78, 
    54, 73, 83, 26, 31, 50, 38, 60, 54, 61, 41, 71, 69, 78, 23, 
    36, 87, 87, 51, 74, 71, 37, 41, 84, 75, 14, 65, 55, 64, 56, 
    45, 66, 60, 28, 69, 67, 4, 35, 74, 72, 30, 37, 24, 36, 20, 
    65, 27, 12, 21, 52, 72, 32, 42, 32, 37, 53, 52, 36, 74, 51, 
    63, 87, 70, 49, 86, 16, 27, 84, 47, 80, 42, 74, 44, 86, 49, 
    70, 74, 76, 40, 32, 73, 77, 23, 22, 43, 77, 44, 60, 65, 49, 
    33, 32, 30, 24, 86, 44, 48, 79, 63, 69, 13, 70, 42, 74, 17, 
    83, 37, 69, 73, 76, 42, 59, 46, 42, 51, 72, 72, 30, 72, 20, 
    15, 84, 36, 75, 89, 10, 26, 51, 14, 64, 58, 60, 42, 48, 65, 
    76, 82, 11, 63, 68, 58, 67, 43, 53, 68, 16, 39, 49, 55, 79, 
    20, 12, 24, 51, 67, 55, 10, 25, 28, 50, 52, 41, 25, 68, 35, 
    35, 68, 14, 63, 77, 80, 78, 56, 82, 51, 41, 51, 46, 42, 39, 
    87, 52, 74, 85, 85, 72, 55, 51, 57, 56, 60, 65, 56, 57, 64, 
    22, 76, 75, 41, 58, 65, 25, 83, 90, 50, 68, 27, 53, 29, 73, 
    42, 52, 62, 34, 61, 34, 68, 39, 29, 21, 61, 54, 42, 72, 64, 
    47, 12, 52, 45, 58, 48, 36, 75, 9, 75, 40, 62, 74, 78, 27, 
    4, 69, 90, 25, 76, 23, 37, 46, 35, 27, 82, 76, 66, 76, 49, 
    85, 26, 36, 80, 24, 48, 44, 65, 24, 59, 52, 25, 38, 44, 39, 
    36, 32, 53, 81, 50, 60, 64, 58, 49, 52, 51, 11, 48, 26, 28
    ), isoane = c(12, 42, 36, 3, 60, 70, 67, 31, 26, 64, 23, 
    36, 44, 26, 59, 41, 36, 36, 32, 38, 20, 78, 46, 22, 74, 89, 
    35, 43, 68, 52, 72, 67, 8, 46, 36, 19, 68, 53, 85, 40, 42, 
    45, 62, 29, 25, 75, 67, 20, 51, 37, 54, 38, 27, 27, 59, 85, 
    72, 25, 29, 79, 16, 70, 33, 34, 40, 21, 31, 34, 28, 68, 24, 
    38, 49, 41, 60, 63, 69, 65, 50, 88, 65, 66, 28, 69, 23, 48, 
    22, 54, 57, 22, 63, 84, 15, 62, 88, 48, 49, 83, 22, 45, 72, 
    51, 74, 52, 70, 55, 19, 89, 35, 72, 71, 51, 21, 84, 70, 32, 
    20, 85, 18, 82, 79, 39, 50, 86, 17, 48, 64, 49, 49, 73, 48, 
    76, 80, 37, 14, 57, 61, 68, 28, 82, 20, 15, 45, 39, 44, 27, 
    52, 47, 34, 45, 32, 39, 37, 50, 26, 43, 40, 49, 36, 21, 40, 
    55, 42, 11, 50, 28, 76, 52, 23, 63, 24, 42, 12, 69, 41, 41, 
    69, 22, 51, 55, 51, 61, 49, 38, 34, 48, 32, 31, 51, 51, 22, 
    46, 48, 54, 32, 24, 25, 50, 33, 34, 18, 87, 31, 57, 53, 16, 
    43, 9, 11, 14, 25, 18, 24, 52, 32, 26, 30, 12, 19, 31, 25, 
    15, 30, 47, 67, 89, 73, 38, 34, 16, 26, 34, 50, 15, 10, 67, 
    85, 37, 38, 45, 60, 64, 36, 62, 64, 74, 38, 21, 87, 61, 50, 
    86, 89, 33, 20, 86, 51, 78, 38, 79, 77, 76, 62, 17, 21, 79, 
    58, 86, 41, 52, 83, 7, 56, 81, 35, 68, 32, 58, 38, 74, 51, 
    45, 60, 86, 15, 69, 87, 78, 37, 49, 86, 71, 64, 71, 25, 81, 
    36, 68, 51, 37, 11, 28, 5, 24, 20, 11, 30, 33, 42, 79, 63, 
    35, 84, 79, 83, 11, 79, 38, 61, 88, 38, 61, 88, 68, 17, 37, 
    65, 62, 71, 28, 77, 27, 15, 23, 12, 27, 19, 11, 41, 79, 71, 
    19, 24, 21, 10, 39, 29, 34, 39, 68, 37, 40, 22, 73, 75, 31, 
    76, 6, 76, 60, 71, 23, 41, 84, 67, 14, 76, 40, 29, 8, 24, 
    57, 78, 28, 85, 83, 76, 71, 16, 65, 75, 34, 45, 30, 78, 55, 
    13, 89, 76, 56, 49, 16, 75, 12, 51, 34, 15, 76, 63, 49, 5, 
    24, 39, 90, 42, 40, 78, 56, 53, 46, 73, 69, 17, 79, 11, 75, 
    8, 37, 84, 44, 65, 58, 44, 50, 80, 36, 31, 38, 67, 32, 74, 
    40, 61, 38, 57, 39, 62, 43, 30, 24, 42, 32, 80, 16, 56, 55, 
    52, 30, 37, 58, 54, 46, 16, 49, 52, 51, 50, 13, 56, 81, 38, 
    86, 62, 63, 38, 58, 83, 75, 64, 65, 49, 33, 59, 58, 29, 37, 
    27, 43, 89, 64, 49, 45, 49, 76, 49, 62, 42, 57, 62, 82, 78, 
    15, 20, 79, 57, 35, 37, 11, 67, 36, 21, 48, 43, 25, 57, 38, 
    54, 15, 44, 59, 52, 31, 77, 60, 2, 52, 55, 17, 59, 4, 68, 
    36, 13, 78, 54, 29, 71, 50, 67, 55, 85, 62, 67, 51, 76, 39, 
    60, 60, 33, 62, 42, 39, 65, 30, 40, 57, 26, 55, 48, 39, 63, 
    18, 37, 62, 54, 65, 67, 48, 44, 72, 59, 48, 63, 48, 76, 67, 
    46, 14, 79, 44, 61, 8, 81, 46, 47, 82, 14, 50, 51, 28, 69, 
    32, 34, 59, 30, 69, 42, 89, 83, 49, 82, 45, 72, 84, 80, 30, 
    87, 51, 26, 64, 43, 68, 82, 59, 87, 49, 81, 59, 86, 57, 47, 
    55, 53, 61, 70, 24, 70, 60, 48, 66, 74, 84, 61, 44, 59, 58, 
    35, 38, 38, 65, 47, 44, 52, 44, 59, 69, 44, 29, 54), kunpar = c(58, 
    52, 36, 34, 67, 21, 37, 52, 81, 42, 56, 62, 47, 57, 38, 40, 
    48, 11, 70, 62, 25, 74, 37, 19, 88, 63, 72, 45, 64, 79, 73, 
    76, 84, 31, 84, 67, 79, 53, 64, 79, 11, 27, 60, 54, 87, 88, 
    78, 86, 56, 85, 53, 10, 69, 19, 61, 44, 74, 10, 56, 83, 65, 
    9, 25, 66, 38, 52, 44, 84, 62, 24, 63, 77, 44, 44, 56, 77, 
    72, 37, 84, 89, 32, 80, 69, 66, 35, 37, 80, 72, 67, 66, 41, 
    65, 57, 54, 39, 61, 54, 57, 48, 14, 82, 17, 81, 21, 70, 64, 
    90, 40, 69, 36, 25, 86, 47, 30, 52, 66, 45, 43, 23, 76, 48, 
    68, 77, 67, 35, 70, 55, 42, 39, 78, 88, 14, 35, 79, 21, 69, 
    83, 14, 56, 49, 40, 40, 41, 52, 77, 49, 43, 53, 87, 82, 60, 
    67, 54, 30, 41, 37, 49, 85, 2, 14, 89, 58, 63, 74, 41, 80, 
    56, 53, 86, 42, 58, 45, 27, 87, 76, 33, 24, 68, 28, 30, 60, 
    34, 35, 67, 50, 49, 82, 64, 52, 48, 53, 46, 45, 53, 57, 67, 
    70, 55, 54, 83, 52, 51, 35, 55, 42, 48, 85, 47, 49, 64, 56, 
    44, 37, 53, 73, 74, 86, 44, 64, 66, 67, 44, 24, 87, 47, 52, 
    67, 34, 63, 32, 90, 78, 84, 23, 19, 59, 29, 81, 86, 47, 90, 
    88, 78, 36, 68, 76, 88, 73, 46, 61, 32, 57, 67, 56, 26, 87, 
    60, 33, 84, 37, 71, 73, 82, 17, 45, 52, 55, 82, 79, 72, 89, 
    68, 67, 25, 59, 77, 70, 58, 67, 76, 20, 60, 55, 74, 88, 75, 
    73, 78, 13, 86, 76, 88, 67, 87, 66, 78, 65, 66, 33, 78, 63, 
    69, 74, 88, 34, 66, 80, 65, 53, 73, 63, 61, 61, 71, 70, 64, 
    56, 56, 71, 73, 60, 72, 72, 65, 72, 46, 80, 75, 60, 72, 83, 
    47, 52, 48, 62, 50, 56, 42, 40, 52, 43, 55, 77, 65, 82, 86, 
    38, 84, 68, 59, 14, 16, 74, 53, 76, 23, 79, 76, 85, 51, 31, 
    49, 85, 71, 51, 34, 46, 68, 61, 80, 55, 77, 35, 63, 56, 54, 
    80, 66, 71, 45, 85, 80, 72, 85, 68, 67, 88, 87, 69, 77, 57, 
    76, 82, 85, 45, 52, 87, 76, 65, 74, 82, 57, 85, 62, 88, 59, 
    80, 89, 58, 68, 47, 77, 80, 86, 50, 56, 56, 51, 66, 70, 75, 
    71, 73, 85, 66, 76, 44, 29, 80, 64, 29, 48, 63, 51, 75, 28, 
    43, 22, 89, 75, 83, 74, 55, 20, 35, 30, 54, 65, 66, 89, 77, 
    78, 69, 48, 88, 72, 77, 56, 81, 62, 59, 90, 56, 88, 58, 36, 
    70, 37, 49, 68, 52, 82, 57, 80, 40, 89, 69, 77, 49, 55, 48, 
    45, 59, 54, 80, 86, 21, 53, 76, 52, 37, 81, 73, 39, 72, 69, 
    42, 79, 46, 37, 32, 68, 18, 82, 58, 77, 80, 42, 23, 72, 45, 
    78, 61, 89, 57, 82, 64, 88, 37, 73, 30, 37, 85, 71, 87, 27, 
    33, 48, 61, 26, 23, 63, 31, 76, 28, 90, 67, 66, 32, 65, 56, 
    41, 26, 21, 81, 80, 50, 78, 86, 41, 64, 71, 81, 23, 86, 73, 
    30, 73, 65, 22, 67, 64, 75, 34, 86, 89, 48, 59, 20, 43, 33, 
    20, 75, 74, 37, 72, 82, 89, 79, 39, 41, 56, 68, 49, 85, 73, 
    63, 68, 38, 77, 66, 33, 90, 83, 20, 35, 80, 63, 80, 22, 35, 
    16, 75, 75, 12, 72, 74, 17, 72, 27, 30, 11, 55, 29, 33, 70, 
    10, 74, 47, 19, 46, 58, 82, 54, 79, 80, 64, 53, 63, 70, 35, 
    52, 69, 73, 51, 32, 70, 38, 31, 78, 75, 74, 20, 54, 32, 59, 
    76, 54, 55, 47, 58, 53, 39, 39, 56, 29, 43, 44, 39, 44, 70, 
    26, 13, 46, 86, 85, 82, 82, 58, 46, 76, 66, 82, 20, 25, 58, 
    53, 31, 75, 55, 87, 84, 50, 36, 16, 44, 79, 65, 9, 72, 40, 
    82, 81, 59, 39, 59, 88, 46, 47, 35, 43, 20, 87, 56, 66, 25, 
    23, 34, 38, 44, 70, 50, 38, 43, 65, 55, 37, 31, 70, 68, 72, 
    60, 51, 76, 74, 47, 61, 38, 54, 46, 65, 56, 57, 70, 48, 48, 
    44, 83, 68, 40, 85, 43, 61, 54, 34, 67, 29, 45, 49, 41, 65, 
    71, 71, 40, 37, 64, 61, 53, 76, 38, 16, 83, 35, 82, 78, 74, 
    83, 45, 19, 27, 29, 68, 74, 71, 77, 13, 80, 46, 38, 74, 25, 
    60, 83, 34, 60, 42, 70, 66, 56, 40, 36, 56, 45, 60, 31, 84, 
    51, 56, 67, 61, 61, 55, 81, 70, 82, 63, 36, 48, 57, 82, 63, 
    70, 58, 41, 47, 57, 44, 61, 14, 16, 76, 20, 89, 72, 34, 51, 
    72, 13, 79, 47, 78, 88, 31, 79, 56, 53, 61, 52, 68, 49, 66, 
    48, 30, 61, 27, 30, 21, 84, 87, 77, 49, 46, 44, 30, 75, 38, 
    25, 69, 19, 80, 88, 19, 65, 43, 80, 87, 57, 77, 64, 49, 43, 
    16, 18, 18, 73, 57, 11, 39, 36, 79, 54, 71, 88, 55, 8, 78, 
    19, 42, 89, 67, 58, 70, 8, 48, 72, 16, 65, 79, 9, 20, 70, 
    84, 84, 69, 81, 76, 56, 54, 70, 42, 28, 81, 42, 81, 16, 20, 
    84, 29, 65, 61, 30, 86, 2, 49, 42, 54, 60, 64, 51, 50, 32, 
    76, 68, 27, 64, 90, 43, 61, 71, 28, 38, 40, 62, 45, 40, 30, 
    37, 32, 51, 65, 55, 44, 69, 50, 79, 26, 39, 24, 58, 42, 53, 
    77, 48, 57, 63, 32, 86, 79, 66, 43, 73, 23, 27, 16, 44, 81, 
    79, 83, 48, 29, 65, 85, 85, 43, 64, 32, 65, 14, 45, 41, 37, 
    87, 42, 34, 28, 62, 32, 57, 78, 54, 49, 54, 55, 52, 83, 79, 
    51, 54, 73, 36, 80, 82, 72, 42, 61, 20, 85, 78, 86, 86, 55, 
    60, 69, 55, 20, 61, 78, 52, 31, 24, 62, 55, 44, 59, 13, 73, 
    86, 40, 63, 45, 62, 56, 57, 67, 85, 43, 68, 22, 75, 36, 77, 
    78, 31, 78, 88, 87, 86, 58, 50, 39, 82, 52, 60, 49, 71, 42, 
    56, 28, 49, 52, 53, 62, 82, 41, 38, 64, 52, 56, 59, 53, 21, 
    74, 6, 82, 74, 42, 43, 79, 62, 70, 28, 77, 90, 26, 61, 39, 
    69, 78, 14, 60, 17, 50, 60, 68, 74, 35, 72, 73, 72, 66, 41, 
    53, 69, 47, 36, 48, 47, 73, 82, 60, 69, 48, 52, 56, 75, 73, 
    56, 17, 81, 63, 46, 62, 77, 43, 45, 59, 50, 66, 64, 54, 62, 
    44, 32, 46, 47, 48, 75, 90, 41, 53, 44, 56, 61, 49, 71, 60, 
    33, 59, 12, 87, 74, 13, 59, 25, 54, 44, 60, 40, 53, 68, 28, 
    59, 85, 63, 52, 43, 42, 68, 52, 61, 34, 45, 64, 76, 42, 7, 
    60, 84, 88, 45, 47, 67, 55, 45, 29, 31, 67, 45, 25, 36, 50, 
    58, 82, 15, 64, 87, 22, 37, 81, 65, 86, 15, 54, 55, 55, 67, 
    60, 32, 45, 38, 48, 60, 61, 54, 50, 44, 74, 42, 67, 59, 62, 
    63, 85, 55, 47, 40, 38, 71, 68, 36, 70, 53, 33, 72, 76, 18, 
    76, 55, 38, 70, 44, 88, 83, 57, 18, 47, 69, 17, 84, 42, 34, 
    29, 41, 47, 47, 76, 38, 48, 57, 87, 52, 49, 68, 80, 66, 44, 
    57, 20, 28, 64, 57, 34, 55, 75, 89, 77, 88, 26, 18, 73, 86, 
    57, 83, 26, 83, 52, 64, 48, 72, 51, 77, 30, 55, 44, 44, 78, 
    86, 72, 28, 16, 68, 89, 88, 56, 19, 82, 47, 21, 69, 52, 28, 
    32, 21, 69), lamfor = c(64, 61, 46, 68, 6, 46, 57, 71, 64, 
    46, 38, 67, 42, 43, 34, 33, 73, 65, 62, 54, 37, 87, 58, 36, 
    53, 39, 84, 41, 51, 68, 37, 35, 56, 40, 52, 64, 84, 49, 43, 
    46, 34, 39, 53, 51, 69, 87, 55, 49, 66, 63, 50, 61, 57, 21, 
    84, 62, 66, 89, 52, 39, 68, 57, 55, 83, 86, 58, 55, 61, 41, 
    78, 59, 65, 76, 70, 61, 64, 67, 65, 67), lasfer = c(25, 38, 
    61, 40, 39, 19, 33, 12, 28, 42, 45, 88, 30, 38, 2, 32, 37, 
    20, 72, 36, 22, 47, 39, 15, 4, 23, 9, 47, 38, 38, 40, 36, 
    34, 76, 70, 76, 49, 73, 42, 26, 74, 23, 26, 66, 22, 26, 68, 
    74, 34, 14, 59, 55, 16, 59, 44, 49, 20, 32, 44, 56, 54, 77, 
    56, 37, 28, 57, 31, 66, 38, 41, 59, 40, 33, 57, 47, 50, 43, 
    25, 52, 73, 27, 50, 76, 41, 23, 56, 50, 11, 68, 39, 31, 57, 
    20, 54, 22, 40, 69, 27, 32, 57, 54, 38, 75, 68, 33, 43, 51, 
    47, 39, 57, 69, 56, 36, 36, 87, 25, 31, 33, 17, 47, 31, 55, 
    71, 73, 47, 78, 34, 48, 74, 36, 4, 37, 46, 46, 64, 51, 38, 
    34, 77, 32, 59, 26, 11, 75, 58, 10, 32, 39, 39, 56, 63, 19, 
    24, 18), lepspp = c(75, 74, 68, 85, 83, 68, 80, 65, 59, 78, 
    59, 37, 71, 36, 78, 79, 63, 80, 52, 63, 63, 44, 86, 74, 60, 
    64, 71, 42, 64, 89, 79, 61, 67, 77, 80, 72, 68, 64, 47, 80, 
    66, 82, 83, 62, 88, 76, 47, 66, 61, 71, 59, 79, 32, 54, 72, 
    45, 84, 72, 61, 83, 40, 74, 52, 54, 85, 23, 82, 76, 51, 77, 
    82, 69, 83, 86, 89, 82, 81, 74, 74, 64, 88, 59, 47, 83, 85, 
    64, 51, 87, 80, 48, 87, 83, 88, 81, 53, 78, 86, 67, 75, 73, 
    33, 55, 77, 70, 82, 75, 57, 23, 71, 86, 33, 89, 66, 61, 42, 
    80, 36, 82, 49, 31, 85, 61, 67, 68, 36, 82, 64, 13, 45, 77, 
    62, 71, 85, 68, 47, 84, 64, 57, 79, 85, 60, 69, 80, 78, 80, 
    45, 65, 51, 40, 76, 87, 58, 71, 88, 61, 24, 51, 76, 68, 67, 
    70, 82, 79, 73, 61, 88, 89, 75, 88, 42, 89, 49, 49, 74, 90, 
    52, 48, 88, 88, 85, 83, 79, 85, 88, 65, 71, 79, 86, 67, 41, 
    63, 75, 72, 61, 89, 59, 51, 71, 44, 72, 69, 70, 68, 54, 80, 
    88, 75, 52, 61, 86, 82, 12, 79, 20, 66, 30, 76, 73, 61, 53, 
    56, 86, 82, 68, 60, 56, 57, 32, 51, 88, 15, 84, 85, 84, 67, 
    79, 71, 83, 80, 65, 49, 65, 33, 50, 47, 72, 65, 65, 59, 86, 
    68, 76, 80, 74, 89, 40, 74, 40, 77, 85, 88, 85, 88, 85, 68, 
    71, 73, 76, 86, 45, 21, 59, 82, 86, 62, 75, 80, 62, 59, 81, 
    67, 65, 76, 79, 19, 82, 85, 76, 79, 69, 45, 59, 46, 76, 41, 
    83, 74, 48, 78, 71, 66, 50, 88, 83, 62, 63, 75, 74, 76, 84, 
    79, 76, 84, 74, 76, 76, 66, 86, 82, 75, 79, 90), leptri = c(55, 
    52, 55, 56, 42, 90, 48, 74, 77, 18, 71, 85, 39, 89, 48, 65, 
    64, 72, 73, 54, 63, 50, 54, 57, 64, 44, 71, 44, 65, 72, 64, 
    43, 29, 78, 87, 81, 78, 79, 63, 87, 58, 82, 53, 19, 69, 63, 
    54, 80, 51, 80, 68, 55, 53, 31, 88, 60, 17, 69, 68, 70, 84, 
    87, 63, 49, 51, 32, 65, 64, 64, 52, 57, 88, 50, 76, 85, 51, 
    57, 57, 72, 34, 70, 32, 11, 86, 76, 47, 77, 50, 78, 67, 89, 
    71, 74, 64, 56, 61, 19, 82, 64, 79, 45, 60, 80, 58, 62, 61, 
    34, 78, 21, 39, 84, 78, 54, 35, 54, 85, 44, 86, 39, 36, 46, 
    88, 66, 61, 53, 40, 77, 76, 19, 76, 88, 25, 78, 39, 75, 84, 
    50, 47, 62, 64, 69, 86, 32, 68, 80, 64, 76, 31, 69, 63, 66, 
    16, 80, 30, 54, 26, 83, 47, 40, 84, 47, 45, 61, 40, 74, 8, 
    40, 36, 50, 71, 47, 32, 62, 82, 63, 87, 82, 26, 75, 21, 39, 
    86, 32, 66, 89, 73, 82, 66, 42, 60, 59, 57, 73, 58, 46, 84, 
    14, 89, 44, 71, 80, 83, 59, 63, 26, 67, 82, 54, 40, 86, 58, 
    41, 74, 11, 32, 32, 54, 65, 29, 67, 68, 43, 79, 65, 49, 35, 
    29, 78, 45, 53, 41, 49, 79, 41, 72, 41, 41, 42, 60, 33, 59, 
    63, 73, 70), leumic = c(33, 56, 25, 47, 35, 44, 15, 49, 11, 
    38, 29, 46, 12, 37, 53, 26, 35, 34, 88, 77, 47, 22, 38, 36, 
    86, 60, 54, 26, 44, 71, 83, 40, 72, 43, 9, 82, 83, 48, 87, 
    7, 55, 43, 59, 75, 48, 77, 76, 60, 30, 61, 20, 41, 37, 46, 
    27, 59, 66, 70, 60, 76, 46, 67, 8, 70, 88, 42, 79, 81, 59, 
    26, 39, 43, 74, 43, 58, 33, 84, 28, 42, 81, 82, 55, 83, 51, 
    40, 85, 55, 36, 62, 21, 46, 54, 43, 38, 20, 57, 26, 38, 53, 
    30, 53, 15, 20, 64, 24, 72, 61, 40, 24, 39, 59, 5, 75, 62, 
    40, 35, 62, 76, 74, 78, 85, 25, 63, 47, 84, 82, 44, 25, 50, 
    24, 27, 6, 38, 73, 57, 16, 27, 44, 5, 70, 75, 75, 19, 26, 
    17, 75, 49, 32, 57, 58, 67, 25, 40, 89, 46, 32, 54, 66, 40, 
    38, 54, 58, 47, 58, 55, 62, 80, 15, 67, 87, 63, 13, 58, 74, 
    86, 70, 51, 51, 56, 77, 55, 88, 47, 23, 79, 21, 35, 62, 58, 
    45, 54, 84, 49, 36, 76, 72, 86, 27, 86, 37, 21, 90, 57, 57, 
    26, 79, 70, 73, 63, 45, 31, 33, 77, 16, 31, 65, 57, 30, 60, 
    29, 71, 19, 38, 67, 65, 85, 90, 20, 33, 51, 39, 11, 49, 47, 
    32, 45, 35, 44, 43, 76, 8, 32, 60, 58, 21, 82, 48, 31, 36, 
    64, 43, 35, 68, 66, 89, 83, 66, 28, 50, 78, 89, 61, 51, 76, 
    59, 69, 24, 48, 72, 55, 68, 61, 80, 57, 88, 36, 59, 53, 67, 
    77, 35, 45, 18, 74, 23, 81, 87, 83, 58, 30, 59, 72, 39, 83, 
    56, 66, 87, 21, 31, 75, 30, 44, 28, 90, 79, 86, 77, 57, 60, 
    90, 27, 83, 74, 82, 18, 64, 25, 83, 22, 56, 50, 7, 53, 57, 
    41, 68, 87, 41, 22, 13, 74, 72, 35, 84, 34, 40, 42, 79, 76, 
    60, 31, 81, 65, 84, 56, 87, 21, 32, 58, 63, 49, 50, 62, 39, 
    76, 35, 36, 42, 62, 44, 71, 64, 47, 15, 32, 76, 48, 49, 70, 
    52, 62, 35, 33, 55, 45, 50, 34, 61, 45, 21, 29, 39, 5, 24, 
    41, 73, 38, 88, 24, 54, 18, 47, 23, 77, 77, 24, 26, 48, 55, 
    58, 47, 70, 53, 51, 23, 20, 44, 37, 55, 59, 74, 66, 83, 80, 
    76, 68, 82, 88, 73, 67, 57, 63, 56, 62, 73, 45, 38, 49, 78, 
    56, 70, 44, 65, 41, 53, 52, 15, 18, 43, 30, 49, 33, 41, 50, 
    14, 34, 34, 23, 32, 52, 69, 59, 17, 66, 53, 77, 60, 59, 7, 
    66, 49, 63, 35, 86, 75, 76, 85, 60, 49, 66, 49, 42, 73, 39, 
    60, 80, 38, 42, 81, 14, 29, 5, 67, 30, 47, 41, 69, 58, 74, 
    73, 80, 8, 50, 59, 86, 63, 46, 72, 41, 89, 31, 40, 74, 44, 
    71, 88, 68, 58, 44, 71, 33, 70, 68, 65, 88, 55, 32, 75, 65, 
    82, 77, 78, 47, 54, 60, 22, 28, 26, 80, 63, 85, 77, 66, 59, 
    80, 25, 7, 24, 65, 48, 62, 89, 49, 88, 70, 75, 77, 35, 67, 
    39, 16, 24, 81, 83, 89, 62, 57, 53, 85, 89, 33, 45, 82, 73, 
    39, 76, 60, 47, 90, 19, 79, 45, 10, 20, 36, 62, 56, 40, 80, 
    48, 40, 74, 21, 86, 88, 47, 30, 11, 77, 41, 56, 21, 59, 39, 
    40, 54, 63, 54, 78, 64, 63, 52, 86, 41, 53, 64, 71, 45, 57, 
    26, 68, 36, 49, 69, 42, 31, 65, 83, 89, 43, 45, 73, 77, 49, 
    66, 48, 69, 33, 32, 26, 47, 60, 25, 13, 18, 74, 86, 85, 18, 
    61, 87, 65, 58, 19, 35, 58, 86, 37, 90, 72, 85, 81, 89, 73, 
    27, 59, 82, 67, 59, 31, 66, 37, 77, 55, 57, 70, 32, 39, 23, 
    67, 21, 45, 17, 66, 82, 63, 64, 83, 17, 35, 71, 45, 66, 64, 
    31, 78, 87, 75, 53, 54, 47, 65, 56, 76, 89, 39, 71, 55, 86, 
    81, 77, 1, 53, 87, 79, 87, 37, 35, 69, 19, 16, 40, 55, 8, 
    41, 13, 20, 27, 36, 64, 63, 86, 42, 53, 50, 43, 49, 9, 48, 
    29, 76, 43, 38, 42, 12, 53, 69, 36, 23, 59, 40, 51, 21, 37, 
    46, 28, 62, 46, 21, 17, 30, 51, 79, 19, 82, 16, 13, 73, 67, 
    52, 19, 4, 26, 52, 58, 61, 35, 17, 54, 89, 87, 19, 49, 12, 
    66, 19, 20, 54, 46, 29, 42, 63, 53, 32, 51, 12, 63, 70, 9, 
    52, 35, 17, 39, 43, 52, 42, 84, 44, 46, 56, 44, 55, 69, 32, 
    74, 42, 82, 10, 43, 65, 49, 45, 11, 46, 22, 21, 57, 66, 69, 
    45, 83, 87, 67, 64, 25, 46, 43, 62, 63, 47, 43, 47, 25, 60, 
    83, 58, 71, 49, 73, 61, 78, 71, 87, 49, 61, 82, 72, 60, 60, 
    23, 46, 48, 65, 54, 59, 17, 64, 80, 17, 34, 22, 27, 38, 35, 
    69, 90, 68, 27, 33, 62, 73, 82, 22, 70, 82, 61, 81, 88, 22, 
    70, 87, 90, 61, 53, 42, 58, 38, 40, 69, 68, 67, 29, 62, 6, 
    78, 51, 39, 24, 44, 84, 59, 58, 29, 63, 70, 44, 13, 77, 74, 
    28, 27, 58, 35, 33, 32, 64, 72, 39, 56, 56, 4, 41, 40, 59, 
    43, 27, 42, 64, 26, 56, 84, 62, 30, 34, 56, 45, 82, 46, 32, 
    21, 50, 81, 88, 76, 50, 34, 85, 64, 56, 74, 89, 17, 38, 48, 
    82, 73, 66, 74, 71, 58, 23, 34, 34, 71, 74, 51, 59, 25, 84, 
    6, 75, 37, 23, 15, 14, 55, 62, 12, 18, 7, 21, 34, 37, 22, 
    35, 25, 58, 57, 88, 84, 39, 78, 87, 53, 57, 82, 60, 9, 20, 
    78, 24, 78, 65, 82, 35, 86, 87, 52, 87, 35, 75, 83, 82, 22, 
    63, 71, 87, 88, 19, 40, 74, 17, 55, 64, 85, 66, 11, 75, 58, 
    58, 55, 36, 89, 72, 26, 25, 12, 33, 16, 33, 43, 41, 54, 35, 
    29, 29, 26, 17, 27, 18, 35, 61, 39, 53, 51, 53, 56, 69, 87, 
    58, 70, 77, 49, 62, 74, 55, 75, 18, 39, 33, 50, 68, 49, 43, 
    23, 25, 48, 69, 69, 85, 57, 31, 87, 23, 45, 45, 26, 85, 88, 
    70, 39, 47, 27, 26, 39, 36, 59, 49, 86, 84, 10, 63, 17, 27, 
    76, 67, 53, 51, 49, 46, 26, 11, 82, 79, 85, 24, 2, 61, 30, 
    42, 67, 67, 32, 28, 30, 39, 40, 49, 38, 42, 61, 56, 45, 81, 
    62, 51, 52, 52, 54, 28, 50, 53, 82, 74, 54, 88, 46, 75, 49, 
    27, 74, 86, 47, 81, 50, 39, 88, 61, 59, 43, 51, 38, 46, 71, 
    53, 56, 87, 22, 23, 74, 80, 65, 48, 65, 57, 66, 34, 55, 52, 
    89, 86, 67, 54, 16, 41, 39, 27, 17, 69, 63, 47, 78, 45, 76, 
    87, 74, 52, 72, 54, 78, 69, 64, 63, 64, 37, 27, 66, 60, 23, 
    87, 78, 29, 67, 59, 79, 19, 48, 13, 78, 82, 73, 78, 38, 86, 
    47, 45, 68, 70, 85, 70, 71, 59, 56, 49, 61, 70, 81, 78, 24, 
    53, 49, 21, 6, 65, 63, 35, 68, 45, 87, 41, 73, 38, 59, 44, 
    43, 58, 82, 64, 28, 47, 83, 60, 65, 25, 65, 52, 32, 29, 39, 
    41, 76, 49, 53, 83, 86, 34, 13, 81, 79, 88, 87, 70, 85, 84, 
    21, 81, 84, 54, 84, 41, 51, 80, 82, 50, 81, 71, 67, 61, 73, 
    82, 72, 53, 80, 58, 84, 67, 61, 64, 58, 45, 47, 47, 40, 28, 
    21, 21, 84, 43, 66, 12, 30, 69, 24, 32, 40, 64, 24, 32, 10, 
    39, 88, 48, 22, 28, 85, 57, 16, 16, 82, 37, 34, 35, 74, 34, 
    38, 55, 77, 49, 83, 54, 44, 34, 59, 89, 56, 87, 67, 48, 34, 
    34, 24, 82, 41, 87, 13, 49, 52, 62, 22, 29, 75, 61, 39, 37, 
    11, 23, 88, 30, 31, 85, 7, 17, 69, 65, 55, 89, 86, 57, 71, 
    36, 33, 87, 31, 71, 88, 31, 50, 82, 20, 27, 40, 55, 24, 57, 
    18, 70, 22, 78, 25, 20, 28, 43, 48, 47, 80, 75, 34, 84, 81, 
    33, 58, 60, 45, 73, 89, 68, 48, 65, 66, 61, 58, 69, 89, 52, 
    71, 57, 82, 62, 47, 68, 27, 67, 88, 53, 12, 90, 51, 42, 46, 
    65, 77, 48, 89, 85, 62, 47, 81, 53, 33, 22, 46, 88, 68, 38, 
    43, 44, 21, 49, 45, 63, 23, 44, 44, 48, 76, 73, 72, 52, 28, 
    11, 41, 49, 47, 35, 86, 64, 41, 86, 38, 7, 49, 50, 52, 57, 
    17, 14, 83, 35, 33, 47, 6, 79, 44, 75, 62, 79, 69, 46, 49, 
    84, 52, 59, 14, 17, 43, 29, 80, 45, 84, 50, 78, 58, 63, 73, 
    90, 16, 64, 86, 45, 34, 29, 20, 33, 7, 26, 55, 8, 67, 54, 
    55, 74, 87, 45, 39, 56, 22, 28, 81, 22, 20, 13, 88, 55, 11, 
    82, 70, 67, 81, 81, 56, 55, 75, 52, 46, 36, 43, 57, 44, 67, 
    74, 86, 42, 74, 73, 77, 57, 69, 71, 61, 59, 38, 73, 20, 56, 
    84, 34, 49, 24, 67, 85, 31, 37, 88, 65, 45, 72, 57, 70, 41, 
    13, 87, 69, 88, 65, 45, 72, 76, 18, 34, 50, 60, 86, 69, 81, 
    43, 13, 80, 76, 46, 72, 51, 21, 41, 16, 61, 17, 40, 13, 52, 
    55, 37, 29, 51, 72, 61, 88, 82, 50, 36, 60, 54, 39, 76, 87, 
    67, 42, 85, 76, 71, 35, 19, 52, 28, 80, 37, 49, 70, 61, 32, 
    56, 61, 86, 38, 64, 73, 55, 86, 89, 8, 75, 61, 86, 30, 4, 
    48, 57, 47, 86, 74, 35, 61, 55, 69, 76, 84, 26, 65, 83, 66, 
    47, 88, 74, 51, 76, 31, 74, 57, 42, 32, 38, 41, 36, 25, 59, 
    84, 69, 62, 43, 36, 88, 89, 34, 72, 84, 71, 79, 75, 51, 69, 
    43, 25, 51, 41, 5, 69, 74, 14, 36, 24, 89, 75, 38, 53, 68, 
    35, 75, 10, 59, 30, 29, 39, 81, 56, 82, 76, 51, 40, 63, 52, 
    71, 72, 89, 39, 59, 60, 26, 64, 22, 55, 66, 36, 81, 50, 17, 
    76, 75, 79, 47, 7, 85, 17, 39, 69, 38, 80, 53, 84, 67, 85, 
    73, 77, 35, 31, 23, 28, 27, 20, 21, 89, 38, 67, 24, 38, 76, 
    41, 68, 83, 82, 19, 87, 88, 60, 5, 62, 33, 70, 64, 39, 38, 
    10, 70, 50, 52, 29, 29, 19, 27, 75, 20, 67, 23, 36, 88, 35, 
    58, 86, 87, 60, 60, 89, 35, 65, 64, 53, 47, 21, 76, 57, 54, 
    80, 52, 59, 78, 68, 90, 32, 49, 75, 61, 53, 44, 59, 85, 76, 
    53, 62, 54, 37, 61, 55, 27, 24, 45, 56, 74, 83, 70, 84, 81, 
    47, 61, 70, 89, 20, 86, 59, 29, 39, 76, 42, 86, 11, 41, 74, 
    44, 40, 35, 16, 76, 78, 81, 30, 25, 81, 36, 31, 79, 59, 8, 
    65, 20, 80, 47, 40, 84, 38, 69, 83, 67, 26, 24, 51, 21, 9, 
    19, 18, 50, 18, 49, 27, 48, 63, 19, 49, 41, 40, 26, 13, 66, 
    28, 51, 76, 65, 78, 69, 11, 35, 20, 9, 67, 69, 90, 80, 56, 
    68, 89, 82, 75, 62, 73, 62, 78, 15, 24, 40, 76, 82, 69, 24, 
    83, 16, 25, 41, 46, 54, 21, 13, 18, 5, 31, 38, 71, 69, 78, 
    87, 59, 75, 58, 77, 81, 43, 83, 80, 87, 51, 30, 36, 82, 66, 
    49, 6, 40, 40, 33, 33, 72, 12, 43, 43, 14, 31, 22, 20, 90, 
    18, 55, 63, 56, 61, 30, 87, 72, 82, 82, 66, 73, 53, 32, 55, 
    30, 24, 58, 53, 32, 23, 55, 65, 78, 89, 19, 61, 69, 89, 68, 
    43, 51, 59, 49, 32, 44, 20, 79, 68, 57, 82, 55, 38, 68, 59, 
    76, 54, 57, 90, 82, 71, 73, 62, 66, 58, 74, 17, 76, 90, 43, 
    81, 64, 19, 18, 48, 39, 57, 47, 20, 26, 81, 59, 82, 76, 53, 
    54, 42, 16, 14, 17, 31, 36, 62, 39, 77, 77, 2, 15, 26, 71, 
    73, 41, 57, 50, 66, 49, 26, 27, 57, 61, 50, 60, 41, 45, 82, 
    68, 37, 13, 33, 71, 72, 41, 83, 28, 77, 23, 16, 84, 63, 64, 
    52, 71, 85, 14, 63, 38, 52, 58, 28, 82, 18, 52, 85, 79, 73, 
    49, 87, 64, 29, 74, 79, 26, 47, 37, 71, 38, 56, 60, 52, 75, 
    84, 62, 67, 45, 16, 74, 41, 68, 69, 49, 32, 33, 35, 81, 18, 
    32, 70, 61, 61, 32, 30, 64, 34, 15, 24, 11, 52, 87, 37, 40, 
    53, 19, 79, 67, 64, 21, 30, 79, 57, 6, 34, 75, 52, 77, 44, 
    65, 62, 57, 81, 62, 48, 53, 54, 48, 66, 76, 35, 75, 42, 18, 
    35, 41, 55, 88, 57, 63, 70, 58, 33, 43, 69, 57, 71, 75, 64, 
    77, 54, 56, 77, 83, 26, 42, 90, 86, 28, 75, 86, 50, 59, 48, 
    69, 46, 87, 73, 68, 83, 43, 30, 77, 38, 76, 69, 13, 42, 61, 
    53, 72, 61, 23, 50, 26, 44, 20, 54, 54, 74, 55, 48, 40, 58, 
    79, 86, 69, 53, 65, 44, 46, 8, 33, 79, 84, 67, 32, 51, 22, 
    44, 49, 22, 42, 68, 61, 75, 28, 52, 32, 30, 72, 86, 19, 46, 
    53, 41, 49, 44, 89, 52, 17, 83, 27, 16, 80, 17, 87, 21, 44, 
    62, 30, 89, 35, 48, 58, 26, 52, 45, 88, 60, 76, 52, 87, 39, 
    63, 23, 39, 89, 23, 34, 43, 82, 48, 40, 76, 25, 38, 51, 81, 
    51, 89, 80, 41, 76, 56, 72, 78, 80, 49, 41, 62, 10, 26, 37, 
    85, 84, 49, 80, 76, 82, 90, 41, 25, 51, 82, 18, 58, 90, 41, 
    24, 23, 40, 14, 74, 62, 58, 43, 29, 48, 54, 67, 62, 7, 40, 
    52, 34, 82, 47, 9, 82, 32, 42, 33, 89, 47, 46, 41, 53, 59, 
    80, 17, 16, 18, 43, 23, 46, 44, 74, 47, 50, 38, 24, 57, 26, 
    26, 45, 30, 21, 27, 14, 37, 51, 32, 72, 38, 37, 3, 44, 6, 
    42, 56, 60, 70, 90, 49, 64, 85, 42, 87, 59, 55, 16, 83, 54, 
    73, 32, 75, 53, 26, 27, 46, 65, 50, 79, 80, 57, 79, 43, 41, 
    47, 59, 43, 36, 80, 71, 15, 48, 31, 82, 77, 41, 59, 10, 48, 
    69, 66, 64, 48, 80, 60, 35, 72, 28, 34, 15, 38, 52, 78, 40, 
    63, 33, 67, 70, 69, 77, 30, 39, 63, 45, 77, 49, 59, 86, 55, 
    38, 36, 64, 41, 40, 43, 77, 89, 32, 67, 13, 76, 30, 48, 39, 
    60, 41, 43, 51, 23, 52, 47, 41, 25, 1, 10, 39, 11, 36, 25, 
    62, 52, 61, 46, 11, 31, 28, 33, 25, 31, 27, 56, 32, 46, 68, 
    23, 4, 15, 62, 17, 13, 48, 62, 42, 57, 49, 58, 61, 77, 54, 
    71, 26, 84, 31, 40, 65, 71, 26, 82, 79, 40, 76, 47, 84, 83, 
    46, 37, 71, 28, 54, 17, 73, 52, 86, 66, 87, 53, 48, 73, 43, 
    6, 75, 60, 3, 57, 51, 33, 75, 88, 19, 61, 42, 39, 48, 53, 
    61, 28, 56, 27, 89, 69, 85, 63, 45, 45, 51, 60, 45, 30, 44, 
    32, 32, 87, 54, 81, 16, 63, 73, 46, 89, 29, 25, 63, 44, 46, 
    85, 64, 61, 64, 43, 33, 22, 38, 78, 67, 80, 67, 51, 52, 80, 
    45, 38, 76, 61, 59, 70, 88, 55, 61, 60, 55, 57, 34, 35, 37, 
    39, 57, 40, 70, 43, 46, 55, 11, 23, 59, 35, 17, 34, 9, 79, 
    64, 86, 16, 25, 60, 68, 70, 19, 50, 35, 27, 23, 34, 50, 13, 
    55, 34, 40, 25, 62, 43, 80, 20, 25, 62, 82, 14, 86, 24, 41, 
    51, 20, 53, 43, 32, 25, 60, 5, 55, 38, 51, 37, 44, 42, 20, 
    81, 57, 54, 22, 40, 19, 57, 68, 17, 29, 61, 30, 39, 38, 55, 
    33, 66, 36, 21, 38, 58, 59, 23, 60, 31, 28, 13, 25, 20, 13, 
    77, 40, 48, 46, 74, 43, 70, 82, 78, 55, 53, 15, 57, 23, 41, 
    33, 67, 68, 28, 51, 21, 77, 29, 22, 67, 70, 80, 87, 52, 57, 
    85, 30, 44, 47, 79, 77, 28, 46, 42, 50, 25, 8, 76, 65, 21, 
    81, 58, 19, 33, 72, 52, 48, 77, 70, 43, 52, 85, 63, 77, 62, 
    52, 11, 75, 68, 85, 77, 87, 68, 64, 88, 76, 20, 40, 23, 50, 
    29, 71, 35, 55, 27, 44, 86, 49, 76, 66, 53, 66, 44, 40, 29, 
    32, 32, 37, 45, 58, 31, 16, 33, 63, 43, 83, 73, 38, 78, 85, 
    65, 85, 11, 37, 34, 4, 31, 52, 79, 33, 30, 87, 89, 14, 12, 
    66, 33, 78, 63, 20, 71, 48, 62, 43, 77, 54, 53, 45, 77, 46, 
    80, 87, 64, 41, 46, 43, 37, 73, 22, 20, 2, 84, 89, 89, 55, 
    58, 82, 82, 87, 54, 79, 51, 62, 40, 64, 67, 69, 25, 79, 83, 
    47, 83, 85, 85, 78, 71, 41, 44, 44, 71, 63, 71, 48, 50, 76, 
    77, 83, 61, 75, 88, 75, 72, 88, 71, 74, 74, 83, 61, 88, 75, 
    62, 70, 60, 88, 33, 45, 69, 38, 33, 86, 8, 66, 41, 31, 18, 
    55, 54, 41, 78, 89, 71, 80, 87, 32, 39, 68, 42, 79, 59, 51, 
    64, 83, 11, 60, 69, 78, 74, 67, 59, 38, 84, 50, 28, 22, 86, 
    47, 73, 71, 79, 88, 53, 73, 83, 15, 5, 81, 11, 60, 45, 88, 
    58, 34, 79, 71, 81, 83, 3, 84, 27, 82, 33, 67, 42, 88, 83, 
    71, 30, 77, 26, 59, 53, 54, 61, 27, 83, 34, 21, 33, 73, 34, 
    59, 30, 55, 82, 78, 54, 39, 58, 83, 87, 85, 27, 89, 75, 22, 
    89, 8, 72, 63, 70, 52, 13, 48, 46, 33, 66, 31, 82, 84, 59, 
    89, 27, 79, 43, 43, 27, 33, 17, 29, 51, 19, 13, 47, 46, 55, 
    53, 32, 81, 55, 27, 84, 78, 56, 23, 78, 72, 88, 68, 82, 83, 
    58, 35, 61, 87, 50, 15, 89, 15, 2, 88, 40, 76, 80, 50, 54, 
    89, 17, 85, 55, 44, 53, 78, 19, 59, 37, 52, 6, 39, 62, 44, 
    42, 54, 82, 47, 9, 63, 76, 89, 14, 64, 88, 3, 44, 57, 11, 
    26, 47, 38, 55, 56, 62, 37, 85, 46, 50, 47, 66, 86, 58, 54, 
    54, 75, 67, 54, 17, 71, 43, 41, 20, 80, 44, 62, 24, 58, 61, 
    66, 45, 70, 35, 77, 76, 58, 43, 86, 52, 14, 88, 44, 37, 41, 
    87, 81, 15, 29, 26, 35, 52, 56, 25, 63, 31, 42, 28, 57, 49, 
    84, 77, 52, 36, 74, 78, 86, 84, 56, 33, 24, 37, 73, 58, 20, 
    35, 90, 33, 88, 87, 67, 70, 50, 38, 31, 76, 86, 53, 68, 72, 
    71, 48, 86, 63, 27, 17, 85, 48, 55, 46, 83, 78, 60, 47, 65, 
    80, 74, 48, 60, 69, 8, 54, 53, 64, 69, 26, 24, 82, 63, 77, 
    23, 33, 54, 39, 35, 36, 16, 30, 57, 50, 58, 38, 60, 11, 33, 
    52, 89, 60, 43, 57, 36, 52, 56, 49, 80, 77, 62, 75, 62, 82, 
    35, 51, 10, 70, 24, 35, 22, 54, 73, 8, 72, 66, 68, 52, 89, 
    83, 73, 31, 81, 35, 83, 50, 65, 40, 63, 68, 90, 45, 74, 29, 
    73, 41, 83, 15, 83, 61, 53, 86, 81, 43, 48, 31, 80, 53, 63, 
    90, 81, 73, 69, 34, 28, 70, 46, 54, 56, 31, 3, 74, 33, 87, 
    72, 79, 77, 55, 73, 74, 19, 37, 28, 65, 62, 76, 46, 64, 46, 
    88, 61, 11, 49, 42, 79, 71, 84, 79, 54, 71, 57, 89, 46, 90, 
    71, 65, 81, 46, 17, 87, 26, 50, 79, 75, 52, 66, 61, 62, 36, 
    44, 83, 17, 70, 49, 60, 23, 29, 83, 45, 71, 41, 22, 72, 78, 
    61, 85, 47, 23, 63, 64, 19, 83, 49, 87, 73, 85, 49, 40, 38, 
    78, 90, 89, 51, 65, 82, 17, 50, 71, 41, 26, 88, 67, 57, 79, 
    35, 17, 69, 75, 45, 51, 43, 86, 50, 52, 9, 54, 47, 31, 87, 
    46, 52, 79, 79, 82, 33, 83, 64, 67, 70, 83, 51, 53, 73, 53, 
    49, 23, 51, 70, 23, 90, 59, 85, 72, 54, 61, 88, 82, 14, 88, 
    61, 54, 46, 53, 52, 49, 41, 87, 68, 49, 89, 47, 20, 89, 40, 
    44, 84, 86, 28, 16, 44, 67, 41, 69, 60, 51, 77, 69, 68, 77, 
    58, 65, 78, 53, 75, 25, 69, 45, 50, 62, 83, 81, 55, 18, 13, 
    46, 22, 76, 79, 74, 81, 63, 75, 21, 86, 65, 63, 55, 22, 30, 
    74, 42, 50, 51, 74, 38, 71, 14, 68, 36, 77, 75, 80, 85, 75, 
    83, 69, 87, 64, 89, 57, 19, 42, 81, 61, 66, 39, 76, 86, 56, 
    49, 73, 65, 67, 68, 72, 62, 55, 82, 56, 56, 82, 55, 33, 13, 
    52, 24, 55, 74, 60, 39, 71, 65, 45, 66, 76, 50, 60, 60, 64, 
    56, 83, 37, 12, 55, 45, 55, 3, 23, 45, 26, 51, 17, 6, 34, 
    49, 87, 85, 41, 42, 48, 32, 66, 76, 36, 59, 26, 83, 53, 87, 
    58, 53, 28, 57, 36, 42, 63, 34, 70, 32, 77, 73, 53, 49, 75, 
    58, 56, 35, 11, 42, 62, 20, 20, 78, 80, 74, 42, 11, 59, 18, 
    56, 82, 48, 59, 56, 30, 17, 75, 69, 81, 62, 50, 38, 81, 90, 
    64, 14, 67, 60, 52, 90, 69, 87, 74, 31, 47, 52, 88, 40, 19, 
    73, 61, 76, 21, 84, 21, 64, 62, 79, 65, 27, 84, 67, 36, 51, 
    27, 63, 53, 67, 66, 74, 30, 37, 49, 41, 79, 33, 63, 68, 77, 
    60, 26, 82, 68, 69, 72, 70, 38, 37, 73, 83, 15, 54, 42, 70, 
    47, 88, 81, 75, 75, 69, 54, 74, 22, 35, 37, 22, 30, 66, 49, 
    80, 63, 58, 79, 61, 87, 58, 76, 81, 32, 58, 48, 25, 74, 80, 
    38, 79, 81, 46, 66, 88, 73, 89, 71, 59, 63, 46, 72, 80, 73, 
    35, 77, 57, 59, 18, 53, 49, 67, 66, 26, 59, 51, 58, 76, 38, 
    29, 23, 53, 35, 87, 65, 26, 77, 46, 56, 84, 17, 68, 85, 63, 
    86, 45, 77, 82, 77, 61, 32, 44, 81, 52, 49, 18, 86, 86, 30, 
    57, 87, 62, 40, 47, 28, 59, 50, 71, 51, 40, 83, 13, 47, 59, 
    41, 2, 79, 84, 71, 18, 66, 74, 57, 54, 88, 62, 52, 87, 63, 
    37, 30, 65, 28, 53, 60, 56, 54, 69, 68, 85, 52, 80, 85, 71, 
    53, 83, 89, 69, 74, 82, 84, 84, 77, 50, 50, 35, 62, 26, 73, 
    78, 33, 73, 62, 83, 38, 46, 65, 29, 13, 82, 86, 70, 62, 56, 
    70, 84, 71, 51, 46, 12, 59, 86, 47, 53, 56, 84, 24, 61, 78, 
    58, 51, 68, 68, 59, 86, 68, 54, 51, 57, 43, 75, 80, 60, 90, 
    63, 18, 29, 43, 80, 27, 58, 77, 60, 34, 60, 25, 27, 85, 72, 
    88, 71, 57, 61, 26, 69, 25, 17, 23, 9, 44, 72, 82, 70, 67, 
    90, 49, 69, 55, 21, 42, 44, 67, 23, 82, 80, 64, 40, 63, 70, 
    47, 70, 59, 41, 56, 33, 81, 13, 58, 51, 64, 49, 56, 8, 60, 
    60, 47, 54, 64, 59, 90, 87, 88, 28, 84, 82, 38, 56, 36, 89, 
    75, 45, 10, 49, 44, 36, 66, 24, 53, 38, 45, 86, 87, 52, 80, 
    31, 3, 87, 51, 79, 27, 22, 77, 82, 17, 73, 72, 63, 13, 62, 
    83, 78, 49, 36, 68, 17, 18, 35, 39, 76, 58, 7, 16, 32, 48, 
    45, 60, 64, 44, 33, 34, 8, 49, 49, 40, 37, 72, 82, 36, 76, 
    88, 57, 87, 86, 22, 61, 30, 20, 44, 67, 34, 85, 86, 46, 66, 
    89, 62, 79, 19, 77, 87, 70, 90, 56, 86, 45, 39, 62, 54, 60, 
    20, 67, 29, 45, 76, 54, 66, 59, 88, 81, 67, 89, 86, 51, 32, 
    31, 68, 63, 63, 21, 49, 79, 79, 18, 16, 47, 2, 48, 50, 82, 
    28, 79, 41, 42, 26, 72, 35, 16, 62, 37, 80, 76, 33, 42, 47, 
    67, 18, 70, 49, 31, 61, 64, 67, 77, 70, 49, 59, 81, 27, 62, 
    84, 56, 29, 77, 79, 82, 61, 72, 54, 40, 29, 63, 37, 90, 79, 
    46, 52, 77, 70, 79, 88, 57, 83, 77, 46, 64, 83, 78, 82, 62, 
    32, 55, 63, 49, 62, 59, 68, 74, 56, 78, 48, 82, 90, 61, 72, 
    19, 67, 57, 42, 72, 86, 67, 82, 29, 50, 90, 57, 40, 12, 39, 
    67, 25, 72, 67, 16, 70, 46, 35, 64, 67, 82, 19, 55, 71, 64, 
    68, 57, 30, 25, 86, 39, 83, 52, 26, 44, 79), lomsil = c(64, 
    44, 28, 48, 59, 57, 66, 30, 88, 30, 53, 17, 41, 63, 42, 59, 
    38, 42, 45, 64, 52, 67, 41, 51, 32, 87, 54, 75, 33, 67, 67, 
    38, 43, 83, 62, 41, 39, 39, 79, 31, 70, 26, 73, 42, 49, 45, 
    70, 22, 58, 71, 30, 45, 82, 55, 40, 65, 68, 53, 44, 35, 89, 
    55, 10, 48, 47, 32, 48, 55, 53, 43, 62, 52, 23, 62, 82, 60, 
    45, 54, 85, 35, 29, 75, 9, 54, 30, 44, 38, 32, 42, 66, 39, 
    38, 38, 76, 48, 57, 4, 47, 31, 41, 40, 46, 36, 51, 50, 39, 
    80, 27, 73, 32, 17, 27, 39, 39, 34, 40, 34, 51, 83, 53, 73, 
    30, 54, 61, 67, 67, 52, 47, 50, 27, 59, 72, 71, 30, 55, 81, 
    61, 64, 67, 79, 73, 23, 57, 28, 69, 32, 57, 50, 65, 42, 61, 
    35, 77, 41, 41, 81, 68, 15, 44, 56, 73, 71, 61, 53, 29, 85, 
    28, 66, 50, 13, 26, 62, 39, 49, 37, 65, 31, 54, 19, 36, 59, 
    50, 46, 49, 22, 61, 60, 44, 34, 68, 5, 47, 29, 73, 13, 54, 
    31, 67, 39, 45, 21, 23, 28, 51, 26, 61, 59, 30, 42, 29, 65, 
    23, 68, 36, 28, 12, 85, 84, 61, 60, 40, 85, 68, 67, 75, 81, 
    41, 52, 86, 71, 44, 47, 58, 37, 11, 14, 15, 62, 36, 40, 57, 
    64, 43, 46, 72, 20, 43, 58, 86, 43, 57, 5, 69, 43, 34, 56, 
    71, 41, 43, 23, 89, 49, 48, 55, 30, 64, 39, 62, 44, 14, 20, 
    52, 55, 19, 23, 27, 54, 57, 48, 57, 59, 50, 36, 66, 69, 53, 
    9, 62, 22, 54, 53, 55, 45, 57, 66, 25, 54, 53, 20, 17, 41, 
    57, 3, 68, 48, 83, 14, 50, 32, 84, 65, 22, 64, 51, 28, 64, 
    39, 60, 66, 48, 56, 28, 54, 40, 35, 49, 53, 52, 58, 20, 44, 
    39, 78, 28, 39, 58, 34, 32, 19, 74, 34, 41, 36, 69, 41, 72, 
    44, 38, 18, 44, 52, 14, 28, 75, 26, 68, 4, 67, 50, 78, 13, 
    56, 80, 38, 57, 50, 31, 41, 35, 81, 59, 70, 25, 48, 20, 89, 
    87, 28, 74, 8, 27, 84, 81, 11, 3, 85, 53, 52, 65, 48, 75, 
    16, 46, 61, 24, 63, 67, 79, 9, 63, 77, 88, 78, 52, 29, 75, 
    28, 88, 9, 57, 7, 72, 58, 68, 59, 48, 52, 53, 55, 69, 51, 
    78, 40, 86, 46, 79, 32, 81, 48, 10), perlan = c(84, 68, 78, 
    65, 89, 76, 67, 89, 72, 78, 82, 28, 76, 80, 88, 79, 86, 85, 
    86, 71, 73, 85, 63, 63, 74, 70, 72, 79, 72, 80, 57, 80, 89, 
    54, 75, 63, 79, 75, 42, 83, 83, 86, 52, 88, 83, 50, 40, 80, 
    61, 83, 31, 44, 84, 71, 75, 46, 86, 60, 50, 65, 59, 67, 84, 
    84, 60, 69, 54, 86, 87, 57, 70, 88, 71, 48, 82, 83, 54, 61, 
    52, 90, 82, 78, 73, 46, 56, 58, 50, 62, 84, 83, 81, 70, 90, 
    48, 57, 47, 76, 80, 34, 62, 55, 89, 76, 68, 55, 82, 77, 56, 
    69, 60, 55, 72, 49, 84, 80, 73, 57, 73, 72, 61, 81, 87, 63, 
    83, 89, 40, 72, 23, 79, 38, 66, 89, 62, 55, 62, 30, 74, 64, 
    49, 82, 75, 61, 56, 65, 74, 72, 51, 70, 82, 76, 49, 56, 70, 
    66, 84, 64, 68, 70, 63, 57, 87, 65, 84, 84, 76, 70, 61, 68, 
    74, 50, 77, 65, 74, 59, 80, 65, 74, 88, 82, 67, 74, 70, 73, 
    83, 67, 75, 29, 80, 61, 79, 50, 77, 65, 77, 72, 82, 57, 69, 
    56, 79, 85, 76, 67, 80, 48, 40, 84, 57, 62, 64, 88, 82, 68, 
    53, 77, 71, 50, 64, 42, 68, 52, 77, 65, 80, 87, 75, 38, 56, 
    50, 78, 85, 44, 81, 87, 90, 59, 82, 82, 80, 59, 71, 79, 23, 
    70, 30, 68, 79, 77, 53, 70, 82, 63, 34, 75, 25, 65, 44, 23, 
    85, 66, 55, 64, 14, 81, 21, 67, 65, 46, 84, 47, 89, 57, 29, 
    78, 82, 86, 81, 75, 54, 89, 81, 51, 73, 61, 89, 74, 74, 82, 
    67, 71, 59, 74, 56, 85, 50, 67, 60, 56, 45, 85, 46, 63, 36, 
    37, 71, 81, 75, 75, 63, 52, 62, 59, 83, 82, 78, 74, 43, 69, 
    52, 78, 83, 66, 51, 83, 77, 25, 67, 77, 88, 62, 80, 67, 79, 
    50, 51, 79, 81, 41, 43, 83, 85, 57, 71, 77, 69, 47, 81, 50, 
    72, 74, 63, 66, 82, 78, 82, 31, 55, 81, 71, 43, 89, 89, 41, 
    60, 52, 65, 71, 81, 63, 79, 60, 85, 74, 46, 83, 60, 72, 59, 
    68, 63, 72, 82, 60, 57, 71, 66, 47, 67, 53, 87, 84, 82, 46, 
    48, 73, 69, 60, 83, 63, 88, 68, 43, 50, 65, 79, 69, 87, 57, 
    37, 84, 76, 89, 48, 60, 56, 85, 78, 64, 80, 29, 81, 77, 85, 
    49, 62, 41, 85, 72, 73, 47, 81, 55, 72, 74, 52, 79, 88, 76, 
    83, 43, 60, 70, 70, 45, 78, 86, 67, 50, 90, 84, 55, 49, 72, 
    88, 85, 73, 63, 53, 70, 89, 82, 46, 77, 72, 84, 83, 86, 87, 
    85, 87, 89, 69, 70, 35, 78, 69, 84, 70, 44, 16, 74, 70, 49, 
    57, 88, 89, 72, 67, 89, 66, 80, 69, 82, 53, 34, 64, 62, 50, 
    33, 76, 88, 89, 41, 68, 72, 22, 77, 61, 87, 75, 74, 85, 82, 
    67, 35, 63, 84, 77, 46, 66, 66, 68, 57, 85, 51, 38, 89, 87, 
    83, 74, 83, 57, 60, 64, 75, 58, 87, 49, 70, 40, 16, 36, 51, 
    61, 59, 90, 53, 70, 73, 79, 77, 73, 40, 54, 80, 79, 64, 76, 
    68, 63, 71, 47, 84, 78, 78, 86, 79, 79, 62, 87, 75, 47, 69, 
    56, 75, 62, 85, 86, 79, 87, 40, 55, 76, 54, 90, 81, 38, 66, 
    84, 57, 90, 55, 86, 81, 43, 62, 79, 55, 52, 70, 83, 66, 86, 
    63, 57, 82, 68, 65, 54, 84, 60, 86, 80, 56, 70, 69, 68, 66, 
    75, 90, 63, 90, 62, 60, 59, 62, 86, 56, 76, 90, 60, 86, 64, 
    73, 73, 50, 89, 86, 79, 67, 52, 80, 89, 83, 79, 70, 65, 85, 
    47, 74, 78, 60, 38, 75, 72, 56, 77, 84, 51, 49, 35, 84, 57, 
    75, 63, 79, 56, 39, 74, 44, 39, 58, 71, 30, 84, 85, 41, 86, 
    70, 88, 78, 57, 82, 87, 62, 76, 68, 82, 71, 69, 86, 70, 59, 
    62, 58, 86, 88, 50, 51, 60, 66, 81, 77, 47, 49, 67, 71, 54, 
    71, 62, 79, 73, 89, 65, 65, 74, 85, 65, 69, 60, 69, 42, 74, 
    71, 39, 89, 85, 90, 41, 83, 83, 62, 58, 77, 72, 84, 67, 86, 
    61, 60, 56, 52, 55, 70, 68, 73, 73, 81, 59, 48, 76, 81, 67, 
    67, 43, 38, 82, 61, 33, 72, 55, 82, 64, 59, 47, 33, 90, 89, 
    75, 46, 60, 64, 50, 71, 28, 87, 89, 71, 66, 67, 79, 79, 51, 
    41, 69, 78, 55, 70, 82, 66, 68, 64, 80, 71, 52, 72, 58, 84, 
    42, 58, 73, 88, 76, 57, 58, 53, 39, 72, 47, 83, 54, 30, 77, 
    72, 36, 79, 88, 71, 89, 56, 75, 88, 81, 80, 87, 54, 49, 71, 
    78, 65, 28, 81, 88, 41, 46, 70, 79, 77, 80, 63, 56, 57, 63, 
    76, 58, 45, 73, 52, 72, 79, 84, 61, 59, 73, 53, 78, 88, 81, 
    63, 68, 28, 61, 87, 65, 60, 85, 75, 49, 51, 74, 73, 42, 58, 
    78, 72, 70, 74, 86, 76, 85, 83, 83, 39, 51, 90, 75, 71, 59, 
    73, 72, 56, 40, 58, 50, 48, 49, 86, 61, 89, 81, 88, 51, 85, 
    37, 80, 87, 49, 76, 79, 53, 24, 50, 64, 59, 19, 37, 82, 43, 
    68, 87, 60, 79, 54, 82, 84, 46, 55, 73, 90, 79, 63, 63, 61, 
    58, 37, 80, 45, 48, 48, 89, 80, 57, 78, 80, 68, 54, 87, 86, 
    89, 41, 74, 65, 79, 90, 71, 71, 62, 56, 73, 57, 87, 61, 77, 
    89, 87, 53, 68, 42, 73, 71, 87, 58, 53, 63, 60, 73, 88, 90, 
    58, 81, 56, 90, 55, 72, 78, 53, 65, 81, 83, 55, 44, 86, 65, 
    86, 82, 88, 72, 79, 41, 65, 89, 69, 49, 55, 73, 80, 89, 81, 
    68, 51, 25, 61, 34, 74, 85, 54, 76, 89, 24, 77, 44, 68, 50, 
    31, 88, 53, 49, 51, 79, 86, 69, 48, 85, 73, 83, 39, 26, 82, 
    44, 81, 71, 84, 80, 86, 43, 72, 73, 89, 86, 55, 60, 62, 54, 
    62, 55, 62, 13, 48, 48, 88, 89, 80, 73, 64, 42, 38, 84, 87, 
    76, 68, 59, 74, 58, 80, 54, 82, 77, 24, 49, 79, 69, 68, 49, 
    62, 43, 69, 62, 82, 81, 80, 32, 42, 42, 75, 78, 84, 54, 68, 
    89, 62, 78, 68, 78, 65, 65, 84, 88, 84, 88, 35, 62, 84, 74, 
    65, 83, 51, 73, 80, 57, 43, 88, 64, 61, 58, 79, 74, 82, 71, 
    47, 73, 58, 69, 61, 82, 45, 62, 69, 54, 29, 86, 88, 62, 59, 
    50, 87, 81, 29, 79, 75, 52, 79, 70, 11, 61, 70, 86, 77, 66, 
    84, 70, 29, 73, 66, 31, 77, 51, 77, 65, 65, 82, 79, 46, 41, 
    50, 89, 81, 79, 50, 89, 74, 61, 73, 57, 83, 59, 69, 75, 37, 
    80, 57, 54, 66, 66, 78, 50, 74, 38, 87, 30, 72, 77, 49, 69, 
    81, 88, 74, 49, 89, 87, 83, 23, 84, 85, 35, 65, 86, 62, 77, 
    52, 77, 63, 79, 76, 86, 85, 85, 86, 40, 85, 56, 90, 63, 64, 
    82, 58, 73, 86, 74, 59, 47, 80, 61, 76, 54, 64, 63, 76, 56, 
    68, 83, 89, 60, 86, 81, 81, 70, 71, 81, 82, 50, 60, 47, 83, 
    66, 46, 29, 48, 77, 62, 89, 69, 47, 64, 47, 47, 83, 83, 37, 
    52, 67, 89, 71, 68, 58, 49, 50, 72, 39, 67, 76, 53, 51, 74, 
    81, 72, 47, 86, 55, 54, 55, 23, 58, 71, 59, 65, 45, 26, 21, 
    87, 77, 59, 45, 31, 57, 49, 33, 56, 70, 73, 54, 80, 76, 56, 
    81, 75, 45, 63, 82, 39, 59, 84, 43, 42, 33, 73, 52, 46, 72, 
    79, 20, 30, 66, 55, 72, 68, 57, 32, 81, 75, 80, 72, 78, 79, 
    73, 86, 85, 71, 89, 64, 77, 79, 85, 86, 86, 60, 77, 72, 64, 
    66, 70, 68, 80, 60, 56, 57, 76, 45, 78, 75, 89, 66, 68, 84, 
    69, 83, 90, 58, 64, 74, 69, 89, 75, 88, 57, 61, 63, 56, 58, 
    40, 85, 82, 85, 76, 87, 83, 76, 88, 63, 87, 86, 56, 74, 48, 
    68, 49, 84, 66, 89, 82, 58, 77, 68, 83, 63, 80, 37, 85, 81, 
    59, 41, 20, 86, 77, 61, 89, 79, 47, 68, 80, 83, 87, 71, 53, 
    61, 82, 79, 87, 83, 34, 78, 71, 73, 14, 81, 74, 41, 44, 46, 
    78, 65, 45, 88, 50, 84, 60, 73, 49, 58, 53, 60, 88, 76, 64, 
    84, 73, 52, 85, 85, 80, 50, 38, 66, 62, 78, 48, 62, 58, 85, 
    76, 80, 79, 55, 82, 84, 88, 48, 69, 54, 71, 89, 73, 83, 87, 
    17, 67, 82, 84, 65, 70, 61, 85, 88, 80, 88, 52, 76, 67, 62, 
    48, 89, 66, 30, 67, 70, 74, 77, 68, 82, 72, 48, 63, 60, 86, 
    64, 69, 88, 77, 61, 76, 49, 61, 90, 63, 66, 86, 81, 87, 77, 
    65, 72, 77, 65, 60, 45, 77, 84, 85, 34, 73, 72, 90, 55, 73, 
    47, 73, 39, 57, 50, 49, 63, 69, 74, 65, 69, 52, 89, 86, 84, 
    61, 63, 54, 55, 47, 79, 70, 78, 70, 58, 51, 80, 65, 53, 75, 
    53, 81, 58, 24, 85, 89, 39, 73, 46, 46, 55, 70, 76, 21, 58, 
    47, 81, 70, 65, 86, 78, 58, 89, 82, 76, 57, 72, 58, 53, 89, 
    57, 87, 61, 25, 44, 59, 58, 81, 70, 78, 86, 59, 85, 89, 78, 
    87, 70, 89, 80, 82, 59, 88, 42, 64, 63, 76, 78, 73, 82, 34, 
    30, 90, 58, 58, 34, 61, 30, 87, 78, 83, 79, 64, 46, 85, 80, 
    55, 81, 67, 87, 89, 87, 66, 88, 90, 61, 60, 77, 83, 83, 49, 
    81, 58, 76, 44, 89, 51, 71, 55, 61, 88, 70, 63, 14, 42, 39, 
    87, 72, 60, 81, 74, 52, 72, 59, 61, 63, 72, 78, 75, 69, 89, 
    79, 67, 54, 68, 80, 83, 82, 82, 54, 59, 84, 76, 85, 72, 52, 
    73, 48, 76, 82, 49, 73, 55, 7, 88, 89, 10, 77, 77, 36, 59, 
    27, 76, 69, 22, 47, 73, 56, 51, 68, 23, 75, 74, 26, 57, 67, 
    68, 81, 55, 79, 86, 54, 46, 18, 65, 63, 29, 25, 60, 46, 62, 
    10, 48, 63, 67, 46, 57, 67, 85, 44, 69, 62, 23, 55, 16, 84, 
    13, 67, 90, 44, 18, 89, 62, 70, 50, 28, 61, 73, 21, 86, 18, 
    44, 57, 63, 43, 64, 9, 68, 58, 41, 34, 28, 63, 79, 66, 46, 
    18, 66, 57, 21, 72, 71, 72, 84, 85, 48, 86, 30, 76, 61, 33, 
    57, 31, 72, 41, 67, 42, 62, 52, 89, 68, 60, 88, 89, 68, 51, 
    69, 81, 49, 58, 29, 76, 66, 33, 79, 77, 84, 41, 37, 49, 90, 
    62, 59, 8, 74, 77, 59, 28, 83, 39, 46, 72, 74, 23, 61, 36, 
    47, 67, 79, 81, 61, 49, 88, 47, 78, 66, 80, 67, 61, 57, 67, 
    76, 56, 51, 54, 58, 27, 52, 80, 42, 85, 68, 51, 45, 86, 71, 
    87, 78, 84, 33, 75, 65, 70, 82, 49, 51, 78, 62, 87, 51, 73, 
    44, 68, 79, 77, 65, 79, 36, 56, 65, 80, 34, 49, 54, 71, 64, 
    73, 71, 86, 80, 62, 63, 88, 69, 89, 76, 69, 88, 79, 22, 73, 
    68, 61, 68, 29, 74, 85, 53, 45, 48, 74, 50, 81, 58, 72, 52, 
    69, 17, 72, 64, 65, 72, 64, 90, 63, 79, 85, 32, 35, 42, 50, 
    90, 59, 29, 31, 77, 58, 67, 61, 74, 85, 85, 83, 89, 64, 77, 
    30, 44, 51, 26, 76, 60, 83, 65, 47, 50, 59, 78, 76, 54, 46, 
    71, 21, 82, 64, 44, 61, 49, 58, 77, 67, 9, 35, 60, 29, 48, 
    63, 25, 38, 57, 87, 61, 67, 61, 65, 78, 65, 76, 85, 71, 76, 
    59, 61, 90, 86, 78, 59, 36, 49, 65, 54, 69, 43, 56, 86, 56, 
    54, 73, 61, 84, 82, 68, 62, 12, 38, 66, 78, 61, 60, 88, 31, 
    44, 36, 44, 88, 55, 23, 90, 46, 21, 25, 86, 83, 30, 80, 47, 
    66, 77, 36, 71, 75, 86, 89, 53, 51, 49, 69, 54, 68, 89, 45, 
    17, 71, 15, 80, 63, 68, 41, 68, 75, 71, 54, 60, 79, 62, 46, 
    41, 73, 77, 43, 55, 77, 59, 42, 57, 70, 38, 42, 78, 31, 35, 
    54, 29, 71, 73, 86, 86, 67, 90, 77, 60, 68, 70, 9, 55, 29, 
    75, 89, 37, 87, 35, 51, 48, 76, 43, 87, 31, 75, 55, 72, 81, 
    85, 82, 86, 81, 47, 61, 88, 64, 49, 67, 67, 62, 44, 47, 82, 
    79, 80, 79, 41, 65, 86, 75, 87, 49, 77, 80, 70, 71, 78, 51, 
    17, 83, 77, 87, 25, 83, 43, 71, 63, 67, 80, 47, 76, 83, 40, 
    75, 65, 75, 67, 62, 89, 25, 57, 84, 80, 15, 78, 70, 59, 79, 
    63, 43, 75, 64, 69, 25, 36, 78, 73, 63, 90, 76, 49, 42, 84, 
    61, 77, 88, 83, 72, 77, 77, 56, 80, 74, 71, 77, 41, 83, 86, 
    22, 26, 78, 29, 19, 69, 31, 45, 72, 79, 29, 60, 78, 63, 59, 
    45, 70, 73, 64, 35, 32, 60, 35, 38, 90, 67, 90, 74, 34, 62, 
    66, 57, 72, 47, 37, 70, 87, 65, 56, 42, 69, 44, 17, 79, 61, 
    83, 80, 87, 86, 79, 69, 67, 60, 40, 53, 79, 69, 44, 84, 64, 
    73, 63, 56, 69, 60, 84, 82, 59, 88, 79, 80, 78, 50, 62, 66, 
    63, 17, 90, 60, 55, 51, 61, 65, 71, 49, 65, 25, 63, 70, 87, 
    37, 42, 24, 85, 57, 74, 23, 41, 90, 11, 66, 44, 90, 38, 52, 
    44, 57, 85, 81, 46, 63, 74, 74, 67, 68, 85, 29, 61, 77, 44, 
    75, 84, 55, 71, 48, 82, 44, 50, 40, 59, 72, 60, 67, 88, 70, 
    69, 84, 46, 79, 71, 89, 42, 67, 53, 51, 46, 34, 82, 58, 31, 
    39, 72, 78, 32, 69, 44, 62, 47, 87, 56, 52, 86, 81, 26, 53, 
    58, 87, 25, 32, 59, 23, 44, 35, 61, 71, 84, 46, 83, 75, 86, 
    64, 71, 89, 79, 78, 57, 61, 78, 59, 71, 75, 81, 80, 70, 71, 
    78, 66, 89, 81, 50, 86, 89, 34, 39, 61, 63, 89, 84, 80, 63, 
    58, 43, 71, 81, 58, 55, 57, 51, 72, 81, 72, 45, 52, 30, 76, 
    75, 46, 62, 87, 58, 46, 64, 57, 81, 56, 88, 70, 70, 47, 85, 
    47, 83, 87, 59, 59, 57, 84, 62, 54, 69, 35, 50, 49, 79, 48, 
    66, 30, 41, 70, 53, 53, 80, 63, 58), perlev = c(72, 87, 70, 
    87, 78, 83, 84, 77, 70, 88, 89, 89, 80, 88, 79, 67, 77, 75, 
    70, 68, 69, 81, 87, 66, 71, 81, 88, 74, 71, 81, 55, 83, 81, 
    87, 89, 55, 89, 89, 60, 24, 84, 69, 75, 66, 60, 66, 75, 63, 
    72, 80, 72, 90, 69, 74, 45, 84, 86, 60, 78, 77, 77, 39, 74, 
    85, 40, 81, 78, 85, 74, 89, 83, 89, 76, 82, 77, 73, 66, 77, 
    73, 52, 63, 77, 72, 57, 84, 70, 73, 80, 51, 76, 74, 82, 76, 
    62, 30, 42, 65, 47, 77, 54, 82, 71, 57, 61, 43, 74, 90, 81, 
    89, 75, 37, 76, 52, 75, 68, 76, 81, 82, 12, 88, 68, 78, 69, 
    63, 88, 54, 89, 60, 79, 82, 22, 85, 81, 56, 56, 84, 79, 82, 
    85, 82, 85, 84, 68, 72, 50, 72, 69, 51, 77, 53, 76, 72, 58, 
    61, 71, 87, 78, 62, 53, 44, 51, 74, 86, 83, 57, 65, 72, 76, 
    55), phyphy = c(61, 44, 56, 49, 25, 20, 46, 22, 14, 65, 81, 
    27, 56, 78, 49, 44, 43, 18, 78, 21, 9, 88, 86, 78, 89, 7, 
    61, 13, 53, 27, 67, 42, 56, 47, 41, 72, 19, 84, 12, 78, 61, 
    80, 75, 22, 87, 84, 85, 87, 61, 48, 68, 11, 89, 21, 88, 20, 
    88, 90, 56, 63, 16, 32, 66, 56, 25, 67, 45, 54, 63, 37, 69, 
    26, 39, 59, 74, 13, 65, 52, 28, 3, 89, 36, 65, 39, 45, 40, 
    62, 41, 29, 18, 50, 40, 12, 44, 30, 15, 78, 75, 24, 54, 7, 
    28, 9, 62, 34, 25, 21, 47, 48, 15, 11, 56, 38, 56, 66, 14, 
    65, 50, 50, 21, 62, 22, 29, 78, 37, 7, 27, 79, 67, 49, 27, 
    46, 58, 32, 42, 48, 37, 48, 61, 15, 42, 50, 49, 34, 22, 60, 
    54, 29, 23, 24, 81, 57, 51, 28, 42, 32, 63, 38, 85, 78, 55, 
    6, 82, 57, 70, 28, 45, 37, 67, 14, 44, 53, 29, 68, 82, 32, 
    57, 41, 40, 53, 90, 37, 74, 61, 55, 52, 47, 48, 51, 35, 45, 
    62, 30, 55, 22, 39, 86, 66, 50, 33, 58, 66, 38, 43, 62, 56, 
    89, 57, 63, 37, 50, 83, 53, 63, 79, 68, 33, 89, 81, 77, 78, 
    11, 86, 42, 38, 52, 52, 75, 20, 43, 46, 72, 41, 38, 72, 48, 
    46, 71, 90, 2, 32, 23, 13, 69, 73, 28, 27, 5, 21, 14, 31, 
    31, 54, 66, 63, 36, 88, 62, 81, 49, 82, 53, 64, 37, 34, 71, 
    45, 56, 68, 71, 47, 45, 48, 75, 54, 32, 42, 69, 36, 70, 55, 
    44, 35, 47, 44, 61, 63, 49, 30, 59, 54, 44, 30, 27, 74, 69, 
    60, 18, 23, 71, 15, 30, 29, 50, 68, 38, 48, 51, 34, 26, 73, 
    20, 28, 20, 62, 53, 75, 50, 60, 35, 29, 7, 74, 49, 21, 58, 
    55, 41, 67, 23, 81, 50, 76, 57, 20, 42, 27, 33, 34, 71, 74, 
    48, 78, 35, 3, 55, 59, 59, 16, 40, 20, 76, 41, 21, 62, 63, 
    79, 59, 24, 74, 77, 32, 28, 87, 33, 48, 47, 46, 38, 40, 54, 
    38, 18, 67, 61, 69, 65, 23, 44, 66, 87, 64, 84, 64, 43, 36, 
    80, 62, 53, 44, 21, 85, 84, 27, 88, 69, 84, 37, 85, 77, 80, 
    76, 42, 86, 89, 4, 21, 10, 89, 44, 61, 85, 54, 23, 21, 58, 
    64, 63, 10, 55, 74, 79, 49, 82, 29, 40, 79, 76, 81, 75, 83, 
    53, 84, 89, 81, 41, 59, 67, 89, 88, 60, 79, 38, 47, 57, 70, 
    18, 86, 51, 40, 53, 57, 40, 31, 83, 50, 43, 64, 40, 35, 24, 
    89, 50, 56, 53, 49, 39, 38, 37, 38, 24, 62, 52, 27, 23, 52, 
    74, 60, 35, 38, 39, 42, 24, 18, 45, 54, 54, 47, 80, 52, 45, 
    38, 28, 41, 53, 71, 57, 35, 67, 28, 43, 17, 40, 68, 51, 59, 
    39, 41, 52, 5, 32, 38, 74, 75, 47, 43, 45, 40, 45, 30, 35, 
    52, 70, 59, 48, 26, 61, 65, 12, 33, 69, 41, 33, 78, 39, 42, 
    50, 43, 45, 57, 56, 54, 43, 50, 39, 53, 38, 47, 28, 52, 59, 
    2, 31, 23, 44, 58, 15, 73, 43, 25, 39, 43, 31, 42, 46, 32, 
    56, 37, 53, 56, 57, 43, 71, 81, 41, 20, 47, 75, 76, 16, 30, 
    52, 46, 65, 84, 67, 12, 63, 73, 51, 71, 28, 37, 58, 71, 66, 
    74, 67, 66, 46, 40, 31, 55, 28, 68, 56, 57, 33, 78, 28, 25, 
    87, 24, 24, 10, 24, 45, 47, 25, 60, 61, 15, 13, 47, 61, 36, 
    35, 13, 18, 63, 45, 33, 31, 16, 17, 56, 33, 43, 57, 74, 36, 
    52, 45, 8, 45, 30, 32, 13, 60, 52, 82, 48, 79, 24, 14, 80, 
    84, 36, 18, 55, 45, 56, 33, 56, 40, 34, 62, 77, 55, 66, 5, 
    28, 74, 72, 37, 65, 23, 64, 48, 30, 56, 51, 85, 47, 81, 25, 
    61, 19, 16, 21, 47, 40, 44, 8, 51, 69, 57, 83, 30, 46, 62, 
    40, 36, 74, 69, 49, 86, 54, 83, 70, 71, 72, 54, 50, 87, 51, 
    70, 26, 72, 36, 59, 51, 74, 29, 75, 76, 82, 49, 45, 40, 66, 
    79, 46, 79, 63, 18, 6, 6, 90, 58, 44, 53, 12, 78, 36, 20, 
    84, 47, 3, 84, 17, 17, 85, 83, 43, 33, 79, 77, 56, 47, 38, 
    59, 41, 57, 62, 37, 80, 87, 57, 28, 42, 54, 17, 18, 12, 48, 
    50, 44, 60, 31, 23, 44, 60, 42, 50, 56, 20, 32, 26, 54, 48, 
    60, 17, 68, 61, 47, 62, 42, 51, 27, 47, 45, 51, 60, 81, 47, 
    36, 4, 33, 38, 18, 65, 19, 71, 27, 27, 72, 80, 57, 25, 63, 
    69, 88, 28, 42, 45, 71, 6, 27, 36, 23, 48, 36, 49, 28, 55, 
    11, 81, 44, 53, 76, 43, 46, 62, 30, 26, 59, 41, 22, 15, 73, 
    52, 50, 29, 16, 87, 13, 57, 52, 67, 74, 81, 66, 44, 56, 64, 
    35, 47, 60, 66, 58, 32, 12, 17, 67, 54, 45, 39, 69, 37, 24, 
    26, 70, 51, 71, 12, 32, 36, 34, 14, 15, 39, 10, 30, 90, 24, 
    43, 21, 18, 40, 87, 52, 17, 85, 88, 85, 74, 89, 75, 8, 73, 
    82, 57, 75, 58, 48, 87, 40, 39, 20, 68, 85, 14, 64, 56, 32, 
    72, 42, 30, 55, 58, 31, 25, 83, 24, 54, 21, 48, 69, 58, 79, 
    64, 86, 55, 85, 32, 29, 42, 37, 64, 68, 53, 54, 89, 12, 60, 
    65, 27, 43, 26, 85, 85, 60, 52, 12, 33, 58, 75, 85, 53, 89, 
    19, 38, 74, 54, 60, 20, 90, 82, 75, 74, 54, 73, 71, 39, 38, 
    45, 80, 54, 62, 53, 22, 63, 69, 70, 68, 64, 37, 57, 36, 35, 
    86, 39, 27, 58, 36, 36, 46, 44, 53, 46, 40, 32, 67, 16, 18, 
    51, 38, 80, 56, 36, 85, 58, 50, 61, 18, 62, 66, 89, 24, 47, 
    27, 43, 61, 37, 50, 23, 53, 68, 72, 64, 10, 78, 35, 30, 46, 
    37, 33, 29, 28, 48, 79, 35, 33, 29, 65, 15, 74, 84, 64, 49, 
    52, 49, 49, 12, 66, 72, 77, 40, 17, 18, 66, 45, 49, 33, 28, 
    68, 30, 84, 37, 63, 82, 57, 79, 26, 79, 60, 28, 40, 33, 40, 
    58, 23, 37, 22, 48, 17, 78, 19, 41, 67, 60, 64, 84, 59, 77, 
    52, 23, 59, 73, 42, 23, 33, 38, 65, 45, 44, 65, 39, 87, 56, 
    44, 57, 70, 74, 38, 86, 82, 86, 86, 90, 41, 23, 38, 17, 76, 
    32, 14, 21, 83, 85, 36, 74, 77, 88, 41, 88, 66, 67, 78, 48, 
    69, 57, 63, 28, 40, 73, 30, 74, 67, 37, 88, 26, 76, 84, 70, 
    12, 44, 79, 58, 69, 6, 76, 24, 81, 64, 89, 89, 46, 49, 54, 
    31, 76, 70, 75, 67, 73, 85, 37, 20, 68, 12, 89, 62, 55, 74, 
    24, 37, 31, 47, 45, 58, 40, 35, 45, 26, 38, 38, 36, 47, 49, 
    62, 17, 73, 60, 61, 67, 43, 49, 51, 40, 27, 69, 45, 21, 14, 
    33, 48, 86, 75, 55, 84, 76, 54, 64, 87, 43, 20, 46, 48, 83, 
    46, 47, 48, 54, 45, 42, 34, 23, 46, 24, 49, 45, 60, 55, 64, 
    84, 74, 60, 58, 86, 53, 74, 48, 45, 35, 73, 89, 21, 54, 49, 
    56, 58, 41, 80, 17, 54, 86, 83, 48, 32, 15, 11, 73, 42, 51, 
    65, 66, 49, 62, 49, 51, 40, 36, 86, 68, 65, 58, 50, 88, 85, 
    16, 66, 78, 67, 16, 84, 83, 83, 89, 72, 82, 40, 22, 73, 58, 
    47, 52, 65, 66, 54, 90, 57, 55, 27, 64, 80, 33, 68, 56, 41, 
    52, 39, 38, 67, 88, 68, 39, 47, 64, 58, 44, 44, 57, 16, 88, 
    50, 63, 26, 44, 55, 71, 53, 39, 53, 47, 54, 30, 52, 49, 67, 
    62, 32, 55, 50, 46, 35, 30, 37, 32, 27, 57, 55, 51, 31, 29, 
    55, 45, 15, 61, 39, 52, 74, 48, 58, 33, 34, 41, 79, 49, 67, 
    49, 43, 54, 53, 41, 72, 45, 60, 69, 51, 64, 44, 37, 56, 50, 
    37, 47, 48, 44, 59, 37, 56, 62, 37, 29, 23, 60, 26, 52, 30, 
    22, 24, 20, 36, 37, 10, 19, 9, 31, 20, 28, 29, 50, 36, 62, 
    57, 46, 42, 63, 51, 45, 32, 38, 39, 33, 63, 67, 38, 72, 29, 
    39, 57, 64, 36, 28, 12, 20, 11, 47, 30, 6, 38, 15, 27, 8, 
    28, 14, 14, 26, 14, 13, 14, 33, 10, 17, 20, 24, 51, 78, 43, 
    63, 39, 43, 40, 49, 65, 37, 40, 33, 59, 25, 24, 23, 19, 47, 
    56, 26, 37, 64, 89, 43, 64, 22, 56, 65, 46, 45, 48, 45, 35, 
    61, 43, 75, 50, 65, 55, 47, 49, 36, 44, 10, 34, 44, 27, 61, 
    63, 71, 60, 67, 81, 61, 72, 55, 65, 45, 57, 59, 44, 47, 55, 
    76, 27, 24, 39, 21, 34, 25, 36, 34, 7, 26, 26, 28, 18, 26, 
    21, 52, 28, 33, 37, 58, 30, 23, 17, 39, 60, 32, 8, 18, 51, 
    26, 23, 22, 27, 89, 70, 59, 84, 87, 4, 21, 77, 28, 38, 39, 
    39, 37, 84, 85, 88, 76, 61, 39, 89, 88, 65, 33, 87, 87, 87, 
    66, 1, 59, 66, 28, 53, 81, 84, 65, 86, 56, 67, 28, 10, 68, 
    67, 56, 45, 17, 54, 46, 32, 56, 56, 38, 49, 22, 57, 56, 49, 
    50, 72, 57, 52, 51, 85, 36, 42, 84, 70, 52, 53, 59, 89, 46, 
    23, 74, 37, 46, 31, 35, 54, 39, 24, 33, 28, 45, 43, 31, 9, 
    53, 35, 39, 53, 25, 88, 28, 33, 46, 54, 82, 25, 34, 37, 48, 
    37, 31, 48, 85, 49, 22, 53, 52, 46, 69, 27, 66, 49, 64, 25, 
    18, 64, 81, 72, 90, 52, 74, 44, 22, 30, 48, 54), pomfur = c(12, 
    45, 37, 26, 48, 52, 30, 44, 14, 42, 26, 35, 31, 25, 39, 24, 
    33, 25, 52, 35, 33, 25, 47, 40, 39, 27, 45, 13, 24, 23, 39, 
    22, 48, 23, 17, 18, 42, 28, 13, 43, 17, 41, 25, 29, 7, 23, 
    6, 21, 64, 27, 31, 44, 15, 37, 35, 37, 8, 25, 53, 41, 28, 
    26, 34, 23, 30, 19, 25, 31, 27, 34, 43, 50), puldap = c(21, 
    19, 70, 17, 37, 12, 11, 50, 21, 43, 72, 11, 46, 9, 58, 42, 
    7, 22, 53, 47, 40, 34, 29, 71, 28, 36, 31, 4, 65, 36, 27, 
    36, 34, 48, 15, 9, 25, 25, 20, 31, 50, 42, 47, 9, 47, 19, 
    75, 38, 15, 55, 35, 10, 38, 16, 38, 34, 38, 33, 51, 47, 24, 
    64, 29, 19, 52, 30, 58, 56, 14, 14, 36, 36, 54, 55, 45, 50, 
    23, 37, 67, 32, 26, 24, 46, 20, 42, 32, 10, 19, 29, 47, 37, 
    14, 29, 31, 31, 45, 52, 57, 68, 31, 51, 46, 40, 35, 5, 39, 
    18, 76, 27, 34, 33, 27, 26, 88, 16, 21, 74, 8, 22, 58, 11, 
    30, 9, 33, 24, 47, 20, 30, 77, 38, 37, 66, 48, 17, 62, 47, 
    35, 49, 55, 15, 26, 16, 30, 46, 34, 73, 53, 21, 18, 69, 81, 
    48, 43, 24, 26, 87, 14, 27, 60, 33, 32, 52, 26, 49, 51, 19, 
    47, 10, 70, 14, 65, 40, 21, 11, 16, 35, 31, 34, 64, 79, 54, 
    56, 29, 54, 40, 19, 60, 47, 38, 69, 39, 82, 38, 84, 35, 18, 
    43, 44, 69, 23, 54, 31, 34, 45, 45, 83, 66, 50, 43, 57, 53, 
    29, 45, 68, 29, 27, 20, 53, 14, 20, 48, 36, 30, 36, 34, 29, 
    23, 27, 34, 31, 34, 28, 9, 55, 17, 51, 53, 42, 50, 29, 46, 
    57, 74, 55, 49, 43, 27, 53, 18, 25, 54, 28, 14, 68, 76, 32, 
    74, 61, 56, 18, 52, 53, 76, 33, 74, 66, 54, 34, 56, 17, 21, 
    34, 22, 56, 22, 61, 30, 23, 50, 36, 30, 18, 45, 56, 56, 32, 
    15, 21, 31, 36, 8, 12, 22, 45, 37, 23, 32, 59, 45, 19, 18, 
    39, 34, 49, 19, 50, 20, 14, 21, 59, 50, 57, 26, 64, 46, 37, 
    24, 46, 55, 34, 75, 49, 53, 40, 31, 43, 49, 39, 53, 51, 43, 
    45, 29, 34, 48, 54, 36, 40, 48, 35, 9, 22, 42, 20, 51, 40, 
    43, 29, 37, 40, 34, 30, 23, 55, 37, 46, 47, 39, 36, 46, 21, 
    8, 24, 4, 19, 11, 34, 30, 16, 57, 33, 60, 49, 19, 33, 49, 
    62, 35, 51, 54, 65, 30, 53, 34, 24, 65, 22, 26, 27, 10, 55, 
    46, 41, 44, 49, 13, 24, 31, 47, 34, 22, 34, 9, 30, 20, 41, 
    26, 37, 38, 35, 57, 38, 17, 30, 46, 18, 26, 80, 69, 66, 32, 
    24, 69, 53, 55, 50, 48, 75, 83, 24, 58, 65, 30, 17, 64, 53, 
    39, 36, 69, 35, 53, 27, 36, 30, 45, 20, 46, 58, 43, 18, 25, 
    9, 40, 59, 35, 42, 21, 47, 69, 27, 40, 29, 69, 29, 24, 51, 
    24, 31, 40, 53, 48, 38, 15, 44, 30, 57, 39, 43, 81, 6, 45, 
    88, 27, 38, 68, 30, 36, 18, 12, 59, 21, 40, 32, 24, 69, 36, 
    60, 8, 22, 44, 32, 50, 38, 46, 42, 19, 40, 19, 38, 34, 33, 
    23, 30, 9, 27, 28, 44, 25, 34, 35, 13, 40, 29, 19, 12, 19, 
    33, 13, 29, 35, 54, 34, 13, 17, 28, 37, 35, 23, 25, 38, 30, 
    13, 52, 10, 39, 47, 29, 41, 14, 57, 2, 54, 19, 42, 15, 22, 
    12, 20, 21, 14, 23, 48, 11, 40, 65, 53, 24, 29, 43, 59, 31, 
    29, 24, 19, 50, 14, 15, 24, 39, 43, 21, 14, 30, 36, 14, 53, 
    65, 33, 7, 13, 47, 32, 20, 26, 5, 31, 60, 8, 32, 26, 34, 
    43, 71, 48, 40, 67, 35, 28, 73, 26, 29, 51, 60, 4, 36, 33, 
    13, 45, 59, 29, 31, 25, 75, 37, 10, 38, 80, 52, 5, 37, 45, 
    22, 18, 24, 23, 34, 46, 32, 28, 39, 31, 24, 38, 17, 41, 18, 
    22, 39, 6, 28, 20, 44, 36, 30, 30, 71, 19, 62, 37, 10, 24, 
    40, 32, 39, 8, 47, 11, 19, 11, 21, 60, 66, 73, 53, 27, 50, 
    25, 12, 34, 32, 45, 36, 45, 51, 35, 27, 33, 32, 24, 10, 12, 
    56, 89, 19, 27, 84, 28, 30, 58, 37, 18, 54, 15, 28, 31, 12, 
    20, 24, 61, 28, 12, 33, 22, 44, 27, 64, 21, 68, 25, 15, 33, 
    10, 30, 28, 38, 66, 61, 12, 15, 31, 36, 5, 44, 42, 72, 21, 
    15, 48, 62, 36, 11, 38, 42, 40, 34, 89, 14, 41, 75, 47, 27, 
    28, 42, 34, 69, 51, 31, 16, 32, 29, 23, 20, 41, 67, 17, 51, 
    39, 36, 18, 26, 18, 32, 20, 88, 76, 51, 71, 54, 64, 56, 54, 
    28, 45, 39, 86, 34, 38, 73, 43, 54, 21, 28, 48, 54, 19, 20, 
    32, 8, 8, 32, 7, 21, 22, 63, 65, 63, 15, 56, 30, 15, 13, 
    28, 33, 32, 21, 59, 56, 13, 48, 20, 30, 53, 42, 22, 44, 50, 
    14, 78, 49, 55, 63, 13, 38, 47, 65, 18, 71, 41, 59, 11, 33, 
    48, 70, 42, 35, 18, 79), pulell = c(38, 37, 27, 40, 40, 67, 
    57, 17, 6, 37, 24, 50, 51, 9, 40, 78, 30, 56, 26, 19, 57, 
    17, 63, 23, 35, 30, 41, 23, 52, 47, 34, 8, 56, 19, 42, 63, 
    54, 29, 21, 54, 45, 55, 1, 1, 7, 33, 7, 56, 30, 32, 49, 29, 
    15, 74, 49, 30, 43, 17, 28, 15, 5, 87, 51, 52, 46, 44, 44, 
    55, 57, 44, 38, 69, 54, 39, 49, 23, 20, 16, 24, 17, 29, 18, 
    33, 30, 27, 81, 43, 49, 50, 55, 62, 42, 67, 73, 62, 68, 86, 
    63, 77, 89, 43, 28, 37, 23, 24, 18, 9, 35, 25, 20, 20, 44, 
    18, 22, 19, 16, 36, 37, 10, 21, 20, 13, 21, 29, 23, 5, 23, 
    27, 32, 23, 74, 32, 90, 77, 52, 88, 87, 35, 72, 53, 27, 22, 
    23, 14, 26, 18, 42, 15, 14, 24, 36, 42, 75, 52, 78, 62, 48, 
    64, 67, 43, 13, 25, 23, 21, 15, 31, 51, 48, 4, 15, 68, 83, 
    20, 18, 58, 39, 74, 51, 38, 39, 77, 77, 70, 37, 79, 40, 63, 
    69, 53, 53, 64, 68, 48, 47, 62, 73, 58, 54, 49, 50, 62, 47, 
    52, 72, 87, 46, 76, 52, 88, 83, 60, 82, 72, 76, 34, 30, 50, 
    27, 36, 43, 48, 21, 36, 33, 36, 22, 34, 53, 42, 59, 71, 52, 
    58, 46, 80, 84, 84, 57, 87, 50, 90, 82, 39, 64, 84, 85, 75, 
    72, 77, 86, 71, 67, 80, 71, 88, 37, 80, 89, 49, 80, 41, 63, 
    75, 74, 51, 39, 84, 57, 18, 69, 72, 82, 89, 8, 64, 37, 17, 
    11, 44, 18, 64, 73, 65, 81, 46, 31, 73, 39, 48, 49, 47, 15, 
    20, 30, 83, 73, 72, 69, 63, 50, 72, 54, 44, 53, 48, 38, 44, 
    46, 38, 43, 62, 55, 71, 43, 44, 43, 40, 13, 28, 59, 83, 73, 
    48, 24, 63, 36, 22, 36, 12, 12, 29, 27, 31, 18, 36, 17, 32, 
    11, 22, 15, 18, 28, 88, 48, 83, 33, 70, 69, 8, 22, 49, 24, 
    40, 16, 27, 19, 31, 54, 54, 45, 37, 9, 40, 23, 19, 19, 42, 
    19, 27, 52, 30, 22, 30, 24, 34, 33, 43, 6, 23, 12, 20, 24, 
    26, 23, 20, 27, 7, 11, 11, 16, 10, 12, 65, 73, 65, 86, 86, 
    89, 59, 85, 62, 55, 78, 13, 73, 86, 78, 71, 77, 79, 66, 65, 
    72, 52, 51, 90, 60, 63, 59, 69, 44, 55, 55, 36, 32, 14, 27, 
    43, 29, 35, 35, 30, 35, 28, 28, 14, 27, 28, 33, 31, 23, 27, 
    16, 40, 29, 30, 23, 18, 45, 17, 42, 37, 71, 5, 12, 13, 18, 
    34, 39, 21, 88, 33, 39, 56, 49, 25, 42, 16, 7, 31, 44, 4, 
    7, 2, 2, 35, 14, 7, 5, 5, 6, 36, 21, 21, 32, 42, 26, 29, 
    13, 21, 29, 75, 64, 49, 49, 48, 41, 71, 87, 38, 26, 10, 40, 
    21, 17, 22, 8, 14, 26, 22, 17, 42, 9, 11, 24, 14, 14, 19, 
    3, 1, 14, 13, 29, 19, 1, 19, 42, 20, 12, 26, 21, 37, 14, 
    24, 14, 27, 36, 62, 81, 57, 60, 42, 71, 37, 10, 36, 80, 71, 
    37, 61, 42, 84, 51, 79, 41, 87, 51, 63, 27, 79, 87, 43, 79, 
    77, 7, 63, 72, 66, 14, 56, 24, 14, 35, 25, 64, 69, 27, 57, 
    52, 34, 32, 58, 33, 37, 53, 56, 45, 59, 51, 42, 55, 55, 50, 
    54, 14, 34, 42, 17, 28, 43, 33, 36, 36, 50, 27, 37, 16, 29, 
    5, 24, 19, 17, 14, 21, 17, 10, 17, 20, 17, 26, 26, 28, 35, 
    34, 34, 17, 17, 20, 20, 23, 15, 18, 33, 49, 64, 58, 70, 37, 
    35, 70, 89, 67, 89, 87, 83, 82, 75, 87, 80, 85, 74, 83, 77, 
    67, 77, 73, 77, 77, 61, 72, 75, 76, 68, 80, 86, 79, 69, 66, 
    58, 76, 63, 58, 76, 71, 64, 63, 65, 56, 61, 69, 63, 61, 60, 
    71, 60, 83, 88, 62, 50, 89, 66, 87, 58, 69, 36, 82, 73, 20, 
    79, 77, 83, 56, 24, 6, 85, 45, 67, 62, 61, 75, 88, 77, 60, 
    60, 53, 61, 82, 58, 84, 89, 86, 75, 64, 90, 84, 71, 73, 73, 
    74, 55, 83, 39, 43, 47, 51, 38, 36, 49, 52, 35, 55, 57, 43, 
    51, 48, 65, 46, 17, 56, 60, 70, 45, 31, 33, 33, 25, 36, 46, 
    45, 39, 25, 5, 14, 45, 31, 14, 61, 56, 61, 68, 60, 46, 47, 
    59, 64, 87, 63, 47, 53, 57, 55, 62, 49, 43, 49, 86, 22, 52, 
    22, 11, 38, 35, 45, 56, 63, 57, 81, 49, 82, 58, 47, 88, 85, 
    87, 83, 86, 58, 79, 77, 80, 87, 79, 86, 33, 46, 36, 33, 23, 
    25, 39, 33, 39, 31, 30, 31, 20, 18, 20, 11, 30, 41, 37, 13, 
    77, 59, 51, 18, 54, 49, 26, 35, 61, 20, 84, 85, 85, 79, 85, 
    77, 87, 89, 79, 80, 83, 77, 86, 88, 72, 79, 63, 83, 59, 66, 
    70, 73, 59, 81, 61, 78, 71, 87, 76, 83, 86, 67, 81, 77, 78, 
    56, 53, 32, 74, 72, 76, 81, 75, 73, 82, 38, 43, 43, 79, 89, 
    66, 66, 87, 65, 86, 88, 64, 64, 33, 83, 75, 11, 50, 53, 88, 
    33, 60, 41, 82, 77, 41, 33, 75, 47, 41, 36, 60, 24, 65, 42, 
    49, 57, 62, 54, 38, 4, 32, 22, 27, 34, 27, 29, 29, 35, 54, 
    17, 21, 20, 27, 37, 36, 27, 23, 27, 11, 34, 13, 19, 28, 8, 
    22, 36, 38, 16, 23, 51, 32, 56, 61, 68, 72, 78, 80, 36, 27, 
    59, 66, 85, 3, 14, 9, 26, 20, 7, 22, 27, 39, 19, 22, 17, 
    21, 27, 3, 32, 13, 21, 1, 41, 16, 28, 17, 21, 21, 6, 6, 16, 
    20, 5, 29, 8, 23, 6, 14, 6, 23, 16, 4, 6, 19, 17, 28, 16, 
    21, 24, 27, 15, 5, 24, 20, 37, 75, 89, 24, 26, 34, 56, 6, 
    4, 10, 55, 43, 24, 40, 59, 72, 59, 87, 74, 55, 88, 76, 37, 
    76, 47, 12, 78, 46, 63, 47, 52, 68, 66, 66, 65, 65, 57, 51, 
    52, 61, 60, 60, 56, 62, 61, 61, 61, 64, 63, 67, 62, 60, 46, 
    55, 53, 48, 53, 58, 62, 66, 48, 51, 33, 55, 47, 23, 76, 70, 
    51, 88, 80, 82, 58, 12, 55, 67, 49, 84, 65, 74, 76, 66, 86, 
    63, 52, 53, 37, 33, 51, 35, 85, 70, 47, 50, 47, 41, 49, 71, 
    87, 77, 76, 68, 72, 79, 85, 81, 87, 78, 84, 89, 80, 90, 84, 
    70, 87, 87, 89, 77, 84, 86, 87, 73, 85, 86, 89, 83, 77, 86, 
    89, 87, 35, 58, 69, 61, 56, 68, 89, 80, 71, 43, 54, 56, 38, 
    32, 53, 43, 37, 39, 33, 27, 52, 45, 37, 79, 79, 46, 84, 67, 
    63, 47, 42, 69, 79, 65, 52, 88, 63, 36, 73, 63, 52, 33, 39, 
    27, 43, 60, 74, 74, 42, 32, 83, 33, 64, 30, 44, 50, 40, 40, 
    25, 40, 26, 47, 32, 21, 33, 19, 35, 4, 10, 40, 34, 21, 32, 
    22, 28, 6, 17, 24, 18, 84, 42, 37, 52, 36, 18, 30, 9, 16, 
    18, 15, 10, 25, 6, 8, 37, 38, 6, 10, 56, 20, 12, 15, 56, 
    31, 35, 39, 29, 41, 30, 62, 6, 40, 53, 31, 36, 27, 18, 26, 
    24, 15, 17, 47, 25, 27, 39, 3, 12, 60, 45, 40, 50, 54, 51, 
    31, 19, 73, 10, 30, 6, 16, 15, 4, 8, 50, 12, 14, 6, 61, 10, 
    6, 32, 11, 15, 5, 16, 13, 36, 10, 11, 20, 41, 5, 11, 18, 
    23, 10, 8, 7, 55, 85, 25, 49, 22, 25, 23, 13, 20, 46, 15, 
    27, 14, 52, 48, 80, 64, 63, 56, 50, 90, 56, 40, 33, 62, 83, 
    82, 87, 50, 33, 89, 15, 63, 88, 84, 32, 45, 20, 14, 13, 28, 
    22, 59, 7, 47, 18, 19, 26, 53, 68, 45, 38, 36, 21, 6, 38, 
    34, 16, 44, 33, 41, 18, 77, 88, 74, 58, 55, 79, 55, 42, 58, 
    46, 55, 66, 72, 45, 45, 29, 41, 55, 45, 56, 36, 42, 49, 47, 
    51, 67, 50, 13, 54, 42, 36, 44, 48, 47, 33, 50, 63, 55, 40, 
    42, 60, 42, 55, 34, 29, 21, 71, 48, 14, 31, 25, 27, 52, 36, 
    39, 43, 24, 41, 39, 46, 87, 55, 36, 66, 78, 89, 81, 62, 63, 
    70, 74, 55, 69, 64, 65, 62, 52, 71, 78, 74, 64, 86, 65, 62, 
    89, 61, 46, 79, 62, 50, 46, 62, 69, 45, 66, 58, 73, 68, 67, 
    60, 73, 49, 57, 55, 86, 78, 60, 76, 72, 83, 53, 66, 80, 69, 
    71, 88, 51, 69, 83, 66, 56, 74, 53, 58, 52, 38, 22, 25, 11, 
    14, 14, 25, 22, 43, 28, 15, 17, 29, 13, 25, 38, 31, 20, 31, 
    14, 6, 7, 23, 14, 7, 5, 14, 14, 13, 15, 8, 9, 8, 17, 8, 88, 
    69, 33, 35, 50, 38, 46, 26, 29, 31, 59, 37, 23, 37, 34, 31, 
    84, 63, 26, 39, 72, 73, 14, 30, 23, 22, 14, 18, 4, 23, 13, 
    23, 18, 42, 39, 48, 28, 25, 19, 27, 31, 46, 25, 32, 49, 35, 
    37, 52, 29, 27, 43, 30, 41, 60, 42, 27, 47, 37, 23, 41, 25, 
    58, 52, 22, 25, 52, 32, 28, 32, 28, 40, 61, 28, 45, 72, 43, 
    29, 60, 26, 11, 47, 20, 41, 28, 74, 52, 39, 79, 62, 42, 71, 
    84), pulsti = c(70, 47, 85, 65, 88, 43, 77, 85, 70, 85, 77, 
    75, 59, 29, 89, 60, 54, 41, 67, 70, 33, 68, 86, 46, 47, 40, 
    36, 74, 43, 44, 47, 88, 59, 75, 82, 79, 54, 55, 44, 69, 78, 
    56, 88, 86, 47, 45, 46, 48, 60, 60, 76, 79, 65, 83, 52, 58, 
    56, 53, 66, 72, 83, 76, 38, 87, 56, 79, 37, 73, 77, 41, 14, 
    61, 87, 75, 75, 66, 55, 83, 67, 89, 82, 64, 65, 72, 72, 46, 
    74, 88, 76, 44, 47, 48, 49, 83, 51, 47, 79, 75, 32, 68, 55, 
    62, 54, 33, 53, 47, 75, 70, 63, 82, 76, 77, 27, 85, 84, 48, 
    52, 52, 82, 78, 34, 77, 89, 72, 69, 73, 72, 88, 41, 87, 85, 
    89, 47, 88, 76, 24, 56, 55, 75, 62, 57, 43, 33, 78, 42, 74, 
    51, 90, 61, 73, 34, 88, 62, 35, 86, 75, 69, 36, 71, 43, 35, 
    89, 69, 82, 82, 35, 89, 56, 44, 83, 73, 49, 55, 63, 49, 40, 
    34, 54, 80, 87, 73, 88, 34, 51, 82, 54, 48, 52, 69, 71, 74, 
    83, 75, 54, 47, 63, 53, 77, 64, 66, 65, 59, 56, 68, 78, 89, 
    59, 87, 46, 84, 53, 65, 38, 43, 81, 63, 46, 43, 77, 70, 83, 
    75, 38, 57, 83, 84, 44, 87, 59, 61, 89, 74, 84, 76, 86, 57, 
    59, 53, 87, 81, 51, 68, 48, 41, 74, 78, 71, 49, 85, 67, 61, 
    79, 67, 72, 53, 65, 46, 69, 48, 52, 56, 80, 69, 59, 71, 84, 
    87, 56, 55, 44, 62, 87, 77, 51, 74, 60, 35, 40, 82, 78, 49, 
    83, 40, 64, 69, 50, 50, 68, 86, 84, 67, 72, 85, 52, 82, 67, 
    86, 71, 44, 59, 62, 89, 58, 66, 55, 78, 73, 63, 61, 66, 38, 
    40, 76, 68, 58, 43, 51, 81, 51, 48, 47, 65, 62, 41, 39, 44, 
    47, 78, 82, 48, 39, 71, 74, 37, 63, 78, 52, 55, 53, 88, 51, 
    58, 57, 35, 58, 89, 60, 61, 84, 65, 68, 67, 81, 67, 69, 64, 
    71, 55, 47, 79, 67, 63, 69, 56, 54, 50, 57, 66, 50, 57, 44, 
    70, 74, 63, 55, 56, 51, 45, 62, 64, 71, 41, 56, 77, 64, 53, 
    72, 74, 67, 56, 58, 73, 76, 69, 52, 81, 57, 62, 75, 84, 63, 
    69, 67, 65, 69, 56, 63, 68, 49, 55, 61, 52, 68, 68, 67, 67, 
    71, 87, 68, 55, 57, 79, 70, 59, 71, 35, 36, 80, 30, 59, 46, 
    65, 75, 21, 49, 61, 48, 82, 74, 68, 80, 77, 42, 87, 76, 87, 
    87, 80, 42, 80, 61, 55, 41, 54, 87, 51, 27, 74, 82, 75, 60, 
    88, 36, 79, 88, 72, 48, 88, 83, 54, 87, 45, 82, 89, 72, 78, 
    81, 79, 72, 81, 67, 67, 19, 69, 22, 81, 7, 68, 76, 34, 50, 
    36, 20, 87, 66, 88, 55, 78, 82, 81, 87, 82, 76, 54, 62, 22, 
    31, 23, 51, 66, 72, 73, 85, 56, 65, 82, 84, 70, 59, 78, 69, 
    61, 76, 45, 79, 19, 71, 70, 82, 87, 72, 86, 75, 62, 85, 82, 
    57, 85, 78, 35, 77, 68, 40, 84, 80, 74, 55, 68, 67, 76, 67, 
    72, 88, 59, 38, 65, 61, 33, 65, 38, 55, 77, 59, 52, 45, 65, 
    79, 51, 45, 45, 67, 74, 61, 55, 69, 73, 50, 87, 80, 78, 61, 
    89, 55, 62, 89, 62, 55, 55, 45, 48, 49, 49, 78, 48, 61, 62, 
    75, 74, 41, 81, 42, 22, 50, 69, 84, 63, 38, 70, 76, 28, 24, 
    51, 75, 89, 67, 85, 49, 47, 86, 86, 80, 75, 50, 89, 36, 80, 
    90, 35, 57, 73, 72, 72, 76, 81, 57, 50, 73, 56, 77, 86, 50, 
    79, 82, 82, 68, 57, 50, 68, 69, 70, 60, 57, 49, 42, 47, 72, 
    61, 49, 65, 46, 59, 61, 71, 73, 74, 56, 37, 66, 56, 59, 77, 
    76, 68, 47, 54, 60, 62, 38, 64, 82, 46, 52, 73, 74, 90, 69, 
    55, 54, 66, 45, 69, 51, 45, 56, 74, 77, 70, 45, 85, 74, 56, 
    69, 64, 75, 57, 58, 63, 68, 82, 39, 61, 26, 78, 54, 66, 89, 
    66, 81, 77, 89, 60, 72, 64, 80, 24, 62, 72, 64, 78, 84, 31, 
    84, 68, 77, 78, 33, 87, 88, 50, 58, 58, 86, 74, 84, 45, 32, 
    79, 42, 54, 14, 48, 46, 78, 89, 79, 52, 48, 88, 49, 44, 83, 
    45, 88, 79, 49, 49, 60, 90, 79, 31, 80, 78, 88, 81, 39, 90, 
    58, 71, 72, 71, 52, 86, 76, 66, 77, 29, 35, 87, 36, 86, 70, 
    70, 71, 85, 31, 66, 82, 62, 56, 88, 63, 69, 39, 50, 34, 73, 
    68, 38, 67, 69, 44, 88, 64, 81, 72, 37, 50, 85, 63, 88, 44, 
    81, 90, 82, 83, 62, 80, 83, 73, 55, 53, 83, 87, 79, 82, 82, 
    51, 30, 86, 88, 77, 82, 42, 21, 86, 42, 46, 90, 44, 63, 72, 
    56, 77, 47, 78, 42, 86, 71, 59, 44, 59, 85, 51, 76, 62, 88, 
    52, 51, 49, 46, 69, 39, 55, 51, 60, 48, 39, 82, 81, 78, 73, 
    75, 55, 90, 73, 61, 74, 74, 84, 45, 63, 87, 72, 67, 68, 61, 
    87, 71, 63, 72, 59, 65, 70, 63, 54, 72, 87, 69, 82, 75, 76, 
    69, 60, 42, 42, 67, 51, 60, 34, 63, 83, 76, 62, 86, 32, 19, 
    57, 61, 82, 61, 65, 61, 56, 48, 61, 82, 52, 68, 78, 57, 64, 
    58, 55, 82, 64, 67, 65, 66, 58, 55, 70, 13, 72, 8, 79, 81, 
    32, 47, 66, 52, 59, 54, 78, 59, 42, 82, 88, 24, 53, 68, 57, 
    49, 69, 90, 58, 75, 47, 57, 80, 80, 67, 90, 76, 43, 59, 58, 
    70, 49, 80, 69, 48, 82, 41, 58, 75, 65, 64, 68, 84, 62, 79, 
    85, 63, 83, 49, 64, 60, 69, 59, 46, 57, 85, 90, 83, 39, 74, 
    47, 70, 51, 74, 56, 39, 76, 53, 75, 72, 40, 83, 72, 88, 66, 
    52, 82, 52, 76, 72, 60, 59, 61, 75, 78, 60, 68, 86, 56, 44, 
    53, 53, 66, 49, 84, 54, 76, 67, 82, 60, 86, 50, 64, 79, 87, 
    36, 42, 56, 42, 65, 74, 62, 81, 71, 54, 56, 79, 59, 81, 58, 
    76, 59, 64, 60, 61, 75, 70, 82, 77, 82, 38, 49, 58, 52, 75, 
    57, 36, 53, 66, 45, 43, 90, 64, 54, 76, 56, 75, 86, 50, 90, 
    50, 15, 37, 25, 23, 30, 67, 57, 1, 63, 35, 35, 77, 46, 66, 
    54, 71, 59, 12, 88, 79, 24, 44, 90, 86, 52, 48, 58, 69, 65, 
    30, 82, 89, 59, 67, 65, 51, 60, 70, 79, 51, 60, 86, 50, 73, 
    88, 45, 74, 88, 45, 35, 23, 66, 82, 76, 58, 44, 27, 49, 79, 
    55, 66, 75, 49, 69, 13, 67, 32, 51, 45, 1, 47, 85, 68, 35, 
    88, 88, 56, 75, 56, 51, 61, 72, 72, 62, 69, 48, 33, 72, 57, 
    49, 64, 24, 58, 81, 77, 37, 88, 29, 54, 78, 88, 61, 74, 81, 
    55, 66, 20, 74, 54, 81, 55, 26, 24, 74, 42, 66, 47, 67, 79, 
    75, 89, 25, 86, 50, 79, 31, 90, 50, 79, 51, 83, 47, 83, 60, 
    71, 89, 83, 59, 76, 89, 73, 26, 89, 86, 76, 83, 68, 83, 87, 
    67, 35, 71, 29, 67, 23, 89, 30, 80, 62, 49, 62, 85, 89, 80, 
    79, 28, 56, 30, 84, 76, 54, 83, 76, 86, 55, 71, 59, 55, 43, 
    36, 75, 73, 87, 77, 37, 83, 86, 36, 62, 88, 39, 59, 75, 60, 
    40, 51, 54, 62, 80, 61, 23, 67, 69, 88, 84, 71, 32, 63, 48, 
    84, 67, 39, 86, 72, 67, 39, 65, 83, 73, 69, 83, 19, 58, 37, 
    39, 86, 52, 67, 73, 25, 71, 53, 78, 65, 40, 22, 77, 87, 77, 
    83, 55, 79, 50, 30, 77, 41, 82, 80, 32, 59, 70, 86, 54, 68, 
    84, 86, 59, 20, 70, 24, 71, 79, 81, 61, 33, 51, 59, 60, 69, 
    33, 17, 36, 44, 84, 75, 71, 36, 51, 61, 63, 63, 42, 52, 47, 
    57, 49, 78, 60, 75, 80, 60, 59, 45, 76, 88, 62, 68, 53, 78, 
    71, 40, 60, 57, 64, 69, 77, 66, 53, 78, 67, 64, 71, 84, 34, 
    70, 53, 62, 82, 80, 81, 81, 70, 62, 86, 74, 32, 90, 83, 63, 
    45, 65, 87, 82, 46, 32, 88, 89, 70, 78, 86, 52, 70, 42, 81, 
    69, 75, 83, 61, 76, 58, 62, 76, 65, 90, 32, 89, 89, 80, 85, 
    44, 84, 83, 80, 87, 53, 83, 64, 87, 88, 54, 40, 51, 88, 65, 
    75, 64, 64, 84, 49, 42, 51, 89, 32, 56, 16, 34, 75, 56, 56, 
    70, 80, 42, 87, 73, 40, 52, 53, 44, 75, 49, 76, 51, 43, 71, 
    71, 33, 77, 85, 42, 32, 23, 88, 26, 55, 34, 77, 71, 84, 90, 
    88, 67, 48, 89, 64, 24, 75, 32, 74, 46, 85, 51, 83, 36, 81, 
    77, 87, 83, 72, 84, 53, 65, 82, 42, 81, 83, 19, 89, 43, 15, 
    17, 83, 79, 15, 28, 44, 71, 42, 23, 16, 22, 89, 57, 88, 12, 
    71, 67, 67, 61, 37, 52, 70, 90, 83, 81, 87, 50, 8, 41, 28, 
    43, 31, 32, 54, 67, 78, 55, 54, 73, 82, 73, 20, 64, 82, 58, 
    20, 68, 86, 27, 43, 84, 86, 83, 64, 70, 58, 64, 80, 48, 79, 
    84, 50, 72, 76, 70, 76, 55, 86, 68, 80, 79, 51, 66, 78, 54, 
    77, 81, 87, 71, 65, 69, 81, 89, 43, 67, 75, 46, 42, 69, 59, 
    81, 57, 62, 79, 73, 54, 34, 82, 39, 58, 60, 50, 64, 71, 55, 
    48, 52, 54, 23, 75, 89, 27, 44, 82, 68, 61, 26, 80, 51, 63, 
    85, 31, 50, 82, 57, 68, 73, 29, 78, 47, 87, 18, 73, 80, 88, 
    54, 80, 75, 87, 79, 48, 62, 86, 77, 44, 45, 36, 47, 61, 83, 
    45, 81, 85, 47, 70, 69, 79, 30, 26, 60, 55, 74, 23, 66, 43, 
    88, 85, 78, 44, 59, 89, 84, 69, 74, 50, 88, 43, 66, 67, 83, 
    68, 57, 86, 69, 51, 54, 72, 75, 66, 89, 45, 71, 40, 61, 68, 
    56, 71, 56, 56, 38, 85, 90, 48, 65, 79, 85, 85, 88, 87, 65, 
    70, 60, 63, 45, 79, 77, 78, 71, 59, 52, 27, 67, 85, 14, 68, 
    87, 84, 63, 59, 28, 76, 38, 60, 75, 64, 56, 73, 12, 25, 72, 
    28, 11, 57, 77, 42, 49, 41, 78, 86, 63, 65, 75, 87, 50, 68, 
    50, 90, 32, 78, 81, 44, 19, 65, 53, 76, 80, 23, 73, 78, 17, 
    84, 67, 76, 50, 79, 73, 42, 89, 30, 84, 76, 29, 67, 77, 71, 
    16, 82, 80, 88, 69, 42, 70, 50, 35, 37, 53, 89, 81, 21, 72, 
    18, 36, 79, 76, 23, 83, 74, 82, 74, 36, 78, 84, 72, 70, 62, 
    52, 37, 82, 74, 58, 82, 72, 77, 73, 66, 76, 78, 28, 37, 74, 
    35, 81, 79, 84, 75, 33, 50, 70, 19, 86, 55, 80, 84, 88, 77, 
    59, 28, 44, 70, 87, 26, 77, 40, 16, 32, 85, 44, 76, 61, 89, 
    79, 47, 48, 53, 65, 64, 44, 19, 48, 37, 24, 46, 87, 72, 64, 
    85, 80, 49, 83, 67, 40, 53, 53, 87, 82, 68, 88, 88, 87, 57, 
    48, 42, 67, 51, 42, 57, 42, 40, 44, 77, 70, 81, 78, 64, 52, 
    64, 82, 57, 55, 40, 41, 71, 43, 86, 43, 45, 62, 40, 73, 69, 
    85, 80, 62, 71, 84, 40, 82, 54, 49, 61, 82, 70, 59, 75, 83, 
    59, 46, 72, 59, 52, 62, 68, 85, 78, 72, 78, 38, 80, 58, 80, 
    70, 51, 53, 76, 68, 75, 66, 52, 54, 59, 73, 62, 68, 59, 84, 
    72, 68, 53, 66, 77, 72, 60, 67, 75, 63, 72, 70, 75, 70, 47, 
    58, 66, 52, 47, 73, 48, 58, 53, 42, 37, 73, 45, 74, 67, 61, 
    78, 44, 79, 81, 82, 45, 24, 88, 56, 48, 80, 23, 64, 84, 40, 
    81, 39, 88, 73, 73, 65, 62, 83, 55, 73, 29, 77, 40, 87, 33, 
    9, 49, 76, 17, 75, 83, 68, 48, 37, 82, 61, 62, 89, 67, 69, 
    86, 89, 77, 84, 83, 60, 88, 77, 86, 36, 37, 26, 65, 43, 67, 
    40, 38, 55, 58, 49, 87, 4, 61, 59, 79, 89, 57, 22, 80, 82, 
    71, 63, 43, 52, 41, 88, 68, 74, 81, 81, 48, 87, 88, 88, 29, 
    26, 36, 79, 59, 55, 85, 78, 25, 72, 61, 26, 89, 38, 82, 31, 
    72, 44, 82, 77, 73, 70, 83, 22, 48, 45, 86, 70, 64, 38, 27, 
    63, 83, 75, 45, 70, 69, 76, 83, 32, 33, 31, 47, 75, 77, 74, 
    62, 76, 42, 74, 26, 67, 21, 61, 85, 17, 45, 66, 81, 55, 58, 
    86, 78, 73, 74, 65, 70, 37, 36, 46, 58, 83, 76, 78, 73, 89, 
    74, 88, 71, 56, 78, 57, 62, 60, 70, 60, 70, 74, 77, 71, 72, 
    85, 44, 43, 53, 44, 88, 69, 82, 52, 60, 90, 45, 80, 82, 50, 
    87, 22, 84, 52, 58, 37, 38, 47, 80, 63, 82, 88, 84, 84, 63, 
    90, 74, 78, 79, 24, 73, 54, 25, 39, 87, 81, 60, 51, 38, 52, 
    70, 56, 58, 73, 60, 61, 54, 82, 62, 47, 43, 78, 52, 68, 71, 
    46, 60, 84, 43, 39, 74, 81, 45, 84, 36, 34, 43, 79, 39, 85, 
    59, 53, 53, 46, 67, 64, 48, 46, 90, 82, 44, 23, 78, 4, 89, 
    53, 76, 77, 17, 10, 52, 84, 60, 68, 62, 66, 88, 15, 74, 43, 
    48, 55, 34, 81, 69, 45, 80, 60, 63, 37, 48, 85, 80, 72, 66, 
    85, 51, 56, 22, 89, 83, 78, 35, 17, 82, 80, 82, 21, 67, 77, 
    40, 17, 87, 45, 70, 56, 89, 88, 30, 81, 86, 80, 62, 85, 24, 
    77, 54, 19, 63, 38, 30, 88, 47, 45, 73, 75, 76, 62, 50, 27, 
    80, 64, 90, 32, 78, 84, 84, 28, 58, 68, 76, 36, 48, 48, 63, 
    90, 59, 86, 27, 63, 87, 50, 75, 74, 84, 37, 48, 58, 85, 73, 
    19, 72, 59, 53, 31, 83, 79, 42, 88, 60, 64, 85, 48, 70, 42, 
    89, 78, 55, 25, 59, 69, 79, 59, 31, 71, 23, 84, 60, 74, 77, 
    88, 61, 83, 45, 40, 77, 63, 46, 81, 79, 88, 74, 74, 70, 88, 
    57, 56, 85, 39, 37, 83, 81, 67, 26, 76, 81, 80, 50, 23, 73, 
    83, 50, 66, 14, 88, 87, 88, 59, 69, 90, 88, 87, 40, 76, 88, 
    27, 59, 26, 47, 36, 86, 82, 87, 53, 16, 50, 9, 32, 36, 35, 
    36, 67, 42, 20, 64, 84, 1, 71, 76, 82, 45, 87, 17, 22, 20, 
    24, 61, 65, 35, 76, 77, 28, 66, 65, 51, 74, 58, 75, 13, 73, 
    47, 61, 30, 88, 25, 61, 62, 63, 84, 84, 44, 45, 87, 42, 42, 
    74, 83, 38, 84, 88, 85, 37, 76, 40, 77, 48, 62, 89, 32, 35, 
    43, 83, 40, 43, 56, 85, 66, 37, 90, 37, 29, 31, 83, 43, 35, 
    47, 56, 28, 90, 75, 66, 89, 78, 88, 65, 38, 80, 88, 48, 47, 
    66, 84, 49, 78, 68, 82, 87, 81, 60, 52, 52, 45, 62, 62, 68, 
    76, 54, 59, 59, 42, 88, 77, 70, 55, 74, 51, 64, 22, 53, 57, 
    45, 67, 78, 47, 67, 44, 65, 43, 86, 27, 74, 88, 70, 88, 28, 
    56, 74, 86, 89, 85, 64, 38, 62, 63, 37, 65, 75, 32, 51, 80, 
    88, 45, 39, 86, 30, 50, 52, 73, 83, 79, 54, 90, 66, 30, 86, 
    55, 45, 64, 38, 81, 27, 68, 79, 32, 89, 46, 64, 71, 80, 43, 
    90, 73, 78, 12, 77, 44, 83, 64, 67, 79, 75, 68, 62, 83, 70, 
    80, 51, 79, 42, 80, 82, 85, 84, 36, 82, 74, 27, 63, 69, 70, 
    84, 52, 63, 69, 82, 80, 56, 67, 57, 24, 39, 76, 62, 90, 76, 
    62, 51, 80, 60, 51, 44, 86, 82, 57, 85, 49, 82, 84, 46, 54, 
    8, 77, 82, 43, 18, 82, 58, 63, 80, 65, 37, 61, 50, 8, 63, 
    79, 78, 68, 73, 65, 38, 75, 44, 19, 73, 90, 76, 54, 43, 29, 
    59, 58, 43, 33, 86, 78, 74, 36, 85, 79, 63, 20, 83, 74, 44, 
    30, 49, 57, 80, 49, 64, 82, 56, 14, 34, 61, 71, 50, 24, 78, 
    87, 69, 28, 28, 63, 20, 11, 73, 68, 67, 55, 19, 88, 66, 84, 
    80, 73, 37, 87, 51, 36, 76, 78, 28, 34, 69, 63, 68, 28, 30, 
    34, 58, 61, 45, 53, 82, 67, 78, 75, 25, 87, 87, 78, 84, 73, 
    75, 50, 32, 64, 88, 87, 78, 20, 57, 49, 70, 87, 87, 70, 74, 
    71, 61, 24, 85, 87, 67, 53, 63, 74, 77, 43, 62, 85, 32, 24, 
    77, 44, 77, 58, 87, 28, 75, 31, 82, 34, 85, 80, 83, 55, 22, 
    41, 72, 28, 80, 83, 28, 80, 42, 29, 37, 84, 68, 73, 59, 67, 
    61, 61, 58, 56, 49, 85, 75, 43, 56, 86, 64, 62, 58, 45, 42, 
    69, 60, 87, 50, 68, 60, 71, 72, 64, 81, 77, 48, 48, 53, 42, 
    80, 64, 43, 86, 50, 66, 77, 84, 50, 74, 74, 69, 50, 84, 50, 
    57, 36, 79, 75, 39, 59, 69, 85, 86, 85, 67, 68, 79, 44, 63, 
    64, 42, 68, 62, 70, 52, 47, 88, 59, 62, 82, 51, 31, 58, 84, 
    48, 55, 49, 49, 82, 88, 47, 33, 58, 79, 28, 74, 85, 58, 39, 
    50, 57, 64, 52, 89, 27, 52, 23, 52, 76, 82, 15, 73, 54, 53, 
    75, 68, 74, 59, 19, 50, 83, 85, 66, 46, 43, 13, 75, 49, 66, 
    89, 46, 78, 88, 76, 28, 84, 79, 22, 41, 88, 56, 81, 44, 57, 
    84, 83, 88, 53, 75, 76, 59, 42, 57, 52, 71, 45, 73, 25, 81, 
    47, 66, 23, 63, 61, 53, 70, 37, 82, 84, 69, 45, 61, 29, 57, 
    41, 71, 14, 89, 73, 72, 49, 87, 23, 62, 89, 46, 75, 15, 7, 
    87, 43, 27, 40, 78, 83, 34, 18, 74, 86, 54, 86, 72, 51, 46, 
    66, 90, 87, 57, 89, 67, 62, 60, 46, 69, 73, 74, 89, 30, 49, 
    42, 50, 74, 89, 87, 48, 41, 88, 62, 50, 46, 63, 89, 62, 26, 
    64, 87, 81, 66, 67, 84, 66, 74, 74, 50, 50, 64, 73, 67, 75, 
    56, 63, 60, 68, 66, 72, 72, 68, 83, 68), rapvar = c(28, 85, 
    15, 46, 12, 48, 45, 19, 23, 22, 49, 18, 26, 43, 31, 30, 52, 
    20, 23, 27, 61, 25, 32, 25, 9, 39, 54, 22, 57, 7, 58, 30, 
    55, 23, 52, 12, 57, 58, 40, 8, 51, 24, 53, 28, 45, 27, 23, 
    33, 25, 43, 28, 37, 44, 40, 52, 30, 17, 24, 51, 8, 84, 7, 
    82, 27, 48, 24, 23, 62, 36, 31, 15, 14, 23, 18, 28, 16, 69, 
    65, 60, 85, 39, 72, 41, 38, 71, 63, 38, 52, 77, 53, 29, 9, 
    50, 45, 25, 11, 61, 59, 69, 55, 40, 32, 31, 36, 31, 38, 39, 
    5, 58, 29, 18, 25, 15, 7, 22, 21, 54, 27, 28, 37, 51, 27, 
    44, 10, 25, 30, 19, 17, 27, 43, 56, 32), syngla = c(46, 19, 
    42, 44, 28, 25, 50, 53, 42, 45, 39, 56, 30, 34, 32, 47, 78, 
    55, 49, 60, 59, 31, 23, 25, 48, 38, 39, 57, 59, 34, 50, 27, 
    34, 52, 66, 63, 35, 50, 20, 34, 54, 31, 18, 41, 50, 21, 58, 
    21, 31, 22, 37, 44, 49, 70, 36, 43, 38, 36, 54, 65, 47, 44, 
    16, 50, 15, 47, 28, 49, 49, 51, 49, 41, 26, 27, 49, 59, 46, 
    57, 52, 38, 59, 39, 70, 26, 68, 32, 37, 50, 42, 45, 69, 61, 
    71, 50, 52, 44, 27, 65, 53, 37, 42, 37, 53, 43, 33, 39, 38, 
    14, 65, 33, 17, 22, 47, 57, 64, 51, 51, 68, 90, 24, 35, 47, 
    49, 41, 15, 52, 63, 50, 68, 38, 54, 67, 89, 60, 71, 10, 31, 
    29, 34, 29, 29, 20, 38, 44, 68, 15, 27, 51, 48, 31, 67, 56, 
    11, 32, 33, 42, 30, 26, 43, 34, 26, 16, 24, 49, 7, 40, 30, 
    61, 19, 52, 14, 47, 37, 42, 55, 25, 54, 71, 43, 47, 29, 49, 
    11, 56, 31, 17, 42, 84, 49, 62, 64, 40, 66, 17, 25, 36, 55, 
    44, 76, 53, 27, 74, 49, 34, 31, 5, 37, 9, 29, 8, 24, 56, 
    41, 55, 72, 35, 41, 49, 46, 53, 30, 50, 43, 51, 18, 45, 45, 
    43, 47, 48, 48, 55, 22, 31, 23, 56, 47, 49, 40, 41, 26, 34, 
    45, 35, 63, 55, 26, 52, 34, 58, 68, 77, 58, 12, 63, 21, 24, 
    57, 40, 9, 44, 81, 41, 51, 61, 31, 17, 75, 43, 43, 50, 42, 
    39, 25, 21, 42, 38, 22, 61, 60, 37, 64, 62, 50, 55, 57, 36, 
    13, 26, 40, 44, 18, 80, 26, 15, 70, 33, 49, 70, 31, 52, 50, 
    47, 34, 50, 13, 19, 81, 64, 40, 17, 12, 71, 29, 63, 64, 48, 
    54, 45, 22, 63, 39, 88, 45, 25, 89, 54, 59, 51, 39, 74, 66, 
    20, 61, 38, 45, 33, 51, 30, 57, 31, 20, 44, 44, 43, 53, 36, 
    60, 31, 67, 29, 22, 22, 3, 45, 31, 35, 38, 59, 46, 65, 48, 
    66, 52, 72, 42, 40, 19, 47, 39, 31, 33, 49, 42, 46, 31, 52, 
    30, 60, 39, 56, 19, 21, 25, 52, 18, 48, 32, 51, 40, 74, 38, 
    57, 41, 69, 37, 66, 28, 21, 49, 29, 31, 14, 54, 47, 45, 32, 
    16, 79, 27, 24, 33, 23, 41, 27, 46, 27, 59, 48, 59, 22, 26, 
    34, 44, 13, 49, 46, 22, 11, 55, 23, 75, 44, 52, 61, 5, 43, 
    32, 66), synglo = c(86, 43, 74, 54, 57, 48, 38, 53, 20, 45, 
    47, 57, 41, 40, 52, 21, 51, 22, 31, 36, 74, 24, 26, 49, 29, 
    10, 40, 43, 49, 58, 24, 24, 35, 16, 23, 31, 61, 50, 50, 50, 
    9, 9, 80, 3, 72, 46, 15, 16, 46, 69, 23, 54, 60, 17, 59, 
    80, 17, 34, 26, 39, 52, 47, 38, 19, 43, 40, 84, 87, 35, 20, 
    38, 46, 42, 80, 33, 66, 61, 89, 33, 55, 52, 32, 30, 50, 44, 
    43, 5, 14, 36, 56, 26, 61, 48, 46, 45, 28, 35, 24, 25, 22, 
    38, 31, 40, 42, 28, 29, 56, 40, 55, 28, 46, 49, 46, 25, 31, 
    17, 64, 62, 36, 14, 16, 2, 8, 45, 57, 47, 54, 26, 27, 41, 
    56, 12, 38, 49, 59, 61, 13, 13, 33, 45, 49, 10, 85, 40, 32, 
    26, 35, 75, 72, 18, 4, 23, 83, 14, 43, 24, 65, 26, 29, 20, 
    53, 83, 19, 19, 42, 27, 88, 36, 88, 37, 27, 38, 15, 45, 13, 
    3, 39, 26, 12, 24, 78, 44, 67, 8, 65, 29, 49, 44, 80, 20, 
    59, 9, 49, 21, 83, 7, 72, 34, 53, 20, 60, 10, 54, 17, 33, 
    10, 42, 38, 26, 42, 8, 8, 14, 13, 22, 23, 65, 40, 54, 39, 
    12, 34, 1, 3, 31, 21, 17, 18, 75, 66, 30, 33, 61, 61, 26, 
    22, 25, 26, 85, 50, 39, 38, 43, 69, 24, 17, 29, 24, 41, 82, 
    22, 10, 51, 47, 21, 40, 23, 58, 36, 7, 81, 85, 46, 13, 24, 
    28, 8, 62, 80, 16, 24, 21, 61, 64, 23, 11, 25, 74, 45, 4, 
    68, 53, 52, 54, 32, 68, 26, 73, 79, 68, 13, 19, 39, 42, 18, 
    18, 64, 39, 61, 61, 22, 44, 50, 22, 24, 86, 37, 34, 45, 49, 
    33, 41, 32, 32, 25, 43, 54, 65, 33, 79, 6, 35, 80, 6, 41, 
    53, 57, 53, 11, 11, 16, 27, 60, 69, 36, 37, 83, 22, 30, 16, 
    70, 17, 55, 12, 28, 26, 89, 72, 65, 37, 15, 55, 41, 36, 42, 
    14, 15, 5, 46, 41, 19, 39, 19, 9, 50, 51, 37, 62, 9, 6, 63, 
    55, 40, 23, 6, 11, 49, 67, 56, 32, 14, 30, 50, 55, 31, 31, 
    15, 8, 67, 52, 36, 38, 3, 28, 20, 13, 73, 38, 51, 44, 16, 
    12, 24, 49, 50, 38, 26, 30, 86, 72, 48, 50, 43, 66, 65, 55, 
    52, 52, 45, 55, 69, 36, 21, 45, 9, 35, 50, 39, 63, 61, 19, 
    32, 32, 19, 24, 50, 41, 32, 11, 18, 30, 8, 39, 28, 41, 37, 
    15, 28, 34, 35, 46, 38, 41, 34, 24, 11, 35, 36, 36, 30, 23, 
    29, 57, 45, 50, 34, 84, 58, 55, 58, 23, 20, 55, 33, 32, 46, 
    33, 52, 52, 53, 69, 64, 74, 40, 14, 13, 59, 50, 57, 33, 32, 
    21, 38, 36, 37, 37, 22, 25, 84, 35, 62, 65, 35, 36, 33, 29, 
    24, 44, 37, 42, 31, 67, 33, 58, 43, 44, 41, 46, 22, 16, 38, 
    19, 35, 49, 43, 35, 80, 18, 28, 20, 54, 51, 11, 44, 10, 46, 
    31, 29, 46, 59, 33, 51, 22, 42, 39, 37, 6, 6, 24, 35, 10, 
    18, 29, 47, 61, 39, 7, 46, 28, 68, 48, 26, 31, 57, 39, 24, 
    17, 25, 77, 43, 41, 20, 21, 17, 38, 34, 33, 44, 45, 14, 29, 
    52, 24, 9, 15, 27, 16, 16, 22, 31, 48, 38, 77, 22, 59, 4, 
    32, 28, 36, 41, 30, 80, 8, 11, 32, 30, 20, 19, 28, 39, 70, 
    69, 22, 35, 35, 43, 56, 29, 30, 7, 46, 33, 33, 28, 36, 23, 
    34, 31, 79, 38, 79, 39, 56, 25, 71, 20, 15, 15, 34, 50, 78, 
    75, 27, 29, 23, 23, 15, 50, 30, 62, 28, 41, 42, 33, 7, 22, 
    23, 29, 3, 15, 37, 20, 46, 68, 50, 53, 35, 41, 80, 25, 9, 
    59, 30, 18, 33, 23, 50, 35, 37, 42, 68, 33, 24, 31, 63, 78, 
    16, 19, 34, 18, 43, 29, 23, 18, 16, 11, 64, 43, 17, 32, 68, 
    44, 34, 77, 88, 78, 10, 14, 39, 39, 28, 33, 46, 38, 13, 22, 
    35, 20, 32, 42, 25, 36, 17, 18, 51, 45, 35, 33, 88, 56, 39, 
    47, 44, 53, 35, 37, 24, 11, 35, 29, 31, 33, 46, 40, 20, 25, 
    54, 57, 16, 16, 32, 25, 26, 38, 23, 37, 20, 42, 31, 30, 18, 
    16, 53, 10, 50, 49, 33, 28, 22, 26, 23, 27, 47, 14, 33, 39, 
    56, 50, 18, 13, 28, 29, 27, 38, 31, 47, 19, 80, 64, 64, 46, 
    46, 7, 9, 5, 38, 76, 44, 44, 46, 30, 14, 36, 24, 71, 63, 
    10, 44, 37, 39, 39, 51, 12, 14, 49, 39, 29, 31, 68, 71, 47, 
    79), treasp = c(48, 70, 73, 79, 83, 86, 72, 68, 68, 51, 77, 
    60, 64, 57, 87, 56, 89, 85, 90, 9, 71, 69, 59, 86, 72, 62, 
    57, 83, 68, 73, 76, 32, 64, 61, 79, 80, 87, 83, 88, 64, 89, 
    80, 87, 71, 86, 65, 73, 73, 70, 64, 51, 87, 60, 77, 84, 78, 
    71, 74, 89, 78, 74, 77, 64, 90, 82, 85, 44, 81, 74, 74, 86, 
    85, 82, 19, 88, 76, 54, 66, 39, 49, 64, 74, 62, 70, 72, 63, 
    67, 64, 57, 59, 65, 78, 77, 82, 46, 70, 16, 59, 65, 68, 65, 
    81, 68, 74, 85, 69, 84, 75, 89, 68, 81, 74, 62, 65, 54, 73, 
    39, 70, 39, 67, 69, 80, 80, 66, 46, 79, 77, 78, 77, 60, 80, 
    81, 79, 75, 84, 44, 52, 89, 59, 55, 64, 26, 67, 84, 53, 69, 
    66, 87, 66, 77, 30, 67, 60, 71, 75, 78, 74, 80, 75, 80, 86, 
    67, 58, 61, 81, 83, 86, 87, 71, 85, 62, 72, 53, 76, 58, 72, 
    71, 85, 86, 84, 62, 86, 84, 73, 82, 74, 82, 71, 79, 2, 50, 
    70, 28, 76, 39, 72, 64, 48, 40, 36, 27, 61, 54, 65, 56, 68, 
    47, 76, 73, 79, 71, 46, 85, 27, 64, 27, 60, 38, 74, 39, 68, 
    31, 75, 77, 77, 74, 80, 79, 58, 38, 63, 26, 57, 63, 44, 38, 
    69, 54, 75, 36, 53, 72, 32, 63, 41, 78, 33, 61, 20, 57, 44, 
    79, 72, 42, 55, 15, 77, 53, 64, 27, 45, 67, 63, 55, 53, 51, 
    63, 52, 58, 12, 58, 71, 25, 76, 57, 67, 60)), .Names = c("Speciesnames", 
"acaflo", "acamyr", "acasua", "anghis", "astflo", "banmar", "banobl", 
"borpin", "breobl", "conlon", "epapul", "eriaus", "eucgum", "euchae", 
"gomlat", "grebux", "grespe", "hakdac", "hibbra", "isoane", "kunpar", 
"lamfor", "lasfer", "lepspp", "leptri", "leumic", "lomsil", "perlan", 
"perlev", "phyphy", "pomfur", "puldap", "pulell", "pulsti", "rapvar", 
"syngla", "synglo", "treasp"))
