/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.AMPSO;

import java.util.ArrayList;
import java.util.Arrays;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.Distance;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Parameters;
import keel.Algorithms.Instance_Generation.utilities.RandomGenerator;

public class AMPSOGenerator
extends PrototypeGenerator {
    private int k;
    private int SwarmSize;
    private int MaxIter;
    private double C1;
    private double C2;
    private double C3;
    private double VMax;
    private double Winertia;
    private double Xfactor;
    private double ProbR;
    private double ProbD;
    protected int numberOfPrototypes;
    private String[] paramsOfInitialReducction = null;
    protected int numberOfClass;

    public AMPSOGenerator(PrototypeSet _trainingDataSet, int neigbors, int poblacion, int iteraciones, double c1, double c2, double c3, double vmax, double inertia, double x, double pr, double pd) {
        super(_trainingDataSet);
        this.algorithmName = "AMPSO";
        this.k = neigbors;
        this.SwarmSize = poblacion;
        this.MaxIter = iteraciones;
        this.C1 = c1;
        this.C2 = c2;
        this.C3 = c3;
        this.VMax = vmax;
        this.Winertia = inertia;
        this.Xfactor = x;
        this.ProbR = pr;
        this.ProbD = pd;
    }

    public AMPSOGenerator(PrototypeSet t, Parameters parameters) {
        super(t, parameters);
        this.algorithmName = "PSO";
        this.k = parameters.getNextAsInt();
        this.SwarmSize = parameters.getNextAsInt();
        this.MaxIter = parameters.getNextAsInt();
        this.C1 = parameters.getNextAsDouble();
        this.C2 = parameters.getNextAsDouble();
        this.C3 = parameters.getNextAsDouble();
        this.VMax = parameters.getNextAsDouble();
        this.Winertia = parameters.getNextAsDouble();
        this.Xfactor = parameters.getNextAsDouble();
        this.ProbR = parameters.getNextAsDouble();
        this.ProbD = parameters.getNextAsDouble();
        this.numberOfClass = this.trainingDataSet.getPosibleValuesOfOutput().size();
        this.numberOfPrototypes = this.getSetSizeFromPercentage(this.SwarmSize);
        System.out.print("\nIsaac dice:  " + this.k + " Swar= " + this.SwarmSize + " ProbD=  " + this.ProbD + " Maxiter= " + this.MaxIter + " Winertia=  " + this.Winertia + "\n");
    }

    protected double fitness(PrototypeSet Population, int particleIndex) {
        double fitness = 0.0;
        PrototypeSet g = new PrototypeSet();
        PrototypeSet b = new PrototypeSet();
        for (int i = 0; i < this.trainingDataSet.size(); ++i) {
            Prototype nearest = Population.nearestTo((Prototype)this.trainingDataSet.get(i));
            if (!nearest.equalsInputs((Prototype)Population.get(particleIndex))) continue;
            if (((Prototype)this.trainingDataSet.get(i)).getOutput(0) == ((Prototype)Population.get(particleIndex)).getOutput(0)) {
                g.add(this.trainingDataSet.get(i));
                continue;
            }
            b.add(this.trainingDataSet.get(i));
        }
        if (g.size() == 0 && b.size() == 0) {
            fitness = 0.0;
        } else {
            int j;
            double Gf = 0.0;
            double Bf = 0.0;
            for (j = 0; j < g.size(); ++j) {
                Gf += 1.0 / (1.0 + Distance.d((Prototype)g.get(j), (Prototype)Population.get(particleIndex)));
            }
            for (j = 0; j < b.size(); ++j) {
                Bf += 1.0 / (1.0 + Distance.d((Prototype)b.get(j), (Prototype)Population.get(particleIndex)));
            }
            fitness = b.size() == 0 ? Gf / (double)this.trainingDataSet.size() + 2.0 : (Gf - Bf) / (Gf + Bf) + 1.0;
        }
        return fitness;
    }

    @Override
    public PrototypeSet reduceSet() {
        PrototypeSet result = new PrototypeSet();
        PrototypeSet Population = new PrototypeSet();
        PrototypeSet bestPosition = new PrototypeSet();
        PrototypeSet AttractionCenter = new PrototypeSet();
        PrototypeSet RepulsionCenter = new PrototypeSet();
        PrototypeSet nextPosition = new PrototypeSet();
        PrototypeSet nominalPopulation = new PrototypeSet();
        PrototypeSet Velocities = new PrototypeSet();
        ArrayList<Double> LocalFitness = new ArrayList<Double>();
        ArrayList bestLocalFitness = new ArrayList();
        ArrayList<Double> SocialFactor = new ArrayList<Double>();
        double chance_reproduction = 0.0;
        double chance_deletion = 0.0;
        System.out.print("\nThe algorithm is starting...\n Computing...\n");
        System.out.println("Number of prototypes, result set = " + this.numberOfPrototypes + "\n");
        System.out.println("Reduction %, result set = " + (this.trainingDataSet.size() - this.numberOfPrototypes) * 100 / this.trainingDataSet.size() + "\n");
        PrototypeSet[] clases = new PrototypeSet[this.numberOfClass];
        for (int i = 0; i < this.numberOfClass; ++i) {
            clases[i] = new PrototypeSet(this.trainingDataSet.getFromClass(i));
        }
        int eachClass = this.numberOfPrototypes / this.numberOfClass + 1;
        System.out.println("De cada clase " + eachClass);
        for (int j = 0; j < this.numberOfClass; ++j) {
            for (int i = 0; i < eachClass; ++i) {
                if (clases[j].size() == 0) continue;
                Prototype aux = new Prototype(clases[j].getRandom());
                Population.add(aux);
            }
        }
        bestPosition = new PrototypeSet(Population);
        this.numberOfPrototypes = Population.size();
        nominalPopulation = new PrototypeSet();
        nominalPopulation.formatear(Population);
        double success_rate = AMPSOGenerator.accuracy(nominalPopulation, this.trainingDataSet);
        for (int i = 0; i < this.numberOfPrototypes; ++i) {
            LocalFitness.add(i, this.fitness(Population, i));
            double value = 1.0 / ((Double)LocalFitness.get(i) + 1.0);
            SocialFactor.add(i, value);
        }
        bestLocalFitness = (ArrayList)LocalFitness.clone();
        double[] output = new double[1];
        Arrays.fill(output, 0.0);
        for (int i = 0; i < this.numberOfPrototypes; ++i) {
            double[] inputs = new double[((Prototype)this.trainingDataSet.get(0)).numberOfInputs()];
            for (int j = 0; j < inputs.length; ++j) {
                inputs[j] = RandomGenerator.Randdouble(-this.VMax, this.VMax);
            }
            Prototype aux = new Prototype(inputs, output);
            Velocities.add(i, aux);
        }
        AttractionCenter = Population.clone();
        RepulsionCenter = Population.clone();
        for (int iter = 0; iter < this.MaxIter && success_rate != 100.0; ++iter) {
            Prototype clasificado;
            int j;
            PrototypeSet patterns;
            int i;
            double aleatorio;
            int i2;
            boolean[] clean = new boolean[this.numberOfPrototypes];
            boolean[] reprod = new boolean[this.numberOfPrototypes];
            Arrays.fill(clean, false);
            Arrays.fill(reprod, false);
            for (i2 = 0; i2 < this.numberOfPrototypes; ++i2) {
                aleatorio = RandomGenerator.Randdouble(0.0, 1.0);
                if ((Double)LocalFitness.get(i2) == 0.0) {
                    chance_deletion = this.ProbD * (double)iter / (double)this.MaxIter;
                    if (!(aleatorio < chance_deletion)) continue;
                    clean[i2] = true;
                    continue;
                }
                chance_reproduction = this.ProbR / ((Double)LocalFitness.get(i2) * 100.0);
                if (!(aleatorio < chance_reproduction)) continue;
                reprod[i2] = true;
            }
            for (i2 = 0; i2 < this.numberOfPrototypes; ++i2) {
                if (clean[i2]) {
                    Population.remove(i2);
                    --this.numberOfPrototypes;
                    continue;
                }
                if (!reprod[i2]) continue;
                Prototype child = (Prototype)Population.get(i2);
                Population.add(child);
                bestPosition.add(Population.size() - 1, child);
                bestLocalFitness.add(Population.size() - 1, LocalFitness.get(i2));
                double[] inputs = new double[((Prototype)this.trainingDataSet.get(0)).numberOfInputs()];
                Arrays.fill(inputs, RandomGenerator.Randdouble(-this.VMax, this.VMax));
                Prototype aux = new Prototype(inputs, output);
                Velocities.add(Population.size() - 1, aux);
                AttractionCenter.add(Population.size() - 1, child);
                RepulsionCenter.add(Population.size() - 1, child);
                LocalFitness.add(Population.size() - 1, (Double)LocalFitness.get(i2));
                SocialFactor.add(Population.size() - 1, (Double)SocialFactor.get(i2));
            }
            this.numberOfPrototypes = Population.size();
            boolean[][] competing = new boolean[this.numberOfClass][];
            boolean[][] nonCompeting = new boolean[this.numberOfClass][];
            for (i = 0; i < this.numberOfClass; ++i) {
                competing[i] = new boolean[this.numberOfPrototypes];
                nonCompeting[i] = new boolean[this.numberOfPrototypes];
            }
            for (i = 0; i < this.numberOfPrototypes; ++i) {
                ((Prototype)Population.get(i)).setIndex(i);
            }
            for (i = 0; i < this.numberOfClass; ++i) {
                Arrays.fill(competing[i], false);
                patterns = this.trainingDataSet.getFromClass(i);
                for (j = 0; j < patterns.size(); ++j) {
                    clasificado = Population.nearestTo((Prototype)patterns.get(j));
                    if (clasificado.getOutput(0) != (double)i) continue;
                    competing[i][clasificado.getIndex()] = true;
                }
            }
            for (i = 0; i < this.numberOfClass; ++i) {
                Arrays.fill(nonCompeting[i], false);
                patterns = this.trainingDataSet.getAllDifferentFromClass(i);
                for (j = 0; j < patterns.size(); ++j) {
                    clasificado = Population.nearestTo((Prototype)patterns.get(j));
                    if (clasificado.getOutput(0) != (double)i) continue;
                    nonCompeting[i][clasificado.getIndex()] = true;
                }
            }
            nextPosition = new PrototypeSet(Population);
            for (i = 0; i < this.numberOfPrototypes; ++i) {
                double valor;
                int particleClass = (int)((Prototype)Population.get(i)).getOutput(0);
                double value2 = this.fitness(Population, i);
                LocalFitness.set(i, value2);
                if (value2 > (Double)bestLocalFitness.get(i)) {
                    bestLocalFitness.set(i, value2);
                }
                double value = 1.0 / ((Double)bestLocalFitness.get(i) + 1.0);
                SocialFactor.set(i, value);
                double ClosestNonCompeting = Double.MAX_VALUE;
                int CNCindex = i;
                double ClosestCompeting = Double.MAX_VALUE;
                int CCindex = i;
                double dist = 0.0;
                for (int k = 0; k < this.numberOfPrototypes; ++k) {
                    if (i == k) continue;
                    if (nonCompeting[particleClass][k] && (dist = Distance.d((Prototype)Population.get(i), (Prototype)Population.get(k))) < ClosestNonCompeting) {
                        ClosestNonCompeting = dist;
                        CNCindex = k;
                    }
                    if (!competing[particleClass][k] || !((dist = Distance.d((Prototype)Population.get(i), (Prototype)Population.get(k))) < ClosestCompeting)) continue;
                    ClosestCompeting = dist;
                    CCindex = k;
                }
                AttractionCenter.set(i, Population.get(CNCindex));
                RepulsionCenter.set(i, Population.get(CCindex));
                Prototype speed = new Prototype((Prototype)Velocities.get(i));
                speed = speed.mul(this.Winertia);
                aleatorio = RandomGenerator.Randdouble(0.0, 1.0);
                Prototype RestaBestParticle = ((Prototype)bestPosition.get(i)).sub((Prototype)Population.get(i));
                RestaBestParticle = RestaBestParticle.mul(aleatorio * this.C1);
                speed = speed.add(RestaBestParticle);
                Prototype RestaAttraction = ((Prototype)AttractionCenter.get(i)).sub((Prototype)Population.get(i));
                aleatorio = RandomGenerator.Randdouble(0.0, 1.0);
                Prototype term2 = new Prototype(RestaAttraction.numberOfInputs(), 1);
                for (int r = 0; r < RestaAttraction.numberOfInputs(); ++r) {
                    valor = this.C2 * aleatorio * (Double)SocialFactor.get(i);
                    if (RestaAttraction.getInput(r) < 0.0) {
                        valor *= -1.0;
                    }
                    term2.setInput(r, valor);
                }
                speed = speed.add(term2);
                aleatorio = RandomGenerator.Randdouble(0.0, 1.0);
                Prototype RestaRepelled = ((Prototype)Population.get(i)).sub((Prototype)RepulsionCenter.get(i));
                Prototype term3 = new Prototype(RestaAttraction.numberOfInputs(), 1);
                for (int r = 0; r < RestaRepelled.numberOfInputs(); ++r) {
                    valor = this.C3 * aleatorio * (Double)SocialFactor.get(i);
                    if (RestaRepelled.getInput(r) < 0.0) {
                        valor *= -1.0;
                    }
                    term3.setInput(r, valor);
                }
                speed = speed.add(term3);
                speed = speed.mul(this.Xfactor);
                for (int m = 0; m < speed.numberOfInputs(); ++m) {
                    if (speed.getInput(m) < -this.VMax) {
                        speed.setInput(m, -this.VMax);
                        continue;
                    }
                    if (!(speed.getInput(m) > this.VMax)) continue;
                    speed.setInput(m, this.VMax);
                }
                Velocities.set(i, speed);
                Prototype incre = (Prototype)Population.get(i);
                incre = incre.add(speed);
                incre.applyThresholds();
                nextPosition.set(i, incre);
            }
            Population = new PrototypeSet(nextPosition);
            nominalPopulation = new PrototypeSet();
            nominalPopulation.formatear(Population);
            double accuracy = AMPSOGenerator.accuracy(nominalPopulation, this.trainingDataSet);
            if (!(accuracy > success_rate)) continue;
            success_rate = accuracy;
            bestPosition = new PrototypeSet(Population);
        }
        nominalPopulation = new PrototypeSet();
        nominalPopulation.formatear(bestPosition);
        result = new PrototypeSet(nominalPopulation);
        boolean[] marcas = new boolean[result.size()];
        Arrays.fill(marcas, true);
        double accuracyInic = KNN.classficationAccuracy(result, this.trainingDataSet);
        for (int i = 0; i < result.size(); ++i) {
            marcas[i] = false;
            PrototypeSet leaveOneOut = result.without((Prototype)result.get(i));
            double accuracy = KNN.classficationAccuracy(result, this.trainingDataSet);
            if (!(accuracy > accuracyInic)) continue;
            marcas[i] = true;
        }
        PrototypeSet clean = new PrototypeSet();
        for (int i = 0; i < marcas.length; ++i) {
            if (marcas[i]) continue;
            clean.add(result.get(i));
        }
        return clean;
    }

    public static void main(String[] args) {
        Parameters.setUse("PSO", "<seed> <Number of neighbors>\n<Swarm size>\n<MaxIter>\n<C1>\n<C2>\n<C3>\n<VMax>\n<Winertia>\n<Xfactor>\n<ProbR>\n<ProbD>");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        AMPSOGenerator.setSeed(seed);
        int k = Parameters.assertExtendedArgAsInt(args, 3, "number of neighbors", 1.0, 2.147483647E9);
        int swarm = Parameters.assertExtendedArgAsInt(args, 4, "swarm size", 1.0, 2.147483647E9);
        int iter = Parameters.assertExtendedArgAsInt(args, 5, "max iter", 1.0, 2.147483647E9);
        double c1 = Parameters.assertExtendedArgAsInt(args, 6, "c1", 1.0, Double.MAX_VALUE);
        double c2 = Parameters.assertExtendedArgAsInt(args, 7, "c2", 1.0, Double.MAX_VALUE);
        double c3 = Parameters.assertExtendedArgAsInt(args, 8, "c3", 1.0, Double.MAX_VALUE);
        double vmax = Parameters.assertExtendedArgAsInt(args, 9, "vmax", 1.0, Double.MAX_VALUE);
        double winertia = Parameters.assertExtendedArgAsInt(args, 10, "winertia", 1.0, Double.MAX_VALUE);
        double xfactor = Parameters.assertExtendedArgAsInt(args, 11, "xfactor", 1.0, Double.MAX_VALUE);
        double probr = Parameters.assertExtendedArgAsInt(args, 11, "probr", 1.0, Double.MAX_VALUE);
        double probd = Parameters.assertExtendedArgAsInt(args, 11, "probd", 1.0, Double.MAX_VALUE);
        AMPSOGenerator generator = new AMPSOGenerator(training, k, swarm, iter, c1, c2, c3, vmax, winertia, xfactor, probr, probd);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

