/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.StageElement;
import com.hp.hpl.jena.mem.HashCommon;
import com.hp.hpl.jena.mem.MatchOrBind;
import com.hp.hpl.jena.mem.TripleBunch;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.ConcurrentModificationException;

public class HashedTripleBunch
extends HashCommon
implements TripleBunch {
    protected int changes;

    public HashedTripleBunch(TripleBunch b) {
        super(HashedTripleBunch.nextSize((int)((double)b.size() / 0.5)));
        ExtendedIterator it = b.iterator();
        while (it.hasNext()) {
            this.add((Triple)it.next());
        }
        this.changes = 0;
    }

    public boolean contains(Triple t) {
        return this.findSlot(t) < 0;
    }

    protected int findSlotBySameValueAs(Triple key) {
        int index = this.initialIndexFor(key);
        Object current;
        while ((current = this.keys[index]) != null) {
            if (key.matches((Triple)current)) {
                return ~index;
            }
            if (--index >= 0) continue;
            index += this.capacity;
        }
        return index;
    }

    public boolean containsBySameValueAs(Triple t) {
        return this.findSlotBySameValueAs(t) < 0;
    }

    public int size() {
        return this.size;
    }

    public int currentCapacity() {
        return this.capacity;
    }

    public void add(Triple t) {
        this.keys[this.findSlot((Object)t)] = t;
        ++this.changes;
        if (++this.size > this.threshold) {
            this.grow();
        }
    }

    protected void grow() {
        Object[] oldContents = this.keys;
        int oldCapacity = this.capacity;
        this.growCapacityAndThreshold();
        this.keys = new Triple[this.capacity];
        Triple[] newKeys = this.keys;
        for (int i = 0; i < oldCapacity; ++i) {
            Object t = oldContents[i];
            if (t == null) continue;
            newKeys[this.findSlot((Object)t)] = t;
        }
    }

    public void remove(Triple t) {
        this.removeFrom(~this.findSlot(t));
        --this.size;
        ++this.changes;
    }

    public ExtendedIterator iterator() {
        return new NiceIterator(){
            int index;
            int lastIndex;
            final int initialChanges;
            Object toRemove;
            Object current;
            {
                this.index = HashedTripleBunch.this.capacity;
                this.lastIndex = -1;
                this.initialChanges = HashedTripleBunch.this.changes;
                this.toRemove = null;
                this.current = null;
            }

            public boolean hasNext() {
                if (HashedTripleBunch.this.changes > this.initialChanges) {
                    throw new ConcurrentModificationException();
                }
                if (this.current == null) {
                    while (this.index > 0 && (this.current = HashedTripleBunch.this.keys[--this.index]) == null) {
                    }
                }
                return this.current != null;
            }

            public Object next() {
                if (HashedTripleBunch.this.changes > this.initialChanges) {
                    throw new ConcurrentModificationException();
                }
                if (this.current == null && !this.hasNext()) {
                    this.noElements("HashedTripleBunch iterator empty");
                }
                Object answer = this.toRemove = this.current;
                this.lastIndex = this.index;
                this.current = null;
                return answer;
            }

            public void remove() {
                if (HashedTripleBunch.this.keys[this.lastIndex] != this.toRemove) {
                    throw new ConcurrentModificationException();
                }
                HashedTripleBunch.this.removeFrom(this.lastIndex);
                this.index = this.lastIndex;
                this.current = HashedTripleBunch.this.keys[this.index];
                this.lastIndex = -1;
            }
        };
    }

    public void app(Domain d, StageElement next, MatchOrBind s) {
        int i = this.capacity;
        int initialChanges = this.changes;
        while (i > 0) {
            Object t;
            if (this.changes > initialChanges) {
                throw new ConcurrentModificationException();
            }
            if ((t = this.keys[--i]) == null || !s.matches((Triple)t)) continue;
            next.run(d);
        }
    }
}

