/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Utils;

public class AttributeExpression
implements Serializable {
    static final long serialVersionUID = 402130123261736245L;
    private Stack m_operatorStack = new Stack();
    private static final String OPERATORS = "+-*/()^lbcesfhrtn";
    private static final String UNARY_FUNCTIONS = "lbcesfhrtn";
    private String m_originalInfix;
    private Vector m_postFixExpVector;
    private boolean m_signMod = false;
    private String m_previousTok = "";

    private void handleOperand(String string) throws Exception {
        if (string.indexOf(97) != -1) {
            this.m_postFixExpVector.addElement(new AttributeOperand(string, this.m_signMod));
        } else {
            try {
                this.m_postFixExpVector.addElement(new NumericOperand(string, this.m_signMod));
            }
            catch (NumberFormatException numberFormatException) {
                throw new Exception("Trouble parsing numeric constant");
            }
        }
        this.m_signMod = false;
    }

    private void handleOperator(String string) throws Exception {
        boolean bl = true;
        char c = string.charAt(0);
        if (c == ')') {
            String string2 = " ";
            do {
                if ((string2 = (String)this.m_operatorStack.pop()).charAt(0) == '(') continue;
                this.m_postFixExpVector.addElement(new Operator(string2.charAt(0)));
            } while (string2.charAt(0) != '(');
        } else {
            int n = this.infixPriority(string.charAt(0));
            while (!this.m_operatorStack.empty() && this.stackPriority(((String)this.m_operatorStack.peek()).charAt(0)) >= n) {
                if (this.m_previousTok.length() == 1 && this.isOperator(this.m_previousTok.charAt(0)) && this.m_previousTok.charAt(0) != ')') {
                    this.m_signMod = string.charAt(0) == '-';
                    bl = false;
                    break;
                }
                String string3 = (String)this.m_operatorStack.pop();
                this.m_postFixExpVector.addElement(new Operator(string3.charAt(0)));
            }
            if (this.m_postFixExpVector.size() == 0 && string.charAt(0) == '-') {
                this.m_signMod = true;
                bl = false;
            }
            if (bl) {
                this.m_operatorStack.push(string);
            }
        }
    }

    public void convertInfixToPostfix(String string) throws Exception {
        String string2;
        this.m_originalInfix = string;
        string = Utils.removeSubstring(string, " ");
        string = Utils.replaceSubstring(string, "log", "l");
        string = Utils.replaceSubstring(string, "abs", "b");
        string = Utils.replaceSubstring(string, "cos", "c");
        string = Utils.replaceSubstring(string, "exp", "e");
        string = Utils.replaceSubstring(string, "sqrt", "s");
        string = Utils.replaceSubstring(string, "floor", "f");
        string = Utils.replaceSubstring(string, "ceil", "h");
        string = Utils.replaceSubstring(string, "rint", "r");
        string = Utils.replaceSubstring(string, "tan", "t");
        string = Utils.replaceSubstring(string, "sin", "n");
        StringTokenizer stringTokenizer = new StringTokenizer(string, OPERATORS, true);
        this.m_postFixExpVector = new Vector();
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.length() > 1) {
                this.handleOperand(string2);
            } else if (this.isOperator(string2.charAt(0))) {
                this.handleOperator(string2);
            } else {
                this.handleOperand(string2);
            }
            this.m_previousTok = string2;
        }
        while (!this.m_operatorStack.empty()) {
            string2 = (String)this.m_operatorStack.pop();
            if (string2.charAt(0) == '(' || string2.charAt(0) == ')') {
                throw new Exception("Mis-matched parenthesis!");
            }
            this.m_postFixExpVector.addElement(new Operator(string2.charAt(0)));
        }
    }

    public double evaluateExpression(Instance instance) throws Exception {
        double[] dArray = new double[instance.numAttributes() + 1];
        for (int i = 0; i < instance.numAttributes(); ++i) {
            dArray[i] = instance.isMissing(i) ? Instance.missingValue() : instance.value(i);
        }
        this.evaluateExpression(dArray);
        return dArray[dArray.length - 1];
    }

    public void evaluateExpression(double[] dArray) throws Exception {
        Stack<Double> stack = new Stack<Double>();
        for (int i = 0; i < this.m_postFixExpVector.size(); ++i) {
            Object e = this.m_postFixExpVector.elementAt(i);
            if (e instanceof NumericOperand) {
                stack.push(new Double(((NumericOperand)e).m_numericConst));
                continue;
            }
            if (e instanceof AttributeOperand) {
                double d = dArray[((AttributeOperand)e).m_attributeIndex];
                if (d == Instance.missingValue()) {
                    dArray[dArray.length - 1] = Instance.missingValue();
                    break;
                }
                if (((AttributeOperand)e).m_negative) {
                    d = -d;
                }
                stack.push(new Double(d));
                continue;
            }
            if (e instanceof Operator) {
                double d;
                double d2;
                char c = ((Operator)e).m_operator;
                if (this.isUnaryFunction(c)) {
                    d2 = (Double)stack.pop();
                    d = ((Operator)e).applyFunction(d2);
                    stack.push(new Double(d));
                    continue;
                }
                d2 = (Double)stack.pop();
                d = (Double)stack.pop();
                double d3 = ((Operator)e).applyOperator(d, d2);
                stack.push(new Double(d3));
                continue;
            }
            throw new Exception("Unknown object in postfix vector!");
        }
        if (stack.size() != 1) {
            throw new Exception("Problem applying function");
        }
        Double d = (Double)stack.pop();
        dArray[dArray.length - 1] = d.isNaN() || d.isInfinite() ? Instance.missingValue() : d;
    }

    private boolean isOperator(char c) {
        return OPERATORS.indexOf(c) != -1;
    }

    private boolean isUnaryFunction(char c) {
        return UNARY_FUNCTIONS.indexOf(c) != -1;
    }

    private int infixPriority(char c) {
        switch (c) {
            case 'b': 
            case 'c': 
            case 'e': 
            case 'f': 
            case 'h': 
            case 'l': 
            case 'n': 
            case 'r': 
            case 's': 
            case 't': {
                return 3;
            }
            case '^': {
                return 2;
            }
            case '*': {
                return 2;
            }
            case '/': {
                return 2;
            }
            case '+': {
                return 1;
            }
            case '-': {
                return 1;
            }
            case '(': {
                return 4;
            }
            case ')': {
                return 0;
            }
        }
        throw new IllegalArgumentException("Unrecognized operator:" + c);
    }

    private int stackPriority(char c) {
        switch (c) {
            case 'b': 
            case 'c': 
            case 'e': 
            case 'f': 
            case 'h': 
            case 'l': 
            case 'n': 
            case 'r': 
            case 's': 
            case 't': {
                return 3;
            }
            case '^': {
                return 2;
            }
            case '*': {
                return 2;
            }
            case '/': {
                return 2;
            }
            case '+': {
                return 1;
            }
            case '-': {
                return 1;
            }
            case '(': {
                return 0;
            }
            case ')': {
                return -1;
            }
        }
        throw new IllegalArgumentException("Unrecognized operator:" + c);
    }

    public String getPostFixExpression() {
        return this.m_postFixExpVector.toString();
    }

    public String toString() {
        return this.m_originalInfix;
    }

    private class Operator
    implements Serializable {
        static final long serialVersionUID = -2760353522666004638L;
        protected char m_operator;

        public Operator(char c) {
            if (!AttributeExpression.this.isOperator(c)) {
                throw new IllegalArgumentException("Unrecognized operator:" + c);
            }
            this.m_operator = c;
        }

        protected double applyOperator(double d, double d2) {
            switch (this.m_operator) {
                case '+': {
                    return d + d2;
                }
                case '-': {
                    return d - d2;
                }
                case '*': {
                    return d * d2;
                }
                case '/': {
                    return d / d2;
                }
                case '^': {
                    return Math.pow(d, d2);
                }
            }
            return Double.NaN;
        }

        protected double applyFunction(double d) {
            switch (this.m_operator) {
                case 'l': {
                    return Math.log(d);
                }
                case 'b': {
                    return Math.abs(d);
                }
                case 'c': {
                    return Math.cos(d);
                }
                case 'e': {
                    return Math.exp(d);
                }
                case 's': {
                    return Math.sqrt(d);
                }
                case 'f': {
                    return Math.floor(d);
                }
                case 'h': {
                    return Math.ceil(d);
                }
                case 'r': {
                    return Math.rint(d);
                }
                case 't': {
                    return Math.tan(d);
                }
                case 'n': {
                    return Math.sin(d);
                }
            }
            return Double.NaN;
        }

        public String toString() {
            return "" + this.m_operator;
        }
    }

    private class NumericOperand
    implements Serializable {
        static final long serialVersionUID = 9037007836243662859L;
        protected double m_numericConst;

        public NumericOperand(String string, boolean bl) throws Exception {
            this.m_numericConst = Double.valueOf(string);
            if (bl) {
                this.m_numericConst *= -1.0;
            }
        }

        public String toString() {
            return "" + this.m_numericConst;
        }
    }

    private class AttributeOperand
    implements Serializable {
        static final long serialVersionUID = -7674280127286031105L;
        protected int m_attributeIndex;
        protected boolean m_negative;

        public AttributeOperand(String string, boolean bl) throws Exception {
            this.m_attributeIndex = Integer.parseInt(string.substring(1)) - 1;
            this.m_negative = bl;
        }

        public String toString() {
            String string = "";
            if (this.m_negative) {
                string = string + '-';
            }
            return string + "a" + (this.m_attributeIndex + 1);
        }
    }
}

