/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.calendars;

import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.timeseries.calendars.DefaultGregorianCalendarProvider;
import ec.tstoolkit.timeseries.calendars.GregorianCalendarManager;
import ec.tstoolkit.timeseries.calendars.IGregorianCalendarProvider;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.utilities.WeightedItem;
import ec.tstoolkit.utilities.WeightedItems;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class CompositeGregorianCalendarProvider
extends WeightedItems<String>
implements IGregorianCalendarProvider {
    private final WeakReference<GregorianCalendarManager> calendarManager;

    public CompositeGregorianCalendarProvider(GregorianCalendarManager calendarManager) {
        this.calendarManager = new WeakReference<GregorianCalendarManager>(calendarManager);
    }

    public CompositeGregorianCalendarProvider() {
        this.calendarManager = new WeakReference<GregorianCalendarManager>(ProcessingContext.getActiveContext().getGregorianCalendars());
    }

    @Override
    @Deprecated
    public void calendarData(TradingDaysType dtype, TsDomain domain, List<DataBlock> buffer, int start) {
        this.calendarData(dtype, domain, buffer.subList(start, start + this.count(dtype)));
    }

    @Override
    public void calendarData(TradingDaysType dtype, TsDomain domain, List<DataBlock> buffer) {
        GregorianCalendarManager mgr = (GregorianCalendarManager)this.calendarManager.get();
        if (mgr == null) {
            return;
        }
        int nvars = this.count(dtype);
        if (nvars == 0) {
            return;
        }
        int n = domain.getLength();
        Matrix S = new Matrix(n, nvars);
        Matrix M = new Matrix(n, nvars);
        ArrayList<DataBlock> cols = new ArrayList<DataBlock>();
        for (int i = 0; i < nvars; ++i) {
            cols.add(M.column(i));
        }
        for (WeightedItem item : this.items()) {
            if (item.weight == 0.0) continue;
            ((IGregorianCalendarProvider)mgr.get((String)item.item)).calendarData(dtype, domain, cols);
            S.add(M.times(item.weight));
        }
        DataBlockIterator scols = S.columns();
        DataBlock scur = scols.getData();
        do {
            buffer.get(scols.getPosition()).copy(scur);
        } while (scols.next());
    }

    @Override
    public List<DataBlock> holidays(TradingDaysType dtype, TsDomain domain) {
        GregorianCalendarManager mgr = (GregorianCalendarManager)this.calendarManager.get();
        if (mgr == null) {
            return null;
        }
        int nvars = this.count(dtype);
        if (nvars == 0) {
            return null;
        }
        int n = domain.getLength();
        Matrix S = new Matrix(n, nvars);
        ArrayList<DataBlock> cols = new ArrayList<DataBlock>();
        for (int i = 0; i < nvars; ++i) {
            cols.add(S.column(i));
        }
        for (WeightedItem item : this.items()) {
            if (item.weight == 0.0) continue;
            List<DataBlock> hcur = ((IGregorianCalendarProvider)mgr.get((String)item.item)).holidays(dtype, domain);
            for (int j = 0; j < nvars; ++j) {
                ((DataBlock)cols.get(j)).addAY(item.weight, hcur.get(j));
            }
        }
        return cols;
    }

    @Override
    public int count(TradingDaysType dtype) {
        return dtype.getVariablesCount();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof CompositeGregorianCalendarProvider && this.equals((CompositeGregorianCalendarProvider)obj);
    }

    private boolean equals(CompositeGregorianCalendarProvider other) {
        return WeightedItems.equals(this, other);
    }

    @Override
    public String getDescription(TradingDaysType dtype, int idx) {
        return DefaultGregorianCalendarProvider.description(dtype, idx);
    }

    @Override
    public CompositeGregorianCalendarProvider withCalendarManager(GregorianCalendarManager manager) {
        CompositeGregorianCalendarProvider result = new CompositeGregorianCalendarProvider(manager);
        this.items().stream().map(CompositeGregorianCalendarProvider::cloneItem).forEach(result::add);
        return result;
    }

    private static WeightedItem<String> cloneItem(WeightedItem<String> o) {
        return new WeightedItem<String>((String)o.item, o.weight);
    }
}

