/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf.multivariate;

import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.ssf.SsfData;
import ec.tstoolkit.ssf.multivariate.IMSsfData;

public class M2uData
extends SsfData {
    static M2uData create(IMSsfData data) {
        int nvars = data.getVarsCount();
        int n = data.count(0);
        for (int j = 1; j < nvars; ++j) {
            if (data.count(j) == n) continue;
            return null;
        }
        Matrix m = new Matrix(nvars, n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < nvars; ++j) {
                m.set(i, j, data.get(i, j));
            }
        }
        return new M2uData(m, data.getInitialState());
    }

    public M2uData(Matrix data, double[] a0) {
        super(data.internalStorage(), a0);
    }

    public M2uData(double[][] data, double[] a0) {
        super(M2uData.merge(data), a0);
    }

    private static double[] merge(double[][] data) {
        Matrix m = new Matrix(data.length, data[0].length);
        for (int i = 0; i < data.length; ++i) {
            m.row(i).copyFrom(data[i], 0);
        }
        return m.internalStorage();
    }
}

