/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.sarima.estimation;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IDataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.linearfilters.Utilities;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.maths.realfunctions.ParamValidation;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.sarima.estimation.DefaultSarimaMapping;

public class SarimaMapping
implements IParametricMapping<SarimaModel> {
    static final double RTOL = 1.1;
    static final double REPS = 0.01;
    static final double MAX = 0.99999;
    static final double RMAX = 0.985;
    public static final double STEP1 = Math.sqrt(1.19E-7);
    public static final double STEP2 = 1.0E-6;
    public static final double STEP3 = Math.sqrt(2.220446E-16);
    private double rmax_ = 1.0;
    private boolean m_all;
    public final SarimaSpecification spec;
    private final double eps_;

    private static boolean checkStability(double d) {
        return Math.abs(d) < 1.0;
    }

    private static boolean checkStability(double a, double b) {
        double ro = b * b - 4.0 * a;
        if (ro < 0.0) {
            return Math.abs(a) < 1.0;
        }
        double sro = Math.sqrt(ro);
        double r = (-b + sro) / (2.0 * a);
        if (Math.abs(1.0 / r) >= 1.0) {
            return false;
        }
        r = (-b - sro) / (2.0 * a);
        return Math.abs(1.0 / r) < 1.0;
    }

    static boolean checkStability(IReadDataBlock c, int start, int nc) {
        while (nc > 0 && c.get(start + nc - 1) == 0.0) {
            --nc;
        }
        if (nc == 0) {
            return true;
        }
        if (nc == 1) {
            return SarimaMapping.checkStability(c.get(start));
        }
        if (nc == 2) {
            return SarimaMapping.checkStability(c.get(start + 1), c.get(start));
        }
        return Utilities.checkStability(c.rextract(start, nc));
    }

    private static boolean stabilize(boolean all, boolean model, SarimaSpecification spec, IDataBlock p, double rmax) {
        boolean rslt = false;
        if (spec.getP() > 0 && SarimaMapping.stabilize(model, p, 0, spec.getP(), rmax)) {
            rslt = true;
        }
        if (spec.getBP() > 0 && SarimaMapping.stabilize(model, p, spec.getP(), spec.getBP(), rmax)) {
            rslt = true;
        }
        if (all && spec.getQ() > 0 && SarimaMapping.stabilize(model, p, spec.getP() + spec.getBP(), spec.getQ(), rmax)) {
            rslt = true;
        }
        if (all && spec.getBQ() > 0 && SarimaMapping.stabilize(model, p, spec.getP() + spec.getBP() + spec.getQ(), spec.getBQ(), rmax)) {
            rslt = true;
        }
        return rslt;
    }

    private static boolean stabilize(boolean model, IDataBlock c, int start, int nc, double rmax) {
        Polynomial sp;
        if (nc == 0) {
            return false;
        }
        if (SarimaMapping.checkStability(c, start, nc)) {
            return false;
        }
        if (nc == 1) {
            double c0 = c.get(start);
            double cabs = Math.abs(c0);
            if (!model && rmax < 1.0 && Math.abs(cabs - 1.0) <= 0.01) {
                c.set(start, c0 > 0.0 ? rmax : -rmax);
                return true;
            }
            if (cabs > 1.0) {
                c.set(start, 1.0 / c0);
                return true;
            }
            return false;
        }
        double[] ctmp = new double[nc + 1];
        ctmp[0] = 1.0;
        for (int i = 0; i < nc; ++i) {
            ctmp[1 + i] = c.get(start + i);
        }
        Polynomial p = Polynomial.of(ctmp);
        if (p != (sp = SarimaMapping.stabilize(model, p, rmax))) {
            for (int i = 0; i < nc; ++i) {
                c.set(start + i, sp.get(1 + i));
            }
            return true;
        }
        return false;
    }

    private static Polynomial stabilize(boolean model, Polynomial p, double rmax) {
        if (p == null) {
            return null;
        }
        Complex[] roots = p.roots();
        boolean changed = false;
        for (int i = 0; i < roots.length; ++i) {
            Complex root = roots[i];
            double n = 1.0 / roots[i].abs();
            if (!model && rmax < 1.0 && Math.abs(n - 1.0) <= 0.01) {
                roots[i] = root.times(n / rmax);
                changed = true;
                continue;
            }
            if (!(n > 1.0)) continue;
            roots[i] = root.inv();
            changed = true;
        }
        if (!changed) {
            return p;
        }
        Polynomial ptmp = Polynomial.fromComplexRoots(roots);
        ptmp = ptmp.divide(ptmp.get(0));
        return ptmp;
    }

    public static boolean stabilize(SarimaModel m) {
        DataBlock np = new DataBlock(m.getParameters());
        if (SarimaMapping.stabilize(true, true, m.getSpecification(), np, 0.985)) {
            m.setParameters(np);
            return true;
        }
        return false;
    }

    public double getRmax() {
        return this.rmax_;
    }

    public void setRmax(double value) {
        this.rmax_ = value;
    }

    public SarimaMapping(SarimaSpecification spec, boolean all) {
        this.spec = spec;
        this.m_all = all;
        this.eps_ = STEP3;
    }

    public SarimaMapping(SarimaSpecification spec, double eps, boolean all) {
        this.spec = spec;
        this.m_all = all;
        this.eps_ = eps;
    }

    public void checkAll(boolean value) {
        this.m_all = value;
    }

    @Override
    public boolean checkBoundaries(IReadDataBlock p) {
        if (this.spec.getP() > 0 && !SarimaMapping.checkStability(p, 0, this.spec.getP())) {
            return false;
        }
        if (this.spec.getBP() > 0 && !SarimaMapping.checkStability(p, this.spec.getP(), this.spec.getBP())) {
            return false;
        }
        if (this.spec.getQ() > 0 && this.m_all && !SarimaMapping.checkStability(p, this.spec.getP() + this.spec.getBP(), this.spec.getQ())) {
            return false;
        }
        return this.spec.getBQ() <= 0 || !this.m_all || SarimaMapping.checkStability(p, this.spec.getP() + this.spec.getBP() + this.spec.getQ(), this.spec.getBQ());
    }

    @Override
    public double epsilon(IReadDataBlock inparams, int idx) {
        double p = inparams.get(idx);
        if (p < 0.0) {
            return this.eps_ * Math.max(1.0, -p);
        }
        return -this.eps_ * Math.max(1.0, p);
    }

    @Override
    public int getDim() {
        return this.spec.getParametersCount();
    }

    public boolean isCheckingAll() {
        return this.m_all;
    }

    @Override
    public double lbound(int idx) {
        if (this.spec.getP() > 0) {
            if (idx < this.spec.getP()) {
                if (this.spec.getP() == 1) {
                    return -0.99999;
                }
                return Double.NEGATIVE_INFINITY;
            }
            idx -= this.spec.getP();
        }
        if (this.spec.getBP() > 0) {
            if (idx < this.spec.getBP()) {
                if (this.spec.getBP() == 1) {
                    return -0.99999;
                }
                return Double.NEGATIVE_INFINITY;
            }
            idx -= this.spec.getBP();
        }
        if (this.spec.getQ() > 0) {
            if (idx < this.spec.getQ()) {
                if (this.spec.getQ() == 1) {
                    return -0.99999;
                }
                return Double.NEGATIVE_INFINITY;
            }
            idx -= this.spec.getQ();
        }
        if (this.spec.getBQ() == 1) {
            return -0.99999;
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public SarimaModel map(IReadDataBlock p) {
        if (p.getLength() != this.spec.getParametersCount()) {
            return null;
        }
        SarimaModel m = new SarimaModel(this.spec);
        m.setParameters(p);
        return m;
    }

    @Override
    public IReadDataBlock map(SarimaModel t) {
        SarimaSpecification curspec = t.getSpecification();
        if (curspec.getP() != this.spec.getP() || curspec.getQ() != this.spec.getQ() || curspec.getBP() != this.spec.getBP() || curspec.getBQ() != this.spec.getBQ()) {
            return null;
        }
        return t.getParameters();
    }

    public boolean stabilize(IDataBlock p) {
        return SarimaMapping.stabilize(this.m_all, false, this.spec, p, this.rmax_);
    }

    @Override
    public double ubound(int idx) {
        if (this.spec.getP() > 0) {
            if (idx < this.spec.getP()) {
                if (this.spec.getP() == 1) {
                    return 0.99999;
                }
                return Double.POSITIVE_INFINITY;
            }
            idx -= this.spec.getP();
        }
        if (this.spec.getBP() > 0) {
            if (idx < this.spec.getBP()) {
                if (this.spec.getBP() == 1) {
                    return 0.99999;
                }
                return Double.POSITIVE_INFINITY;
            }
            idx -= this.spec.getBP();
        }
        if (this.spec.getQ() > 0) {
            if (idx < this.spec.getQ()) {
                if (this.spec.getQ() == 1) {
                    return 0.99999;
                }
                return Double.POSITIVE_INFINITY;
            }
            idx -= this.spec.getQ();
        }
        if (this.spec.getBQ() == 1) {
            return 0.99999;
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public ParamValidation validate(IDataBlock value) {
        if (value.getLength() != this.spec.getParametersCount()) {
            return ParamValidation.Invalid;
        }
        if (SarimaMapping.stabilize(true, true, this.spec, value, this.rmax_)) {
            return ParamValidation.Changed;
        }
        return ParamValidation.Valid;
    }

    @Override
    public String getDescription(int idx) {
        return DefaultSarimaMapping.getDescription(this.spec, idx);
    }
}

