/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.data;

import ec.tstoolkit.design.IntValue;

public enum WindowType implements IntValue
{
    Square(0),
    Welch(1),
    Tukey(2),
    Bartlett(3),
    Hamming(4),
    Parzen(5);

    private final int value;

    public static WindowType valueOf(int value) {
        return IntValue.valueOf(WindowType.class, value).orElse(null);
    }

    private WindowType(int value) {
        this.value = value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    private static double parzen(int idx, int size) {
        double tmp = (double)idx / (double)size;
        if (idx <= size / 2) {
            return 1.0 - 6.0 * Math.pow(tmp, 2.0) + 6.0 * Math.pow(tmp, 3.0);
        }
        return 2.0 * Math.pow(1.0 - tmp, 3.0);
    }

    public double[] window(int winSize) {
        double[] window = new double[winSize];
        double dsize = winSize;
        switch (this) {
            case Welch: {
                for (int i = 0; i < winSize; ++i) {
                    window[i] = 1.0 - (double)i / (double)winSize * ((double)i / dsize);
                }
                break;
            }
            case Tukey: {
                for (int i = 0; i < winSize; ++i) {
                    window[i] = 0.5 * (1.0 + Math.cos(Math.PI * (double)i / dsize));
                }
                break;
            }
            case Bartlett: {
                for (int i = 0; i < winSize; ++i) {
                    window[i] = 1.0 - (double)i / dsize;
                }
                break;
            }
            case Hamming: {
                for (int i = 0; i < winSize; ++i) {
                    window[i] = 0.54 + 0.46 * Math.cos(Math.PI * (double)i / dsize);
                }
                break;
            }
            case Parzen: {
                for (int i = 0; i < winSize; ++i) {
                    window[i] = WindowType.parzen(i, winSize);
                }
                break;
            }
            case Square: {
                for (int i = 0; i < winSize; ++i) {
                    window[i] = 1.0;
                }
                break;
            }
        }
        return window;
    }
}

