/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.data;

import ec.tstoolkit.data.IReadDataBlock;
import java.util.Arrays;

public class DescriptiveStatistics {
    public static final double DELTA = 3.834E-20;
    private double[] m_data;
    private double[] m_obs;
    private double[] m_sdata;
    private double m_sx;
    private double m_sxx = -1.0;
    private double m_sk;
    private double m_kr = -1.0;
    private int m_nm;

    public static double[] ac(int k, double[] data) {
        double[] c = new double[k];
        double var = DescriptiveStatistics.cov(0, data);
        for (int i = 0; i < k; ++i) {
            c[i] = DescriptiveStatistics.cov(i + 1, data) / var;
        }
        return c;
    }

    public static double cov(double[] x, double[] y, int t) {
        if (t < 0) {
            return DescriptiveStatistics.cov(y, x, -t);
        }
        double v = 0.0;
        int n = x.length - t;
        int nm = 0;
        for (int i = 0; i < n; ++i) {
            double xcur = x[i];
            double ycur = y[i + t];
            if (Double.isFinite(xcur) && Double.isFinite(ycur)) {
                v += xcur * ycur;
                continue;
            }
            ++nm;
        }
        int m = x.length - nm;
        if (m == 0) {
            return 0.0;
        }
        return v / (double)m;
    }

    public static double cov(double[] x, int sx, double[] y, int sy, int n) {
        double v = 0.0;
        int nm = 0;
        for (int i = 0; i < n; ++i) {
            double xcur = x[i + sx];
            double ycur = y[i + sy];
            if (Double.isFinite(xcur) && Double.isFinite(ycur)) {
                v += xcur * ycur;
                continue;
            }
            ++nm;
        }
        if ((n -= nm) == 0) {
            return 0.0;
        }
        return v / (double)n;
    }

    public static double cov(int k, double[] data) {
        return DescriptiveStatistics.cov(data, data, k);
    }

    public static boolean isSmall(double val) {
        return Math.abs(val) < 3.834E-20;
    }

    public static double[] pac(double[] ac) {
        double[] pc = new double[ac.length];
        return DescriptiveStatistics.pac(ac, pc);
    }

    public static double[] pac(double[] ac, double[] coeff) {
        int kmax = ac.length;
        double[] pac = new double[kmax];
        double[] tmp = new double[kmax];
        pac[0] = coeff[0] = ac[0];
        for (int K = 2; K <= kmax; ++K) {
            double n = 0.0;
            double d = 0.0;
            for (int k = 1; k <= K - 1; ++k) {
                double x = coeff[k - 1];
                n += ac[K - k - 1] * x;
                d += ac[k - 1] * x;
            }
            double d2 = (ac[K - 1] - n) / (1.0 - d);
            coeff[K - 1] = d2;
            pac[K - 1] = d2;
            for (int i = 0; i < K; ++i) {
                tmp[i] = coeff[i];
            }
            for (int j = 1; j <= K - 1; ++j) {
                coeff[j - 1] = tmp[j - 1] - tmp[K - 1] * tmp[K - j - 1];
            }
        }
        return pac;
    }

    public static double[] pac(int k, double[] data) {
        return DescriptiveStatistics.pac(DescriptiveStatistics.ac(k, data));
    }

    public static double var(double[] x, int sx, int n) {
        double v = 0.0;
        int nm = 0;
        for (int i = 0; i < n; ++i) {
            double xcur = x[i + sx];
            if (Double.isFinite(xcur)) {
                v += xcur * xcur;
                continue;
            }
            ++nm;
        }
        return v / (double)(n -= nm);
    }

    public DescriptiveStatistics() {
    }

    public DescriptiveStatistics(IReadDataBlock ids) {
        this.m_data = new double[ids.getLength()];
        ids.copyTo(this.m_data, 0);
        this.initStats();
    }

    public DescriptiveStatistics(double[] data) {
        this.m_data = data;
        this.initStats();
    }

    protected void calcMoments() {
        double stdev = this.getStdev();
        double avg = this.getAverage();
        int n = this.m_data.length;
        this.m_sk = 0.0;
        this.m_kr = 0.0;
        double stdev3 = stdev * stdev * stdev;
        for (int i = 0; i < n; ++i) {
            double cur = this.m_data[i];
            if (!Double.isFinite(cur)) continue;
            double m3 = (cur - avg) * (cur - avg) * (cur - avg);
            this.m_sk += m3;
            this.m_kr += m3 * (cur - avg);
        }
        this.m_sk /= stdev3 * (double)(n -= this.m_nm);
        this.m_kr /= stdev3 * stdev * (double)n;
    }

    public int countBetween(double a, double b) {
        if (this.m_sdata != null) {
            int i1;
            int i0;
            int n = this.m_sdata.length;
            if (n == 0) {
                return 0;
            }
            for (i0 = 0; i0 < n && this.m_sdata[i0] < a; ++i0) {
            }
            for (i1 = i0; i1 < n && this.m_sdata[i1] < b; ++i1) {
            }
            return i1 - i0;
        }
        int n = this.m_data.length;
        int m = 0;
        for (int i = 0; i < n; ++i) {
            double v = this.m_data[i];
            if (!Double.isFinite(v) || !(v >= a) || !(v < b)) continue;
            ++m;
        }
        return m;
    }

    public double getAverage() {
        if (!this.isInitialized()) {
            this.initStats();
        }
        int n = this.m_data.length - this.m_nm;
        return this.m_sx / (double)n;
    }

    public int getDataCount() {
        return this.m_data.length;
    }

    public double getKurtosis() {
        if (this.m_kr < 0.0) {
            this.calcMoments();
        }
        return this.m_kr;
    }

    public double getMax() {
        if (this.m_sdata != null) {
            return this.m_sdata[this.m_sdata.length - 1];
        }
        int n = this.m_data.length;
        double sent = -1.7976931348623157E308;
        for (int i = 0; i < n; ++i) {
            double v = this.m_data[i];
            if (!Double.isFinite(v) || !(v > sent)) continue;
            sent = v;
        }
        return sent;
    }

    public double getMedian() {
        boolean even;
        this.sortObservations();
        if (this.m_sdata.length == 0) {
            return Double.NaN;
        }
        boolean bl = even = this.m_sdata.length % 2 == 0;
        if (even) {
            return (this.m_sdata[this.m_sdata.length / 2 - 1] + this.m_sdata[this.m_sdata.length / 2]) / 2.0;
        }
        return this.m_sdata[this.m_sdata.length / 2];
    }

    public double getMin() {
        if (this.m_sdata != null) {
            return this.m_sdata[0];
        }
        int n = this.m_data.length;
        double sent = Double.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            double v = this.m_data[i];
            if (!Double.isFinite(v) || !(v < sent)) continue;
            sent = v;
        }
        return sent;
    }

    public int getMissingValuesCount() {
        if (!this.isInitialized()) {
            this.initStats();
        }
        return this.m_nm;
    }

    public int getObservationsCount() {
        return this.m_data.length - this.getMissingValuesCount();
    }

    public double getSkewness() {
        if (this.m_kr < 0.0) {
            this.calcMoments();
        }
        return this.m_sk;
    }

    public double getStdev() {
        return Math.sqrt(this.getVar());
    }

    public double getStdevDF(int df) {
        return Math.sqrt(this.getVarDF(df));
    }

    public double getSum() {
        if (!this.isInitialized()) {
            this.initStats();
        }
        return this.m_sx;
    }

    public double getSumSquare() {
        if (!this.isInitialized()) {
            this.initStats();
        }
        return this.m_sxx;
    }

    public double getVar() {
        return this.getVarDF(0);
    }

    public double getVarDF(int df) {
        if (!this.isInitialized()) {
            this.initStats();
        }
        int n = this.m_data.length - this.m_nm;
        double sxx = 0.0;
        double m = this.m_sx / (double)n;
        for (int i = 0; i < this.m_data.length; ++i) {
            double v = this.m_data[i];
            if (!Double.isFinite(v)) continue;
            double e = v - m;
            sxx += e * e;
        }
        return sxx / (double)(n - df);
    }

    public double getRmse() {
        if (!this.isInitialized()) {
            this.initStats();
        }
        int n = this.m_data.length - this.m_nm;
        return Math.sqrt(this.m_sxx / (double)n);
    }

    public boolean hasMissingValues() {
        if (!this.isInitialized()) {
            this.initStats();
        }
        return this.m_nm > 0;
    }

    public boolean hasNullValues() {
        if (this.m_sdata != null && (this.m_sdata[0] > 0.0 || this.m_sdata[this.m_sdata.length - 1] < 0.0)) {
            return false;
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            double v = this.m_data[i];
            if (!Double.isFinite(v) || v != 0.0) continue;
            return true;
        }
        return false;
    }

    private void initStats() {
        this.m_sxx = 0.0;
        for (int i = 0; i < this.m_data.length; ++i) {
            double v = this.m_data[i];
            if (!Double.isFinite(v)) {
                ++this.m_nm;
                continue;
            }
            this.m_sx += v;
            this.m_sxx += v * v;
        }
    }

    public double[] internalStorage() {
        return this.m_data;
    }

    public boolean isConstant() {
        if (this.m_sdata != null) {
            if (this.m_sdata.length == 0) {
                return true;
            }
            return this.m_sdata[0] == this.m_sdata[this.m_sdata.length - 1];
        }
        double sent = Double.NaN;
        for (int i = 0; i < this.m_data.length; ++i) {
            double v = this.m_data[i];
            if (!Double.isFinite(v)) continue;
            if (Double.isNaN(sent)) {
                sent = v;
                continue;
            }
            if (v == sent) continue;
            return false;
        }
        return true;
    }

    public boolean isGreater(double val) {
        if (this.m_sdata != null) {
            return this.m_sdata[0] > val;
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            double v = this.m_data[i];
            if (!Double.isFinite(v) || !(v <= val)) continue;
            return false;
        }
        return true;
    }

    public boolean isGreaterOrEqual(double val) {
        if (this.m_sdata != null) {
            return this.m_sdata[0] > val;
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            double v = this.m_data[i];
            if (!Double.isFinite(v) || !(v < val)) continue;
            return false;
        }
        return true;
    }

    private boolean isInitialized() {
        return this.m_sxx >= 0.0;
    }

    public boolean isNegative() {
        return this.isSmaller(0.0);
    }

    public boolean isNegativeOrNull() {
        return this.isSmallerOrEqual(0.0);
    }

    public boolean isPositive() {
        return this.isGreater(0.0);
    }

    public boolean isPositiveOrNull() {
        return this.isGreaterOrEqual(0.0);
    }

    public boolean isSmaller(double val) {
        if (this.m_sdata != null) {
            return this.m_sdata[0] > val;
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            double v = this.m_data[i];
            if (!Double.isFinite(v) || !(v >= val)) continue;
            return false;
        }
        return true;
    }

    public boolean isSmallerOrEqual(double val) {
        if (this.m_sdata != null) {
            return this.m_sdata[0] > val;
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            double v = this.m_data[i];
            if (!Double.isFinite(v) || !(v > val)) continue;
            return false;
        }
        return true;
    }

    public boolean isZero(double eps) {
        if (this.m_sdata != null) {
            return this.m_sdata[0] >= -eps && this.m_sdata[this.m_sdata.length - 1] <= eps;
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            double v = this.m_data[i];
            if (!Double.isFinite(v) || !(Math.abs(v) > eps)) continue;
            return false;
        }
        return true;
    }

    public double[] observations() {
        if (this.m_obs == null) {
            if (!this.isInitialized()) {
                this.initStats();
            }
            if (this.m_nm == 0) {
                this.m_obs = this.m_data;
            } else {
                this.m_obs = new double[this.m_data.length - this.m_nm];
                int j = 0;
                for (int i = 0; i < this.m_data.length; ++i) {
                    double x = this.m_data[i];
                    if (!Double.isFinite(x)) continue;
                    this.m_obs[j++] = x;
                }
            }
        }
        return this.m_obs;
    }

    public double[] quantiles(int partitions) {
        this.sortObservations();
        int n = this.m_sdata.length;
        if (n == 0) {
            return null;
        }
        if (partitions < 2 || n / partitions < 1) {
            return null;
        }
        int np = partitions - 1;
        double[] res = new double[np];
        int ns = (n - 1) / partitions;
        if (ns * partitions == n - 1) {
            for (int i = 0; i < np; ++i) {
                res[i] = this.m_sdata[(i + 1) * ns];
            }
        } else {
            double ds = (double)(n - 1) / (double)partitions;
            for (int i = 0; i < np; ++i) {
                double dindex = (double)(i + 1) * ds;
                int lo = (int)dindex;
                double dlo = dindex - (double)lo;
                res[i] = this.m_sdata[lo] * (1.0 - dlo) + this.m_sdata[lo + 1] * dlo;
            }
        }
        return res;
    }

    public double[] sortedObservations() {
        this.sortObservations();
        return this.m_sdata;
    }

    private void sortObservations() {
        if (this.m_sdata == null) {
            if (!this.isInitialized()) {
                this.initStats();
            }
            this.m_sdata = (double[])this.observations().clone();
            Arrays.sort(this.m_sdata);
        }
    }
}

