/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stat;

import java.util.ArrayList;
import java.util.List;
import umontreal.iro.lecuyer.stat.ObservationListener;
import umontreal.iro.lecuyer.util.PrintfFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StatProbe {
    private List<ObservationListener> listeners = new ArrayList<ObservationListener>();
    protected String name;
    protected double maxValue;
    protected double minValue;
    protected double sumValue;
    protected boolean collect = true;
    protected boolean broadcast = false;
    protected boolean showNobs = true;

    public abstract void init();

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public double min() {
        return this.minValue;
    }

    public double max() {
        return this.maxValue;
    }

    public double sum() {
        return this.sumValue;
    }

    public abstract double average();

    public abstract String report();

    public abstract String shortReport();

    public abstract String shortReportHeader();

    public static String report(String string, StatProbe[] statProbeArray) {
        int n = 0;
        StatProbe statProbe = null;
        for (StatProbe statProbe2 : statProbeArray) {
            String object;
            if (statProbe == null) {
                statProbe = statProbe2;
            }
            if ((object = statProbe2.getName()) == null || object.length() <= n) continue;
            n = object.length();
        }
        if (statProbe == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("Report for ");
        stringBuffer.append(string).append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append("   ");
        stringBuffer.append(statProbe.shortReportHeader()).append("\n");
        for (StatProbe statProbe2 : statProbeArray) {
            stringBuffer.append(PrintfFormat.s(-n, statProbe2.getName()));
            stringBuffer.append("   ");
            stringBuffer.append(statProbe2.shortReport()).append('\n');
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String report(String string, Iterable<? extends StatProbe> iterable) {
        void var5_7;
        int n = 0;
        StatProbe statProbe = null;
        for (StatProbe statProbe2 : iterable) {
            String string2;
            int n2;
            if (statProbe == null) {
                statProbe = statProbe2;
            }
            if ((n2 = (string2 = statProbe2.getName()) == null ? 4 : string2.length()) <= n) continue;
            n = n2;
        }
        if (statProbe == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("Report for ");
        stringBuffer.append(string).append('\n');
        boolean i = false;
        while (var5_7 < n) {
            stringBuffer.append(' ');
            ++var5_7;
        }
        stringBuffer.append("   ");
        stringBuffer.append(statProbe.shortReportHeader()).append("\n");
        for (StatProbe statProbe2 : iterable) {
            stringBuffer.append(PrintfFormat.s(-n, statProbe2.getName()));
            stringBuffer.append("   ");
            stringBuffer.append(statProbe2.shortReport()).append('\n');
        }
        return stringBuffer.toString();
    }

    public boolean isBroadcasting() {
        return this.broadcast;
    }

    public void setBroadcasting(boolean bl) {
        this.broadcast = bl;
    }

    public boolean isCollecting() {
        return this.collect;
    }

    public void setCollecting(boolean bl) {
        this.collect = bl;
    }

    public void addObservationListener(ObservationListener observationListener) {
        if (observationListener == null) {
            throw new NullPointerException();
        }
        if (!this.listeners.contains(observationListener)) {
            this.listeners.add(observationListener);
        }
    }

    public void removeObservationListener(ObservationListener observationListener) {
        this.listeners.remove(observationListener);
    }

    public void clearObservationListeners() {
        this.listeners.clear();
    }

    public void notifyListeners(double d) {
        if (!this.broadcast) {
            return;
        }
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            this.listeners.get(i).newObservation(this, d);
        }
    }

    public StatProbe clone() throws CloneNotSupportedException {
        StatProbe statProbe = (StatProbe)super.clone();
        statProbe.listeners = new ArrayList<ObservationListener>(this.listeners);
        return statProbe;
    }
}

