/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.outbound;

import com.amazon.jdbc.communications.interfaces.AbstractOutboundMessage;
import com.amazon.redshift.api.PGDataTypeUtilities;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.IPGLogger;
import java.nio.ByteBuffer;

public class PasswordMessage
extends AbstractOutboundMessage
implements PGConstants {
    private final byte[] m_password;

    public PasswordMessage(String string, IPGLogger iPGLogger) {
        this.m_password = (byte[])(null != string ? PGDataTypeUtilities.toUTF8ByteArray(string) : null);
        if (iPGLogger.isExternalLoggerEnabled()) {
            this.logMessageContent(iPGLogger);
        }
    }

    public PasswordMessage(byte[] byArray, IPGLogger iPGLogger) {
        this.m_password = byArray;
        if (iPGLogger.isExternalLoggerEnabled()) {
            this.logMessageContent(iPGLogger);
        }
    }

    @Override
    public void serialize(ByteBuffer byteBuffer, byte[] byArray) {
        byteBuffer.put((byte)112);
        byteBuffer.put(byArray);
        if (null != this.m_password) {
            byteBuffer.put(this.m_password);
        }
        byteBuffer.put(TERMINATOR);
    }

    @Override
    public int getSize() {
        return 4 + (this.m_password != null ? this.m_password.length : 0) + 1;
    }

    public void logMessageContent(IPGLogger iPGLogger) {
        String string = "=>FE Password(md5digest=" + new String(this.m_password) + ")";
        iPGLogger.logDebugExternal(string);
    }
}

