/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.distributed.test;

import java.util.Random;
import junit.framework.TestCase;
import no.uib.cipr.matrix.distributed.CollectiveCommunications;
import no.uib.cipr.matrix.distributed.Communicator;

public class PointToPointTest
extends TestCase {
    CollectiveCommunications coll;
    byte[] bsend;
    byte[] brecv;
    char[] csend;
    char[] crecv;
    short[] ssend;
    short[] srecv;
    int[] isend;
    int[] irecv;
    long[] lsend;
    long[] lrecv;
    float[] fsend;
    float[] frecv;
    double[] dsend;
    double[] drecv;
    int length;

    protected void setUp() throws Exception {
        this.coll = new CollectiveCommunications(2);
        Random r = new Random();
        this.length = r.nextInt(100);
        this.bsend = new byte[this.length];
        this.brecv = new byte[this.length];
        this.csend = new char[this.length];
        this.crecv = new char[this.length];
        this.ssend = new short[this.length];
        this.srecv = new short[this.length];
        this.isend = new int[this.length];
        this.irecv = new int[this.length];
        this.lsend = new long[this.length];
        this.lrecv = new long[this.length];
        this.fsend = new float[this.length];
        this.frecv = new float[this.length];
        this.dsend = new double[this.length];
        this.drecv = new double[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.dsend[i] = r.nextDouble();
            this.fsend[i] = r.nextFloat();
            this.lsend[i] = r.nextLong();
            this.isend[i] = r.nextInt();
            this.ssend[i] = (short)r.nextInt();
            this.csend[i] = (char)r.nextInt();
            this.bsend[i] = (byte)r.nextInt();
        }
    }

    public void testByteSendRecv() throws Exception {
        this.runSendRecv(this.bsend, this.brecv);
        for (int i = 0; i < this.length; ++i) {
            PointToPointTest.assertEquals((byte)this.bsend[i], (byte)this.brecv[i]);
        }
    }

    public void testCharSendRecv() throws Exception {
        this.runSendRecv(this.csend, this.crecv);
        for (int i = 0; i < this.length; ++i) {
            PointToPointTest.assertEquals((char)this.csend[i], (char)this.crecv[i]);
        }
    }

    public void testShortSendRecv() throws Exception {
        this.runSendRecv(this.ssend, this.srecv);
        for (int i = 0; i < this.length; ++i) {
            PointToPointTest.assertEquals((short)this.ssend[i], (short)this.srecv[i]);
        }
    }

    public void testIntSendRecv() throws Exception {
        this.runSendRecv(this.isend, this.irecv);
        for (int i = 0; i < this.length; ++i) {
            PointToPointTest.assertEquals((int)this.isend[i], (int)this.irecv[i]);
        }
    }

    public void testLongSendRecv() throws Exception {
        this.runSendRecv(this.lsend, this.lrecv);
        for (int i = 0; i < this.length; ++i) {
            PointToPointTest.assertEquals((long)this.lsend[i], (long)this.lrecv[i]);
        }
    }

    public void testFloatSendRecv() throws Exception {
        this.runSendRecv(this.fsend, this.frecv);
        for (int i = 0; i < this.length; ++i) {
            PointToPointTest.assertEquals((double)this.fsend[i], (double)this.frecv[i], (double)1.0E-10);
        }
    }

    public void testDoubleSendRecv() throws Exception {
        this.runSendRecv(this.dsend, this.drecv);
        for (int i = 0; i < this.length; ++i) {
            PointToPointTest.assertEquals((double)this.dsend[i], (double)this.drecv[i], (double)1.0E-10);
        }
    }

    private void runSendRecv(Object send, Object recv) throws InterruptedException {
        Thread sender = this.createSender(send, 0, 1);
        Thread receiver = this.createReceiver(recv, 1, 0);
        sender.start();
        receiver.start();
        sender.join();
        receiver.join();
    }

    private Thread createSender(final Object send, final int rank, final int peer) {
        return new Thread(new Runnable(){

            public void run() {
                Communicator c = PointToPointTest.this.coll.createCommunicator(rank);
                c.send(send, peer);
            }
        });
    }

    private Thread createReceiver(final Object recv, final int rank, final int peer) {
        return new Thread(new Runnable(){

            public void run() {
                Communicator c = PointToPointTest.this.coll.createCommunicator(rank);
                c.recv(recv, peer);
            }
        });
    }
}

