/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.featureranking;

import com.github.javacliparser.FloatOption;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import moa.classifiers.rules.featureranking.AbstractFeatureRanking;
import moa.classifiers.rules.featureranking.FeatureRanking;
import moa.classifiers.rules.featureranking.messages.ChangeDetectedMessage;
import moa.classifiers.rules.featureranking.messages.MeritCheckMessage;
import moa.classifiers.rules.featureranking.messages.RuleExpandedMessage;
import moa.classifiers.rules.multilabel.core.ObservableMOAObject;
import moa.core.DoubleVector;

public class WeightedMajorityFeatureRanking
extends AbstractFeatureRanking
implements FeatureRanking {
    private static final long serialVersionUID = 1L;
    protected double[] attributeImportance;
    protected HashMap<ObservableMOAObject, RuleInformation> ruleInformation;
    public FloatOption meritThresholdOption = new FloatOption("meritThreshold", 'm', "Merit threshold value. If the merit of an input attribute is below the threshold its importance will decrease", 0.01, 0.0, 1.0);

    public WeightedMajorityFeatureRanking() {
        this.ruleInformation = new HashMap();
    }

    @Override
    public void update(ObservableMOAObject o, Object arg) {
        if (arg instanceof MeritCheckMessage) {
            MeritCheckMessage msg = (MeritCheckMessage)arg;
            boolean[] attributesMask = (boolean[])msg.getLearningAttributes().clone();
            int numAttributes = attributesMask.length;
            if (this.attributeImportance == null) {
                this.attributeImportance = new double[numAttributes];
                for (int i = 0; i < attributesMask.length; ++i) {
                    this.attributeImportance[i] = 1.0;
                }
            }
            int numRules = this.ruleInformation.size();
            RuleInformation ri = this.ruleInformation.get(o);
            if (ri == null) {
                ri = new RuleInformation(numAttributes);
                this.ruleInformation.put(o, ri);
                for (int i = 0; i < numAttributes; ++i) {
                    this.attributeImportance[i] = (this.attributeImportance[i] * (double)numRules + 1.0) / (double)(numRules + 1);
                }
            } else {
                double[] old = (double[])ri.getAttributesImportance().clone();
                List<Integer> updated = ri.update(msg.getMerits().getArrayRef(), attributesMask, this.meritThresholdOption.getValue());
                for (int attIndex : updated) {
                    this.attributeImportance[attIndex] = (this.attributeImportance[attIndex] * (double)numRules - old[attIndex] + ri.getAttributeImportance(attIndex)) / (double)numRules;
                }
            }
        } else if (arg instanceof RuleExpandedMessage) {
            int numRules = this.ruleInformation.size();
            RuleInformation ri = this.ruleInformation.get(o);
            RuleExpandedMessage msg = (RuleExpandedMessage)arg;
            int attIndex = msg.getAttributeIndex();
            double oldValue = ri.getAttributeImportance(attIndex);
            this.attributeImportance[attIndex] = (this.attributeImportance[attIndex] * (double)numRules - oldValue + 1.0) / (double)numRules;
            ri.addLiteralAttribute(attIndex);
        } else if (arg instanceof ChangeDetectedMessage) {
            RuleInformation ri = this.ruleInformation.get(o);
            int numRules = this.ruleInformation.size();
            double[] attribImportance = ri.getAttributesImportance();
            for (int i = 0; i < this.attributeImportance.length; ++i) {
                this.attributeImportance[i] = (this.attributeImportance[i] * (double)numRules - attribImportance[i]) / (double)(numRules - 1);
            }
            this.ruleInformation.remove(o);
        }
    }

    @Override
    public DoubleVector getFeatureRankings() {
        if (this.attributeImportance == null) {
            return new DoubleVector();
        }
        return new DoubleVector(this.attributeImportance);
    }

    public class RuleInformation {
        private double[] attributeImportance;
        private double depth;
        private List<Integer> literalAttributes = new LinkedList<Integer>();

        public RuleInformation(int numAttributes) {
            this.attributeImportance = new double[numAttributes];
            this.depth = 0.0;
            for (int i = 0; i < numAttributes; ++i) {
                this.attributeImportance[i] = 1.0;
            }
        }

        public void addLiteralAttribute(int attribIndex) {
            this.depth += 1.0;
            this.attributeImportance[attribIndex] = 1.0;
            if (!this.literalAttributes.contains(attribIndex)) {
                this.literalAttributes.add(attribIndex);
            }
        }

        public double[] getAttributesImportance() {
            return this.attributeImportance;
        }

        public double getAttributeImportance(int attribIndex) {
            return this.attributeImportance[attribIndex];
        }

        public List<Integer> update(double[] merits, boolean[] attributesMask, double threshold) {
            boolean[] attributesMaskAux = (boolean[])attributesMask.clone();
            Iterator<Integer> it = this.literalAttributes.iterator();
            while (it.hasNext()) {
                attributesMaskAux[it.next().intValue()] = false;
            }
            LinkedList<Integer> updated = new LinkedList<Integer>();
            for (int i = 0; i < attributesMaskAux.length; ++i) {
                if (!(merits[i] < threshold) || !attributesMaskAux[i]) continue;
                int n = i;
                this.attributeImportance[n] = this.attributeImportance[n] * ((1.0 + this.depth) / (2.0 + this.depth));
                updated.add(i);
            }
            return updated;
        }
    }
}

