/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import java.awt.Dimension;
import java.util.List;
import org.xmlcml.euclid.Axis;
import org.xmlcml.euclid.EuclidConstants;
import org.xmlcml.euclid.Real2;
import org.xmlcml.euclid.RealArray;
import org.xmlcml.euclid.RealRange;
import org.xmlcml.euclid.Transform2;

public class Real2Range
implements EuclidConstants {
    RealRange xrange;
    RealRange yrange;

    public Real2Range() {
    }

    public Real2Range(RealRange xr, RealRange yr) {
        if (xr.isValid() && yr.isValid()) {
            this.xrange = xr;
            this.yrange = yr;
        }
    }

    public Real2Range(Real2 r2a, Real2 r2b) {
        double x0 = r2a.getX();
        double x1 = r2b.getX();
        this.xrange = new RealRange(Math.min(x0, x1), Math.max(x0, x1));
        double y0 = r2a.getY();
        double y1 = r2b.getY();
        this.yrange = new RealRange(Math.min(y0, y1), Math.max(y0, y1));
    }

    public Real2Range(Real2Range r) {
        if (r.isValid()) {
            this.xrange = new RealRange(r.xrange);
            this.yrange = new RealRange(r.yrange);
        }
    }

    public static Real2Range createFrom(String s) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("((") && s.endsWith("))")) {
            String ss = s.substring(2, s.length() - 2);
            int i = ss.indexOf(")");
            int j = ss.indexOf("(");
            if (i == -1 || j == -1 || i + 2 != j) {
                throw new RuntimeException("Bad Real2Range syntax: " + s);
            }
            RealRange xr = Real2Range.getRealRange(ss.substring(0, i));
            RealRange yr = Real2Range.getRealRange(ss.substring(j + 1));
            if (xr == null || yr == null) {
                throw new RuntimeException("Bad Real2Range syntax: " + s);
            }
            return new Real2Range(xr, yr);
        }
        throw new RuntimeException("Bad Real2Range syntax: " + s);
    }

    private static RealRange getRealRange(String s) {
        RealArray xa = new RealArray(s.replaceAll(",", " "));
        return xa.size() == 2 ? new RealRange(xa.get(0), xa.get(1)) : null;
    }

    public boolean isValid() {
        return this.xrange != null && this.yrange != null && this.xrange.isValid() && this.yrange.isValid();
    }

    @Deprecated
    public boolean isEqualTo(Real2Range r2) {
        if (this.isValid() && r2 != null && r2.isValid()) {
            return this.xrange.isEqualTo(r2.xrange) && this.yrange.isEqualTo(r2.yrange);
        }
        return false;
    }

    public boolean isEqualTo(Real2Range r2, double eps) {
        if (this.isValid() && r2 != null && r2.isValid()) {
            return this.xrange.isEqualTo(r2.xrange, eps) && this.yrange.isEqualTo(r2.yrange, eps);
        }
        return false;
    }

    public Real2Range plus(Real2Range r2) {
        if (!this.isValid()) {
            if (r2 == null || !r2.isValid()) {
                return new Real2Range();
            }
            return new Real2Range(r2);
        }
        if (r2 == null || !r2.isValid()) {
            return new Real2Range(this);
        }
        return new Real2Range(this.xrange.plus(r2.xrange), this.yrange.plus(r2.yrange));
    }

    public Real2Range plusEquals(Real2Range r2) {
        if (r2 != null) {
            this.xrange = this.xrange == null ? r2.xrange : this.xrange.plus(r2.xrange);
            this.yrange = this.yrange == null ? r2.yrange : this.yrange.plus(r2.yrange);
        }
        return this;
    }

    public Real2Range intersectionWith(Real2Range r2) {
        if (!this.isValid() || r2 == null || !r2.isValid()) {
            return new Real2Range();
        }
        RealRange xr = this.getXRange().intersectionWith(r2.getXRange());
        RealRange yr = this.getYRange().intersectionWith(r2.getYRange());
        return xr == null || yr == null ? null : new Real2Range(xr, yr);
    }

    public RealRange getXRange() {
        return this.xrange;
    }

    public RealRange getYRange() {
        return this.yrange;
    }

    public void setXRange(RealRange xrange) {
        this.xrange = xrange;
    }

    public void setYRange(RealRange yrange) {
        this.yrange = yrange;
    }

    public Real2 getCentroid() {
        return new Real2(this.xrange.getMidPoint(), this.yrange.getMidPoint());
    }

    public Real2[] getCorners() {
        Real2[] rr = null;
        if (this.xrange != null && this.yrange != null) {
            rr = new Real2[]{new Real2(this.xrange.getMin(), this.yrange.getMin()), new Real2(this.xrange.getMax(), this.yrange.getMax())};
        }
        return rr;
    }

    public boolean includes(Real2 p) {
        if (!this.isValid()) {
            return false;
        }
        return this.xrange.includes(p.getX()) && this.yrange.includes(p.getY());
    }

    public boolean includes(Real2Range r) {
        if (!this.isValid() || r == null || !r.isValid()) {
            return false;
        }
        RealRange xr = r.getXRange();
        RealRange yr = r.getYRange();
        return this.xrange.includes(xr) && this.yrange.includes(yr);
    }

    public void add(Real2 p) {
        if (p == null) {
            return;
        }
        if (this.xrange == null) {
            this.xrange = new RealRange();
        }
        if (this.yrange == null) {
            this.yrange = new RealRange();
        }
        this.xrange.add(p.getX());
        this.yrange.add(p.getY());
    }

    public void add(Axis.Axis2 ax, RealRange range) {
        if (range == null) {
            return;
        }
        if (ax.equals((Object)Axis.Axis2.X)) {
            if (this.xrange == null) {
                this.xrange = new RealRange();
            }
            this.xrange = this.xrange.plus(range);
        }
        if (ax.equals((Object)Axis.Axis2.Y)) {
            if (this.yrange == null) {
                this.yrange = new RealRange();
            }
            this.yrange = this.yrange.plus(range);
        }
    }

    public Real2 distanceOutside(Real2 p) {
        Real2 r2 = null;
        if (p != null) {
            double dx = this.xrange.distanceOutside(p.getX());
            double dy = this.yrange.distanceOutside(p.getY());
            if (!Double.isNaN(dx) && !Double.isNaN(dy)) {
                r2 = new Real2(dx, dy);
            }
        }
        return r2;
    }

    public Real2Range getTranformedRange(Transform2 t2) {
        RealRange xRange = this.getXRange();
        RealRange yRange = this.getYRange();
        Real2 xyMin = new Real2(xRange.getMin(), yRange.getMin());
        xyMin.transformBy(t2);
        Real2 xyMax = new Real2(xRange.getMax(), yRange.getMax());
        xyMax.transformBy(t2);
        return new Real2Range(xyMin, xyMax);
    }

    public String toString() {
        String xx = this.xrange == null ? "NULL" : this.xrange.toString();
        String yy = this.yrange == null ? "NULL" : this.yrange.toString();
        return "(" + xx + "," + yy + ")";
    }

    public Real2Range format(Integer decimalPlaces) {
        if (this.xrange != null && this.yrange != null) {
            this.xrange = this.xrange.format(decimalPlaces);
            this.yrange = this.yrange.format(decimalPlaces);
        }
        return this;
    }

    public static boolean isNull(Real2Range r2r) {
        return r2r == null || r2r.getXRange() == null && r2r.getYRange() == null;
    }

    public boolean isHorizontal() {
        return this.xrange != null && this.yrange != null && this.xrange.getRange() > this.yrange.getRange();
    }

    public boolean isVertical() {
        return this.xrange != null && this.yrange != null && this.xrange.getRange() < this.yrange.getRange();
    }

    public Double getHorizontalVerticalRatio() {
        Double ratio = null;
        if (this.xrange != null && this.yrange != null) {
            ratio = this.xrange.getRange() / this.yrange.getRange();
        }
        return ratio;
    }

    public RealRange getRealRange(RealRange.Direction direction) {
        RealRange range = null;
        if (RealRange.Direction.HORIZONTAL.equals((Object)direction)) {
            range = this.getXRange();
        } else if (RealRange.Direction.VERTICAL.equals((Object)direction)) {
            range = this.getYRange();
        }
        return range;
    }

    public boolean isContainedInAnyRange(List<Real2Range> r2rList) {
        if (r2rList != null) {
            for (Real2Range r2r : r2rList) {
                if (!r2r.includes(this)) continue;
                return true;
            }
        }
        return false;
    }

    public Dimension getDimension() {
        return new Dimension((int)this.getXRange().getRange(), (int)this.getYRange().getRange());
    }

    public Double getXMin() {
        return this.xrange == null ? null : Double.valueOf(this.xrange.getMin());
    }

    public Double getXMax() {
        return this.xrange == null ? null : Double.valueOf(this.xrange.getMax());
    }

    public Double getYMin() {
        return this.yrange == null ? null : Double.valueOf(this.yrange.getMin());
    }

    public Double getYMax() {
        return this.yrange == null ? null : Double.valueOf(this.yrange.getMax());
    }

    public Real2Range getReal2RangeExtendedInX(double leftSide, double rightSide) {
        Real2Range r2r = new Real2Range(this);
        if (r2r.xrange != null) {
            r2r.xrange = r2r.xrange.getRangeExtendedBy(leftSide, rightSide);
        }
        return r2r;
    }

    public Real2Range getReal2RangeExtendedInY(double topExtend, double bottomExtend) {
        Real2Range r2r = new Real2Range(this);
        if (r2r.yrange != null) {
            r2r.yrange = r2r.yrange.getRangeExtendedBy(topExtend, bottomExtend);
        }
        return r2r;
    }

    public static void format(List<Real2Range> boxList, int nplaces) {
        for (Real2Range box : boxList) {
            box.format(nplaces);
        }
    }

    public Double calculateArea() {
        return this.xrange == null || this.yrange == null ? null : Double.valueOf(this.xrange.getRange() * this.yrange.getRange());
    }

    public Real2 getMidPoint(BoxDirection direction) {
        Real2 midPoint = null;
        if (BoxDirection.TOP.equals((Object)direction)) {
            midPoint = new Real2(this.getXRange().getMidPoint(), this.getYMax());
        } else if (BoxDirection.BOTTOM.equals((Object)direction)) {
            midPoint = new Real2(this.getXRange().getMidPoint(), this.getYMin());
        } else if (BoxDirection.LEFT.equals((Object)direction)) {
            midPoint = new Real2(this.getXMin(), this.getYRange().getMidPoint());
        } else if (BoxDirection.RIGHT.equals((Object)direction)) {
            midPoint = new Real2(this.getXMax(), this.getYRange().getMidPoint());
        }
        return midPoint;
    }

    public boolean isLessThan(Real2Range bbox) {
        return bbox != null && this.xrange.isLessThan(bbox.getXRange()) && this.yrange.isLessThan(bbox.getYRange());
    }

    public static enum BoxDirection {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

