## ---- echo = FALSE, message = FALSE, include = FALSE--------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  out.width = "100%"
)

## ---- message = FALSE---------------------------------------------------------
library(metalite)

## -----------------------------------------------------------------------------
meta <- meta_example()
meta

## -----------------------------------------------------------------------------
meta$population$apat

## -----------------------------------------------------------------------------
collect_adam_mapping(meta, name = "apat")

## -----------------------------------------------------------------------------
collect_adam_mapping(meta, name = "ser")

## -----------------------------------------------------------------------------
collect_adam_mapping(meta, name = "ae_summary")

## -----------------------------------------------------------------------------
meta$population$apat$subset

## -----------------------------------------------------------------------------
collect_population(meta, population = "apat")

## -----------------------------------------------------------------------------
collect_population(meta,
  population = "apat",
  observation = "wk12",
  parameter = "ser"
)

## -----------------------------------------------------------------------------
population_index <- collect_population_index(meta, "apat")

## -----------------------------------------------------------------------------
head(collect_population_index(meta, "apat"))

## -----------------------------------------------------------------------------
population_id <- collect_population_id(meta, "apat")

## -----------------------------------------------------------------------------
head(collect_population_id(meta, "apat"))

## -----------------------------------------------------------------------------
head(collect_population_record(meta, "apat"))

## -----------------------------------------------------------------------------
head(collect_population_record(meta, "apat", var = "AGE"))

## -----------------------------------------------------------------------------
head(collect_population_record(meta, "apat", var = c("AGE", "TRT01P")))

## -----------------------------------------------------------------------------
collect_observation_index(meta, "apat", "wk12", "ser")

## -----------------------------------------------------------------------------
collect_observation_record(meta, "apat", "wk12", "ser")

## -----------------------------------------------------------------------------
collect_observation_record(meta, "apat", "wk12", "ser", var = "AEDECOD")

## -----------------------------------------------------------------------------
collect_title(meta, "apat", "wk12", "ser", "ae_summary")

## -----------------------------------------------------------------------------
collect_dataname(meta)

