/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.gann;

import keel.Algorithms.Neural_Networks.gann.Data;
import keel.Algorithms.Neural_Networks.gann.Individual;
import keel.Algorithms.Neural_Networks.gann.Rand;
import keel.Algorithms.Neural_Networks.gann.Selector;
import keel.Algorithms.Neural_Networks.gann.SetupParameters;

public class Population {
    int n_indiv;
    Individual[] indiv;
    double[] fitness;

    public Population(SetupParameters global) {
        this.n_indiv = global.n_indiv;
        this.indiv = new Individual[this.n_indiv];
        this.fitness = new double[this.n_indiv];
    }

    public Individual EvolvePopulation(SetupParameters global, Data data) {
        int next;
        int i;
        boolean finish = false;
        Population new_pop = new Population(global);
        int size = global.Ninputs * global.Nhidden[0];
        for (i = 1; i < global.Nhidden_layers; ++i) {
            size += global.Nhidden[i] * global.Nhidden[i - 1];
        }
        size += global.Noutputs * global.Nhidden[global.Nhidden_layers - 1];
        for (i = 0; i < this.n_indiv; ++i) {
            new_pop.indiv[i] = new Individual(size);
        }
        for (i = 0; i < this.n_indiv; ++i) {
            this.indiv[i] = new Individual(global);
        }
        for (i = 0; i < this.n_indiv; ++i) {
            this.fitness[i] = this.indiv[i].EvaluateIndividual(global, data);
        }
        int g = 1;
        while (!finish) {
            int i2;
            int being = 0;
            while ((double)being < (double)this.n_indiv * global.elite) {
                next = Selector.Ordered(this.fitness, being, this.n_indiv);
                this.indiv[next].CopyIndividualTo(new_pop.indiv[being]);
                ++being;
            }
            while (being < this.n_indiv) {
                int father = Selector.Roulette(this.fitness, this.n_indiv, global);
                int mother = Selector.Roulette(this.fitness, this.n_indiv, global);
                new_pop.indiv[being].TwoPointsCrossover(global, this.indiv[father], this.indiv[mother], data);
                ++being;
            }
            for (i2 = 0; i2 < this.n_indiv; ++i2) {
                if (!(Rand.frandom(0.0, 1.0) < global.p_struct)) continue;
                new_pop.indiv[i2].StructuralMutation(global);
            }
            for (i2 = 0; i2 < this.n_indiv; ++i2) {
                if (!(Rand.frandom(0.0, 1.0) < global.p_param)) continue;
                new_pop.indiv[i2].ParametricMutation(global);
            }
            for (i2 = 0; i2 < this.n_indiv; ++i2) {
                if (!(Rand.frandom(0.0, 1.0) < global.p_bp)) continue;
                new_pop.indiv[i2].BPMutation(global, data.train, global.n_train_patterns);
            }
            for (i2 = 0; i2 < this.n_indiv; ++i2) {
                new_pop.indiv[i2].CopyIndividualTo(this.indiv[i2]);
            }
            for (i2 = 0; i2 < this.n_indiv; ++i2) {
                this.fitness[i2] = this.indiv[i2].EvaluateIndividual(global, data);
            }
            System.out.print("Best individual on generation " + g + ": ");
            System.out.println(this.fitness[Selector.Ordered(this.fitness, 0, this.n_indiv)]);
            if (++g <= global.max_generations) continue;
            finish = true;
        }
        next = Selector.Ordered(this.fitness, 0, this.n_indiv);
        return this.indiv[next];
    }
}

