/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.util;

import it.bancaditalia.oss.sdmx.parser.v21.Sdmx21Queries;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RestQueryBuilder {
    protected final URI entryPoint;
    protected final List<String> paths = new ArrayList<String>();
    protected final Map<String, String> params = new LinkedHashMap<String, String>();
    protected String filter = null;

    public RestQueryBuilder(URI uRI) {
        this.entryPoint = uRI;
    }

    public RestQueryBuilder addPath(String string) {
        if (string == null) {
            throw new NullPointerException("path");
        }
        this.paths.add(string);
        return this;
    }

    public RestQueryBuilder addParam(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("key");
        }
        if (string2 == null) {
            throw new NullPointerException("value");
        }
        this.params.put(string, string2);
        return this;
    }

    public RestQueryBuilder addFilter(String string) {
        if (string == null) {
            throw new NullPointerException("filter");
        }
        this.filter = string;
        return this;
    }

    public URL build() throws MalformedURLException {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.entryPoint);
            if (this instanceof Sdmx21Queries) {
                for (String object : this.paths) {
                    stringBuilder.append('/').append(URLEncoder.encode(object, "UTF-8"));
                }
            } else {
                for (String string : this.paths) {
                    stringBuilder.append('/').append(string);
                }
            }
            boolean bl = true;
            if (this.filter != null) {
                stringBuilder.append(bl ? (char)'?' : '&');
                stringBuilder.append(this.filter);
                bl = false;
            }
            for (Map.Entry<String, String> entry : this.params.entrySet()) {
                stringBuilder.append(bl ? (char)'?' : '&');
                stringBuilder.append(URLEncoder.encode(entry.getKey(), "UTF-8")).append('=').append(entry.getValue());
                bl = false;
            }
            return new URL(stringBuilder.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UnsupportedEncodingException", unsupportedEncodingException);
        }
    }
}

