/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.utilities;

import ec.tstoolkit.design.PrimitiveReplacementOf;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.DoubleStream;

@PrimitiveReplacementOf(generic=List.class, primitive=double.class)
public final class DoubleList {
    private static final int DEFAULT_SIZE = 128;
    private double[] _array;
    private int _limit;
    private double fillval = 0.0;

    public DoubleList() {
        this(128);
    }

    public DoubleList(int initialCapacity) {
        this(initialCapacity, 0.0);
    }

    public DoubleList(DoubleList list) {
        this(list._array.length);
        System.arraycopy(list._array, 0, this._array, 0, this._array.length);
        this._limit = list._limit;
    }

    public DoubleList(int initialCapacity, double fillvalue) {
        this._array = new double[initialCapacity];
        if (this.fillval != 0.0) {
            this.fillval = fillvalue;
            Arrays.fill(this._array, this.fillval);
        }
        this._limit = 0;
    }

    public void add(int index, double value) {
        if (index > this._limit) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this._limit) {
            this.add(value);
        } else {
            if (this._limit == this._array.length) {
                this.growArray(this._limit * 2);
            }
            System.arraycopy(this._array, index, this._array, index + 1, this._limit - index);
            this._array[index] = value;
            ++this._limit;
        }
    }

    public boolean add(double value) {
        if (this._limit == this._array.length) {
            this.growArray(this._limit * 2);
        }
        this._array[this._limit++] = value;
        return true;
    }

    public boolean addAll(DoubleList c) {
        if (c._limit != 0) {
            if (this._limit + c._limit > this._array.length) {
                this.growArray(this._limit + c._limit);
            }
            System.arraycopy(c._array, 0, this._array, this._limit, c._limit);
            this._limit += c._limit;
        }
        return true;
    }

    public boolean addAll(int index, DoubleList c) {
        if (index > this._limit) {
            throw new IndexOutOfBoundsException();
        }
        if (c._limit != 0) {
            if (this._limit + c._limit > this._array.length) {
                this.growArray(this._limit + c._limit);
            }
            System.arraycopy(this._array, index, this._array, index + c._limit, this._limit - index);
            System.arraycopy(c._array, 0, this._array, index, c._limit);
            this._limit += c._limit;
        }
        return true;
    }

    public void clear() {
        this._limit = 0;
    }

    public boolean contains(double o) {
        boolean rval = false;
        for (int j = 0; !rval && j < this._limit; ++j) {
            if (this._array[j] != o) continue;
            rval = true;
        }
        return rval;
    }

    public boolean containsAll(DoubleList c) {
        boolean rval = true;
        if (this != c) {
            for (int j = 0; rval && j < c._limit; ++j) {
                if (this.contains(c._array[j])) continue;
                rval = false;
            }
        }
        return rval;
    }

    public boolean equals(Object o) {
        boolean rval;
        boolean bl = rval = this == o;
        if (!rval && o != null && o.getClass() == this.getClass()) {
            DoubleList other = (DoubleList)o;
            if (other._limit == this._limit) {
                rval = true;
                for (int j = 0; rval && j < this._limit; ++j) {
                    rval = this._array[j] == other._array[j];
                }
            }
        }
        return rval;
    }

    public double get(int index) {
        if (index >= this._limit) {
            throw new IndexOutOfBoundsException();
        }
        return this._array[index];
    }

    public int hashCode() {
        return Arrays.hashCode(this._array);
    }

    public int indexOf(double o) {
        int rval;
        for (rval = 0; rval < this._limit && o != this._array[rval]; ++rval) {
        }
        if (rval == this._limit) {
            rval = -1;
        }
        return rval;
    }

    public boolean isEmpty() {
        return this._limit == 0;
    }

    public int lastIndexOf(double o) {
        int rval;
        for (rval = this._limit - 1; rval >= 0 && o != this._array[rval]; --rval) {
        }
        return rval;
    }

    public double remove(int index) {
        if (index >= this._limit) {
            throw new IndexOutOfBoundsException();
        }
        double rval = this._array[index];
        System.arraycopy(this._array, index + 1, this._array, index, this._limit - index);
        --this._limit;
        return rval;
    }

    public boolean removeValue(double o) {
        boolean rval = false;
        for (int j = 0; !rval && j < this._limit; ++j) {
            if (o != this._array[j]) continue;
            if (j + 1 < this._limit) {
                System.arraycopy(this._array, j + 1, this._array, j, this._limit - j);
            }
            --this._limit;
            rval = true;
        }
        return rval;
    }

    public boolean removeAll(DoubleList c) {
        boolean rval = false;
        for (int j = 0; j < c._limit; ++j) {
            if (!this.removeValue(c._array[j])) continue;
            rval = true;
        }
        return rval;
    }

    public boolean retainAll(DoubleList c) {
        boolean rval = false;
        int j = 0;
        while (j < this._limit) {
            if (!c.contains(this._array[j])) {
                this.remove(j);
                rval = true;
                continue;
            }
            ++j;
        }
        return rval;
    }

    public double set(int index, double element) {
        if (index >= this._limit) {
            throw new IndexOutOfBoundsException();
        }
        double rval = this._array[index];
        this._array[index] = element;
        return rval;
    }

    public int size() {
        return this._limit;
    }

    public double[] toArray() {
        double[] rval = new double[this._limit];
        System.arraycopy(this._array, 0, rval, 0, this._limit);
        return rval;
    }

    public double[] toArray(double[] a) {
        double[] rval;
        if (a.length == this._limit) {
            System.arraycopy(this._array, 0, a, 0, this._limit);
            rval = a;
        } else {
            rval = this.toArray();
        }
        return rval;
    }

    private void growArray(int new_size) {
        int size = new_size == this._array.length ? new_size + 1 : new_size;
        double[] new_array = new double[size];
        if (this.fillval != 0.0) {
            Arrays.fill(new_array, this._array.length, new_array.length, this.fillval);
        }
        System.arraycopy(this._array, 0, new_array, 0, this._limit);
        this._array = new_array;
    }

    public DoubleStream stream() {
        return Arrays.stream(this._array, 0, this._limit);
    }

    public void replaceAll(DoubleUnaryOperator operator) {
        Objects.requireNonNull(operator);
        for (int i = 0; i < this._limit; ++i) {
            this._array[i] = operator.applyAsDouble(this._array[i]);
        }
    }

    public void sort() {
        Arrays.sort(this._array, 0, this._limit);
    }

    public Spliterator.OfDouble spliterator() {
        return Arrays.spliterator(this._array, 0, this._limit);
    }

    public boolean removeIf(DoublePredicate filter) {
        Objects.requireNonNull(filter);
        boolean removed = false;
        int i = 0;
        while (i < this._limit) {
            if (filter.test(this._array[i])) {
                this.remove(i);
                removed = true;
                continue;
            }
            ++i;
        }
        return removed;
    }

    public void forEach(DoubleConsumer action) {
        Objects.requireNonNull(action);
        for (int i = 0; i < this._limit; ++i) {
            action.accept(this._array[i]);
        }
    }
}

