/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo.spectrum;

import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.modelling.arima.tramo.spectrum.Peaks;
import ec.tstoolkit.modelling.arima.tramo.spectrum.PeaksEnum;
import ec.tstoolkit.modelling.arima.tramo.spectrum.TPeaks;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsFrequency;

public class Spect {
    public static PeaksEnum[] SpectrumComputation(TsData serie) {
        PeaksEnum[] RetVal = new PeaksEnum[7];
        double prob1 = 0.99;
        double prob2 = 0.95;
        if (serie.getLength() >= 80 || serie.getFrequency() != TsFrequency.Monthly && serie.getLength() >= 60) {
            Peaks pkar = new Peaks(serie, 120, false);
            DescriptiveStatistics bs = new DescriptiveStatistics(serie);
            TsData targetS = serie.minus(bs.getAverage());
            TPeaks pkt = new TPeaks(targetS);
            PeaksEnum.AR ar = pkar.getTDPeaks()[0] >= prob1 ? PeaksEnum.AR.A : (pkar.getTDPeaks()[0] >= prob2 ? PeaksEnum.AR.a : PeaksEnum.AR.none);
            PeaksEnum.Tukey tu = pkt.getTDPeaks() >= prob1 ? PeaksEnum.Tukey.T : (pkt.getTDPeaks() >= prob2 ? PeaksEnum.Tukey.t : PeaksEnum.Tukey.none);
            RetVal[6] = new PeaksEnum(ar, tu);
            for (int i = 0; i < RetVal.length - 1; ++i) {
                ar = pkar.getSPeaks()[i] >= prob1 ? PeaksEnum.AR.A : (pkar.getSPeaks()[i] >= prob2 ? PeaksEnum.AR.a : PeaksEnum.AR.none);
                tu = pkt.getSPeaks()[i] >= prob1 ? PeaksEnum.Tukey.T : (pkt.getSPeaks()[i] >= prob2 ? PeaksEnum.Tukey.t : PeaksEnum.Tukey.none);
                RetVal[i] = new PeaksEnum(ar, tu);
            }
        } else {
            for (int i = 0; i < RetVal.length; ++i) {
                RetVal[i] = new PeaksEnum(PeaksEnum.AR.undef, PeaksEnum.Tukey.undef);
            }
        }
        return RetVal;
    }

    public static boolean SeasSpectCrit(PeaksEnum[] peaks, TsFrequency freq) {
        boolean retVal = false;
        int ip = 0;
        int id = 0;
        if (freq == TsFrequency.Quarterly) {
            if (peaks.length < 3) {
                return retVal;
            }
            for (int i = 0; i < 2; ++i) {
                if (peaks[i].equals(PeaksEnum.NONE) || peaks[i].equals(PeaksEnum.UNDEF)) continue;
                ++ip;
            }
            retVal = !peaks[2].equals(PeaksEnum.NONE) && !peaks[2].equals(PeaksEnum.UNDEF) ? true : ip == 2;
        } else {
            if (peaks.length < 6) {
                return retVal;
            }
            for (int i = 0; i < 6; ++i) {
                if (peaks[i].equals(PeaksEnum.ALL)) {
                    ++ip;
                    ++id;
                    continue;
                }
                if (peaks[i].equals(PeaksEnum.NONE)) continue;
                ++ip;
            }
            switch (ip) {
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    retVal = true;
                    break;
                }
                case 2: {
                    if (peaks[5].ar.isPresent() && peaks[5].tu.isPresent()) {
                        if (id != 2) break;
                        retVal = true;
                        break;
                    }
                    if (!peaks[5].equals(PeaksEnum.NONE) || id != 1) break;
                    retVal = true;
                    break;
                }
                default: {
                    retVal = false;
                }
            }
        }
        return retVal;
    }

    public static boolean SeasSpectCrit2(PeaksEnum[] peaks, TsFrequency freq) {
        boolean retVal = false;
        int ip = 0;
        int id = 0;
        if (freq == TsFrequency.Quarterly) {
            if (peaks.length < 3) {
                return retVal;
            }
            for (int i = 0; i < 2; ++i) {
                if (!peaks[i].equals(PeaksEnum.ALL)) continue;
                ++ip;
            }
            retVal = peaks[0].equals(PeaksEnum.ALL) ? true : ip == 2;
        } else {
            if (peaks.length < 6) {
                return retVal;
            }
            for (int i = 0; i < 6; ++i) {
                if (peaks[i].equals(PeaksEnum.ALL)) {
                    ++ip;
                    ++id;
                    continue;
                }
                if (peaks[i].ar != PeaksEnum.AR.A && peaks[i].tu != PeaksEnum.Tukey.T) continue;
                ++ip;
            }
            switch (ip) {
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    retVal = true;
                    break;
                }
                case 2: {
                    if (peaks[5].equals(PeaksEnum.ALL)) {
                        if (id != 2) break;
                        retVal = true;
                        break;
                    }
                    if (id != 1) break;
                    retVal = true;
                    break;
                }
                default: {
                    retVal = false;
                }
            }
        }
        return retVal;
    }
}

