/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima;

import ec.tstoolkit.arima.estimation.IRegArimaProcessor;
import ec.tstoolkit.arima.estimation.RegArimaEstimation;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.ReadDataBlock;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.eco.EcoException;
import ec.tstoolkit.eco.Ols;
import ec.tstoolkit.eco.RegModel;
import ec.tstoolkit.modelling.IRobustStandardDeviationComputer;
import ec.tstoolkit.modelling.arima.AbstractSingleOutlierDetector;
import ec.tstoolkit.modelling.arima.ExactSingleOutlierDetector;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.estimation.GlsSarimaMonitor;
import ec.tstoolkit.sarima.estimation.HannanRissanen;
import ec.tstoolkit.sarima.estimation.SarimaMapping;
import ec.tstoolkit.timeseries.regression.AdditiveOutlierFactory;
import ec.tstoolkit.timeseries.regression.IOutlierFactory;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.LevelShiftFactory;
import ec.tstoolkit.timeseries.regression.SeasonalOutlierFactory;
import ec.tstoolkit.timeseries.regression.TransitoryChangeFactory;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import java.util.ArrayList;
import java.util.List;

public class GeneralOutliersDetector {
    private AbstractSingleOutlierDetector<SarimaModel> m_sod;
    private RegArimaModel<SarimaModel> m_model;
    private double m_cv;
    private double m_pc = 0.12;
    private ArrayList<IOutlierVariable> m_o = new ArrayList();
    private int m_maxiter = 30;
    private int m_round;
    private IOutlierVariable m_lastremoved;
    private boolean m_mvx = true;
    private int m_n;

    public static double calcDefaultVA(int n) {
        double cv = 0.0;
        cv = n < 50 ? 3.0 : (n < 450 ? 3.0 + 0.0025 * (double)(n - 50) : 4.0);
        return cv;
    }

    public GeneralOutliersDetector() {
        this.m_sod = new ExactSingleOutlierDetector<SarimaModel>(IRobustStandardDeviationComputer.mad(50, true));
    }

    public GeneralOutliersDetector(AbstractSingleOutlierDetector<SarimaModel> sod) {
        this.m_sod = sod;
    }

    private void addOutlier(IOutlierVariable o) {
        this.m_o.add(o);
        double[] xo = new double[this.m_n];
        DataBlock XO = new DataBlock(xo);
        o.data(this.m_sod.getDomain().getStart(), XO);
        this.m_model.addX(XO);
        this.m_sod.exclude(o);
    }

    public void addOutlierFactory(IOutlierFactory o) {
        this.m_sod.addOutlierFactory(o);
    }

    public void clear() {
        this.m_o.clear();
        this.m_lastremoved = null;
        this.m_model = null;
    }

    public void clearOutlierFactories() {
        this.m_sod.clearOutlierFactories();
    }

    public boolean continueProcessing() {
        double cv = Math.max(2.8, this.m_cv - this.m_cv * this.m_pc);
        if (cv == this.m_cv) {
            return false;
        }
        this.m_cv = cv;
        return this.execute();
    }

    public boolean continueProcessing(double cv) {
        this.m_cv = cv;
        return this.execute();
    }

    private IRegArimaProcessor<SarimaModel> estimator() {
        GlsSarimaMonitor est = new GlsSarimaMonitor();
        est.setPrecision(1.0E-7);
        return est;
    }

    private boolean execute() {
        boolean changed = false;
        double max = 0.0;
        this.m_round = 0;
        this.initmodel();
        while (Math.abs(max = this.m_sod.getMaxTStat()) > this.m_cv) {
            ++this.m_round;
            IOutlierVariable o = this.m_sod.getMaxOutlier();
            this.addOutlier(o);
            this.reestimatemodel();
            changed = true;
            if (this.m_round < this.m_maxiter) continue;
        }
        while (this.verifymodel(this.m_cv) == 0) {
            this.reestimatemodel();
        }
        return changed;
    }

    public double getCriticalValue() {
        return this.m_cv;
    }

    public RegArimaModel<SarimaModel> getModel() {
        return this.m_model;
    }

    public int getOutlierFactoriesCount() {
        return this.m_sod.getOutlierFactoriesCount();
    }

    public int getOutliersCount() {
        return this.m_o.size();
    }

    public double getPctReduction() {
        return this.m_pc;
    }

    private void initmodel() {
        RegModel dmodel = this.m_model.getDModel();
        ConcentratedLikelihood ll = null;
        if (!this.m_mvx) {
            Ols ols;
            DataBlock yc = dmodel.getY();
            if (this.m_model.getVarsCount() > 0 && (ols = new Ols()).process(dmodel)) {
                yc = dmodel.calcRes(new ReadDataBlock(ols.getLikelihood().getB()));
            }
            SarimaModel mb = null;
            HannanRissanen hr = new HannanRissanen();
            hr.process(yc, this.m_model.getArma().getSpecification().doStationary());
            mb = hr.getModel();
            boolean unstable = SarimaMapping.stabilize(mb);
            if (!unstable) {
                this.m_model.getArima().setParameters(mb.getParameters());
                this.m_sod.process(this.m_model);
                ll = this.m_model.computeLikelihood();
            }
        }
        if (ll == null) {
            IRegArimaProcessor<SarimaModel> est = this.estimator();
            RegArimaEstimation<SarimaModel> rslt = est.optimize(this.m_model);
            if (rslt == null) {
                throw new EcoException();
            }
            this.m_model = rslt.model;
            ll = rslt.likelihood;
            if (ll == null) {
                throw new EcoException();
            }
            this.m_sod.process(this.m_model);
        }
    }

    public boolean isEML() {
        return this.m_mvx;
    }

    public boolean isInitialized() {
        return this.m_model != null;
    }

    public IOutlierVariable outlier(int i) {
        return this.m_o.get(i);
    }

    public List<IOutlierVariable> outliers() {
        return this.m_o;
    }

    public void prepare(TsDomain domain, TsDomain edomain) {
        this.m_sod.prepare(domain, edomain);
    }

    public boolean process(RegArimaModel<SarimaModel> model) {
        this.clear();
        this.m_model = model.clone();
        this.m_sod.exclude(model.getMissings());
        this.m_n = this.m_model.getObsCount();
        if (this.m_cv == 0.0) {
            this.m_cv = GeneralOutliersDetector.calcDefaultVA(this.m_n);
        }
        return this.execute();
    }

    private void reestimatemodel() {
        if (this.m_mvx) {
            IRegArimaProcessor<SarimaModel> est = this.estimator();
            RegArimaEstimation<SarimaModel> rslt = est.optimize(this.m_model);
            if (rslt == null) {
                throw new EcoException();
            }
            this.m_model = rslt.model;
            this.m_sod.process(this.m_model);
        } else {
            RegModel dmodel = this.m_model.getDModel();
            DataBlock yc = dmodel.getY();
            if (this.m_model.getVarsCount() > 0) {
                yc = dmodel.calcRes(new ReadDataBlock(this.m_model.computeLikelihood().getB()));
            }
            HannanRissanen hr = new HannanRissanen();
            hr.process(yc, this.m_model.getArma().getSpecification().doStationary());
            SarimaModel mb = hr.getModel();
            if (!SarimaMapping.stabilize(mb)) {
                this.m_model.getArima().setParameters(mb.getParameters());
                this.m_sod.process(this.m_model);
            }
        }
    }

    private void removeOutlier(int idx) {
        int opos = this.m_model.getXCount() - this.m_o.size() + idx;
        this.m_model.removeX(opos);
        this.m_o.remove(idx);
    }

    public void setAll() {
        this.clear();
        this.clearOutlierFactories();
        this.addOutlierFactory(new AdditiveOutlierFactory());
        LevelShiftFactory lfac = new LevelShiftFactory();
        lfac.setZeroEnded(true);
        this.addOutlierFactory(lfac);
        this.addOutlierFactory(new TransitoryChangeFactory());
        SeasonalOutlierFactory sfac = new SeasonalOutlierFactory();
        sfac.setZeroEnded(true);
        this.addOutlierFactory(sfac);
    }

    public void setCriticalValue(double value) {
        this.m_cv = value;
    }

    public void setDefault() {
        this.clear();
        this.clearOutlierFactories();
        this.addOutlierFactory(new AdditiveOutlierFactory());
        this.addOutlierFactory(new LevelShiftFactory());
        this.addOutlierFactory(new TransitoryChangeFactory());
        this.m_cv = 0.0;
    }

    public void setPctReduction(double value) {
        this.m_pc = value;
    }

    public void useEML(boolean value) {
        this.m_mvx = value;
    }

    private int verifymodel(double cv) {
        if (this.m_model == null) {
            return 1;
        }
        if (this.m_o.isEmpty()) {
            return 1;
        }
        int imin = 0;
        double[] t = this.m_model.computeLikelihood().getTStats(true, this.m_model.getArma().getParametersCount());
        int nx0 = this.m_model.getVarsCount() - this.m_o.size();
        for (int i = 1; i < this.m_o.size(); ++i) {
            if (!(Math.abs(t[i + nx0]) < Math.abs(t[imin + nx0]))) continue;
            imin = i;
        }
        if (Math.abs(t[nx0 + imin]) >= cv) {
            return 1;
        }
        IOutlierVariable toremoved = this.m_o.get(imin);
        this.removeOutlier(imin);
        if (this.m_lastremoved != null && toremoved.getPosition().equals((Object)this.m_lastremoved.getPosition()) && toremoved.getOutlierType() == this.m_lastremoved.getOutlierType()) {
            return -1;
        }
        this.m_lastremoved = toremoved;
        return 0;
    }
}

