/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.maths.matrices.Householder;
import ec.tstoolkit.maths.matrices.LowerTriangularMatrix;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.maths.matrices.SubMatrix;

public final class SymmetricMatrix {
    public static void fromLower(Matrix m) {
        double[] data = m.data_;
        int n = m.nrows_;
        int c = 0;
        int id = 0;
        while (c < n) {
            int il = id;
            int iu = id;
            for (int r = c + 1; r < n; ++r) {
                data[iu += n] = data[++il];
            }
            ++c;
            id += n + 1;
        }
    }

    public static void fromLower(SubMatrix m) throws MatrixException {
        double[] data = m.m_data;
        int n = m.m_nrows;
        if (n != m.m_ncols) {
            throw new MatrixException("m_err_square");
        }
        int ddel = m.m_row_inc + m.m_col_inc;
        int c = 0;
        int id = m.m_start;
        while (c < n) {
            int il = id;
            int iu = id;
            for (int r = c + 1; r < n; ++r) {
                data[iu += m.m_col_inc] = data[il += m.m_row_inc];
            }
            ++c;
            id += ddel;
        }
    }

    public static void fromUpper(Matrix m) {
        double[] data = m.data_;
        int n = m.nrows_;
        int c = 0;
        int id = 0;
        while (c < n) {
            int il = id;
            int iu = id;
            for (int r = c + 1; r < n; ++r) {
                data[++il] = data[iu += n];
            }
            ++c;
            id += n + 1;
        }
    }

    public static void fromUpper(SubMatrix m) throws MatrixException {
        double[] data = m.m_data;
        int n = m.m_nrows;
        if (n != m.m_ncols) {
            throw new MatrixException("m_err_square");
        }
        int ddel = m.m_row_inc + m.m_col_inc;
        int c = 0;
        int id = m.m_start;
        while (c < n) {
            int il = id;
            int iu = id;
            for (int r = c + 1; r < n; ++r) {
                data[il += m.m_row_inc] = data[iu += m.m_col_inc];
            }
            ++c;
            id += ddel;
        }
    }

    public static Matrix inverse(Matrix s) throws MatrixException {
        try {
            Matrix lower = s.clone();
            SymmetricMatrix.lcholesky(lower);
            lower = LowerTriangularMatrix.inverse(lower);
            return SymmetricMatrix.XtX(lower);
        }
        catch (MatrixException e) {
            Householder householder = new Householder(true);
            householder.decompose(s);
            return householder.inverse();
        }
    }

    public static boolean isDPos(Matrix m, boolean useM) {
        if (!useM) {
            m = m.clone();
        }
        double[] data = m.data_;
        int n = m.nrows_;
        int i = 0;
        int idiag = 0;
        while (i < n) {
            double aii = data[idiag];
            for (int j = i; j < idiag; j += n) {
                double x = data[j];
                aii -= x * x;
            }
            if (aii <= 0.0) {
                return false;
            }
            data[idiag] = aii = Math.sqrt(aii);
            int ymax = (i + 1) * n;
            for (int jx = i; jx < idiag; jx += n) {
                double temp = data[jx];
                if (temp == 0.0) continue;
                int ia = jx + 1;
                int iy = idiag + 1;
                while (iy < ymax) {
                    int n2 = iy++;
                    data[n2] = data[n2] - temp * data[ia];
                    ++ia;
                }
            }
            int iy = idiag + 1;
            while (iy < ymax) {
                int n3 = iy++;
                data[n3] = data[n3] / aii;
            }
            ++i;
            idiag += n + 1;
        }
        return true;
    }

    public static boolean isSymmetric(Matrix m, double eps) {
        double[] data = m.data_;
        int n = m.nrows_;
        int c = 0;
        int id = 0;
        while (c < n) {
            int il = id;
            int iu = id;
            for (int r = c + 1; r < n; ++r) {
                if (!(Math.abs(data[++il] - data[iu += n]) > eps)) continue;
                return false;
            }
            ++c;
            id += n + 1;
        }
        return true;
    }

    public static void lcholesky(Matrix m) {
        double[] data = m.data_;
        int n = m.nrows_;
        int i = 0;
        int idiag = 0;
        while (i < n) {
            double aii = data[idiag];
            for (int j = i; j < idiag; j += n) {
                double x = data[j];
                aii -= x * x;
            }
            if (aii <= 0.0) {
                throw new MatrixException("m_err_chol");
            }
            data[idiag] = aii = Math.sqrt(aii);
            int ymax = (i + 1) * n;
            for (int jx = i; jx < idiag; jx += n) {
                double temp = data[jx];
                if (temp == 0.0) continue;
                int ia = jx + 1;
                int iy = idiag + 1;
                while (iy < ymax) {
                    int n2 = iy++;
                    data[n2] = data[n2] - temp * data[ia];
                    ++ia;
                }
            }
            int iy = idiag + 1;
            while (iy < ymax) {
                int n3 = iy++;
                data[n3] = data[n3] / aii;
            }
            ++i;
            idiag += n + 1;
        }
        m.toLower();
    }

    public static void lcholesky(Matrix m, double Zero) {
        double[] data = m.data_;
        int n = m.nrows_;
        int i = 0;
        int idiag = 0;
        while (i < n) {
            int iy;
            int iy2;
            int ia;
            double temp;
            int jx;
            int ymax;
            double aii = data[idiag];
            for (int j = i; j < idiag; j += n) {
                double x = data[j];
                aii -= x * x;
            }
            if (aii < -Zero) {
                throw new MatrixException("m_err_chol");
            }
            if (aii <= Zero) {
                data[idiag] = 0.0;
                ymax = (i + 1) * n;
                for (jx = i; jx < idiag; jx += n) {
                    temp = data[jx];
                    if (temp == 0.0) continue;
                    ia = jx + 1;
                    iy2 = idiag + 1;
                    while (iy2 < ymax) {
                        int n2 = iy2++;
                        data[n2] = data[n2] - temp * data[ia];
                        ++ia;
                    }
                }
                for (iy = idiag + 1; iy < ymax; ++iy) {
                    if (Math.abs(data[iy]) > Zero) {
                        throw new MatrixException("m_err_chol");
                    }
                    data[iy] = 0.0;
                }
            } else {
                data[idiag] = aii = Math.sqrt(aii);
                ymax = (i + 1) * n;
                for (jx = i; jx < idiag; jx += n) {
                    temp = data[jx];
                    if (temp == 0.0) continue;
                    ia = jx + 1;
                    iy2 = idiag + 1;
                    while (iy2 < ymax) {
                        int n3 = iy2++;
                        data[n3] = data[n3] - temp * data[ia];
                        ++ia;
                    }
                }
                iy = idiag + 1;
                while (iy < ymax) {
                    int n4 = iy++;
                    data[n4] = data[n4] / aii;
                }
            }
            ++i;
            idiag += n + 1;
        }
        m.toLower();
    }

    public static Matrix LLt(Matrix lower) throws MatrixException {
        int n = lower.getRowsCount();
        double[] pl = lower.data_;
        Matrix O = new Matrix(n, n);
        double[] po = O.data_;
        int i = 0;
        int idiag = 0;
        int omax = n;
        while (i < n) {
            for (int l = i; l <= idiag; l += n) {
                double x = pl[l];
                int o = idiag;
                int q = l;
                while (o < omax) {
                    int n2 = o++;
                    po[n2] = po[n2] + pl[q] * x;
                    ++q;
                }
            }
            ++i;
            idiag += n + 1;
            omax += n;
        }
        SymmetricMatrix.fromLower(O);
        return O;
    }

    public static double quadraticForm(Matrix S, DataBlock x) {
        double[] pm = S.data_;
        double[] px = x.getData();
        int x0 = x.getStartPosition();
        int x1 = x.getEndPosition();
        int xinc = x.getIncrement();
        int cinc = S.nrows_;
        double s = 0.0;
        int ic = 0;
        int id = 0;
        int ix = x0;
        while (ix != x1) {
            double xi = px[ix];
            double z = pm[id] * xi;
            int ir = ic;
            for (int jx = x0; jx < ix; jx += xinc) {
                z += 2.0 * pm[ir] * px[jx];
                ++ir;
            }
            s += z * xi;
            ix += xinc;
            id += 1 + cinc;
            ic += cinc;
        }
        return s;
    }

    public static double quadraticForm(Matrix s, double[] x) {
        double n = s.getRowsCount();
        double w = 0.0;
        double[] data = s.data_;
        int c = 0;
        int i = 0;
        while ((double)c < n) {
            double z = 0.0;
            int r = 0;
            while ((double)r < n) {
                z += data[i] * x[r];
                ++r;
                ++i;
            }
            w += z * x[c];
            ++c;
        }
        return w;
    }

    public static Matrix quadraticForm(Matrix s, Matrix x) {
        int nc = x.getColumnsCount();
        Matrix SX = s.times(x);
        DataBlockIterator rows = x.columns();
        DataBlockIterator cols = SX.columns();
        Matrix o = new Matrix(nc, nc);
        int idx = 0;
        int c = 0;
        do {
            idx += c;
            rows.setPosition(c++);
            DataBlock col = cols.getData();
            DataBlock row = rows.getData();
            do {
                o.data_[idx++] = row.dot(col);
            } while (rows.next());
        } while (cols.next());
        SymmetricMatrix.fromLower(o);
        return o;
    }

    public static double quadraticForm(SubMatrix M, DataBlock x) {
        double[] pm = M.m_data;
        double[] px = x.getData();
        int x0 = x.getStartPosition();
        int x1 = x.getEndPosition();
        int xinc = x.getIncrement();
        int m0 = M.m_start;
        int rinc = M.m_row_inc;
        int cinc = M.m_col_inc;
        double s = 0.0;
        int ic = m0;
        int id = m0;
        int ix = x0;
        while (ix != x1) {
            double xi = px[ix];
            double z = pm[id] * xi;
            int ir = ic;
            for (int jx = x0; jx < ix; jx += xinc) {
                z += 2.0 * pm[ir] * px[jx];
                ir += rinc;
            }
            s += z * xi;
            ix += xinc;
            id += rinc + cinc;
            ic += cinc;
        }
        return s;
    }

    public static Matrix quadraticForm(SubMatrix s, SubMatrix x) throws MatrixException {
        int n = s.getRowsCount();
        int nc = x.getColumnsCount();
        Matrix SX = new Matrix(n, nc);
        SX.all().product(s, x);
        DataBlockIterator rows = x.columns();
        DataBlockIterator cols = SX.columns();
        Matrix o = new Matrix(nc, nc);
        int idx = 0;
        int c = 0;
        DataBlock col = cols.getData();
        DataBlock row = rows.getData();
        do {
            idx += c;
            rows.setPosition(c++);
            do {
                o.data_[idx++] = row.dot(col);
            } while (rows.next());
        } while (cols.next());
        SymmetricMatrix.fromLower(o);
        return o;
    }

    public static void quadraticForm(SubMatrix s, SubMatrix x, SubMatrix xtsx) throws MatrixException {
        int n = s.getRowsCount();
        int nc = x.getColumnsCount();
        Matrix SX = new Matrix(n, nc);
        SX.all().product(s, x);
        DataBlockIterator rows = x.columns();
        DataBlockIterator cols = SX.columns();
        DataBlockIterator xcols = xtsx.columns();
        DataBlock col = cols.getData();
        DataBlock xcol = xcols.getData();
        DataBlock cur = rows.getData();
        int c = 0;
        do {
            int idx = c;
            rows.setPosition(c++);
            do {
                xcol.set(idx++, cur.dot(col));
            } while (rows.next());
        } while (cols.next() && xcols.next());
        SymmetricMatrix.fromLower(xtsx);
    }

    public static Matrix quadraticFormT(Matrix s, Matrix x) throws MatrixException {
        int nr = x.getRowsCount();
        Matrix XS = x.times(s);
        DataBlockIterator rows = XS.rows();
        DataBlockIterator cols = x.rows();
        Matrix o = new Matrix(nr, nr);
        int idx = 0;
        int c = 0;
        DataBlock col = cols.getData();
        DataBlock row = rows.getData();
        do {
            idx += c;
            rows.setPosition(c++);
            do {
                o.data_[idx++] = row.dot(col);
            } while (rows.next());
        } while (cols.next());
        SymmetricMatrix.fromLower(o);
        return o;
    }

    public static Matrix quadraticFormT(SubMatrix s, SubMatrix x) throws MatrixException {
        int n = s.getRowsCount();
        int nr = x.getRowsCount();
        Matrix XS = new Matrix(nr, n);
        XS.all().product(x, s);
        DataBlockIterator rows = XS.rows();
        DataBlockIterator cols = x.rows();
        Matrix o = new Matrix(nr, nr);
        int idx = 0;
        int c = 0;
        DataBlock col = cols.getData();
        DataBlock row = rows.getData();
        do {
            idx += c;
            rows.setPosition(c++);
            do {
                o.data_[idx++] = row.dot(col);
            } while (rows.next());
        } while (cols.next());
        SymmetricMatrix.fromLower(o);
        return o;
    }

    public static void quadraticFormT(SubMatrix s, SubMatrix x, SubMatrix xsxt) throws MatrixException {
        int n = s.getRowsCount();
        int nr = x.getRowsCount();
        Matrix XS = new Matrix(nr, n);
        XS.all().product(x, s);
        DataBlockIterator rows = XS.rows();
        DataBlockIterator cols = x.rows();
        DataBlockIterator xcols = xsxt.columns();
        DataBlock col = cols.getData();
        DataBlock xcol = xcols.getData();
        DataBlock cur = rows.getData();
        int c = 0;
        do {
            int idx = c;
            rows.setPosition(c++);
            do {
                xcol.set(idx++, cur.dot(col));
            } while (rows.next());
        } while (cols.next() && xcols.next());
        SymmetricMatrix.fromLower(xsxt);
    }

    public static void rcumul(Matrix m) {
        int cmin;
        double[] data = m.data_;
        int n = m.nrows_;
        int cur = n * n - 1;
        for (cmin = n * (n - 1); cmin >= 0; cmin -= n) {
            while (--cur >= cmin) {
                int n2 = cur;
                data[n2] = data[n2] + data[cur + 1];
            }
        }
        int cmax = n * n - 1;
        int c = 0;
        while (++c < n) {
            cmin = --cmax - c * n;
            for (int i = cmax; i > cmin; i -= n) {
                int n3 = i - n;
                data[n3] = data[n3] + data[i];
            }
        }
        SymmetricMatrix.fromUpper(m);
    }

    public static void rcumul(Matrix m, double delta) {
        int cmin;
        double[] data = m.data_;
        int n = m.nrows_;
        int cur = n * n - 1;
        for (cmin = n * (n - 1); cmin >= 0; cmin -= n) {
            while (--cur >= cmin) {
                int n2 = cur;
                data[n2] = data[n2] + delta * data[cur + 1];
            }
        }
        int cmax = n * n - 1;
        int c = 0;
        while (++c < n) {
            cmin = --cmax - c * n;
            for (int i = cmax; i > cmin; i -= n) {
                int n3 = i - n;
                data[n3] = data[n3] + delta * data[i];
            }
        }
        SymmetricMatrix.fromUpper(m);
    }

    public static void rcumul(Matrix m, double delta, int lag) {
        double[] data = m.data_;
        int n = m.nrows_;
        int imax = n * n - 1;
        int jmax = n * (n - 1) + lag;
        while (imax > 0) {
            for (int j = imax; j >= jmax; j -= lag) {
                int n2 = j - lag;
                data[n2] = data[n2] + delta * data[j];
            }
            imax -= n;
            jmax -= n;
        }
        int cmax = n * n - 1;
        int c = 0;
        int dlag = lag * n;
        while (++c < n) {
            int cmin = --cmax - c * n;
            for (int i = cmax - dlag; i >= cmin; i -= dlag) {
                int n3 = i;
                data[n3] = data[n3] + delta * data[i + dlag];
            }
        }
        SymmetricMatrix.fromUpper(m);
    }

    public static void rcumul(Matrix m, int lag) {
        double[] data = m.data_;
        int n = m.nrows_;
        int imax = n * n - 1;
        int jmax = n * (n - 1) + lag;
        while (imax > 0) {
            for (int j = imax; j >= jmax; j -= lag) {
                int n2 = j - lag;
                data[n2] = data[n2] + data[j];
            }
            imax -= n;
            jmax -= n;
        }
        int cmax = n * n - 1;
        int c = 0;
        int dlag = lag * n;
        while (++c < n) {
            int cmin = --cmax - c * n;
            for (int i = cmax - dlag; i >= cmin; i -= dlag) {
                int n3 = i;
                data[n3] = data[n3] + data[i + dlag];
            }
        }
        SymmetricMatrix.fromUpper(m);
    }

    public static void reinforceSymmetry(Matrix m) throws MatrixException {
        double[] data = m.data_;
        int n = m.nrows_;
        if (n != m.ncols_) {
            throw new MatrixException("m_err_square");
        }
        int c = 0;
        int id = 0;
        while (c < n) {
            int il = id;
            int iu = id;
            for (int r = c + 1; r < n; ++r) {
                double q;
                data[iu += n] = q = (data[iu] + data[++il]) / 2.0;
                data[il] = q;
            }
            ++c;
            id += n + 1;
        }
    }

    public static void reinforceSymmetry(SubMatrix m) {
        int n = m.m_nrows;
        for (int i = 0; i < n - 1; ++i) {
            DataBlock r = m.row(i).drop(i + 1, 0);
            DataBlock c = m.column(i).drop(i + 1, 0);
            c.add(r);
            c.mul(0.5);
            r.copy(c);
        }
    }

    public static void ucholesky(Matrix s) throws MatrixException {
        double[] data = s.data_;
        int n = s.nrows_;
        int ymax = data.length;
        int i = 0;
        int idiag = 0;
        while (i < n) {
            double aii = data[idiag];
            for (int j = i * n; j < idiag; ++j) {
                double x = data[j];
                aii -= x * x;
            }
            if (aii <= 0.0) {
                throw new MatrixException("m_err_chol");
            }
            data[idiag] = aii = Math.sqrt(aii);
            for (int jx = i * n; jx < idiag; ++jx) {
                double temp = data[jx];
                if (temp == 0.0) continue;
                int ia = jx + n;
                for (int iy = idiag + n; iy < ymax; iy += n) {
                    int n2 = iy;
                    data[n2] = data[n2] - temp * data[ia];
                    ia += n;
                }
            }
            for (int iy = idiag + n; iy < ymax; iy += n) {
                int n3 = iy;
                data[n3] = data[n3] / aii;
            }
            ++i;
            idiag += n + 1;
        }
        s.toUpper();
    }

    public static Matrix UtU(Matrix upper) {
        int n = upper.getRowsCount();
        double[] pu = upper.data_;
        Matrix O = new Matrix(n, n);
        double[] po = O.data_;
        int umax = pu.length;
        int i = 0;
        int j = 0;
        while (i < n) {
            int idiag = j + i;
            for (int u = j; u < umax; u += n) {
                double x = 0.0;
                int o = j;
                int p = u;
                while (o <= idiag) {
                    x += pu[p] * pu[o];
                    ++o;
                    ++p;
                }
                po[u + i] = x;
            }
            ++i;
            j += n;
        }
        SymmetricMatrix.fromUpper(O);
        return O;
    }

    public static Matrix XpXt(Matrix x) {
        Matrix o = x.clone();
        o.all().add(x.all().transpose());
        return o;
    }

    public static void XpXt(SubMatrix m, SubMatrix o) {
        o.sum(m, m.transpose());
    }

    public static Matrix XtX(Matrix x) throws MatrixException {
        int n = x.getColumnsCount();
        DataBlockIterator rows = x.columns();
        DataBlockIterator cols = x.columns();
        Matrix o = new Matrix(n, n);
        int idx = 0;
        int c = 0;
        DataBlock col = cols.getData();
        DataBlock row = rows.getData();
        do {
            idx += c;
            rows.setPosition(c++);
            do {
                o.data_[idx++] = row.dot(col);
            } while (rows.next());
        } while (cols.next());
        SymmetricMatrix.fromLower(o);
        return o;
    }

    public static void XtX(SubMatrix x, SubMatrix m) {
        DataBlockIterator rows = x.columns();
        DataBlockIterator cols = x.columns();
        DataBlockIterator rcols = m.columns();
        int c = 0;
        DataBlock col = cols.getData();
        DataBlock rcol = rcols.getData();
        DataBlock cur = rows.getData();
        do {
            int idx = c;
            rows.setPosition(c++);
            do {
                rcol.set(idx++, cur.dot(col));
            } while (rows.next());
        } while (cols.next() && rcols.next());
        SymmetricMatrix.fromLower(m);
    }

    public static Matrix XXt(Matrix x) throws MatrixException {
        int n = x.getRowsCount();
        DataBlockIterator rows = x.rows();
        DataBlockIterator cols = x.rows();
        Matrix o = new Matrix(n, n);
        int idx = 0;
        int c = 0;
        DataBlock col = cols.getData();
        DataBlock row = rows.getData();
        do {
            idx += c;
            rows.setPosition(c++);
            do {
                o.data_[idx++] = row.dot(col);
            } while (rows.next());
        } while (cols.next());
        SymmetricMatrix.fromLower(o);
        return o;
    }

    public static void XXt(SubMatrix x, SubMatrix m) {
        DataBlockIterator rows = x.rows();
        DataBlockIterator cols = x.rows();
        DataBlockIterator rcols = m.columns();
        int c = 0;
        DataBlock col = cols.getData();
        DataBlock rcol = rcols.getData();
        DataBlock cur = rows.getData();
        do {
            int idx = c;
            rows.setPosition(c++);
            do {
                rcol.set(idx++, cur.dot(col));
            } while (rows.next());
        } while (cols.next() && rcols.next());
        SymmetricMatrix.fromLower(m);
    }

    public static void addXaXt(Matrix S, double a, DataBlock x) {
        if (a == 0.0) {
            return;
        }
        double[] s = S.data_;
        double[] z = x.getData();
        int n = S.ncols_;
        int beg = x.getStartPosition();
        int inc = x.getIncrement();
        if (inc == 1) {
            int c = 0;
            int k = 0;
            int l = beg;
            while (c < n) {
                double x1 = z[l];
                if (x1 != 0.0) {
                    x1 *= a;
                    int r = c;
                    int m = l;
                    while (r < n) {
                        int n2 = k++;
                        s[n2] = s[n2] + x1 * z[m];
                        ++r;
                        ++m;
                    }
                } else {
                    k += n - c;
                }
                k += ++c;
                ++l;
            }
        } else {
            int c = 0;
            int k = 0;
            int l = beg;
            while (c < n) {
                double x1 = z[l];
                if (x1 != 0.0) {
                    x1 *= a;
                    int r = c;
                    int m = l;
                    while (r < n) {
                        int n3 = k++;
                        s[n3] = s[n3] + x1 * z[m];
                        ++r;
                        m += inc;
                    }
                } else {
                    k += n - c;
                }
                k += ++c;
                l += inc;
            }
        }
        SymmetricMatrix.fromLower(S);
    }

    public static void rsolve(Matrix S, SubMatrix B, boolean clone) {
        Matrix Q = S;
        if (clone) {
            Q = Q.clone();
        }
        SymmetricMatrix.lcholesky(Q);
        LowerTriangularMatrix.rsolve(Q, B);
        LowerTriangularMatrix.lsolve(Q, B.transpose());
    }

    public static void lsolve(Matrix S, SubMatrix B, boolean clone) {
        Matrix Q = S;
        if (clone) {
            Q = Q.clone();
        }
        SymmetricMatrix.lcholesky(Q);
        LowerTriangularMatrix.rsolve(Q, B.transpose());
        LowerTriangularMatrix.lsolve(Q, B);
    }

    public static void solve(Matrix S, DataBlock b, boolean clone) {
        Matrix Q = S;
        if (clone) {
            Q = Q.clone();
        }
        SymmetricMatrix.lcholesky(Q);
        LowerTriangularMatrix.rsolve(Q, b);
        LowerTriangularMatrix.lsolve(Q, b);
    }

    public static void rsolve(Matrix S, DataBlock b, boolean clone) {
        Matrix Q = S;
        if (clone) {
            Q = Q.clone();
        }
        SymmetricMatrix.lcholesky(Q);
        LowerTriangularMatrix.rsolve(Q, b);
        LowerTriangularMatrix.lsolve(Q, b);
    }

    public static Matrix CCt(DataBlock x) {
        int n = x.getLength();
        Matrix m = new Matrix(n, n);
        DataBlockIterator cols = m.columns();
        DataBlock col = cols.getData();
        do {
            col.product(x, x.get(cols.getPosition()));
        } while (cols.next());
        return m;
    }

    private SymmetricMatrix() {
    }
}

