/*
 * Decompiled with CFR 0.152.
 */
package core.graph;

import core.graph.CliqueGraphEdge;
import core.graph.CliqueGraphEdgeFactory;
import core.graph.UniqueTreeSet;
import core.stats.MyPriorityQueue;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jgrapht.EdgeFactory;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.ConnectivityInspector;
import org.jgrapht.experimental.dag.DirectedAcyclicGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleGraph;

public class ChordalGraph
extends SimpleGraph<Integer, DefaultEdge>
implements UndirectedGraph<Integer, DefaultEdge> {
    public SimpleGraph<BitSet, CliqueGraphEdge> cg = new SimpleGraph((EdgeFactory)CliqueGraphEdgeFactory.getInstance());
    CliqueGraphEdge[][] eligibleEdges = null;
    ArrayList<Integer> peo = null;
    ArrayList<BitSet> cliques = null;
    ArrayList<BitSet> separators = null;
    private static final long serialVersionUID = -1106115079865694550L;

    public ChordalGraph() {
        super(DefaultEdge.class);
    }

    public boolean isEdgeRemovable(Integer vertex1, Integer vertex2) {
        if (this.containsEdge(vertex1, vertex2) || this.containsEdge(vertex2, vertex1)) {
            int numberCliquesContainingBoth = 0;
            for (BitSet clique : this.cg.vertexSet()) {
                if (clique.get(vertex1) && clique.get(vertex2) && ++numberCliquesContainingBoth > 1) break;
            }
            return numberCliquesContainingBoth == 1;
        }
        return false;
    }

    public void initStructures() {
        if (this.areStructuresInitialised()) {
            return;
        }
        int nbVertices = this.vertexSet().size();
        this.eligibleEdges = new CliqueGraphEdge[nbVertices][nbVertices];
        int i = 0;
        while (i < nbVertices - 1) {
            BitSet Ci = new BitSet(nbVertices);
            Ci.set(i);
            int j = i + 1;
            while (j < nbVertices) {
                BitSet Cj = new BitSet();
                Cj.set(j);
                this.eligibleEdges[i][j] = new CliqueGraphEdge(Ci, Cj);
                this.eligibleEdges[j][i] = this.eligibleEdges[i][j];
                ++j;
            }
            ++i;
        }
        for (Integer v : this.vertexSet()) {
            BitSet clique = new BitSet();
            clique.set(v);
            this.cg.addVertex((Object)clique);
        }
    }

    private boolean areStructuresInitialised() {
        return this.eligibleEdges != null;
    }

    public boolean isEdgeAddable(Integer vertex1, Integer vertex2) {
        if (!this.areStructuresInitialised()) {
            this.initStructures();
        }
        if (this.containsEdge(vertex1, vertex2) || this.containsEdge(vertex2, vertex1)) {
            return false;
        }
        return this.eligibleEdges[vertex1][vertex2] != null;
    }

    public boolean addVertex(Integer v) {
        if (this.areStructuresInitialised()) {
            this.eligibleEdges = null;
        }
        return super.addVertex((Object)v);
    }

    public DefaultEdge addEdge(Integer vertex1, Integer vertex2) {
        if (this.isEdgeAddable(vertex1, vertex2)) {
            return this.addSecuredEdge(vertex1, vertex2);
        }
        System.err.println("Can't add edge (" + vertex1 + "," + vertex2 + "), wouldn't give a chordal graph");
        return null;
    }

    public DefaultEdge addEdgeEvenIfNotChordal(Integer sourceVertex, Integer targetVertex) {
        this.separators = null;
        this.cliques = null;
        return (DefaultEdge)super.addEdge((Object)sourceVertex, (Object)targetVertex);
    }

    public DefaultEdge removeEdge(Integer vertex1, Integer vertex2) {
        if (this.isEdgeRemovable(vertex1, vertex2)) {
            return this.removeSecuredEdge(vertex1, vertex2);
        }
        return null;
    }

    public DefaultEdge addSecuredEdge(Integer a, Integer b) {
        return this.addSecuredEdge(a, b, null, false);
    }

    public DefaultEdge addSecuredEdge(Integer a, Integer b, MyPriorityQueue pq) {
        return this.addSecuredEdge(a, b, pq, false);
    }

    public BitSet getSeparator(Integer a, Integer b) {
        if (this.eligibleEdges[a][b] == null) {
            return null;
        }
        return (BitSet)this.eligibleEdges[a.intValue()][b.intValue()].separator.clone();
    }

    public DefaultEdge removeSecuredEdge(Integer v1, Integer v2) {
        System.err.println("removing an edge in the chordal graph is not implemented yet");
        return null;
    }

    public List<BitSet> getCliques() {
        if (!this.areStructuresInitialised()) {
            this.initStructures();
        }
        return new ArrayList<BitSet>(this.cg.vertexSet());
    }

    private void computeCliquesAndSeparatorsBFS() {
        this.cliques = new ArrayList();
        this.separators = new ArrayList();
        SimpleGraph gNum = new SimpleGraph(DefaultEdge.class);
        SimpleGraph gElim = (SimpleGraph)super.clone();
        TreeMap<Integer, Integer> labels = new TreeMap<Integer, Integer>();
        for (Integer vertex : this.vertexSet()) {
            labels.put(vertex, new Integer(0));
        }
        int lambda = Integer.MAX_VALUE;
        Integer xiplus1 = null;
        while (!labels.isEmpty()) {
            int maxNumber = -1;
            Integer xi = null;
            for (Map.Entry entry : labels.entrySet()) {
                if ((Integer)entry.getValue() <= maxNumber) continue;
                xi = (Integer)entry.getKey();
                maxNumber = (Integer)entry.getValue();
            }
            gNum.addVertex(xi);
            Set gEdges = this.edgesOf(xi);
            for (DefaultEdge edge : gEdges) {
                Integer source = (Integer)this.getEdgeSource(edge);
                Integer target = (Integer)this.getEdgeTarget(edge);
                if (source.equals(xi)) {
                    if (!gNum.containsVertex((Object)target)) continue;
                    gNum.addEdge((Object)source, (Object)target);
                    continue;
                }
                if (!gNum.containsVertex((Object)source)) continue;
                gNum.addEdge((Object)source, (Object)target);
            }
            if (xiplus1 != null && maxNumber <= lambda) {
                Object target;
                Set currentEdges = gNum.edgesOf((Object)xi);
                BitSet currentNeighbours = new BitSet();
                for (DefaultEdge edge : currentEdges) {
                    Integer source = (Integer)gNum.getEdgeSource((Object)edge);
                    target = (Integer)gNum.getEdgeTarget((Object)edge);
                    if (source.equals(xi)) {
                        currentNeighbours.set((Integer)target);
                        continue;
                    }
                    currentNeighbours.set(source);
                }
                if (!currentNeighbours.isEmpty()) {
                    this.separators.add(currentNeighbours);
                }
                Set previousEdges = gNum.edgesOf((Object)xiplus1);
                BitSet previousNeighbours = new BitSet();
                target = previousEdges.iterator();
                while (target.hasNext()) {
                    DefaultEdge edge = (DefaultEdge)target.next();
                    Integer source = (Integer)gNum.getEdgeSource((Object)edge);
                    Integer target2 = (Integer)gNum.getEdgeTarget((Object)edge);
                    if (source.equals(xiplus1)) {
                        previousNeighbours.set(target2);
                        continue;
                    }
                    previousNeighbours.set(source);
                }
                previousNeighbours.set(xiplus1);
                previousNeighbours.clear(xi);
                this.cliques.add(previousNeighbours);
            }
            lambda = maxNumber;
            Set edges = gElim.edgesOf((Object)xi);
            for (DefaultEdge edge : edges) {
                Integer number;
                Integer source = (Integer)gElim.getEdgeSource((Object)edge);
                Integer target = (Integer)gElim.getEdgeTarget((Object)edge);
                if (source.equals(xi)) {
                    number = (Integer)labels.get(target);
                    labels.put(target, number + 1);
                    continue;
                }
                number = (Integer)labels.get(source);
                labels.put(source, number + 1);
            }
            gElim.removeVertex((Object)xi);
            labels.remove(xi);
            xiplus1 = xi;
        }
        Set lastEdges = this.edgesOf(xiplus1);
        BitSet lastNeighbours = new BitSet();
        for (DefaultEdge edge : lastEdges) {
            Integer source = (Integer)this.getEdgeSource(edge);
            Integer target = (Integer)this.getEdgeTarget(edge);
            if (source.equals(xiplus1)) {
                lastNeighbours.set(target);
                continue;
            }
            lastNeighbours.set(source);
        }
        lastNeighbours.set(xiplus1);
        this.cliques.add(lastNeighbours);
    }

    public List<BitSet> getSeparatorsBFS() {
        if (this.separators == null) {
            this.computeCliquesAndSeparatorsBFS();
        }
        return this.separators;
    }

    public List<BitSet> getCliquesBFS() {
        if (this.separators == null) {
            this.computeCliquesAndSeparatorsBFS();
        }
        return this.cliques;
    }

    public int getTreeWidth() {
        int maxCliqueSize = 0;
        Set cliques = this.cg.vertexSet();
        for (BitSet clique : cliques) {
            if (clique.cardinality() <= maxCliqueSize) continue;
            maxCliqueSize = clique.cardinality();
        }
        return maxCliqueSize;
    }

    public void printAvailableEdges() {
        System.out.print("\t\t");
        int j = 0;
        while (j < this.eligibleEdges.length) {
            System.out.print(String.valueOf(j) + "\t");
            ++j;
        }
        System.out.println();
        int i = 0;
        while (i < this.eligibleEdges.length) {
            System.out.print("\t" + i + "\t");
            int j2 = 0;
            while (j2 < this.eligibleEdges.length) {
                if (this.eligibleEdges[i][j2] == null) {
                    System.out.print("\t");
                } else {
                    System.out.print(String.valueOf(this.eligibleEdges[i][j2].separator.toString()) + "\t");
                }
                ++j2;
            }
            System.out.println();
            ++i;
        }
    }

    public String toString() {
        String str = super.toString();
        str = String.valueOf(str) + "\ncliques:\n";
        for (BitSet clique : this.cg.vertexSet()) {
            str = String.valueOf(str) + "\t" + clique.toString() + "\n";
        }
        str = String.valueOf(str) + "\nedges:\n";
        for (CliqueGraphEdge edge : this.cg.edgeSet()) {
            str = String.valueOf(str) + "\t" + edge.toString() + "\n";
        }
        return str;
    }

    public Object clone() {
        ChordalGraph copy = (ChordalGraph)((Object)super.clone());
        copy.cg = (SimpleGraph)this.cg.clone();
        return copy;
    }

    public SimpleGraph<BitSet, UniqueTreeSet<Integer>> getCliqueGraph() {
        return (SimpleGraph)this.cg.clone();
    }

    public DefaultEdge addSecuredEdge(Integer a, Integer b, MyPriorityQueue pq, boolean verbose) {
        int nbVertices = this.vertexSet().size();
        BitSet Ca = this.eligibleEdges[a.intValue()][b.intValue()].c1;
        BitSet Cb = this.eligibleEdges[a.intValue()][b.intValue()].c2;
        if (!Ca.get(a)) {
            BitSet tmp = Ca;
            Ca = Cb;
            Cb = tmp;
        }
        if (verbose) {
            System.out.println(a + "--" + Ca);
        }
        if (verbose) {
            System.out.println(b + "--" + Cb);
        }
        BitSet Sab = this.eligibleEdges[a.intValue()][b.intValue()].separator;
        TreeSet<Integer> SabSet = new TreeSet<Integer>();
        int i = Sab.nextSetBit(0);
        while (i >= 0) {
            SabSet.add(i);
            i = Sab.nextSetBit(i + 1);
        }
        if (verbose) {
            System.out.println("\tSab=" + Sab);
        }
        BitSet Cab = new BitSet(nbVertices);
        Cab.or(Sab);
        Cab.set(a);
        Cab.set(b);
        Set cgEdges = this.cg.edgeSet();
        SimpleGraph gMinusSabBeforeAB = (SimpleGraph)super.clone();
        gMinusSabBeforeAB.removeAllVertices(SabSet);
        ConnectivityInspector inspectorgMinusSabBeforeAB = new ConnectivityInspector((UndirectedGraph)gMinusSabBeforeAB);
        TreeSet connectedToA = new TreeSet(inspectorgMinusSabBeforeAB.connectedSetOf((Object)a));
        TreeSet connectedToB = new TreeSet(inspectorgMinusSabBeforeAB.connectedSetOf((Object)b));
        DefaultEdge addedE = (DefaultEdge)super.addEdge((Object)a, (Object)b);
        this.disableEdge(a, b, pq, verbose);
        SimpleGraph gpp = (SimpleGraph)super.clone();
        gpp.removeAllVertices(SabSet);
        ConnectivityInspector inspectorGpp = new ConnectivityInspector((UndirectedGraph)gpp);
        if (verbose) {
            System.out.println("\tdisabling edges for vertices linked to " + a + " and " + b);
        }
        if (verbose) {
            System.out.println("neighbours of " + a + ":" + connectedToA);
        }
        if (verbose) {
            System.out.println("neighbours of " + b + ":" + connectedToB);
        }
        for (Integer vx : connectedToA) {
            for (Integer vy : connectedToB) {
                this.disableEdge(vx, vy, pq, verbose);
            }
        }
        if (verbose) {
            System.out.println("\tremove edge (" + Ca + "," + Cb + ")");
        }
        this.cg.removeEdge((Object)Ca, (Object)Cb);
        this.cg.removeEdge((Object)Cb, (Object)Ca);
        if (verbose) {
            System.out.println("\tadd vertex Cab=" + Cab);
        }
        this.cg.addVertex((Object)Cab);
        if (verbose) {
            System.out.println("\tadd edge (Ca,Cab)=(" + Ca + "," + Cab + ")");
        }
        this.cg.addEdge((Object)Ca, (Object)Cab);
        if (verbose) {
            System.out.println("\tadd edge (Cb,Cab)=(" + Cb + "," + Cab + ")");
        }
        this.cg.addEdge((Object)Cb, (Object)Cab);
        if (verbose) {
            System.out.println("\tdisabling edges for vertices for which Sab is identical");
        }
        this.removeInvalidEdgesCG(Sab, cgEdges, (ConnectivityInspector<Integer, DefaultEdge>)inspectorGpp, pq, verbose);
        BitSet SabUniona = (BitSet)Sab.clone();
        SabUniona.set(a);
        this.addCGEdgesAroundCa(Ca, Cab, SabUniona, verbose);
        this.addCGEdgesAroundCaFullCheckVb(b, Cab, SabUniona, verbose);
        BitSet SabUnionb = (BitSet)Sab.clone();
        SabUnionb.set(b);
        this.addCGEdgesAroundCa(Cb, Cab, SabUnionb, verbose);
        this.addCGEdgesAroundCaFullCheckVb(a, Cab, SabUnionb, verbose);
        if (ChordalGraph.containsAll(Cab, Ca)) {
            if (verbose) {
                System.out.println("\tremove vertex Ca=" + Ca);
            }
            this.cg.removeVertex((Object)Ca);
        }
        if (ChordalGraph.containsAll(Cab, Cb)) {
            if (verbose) {
                System.out.println("\tremove vertex Cb=" + Cb);
            }
            this.cg.removeVertex((Object)Cb);
        }
        this.updateEligibilityAroundCab(Cab, pq, verbose);
        if (ChordalGraph.containsAll(Cab, Ca)) {
            this.updateEligibilityForNonConectedComponentsSmart(Ca, pq, verbose);
        }
        if (ChordalGraph.containsAll(Cab, Cb)) {
            this.updateEligibilityForNonConectedComponentsSmart(Cb, pq, verbose);
        }
        if (verbose) {
            this.printAvailableEdges();
        }
        if (pq != null) {
            pq.processStoredModifications();
        }
        return addedE;
    }

    private void updateEligibilityForNonConectedComponentsSmart(BitSet Cab, MyPriorityQueue pq, boolean verbose) {
        ConnectivityInspector insp = new ConnectivityInspector((UndirectedGraph)this);
        if (!insp.isGraphConnected()) {
            if (verbose) {
                System.out.println("\tnon-connected components");
            }
            int v = Cab.nextSetBit(0);
            while (v >= 0) {
                int j = 0;
                while (j < this.eligibleEdges.length) {
                    if (!insp.pathExists((Object)v, (Object)j)) {
                        BitSet Ci = null;
                        BitSet Cj = null;
                        for (BitSet c : this.cg.vertexSet()) {
                            if (Ci == null && c.get(v)) {
                                Ci = c;
                                continue;
                            }
                            if (Cj != null || !c.get(j)) continue;
                            Cj = c;
                        }
                        this.enableEdge(v, j, new CliqueGraphEdge(Ci, Cj), pq, verbose);
                    }
                    ++j;
                }
                v = Cab.nextSetBit(v + 1);
            }
        }
    }

    private void updateEligibilityAroundCab(BitSet Cab, MyPriorityQueue pq, boolean verbose) {
        Set edgesAroundCab = this.cg.edgesOf((Object)Cab);
        if (verbose) {
            System.out.println("\tnew edges around Cab");
        }
        for (CliqueGraphEdge edgeAroundCab : edgesAroundCab) {
            BitSet Sp = edgeAroundCab.separator;
            BitSet Cp = edgeAroundCab.c1;
            if (Cp.equals(Cab)) {
                Cp = edgeAroundCab.c2;
            }
            BitSet CpMinusSp = (BitSet)Cp.clone();
            CpMinusSp.andNot(Sp);
            BitSet CabMinusSp = (BitSet)Cab.clone();
            CabMinusSp.andNot(Sp);
            int vx = CpMinusSp.nextSetBit(0);
            while (vx >= 0) {
                int vxp = CabMinusSp.nextSetBit(0);
                while (vxp >= 0) {
                    this.enableEdge(vx, vxp, edgeAroundCab, pq, verbose);
                    vxp = CabMinusSp.nextSetBit(vxp + 1);
                }
                vx = CpMinusSp.nextSetBit(vx + 1);
            }
        }
    }

    private void addCGEdgesAroundCaFullCheckVb(Integer b, BitSet Cab, BitSet SabUniona, boolean verbose) {
        for (BitSet Cp : this.cg.vertexSet()) {
            Integer oneVertex;
            Set componentOfCpMinusCab;
            BitSet Sp = (BitSet)Cp.clone();
            Sp.and(Cab);
            if (Sp.isEmpty() || !Sp.equals(SabUniona)) continue;
            BitSet CpMinusCab = (BitSet)Cp.clone();
            CpMinusCab.andNot(Sp);
            if (CpMinusCab.isEmpty()) continue;
            SimpleGraph graphCopy = (SimpleGraph)super.clone();
            int v = SabUniona.nextSetBit(0);
            while (v >= 0) {
                graphCopy.removeVertex((Object)v);
                v = SabUniona.nextSetBit(v + 1);
            }
            ConnectivityInspector inspector = new ConnectivityInspector((UndirectedGraph)graphCopy);
            Set componentOfB = inspector.connectedSetOf((Object)b);
            if (componentOfB.equals(componentOfCpMinusCab = inspector.connectedSetOf((Object)(oneVertex = Integer.valueOf(CpMinusCab.nextSetBit(0))))) || this.cg.containsEdge((Object)Cp, (Object)Cab) || this.cg.containsEdge((Object)Cab, (Object)Cp)) continue;
            if (verbose) {
                System.out.println("\tadd edge (Cab,C') = (" + Cab + "," + Cp + ")");
            }
            CliqueGraphEdge addedEdge = (CliqueGraphEdge)this.cg.addEdge((Object)Cp, (Object)Cab);
            if (!addedEdge.separator.isEmpty()) continue;
            System.err.println("shouldn't have added this edge");
            System.exit(0);
        }
    }

    private void addCGEdgesAroundCa(BitSet Ca, BitSet Cab, BitSet SabUniona, boolean verbose) {
        for (CliqueGraphEdge CpCa : this.cg.edgesOf((Object)Ca)) {
            BitSet Cp = CpCa.c1;
            if (Cp.equals(Ca)) {
                Cp = CpCa.c2;
            }
            if (Cp.equals(Cab)) continue;
            if (verbose) {
                System.out.println("\tCp=" + Cp + " is a neighbour of Ca=" + Ca);
            }
            BitSet Sp = CpCa.separator;
            if (verbose) {
                System.out.println("\tS' = Cp inter Ca=" + Sp);
            }
            if (Sp.isEmpty() || !ChordalGraph.containsAll(SabUniona, Sp) || this.cg.containsEdge((Object)Cp, (Object)Cab) || this.cg.containsEdge((Object)Cab, (Object)Cp)) continue;
            if (verbose) {
                System.out.println("\tadd edge (C',Cab)a=(" + Cp + "," + Cab + ")");
            }
            CliqueGraphEdge addedEdge = (CliqueGraphEdge)this.cg.addEdge((Object)Cp, (Object)Cab);
            if (!addedEdge.separator.isEmpty()) continue;
            System.err.println("shouldn't have added this edge");
            System.exit(0);
        }
    }

    private void removeInvalidEdgesCG(BitSet Sab, Set<CliqueGraphEdge> cgEdgesBeforeNewNode, ConnectivityInspector<Integer, DefaultEdge> inspectorGpp, MyPriorityQueue pq, boolean verbose) {
        ArrayList<CliqueGraphEdge> toRemove = new ArrayList<CliqueGraphEdge>();
        for (CliqueGraphEdge cEdge : cgEdgesBeforeNewNode) {
            BitSet c1 = cEdge.c1;
            BitSet c2 = cEdge.c2;
            BitSet S12 = cEdge.separator;
            if (!S12.equals(Sab)) continue;
            if (verbose) {
                System.out.println("\ttrying to remove edge between " + c1 + " and " + c2);
            }
            BitSet c1mS12 = (BitSet)c1.clone();
            c1mS12.andNot(S12);
            BitSet c2mS12 = (BitSet)c2.clone();
            c2mS12.andNot(S12);
            Integer vFromC1mS12 = c1mS12.nextSetBit(0);
            Integer vFromC2mS12 = c2mS12.nextSetBit(0);
            if (!inspectorGpp.pathExists((Object)vFromC1mS12, (Object)vFromC2mS12)) continue;
            if (verbose) {
                System.out.println("\tremove edge S12=" + S12);
            }
            toRemove.add(cEdge);
            int vx = c1mS12.nextSetBit(0);
            while (vx >= 0) {
                int vy = c2mS12.nextSetBit(0);
                while (vy >= 0) {
                    this.disableEdge(vx, vy, pq, verbose);
                    vy = c2mS12.nextSetBit(vy + 1);
                }
                vx = c1mS12.nextSetBit(vx + 1);
            }
        }
        this.cg.removeAllEdges(toRemove);
    }

    private void disableEdge(Integer a, Integer b, MyPriorityQueue pq, boolean verbose) {
        this.eligibleEdges[a.intValue()][b.intValue()] = null;
        this.eligibleEdges[b.intValue()][a.intValue()] = null;
        if (pq != null) {
            pq.disableEdge(a, b);
        }
        if (verbose) {
            System.out.println("\t(" + a + "," + b + ") not accessible any more:" + this.eligibleEdges[a][b]);
        }
    }

    private void enableEdge(Integer a, Integer b, CliqueGraphEdge edge, MyPriorityQueue pq, boolean verbose) {
        if (verbose && this.eligibleEdges[a][b] != null && this.eligibleEdges[a][b].equals(edge)) {
            System.err.println("\tdidn't need to update (" + a + "," + b + "):" + this.eligibleEdges[a][b]);
        }
        if (this.eligibleEdges[a][b] == null) {
            this.eligibleEdges[a.intValue()][b.intValue()] = edge;
            this.eligibleEdges[b.intValue()][a.intValue()] = edge;
            if (pq != null) {
                pq.enableEdge(a, b);
            }
        } else if (!this.eligibleEdges[a][b].equals(edge)) {
            this.eligibleEdges[a.intValue()][b.intValue()] = edge;
            this.eligibleEdges[b.intValue()][a.intValue()] = edge;
            if (!this.eligibleEdges[a.intValue()][b.intValue()].separator.equals(edge.separator) && pq != null) {
                pq.updateEdge(a, b);
            }
        }
        if (verbose) {
            System.out.println("\t(" + a + "," + b + ") now accessible:" + this.eligibleEdges[a][b]);
        }
    }

    private static final boolean containsAll(BitSet s1, BitSet s2) {
        BitSet intersection = (BitSet)s1.clone();
        intersection.and(s2);
        return intersection.equals(s2);
    }

    public DirectedAcyclicGraph<Integer, DefaultEdge> getBayesianNetwork() throws DirectedAcyclicGraph.CycleFoundException {
        ArrayList<Integer> peo = this.getEliminationOrdering();
        DirectedAcyclicGraph bn = new DirectedAcyclicGraph(DefaultEdge.class);
        int i = 0;
        while (i < peo.size()) {
            Integer nodeI = (Integer)peo.get(i);
            bn.addVertex((Object)nodeI);
            int j = 0;
            while (j < i) {
                Integer nodeJ = (Integer)peo.get(j);
                if (this.containsEdge(nodeJ, nodeI) || this.containsEdge(nodeI, nodeJ)) {
                    bn.addDagEdge((Object)nodeI, (Object)nodeJ);
                }
                ++j;
            }
            ++i;
        }
        SimpleGraph moralized = new SimpleGraph(DefaultEdge.class);
        for (Integer v : this.vertexSet()) {
            moralized.addVertex((Object)v);
        }
        for (Integer v : bn.vertexSet()) {
            TreeSet<Integer> parents = new TreeSet<Integer>();
            Set edges = bn.edgesOf((Object)v);
            for (DefaultEdge e : edges) {
                Integer child = (Integer)bn.getEdgeTarget((Object)e);
                if (!child.equals(v)) continue;
                parents.add((Integer)bn.getEdgeSource((Object)e));
            }
            for (Integer p : parents) {
                moralized.addEdge((Object)v, (Object)p);
            }
            ArrayList listOfParents = new ArrayList(parents);
            int p1 = 1;
            while (p1 < listOfParents.size()) {
                int p2 = 0;
                while (p2 < p1) {
                    Integer parent2;
                    Integer parent1 = (Integer)listOfParents.get(p1);
                    if (!this.containsEdge(parent1, parent2 = (Integer)listOfParents.get(p2)) && !this.containsEdge(parent2, parent1)) {
                        System.err.println("shouldn't add (" + parent1 + "," + parent2 + ")");
                    }
                    moralized.addEdge((Object)parent1, (Object)parent2);
                    ++p2;
                }
                ++p1;
            }
        }
        if (this.vertexSet().size() != moralized.vertexSet().size() || !this.vertexSet().containsAll(moralized.vertexSet())) {
            System.err.println("different vertices!");
            System.err.println("original: " + this.vertexSet());
            System.err.println("bn: " + bn.vertexSet());
        }
        if (this.edgeSet().size() != moralized.edgeSet().size()) {
            System.err.println("not the same number of edges!");
            System.err.println("original: " + this.edgeSet().size());
            System.err.println("moralized bn: " + moralized.edgeSet().size());
        }
        for (DefaultEdge e : this.edgeSet()) {
            Integer target;
            Integer source = (Integer)this.getEdgeSource(e);
            if (moralized.containsEdge((Object)source, (Object)(target = (Integer)this.getEdgeTarget(e))) || moralized.containsEdge((Object)target, (Object)source)) continue;
            System.err.println(e + " missing in moralized graph");
        }
        return bn;
    }

    public final ArrayList<Integer> getEliminationOrdering() {
        if (this.peo != null) {
            return this.peo;
        }
        this.peo = new ArrayList();
        SimpleGraph gElim = (SimpleGraph)super.clone();
        TreeMap<Integer, Integer> labels = new TreeMap<Integer, Integer>();
        for (Integer vertex : this.vertexSet()) {
            labels.put(vertex, new Integer(0));
        }
        while (!labels.isEmpty()) {
            int maxNumber = -1;
            Integer xi = null;
            for (Map.Entry entry : labels.entrySet()) {
                if ((Integer)entry.getValue() <= maxNumber) continue;
                xi = (Integer)entry.getKey();
                maxNumber = (Integer)entry.getValue();
            }
            this.peo.add(0, xi);
            Set edges = gElim.edgesOf(xi);
            for (DefaultEdge edge : edges) {
                Integer number;
                Integer source = (Integer)gElim.getEdgeSource((Object)edge);
                Integer target = (Integer)gElim.getEdgeTarget((Object)edge);
                if (source.equals(xi)) {
                    number = (Integer)labels.get(target);
                    labels.put(target, number + 1);
                    continue;
                }
                number = (Integer)labels.get(source);
                labels.put(source, number + 1);
            }
            gElim.removeVertex((Object)xi);
            labels.remove(xi);
        }
        System.out.println(this.peo);
        return this.peo;
    }

    public void exportDOT(File file) {
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(file), true);
            out.println("graph Chordalysis{");
            out.println("\tgraph [K=1.0 fontsize=14 overlap=\"10:\" splines=\"true\"];");
            out.println("\tratio = auto;");
            ArrayList listNodes = new ArrayList(this.vertexSet());
            int i = 0;
            while (i < listNodes.size()) {
                Integer node = (Integer)listNodes.get(i);
                out.print("\t\"" + node + "\"");
                out.print(" [shape=\"ellipse\" ");
                double fontSize = 10.0;
                out.print("fontsize=" + fontSize + " ");
                out.println("];");
                ++i;
            }
            for (DefaultEdge edge : this.edgeSet()) {
                out.println(this.getEdgeSource(edge) + "--" + this.getEdgeTarget(edge));
            }
            out.println("}");
            out.close();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
    }
}

