/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering.statistics;

import dr.evolution.tree.NodeRef;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.LinkedList;

public class PathStatistic
extends Statistic.Abstract
implements VariableListener {
    private int max_dim;
    private LinkedList<Double> path = new LinkedList();
    private int[] fromMembership;
    private Parameter indicators;
    private TreeModel treeModel;
    public static final String PATH_STATISTIC = "pathStatistic";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String INDICATORS = "indicators";
        public static final String MAXDIMSTR = "maxDim";
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(TreeModel.class), new ElementRule("indicators", Parameter.class), AttributeRule.newDoubleRule("maxDim", true, "the variance of mu")};

        @Override
        public String getParserName() {
            return PathStatistic.PATH_STATISTIC;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            Parameter parameter = (Parameter)xMLObject.getElementFirstChild(INDICATORS);
            int n = 30;
            if (xMLObject.hasAttribute(MAXDIMSTR)) {
                n = xMLObject.getIntegerAttribute(MAXDIMSTR);
            }
            return new PathStatistic(treeModel, parameter, n);
        }

        @Override
        public String getParserDescription() {
            return "This element returns a statistic that shifts a matrix of locations by location drift in the first dimension.";
        }

        @Override
        public Class getReturnType() {
            return PathStatistic.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public PathStatistic(TreeModel treeModel, Parameter parameter, int n) {
        this.treeModel = treeModel;
        this.indicators = parameter;
        this.max_dim = n;
        parameter.addParameterListener(this);
    }

    @Override
    public int getDimension() {
        return this.max_dim;
    }

    @Override
    public double getStatisticValue(int n) {
        if (n == 0) {
            this.fromMembership = this.determine_from_membership_v2();
        }
        return this.fromMembership[n];
    }

    int[] determine_from_membership_v3() {
        int n;
        int[] nArray = new int[this.treeModel.getNodeCount()];
        for (int i = 0; i < this.treeModel.getNodeCount(); ++i) {
            nArray[i] = -1;
        }
        int[] nArray2 = new int[this.treeModel.getNodeCount()];
        for (int i = 0; i < this.treeModel.getNodeCount(); ++i) {
            nArray2[i] = -99;
        }
        NodeRef nodeRef = this.treeModel.getRoot();
        int n2 = 1;
        LinkedList<NodeRef> linkedList = new LinkedList<NodeRef>();
        linkedList.addFirst(nodeRef);
        int[] nArray3 = new int[this.treeModel.getNodeCount()];
        for (n = 0; n < this.treeModel.getNodeCount(); ++n) {
            nArray3[n] = -1;
        }
        nArray3[nodeRef.getNumber()] = 0;
        nArray2[0] = -1;
        while (!linkedList.isEmpty()) {
            NodeRef nodeRef2 = (NodeRef)linkedList.pop();
            if (!this.treeModel.isRoot(nodeRef2)) {
                if ((int)this.indicators.getParameterValue(nodeRef2.getNumber()) == 1) {
                    nArray3[nodeRef2.getNumber()] = ++n2 - 1;
                    nArray2[nodeRef2.getNumber()] = nArray3[this.treeModel.getParent(nodeRef2).getNumber()];
                } else {
                    nArray3[nodeRef2.getNumber()] = nArray3[this.treeModel.getParent(nodeRef2).getNumber()];
                    nArray2[nodeRef2.getNumber()] = nArray2[this.treeModel.getParent(nodeRef2).getNumber()];
                }
            } else {
                nArray2[nodeRef2.getNumber()] = -1;
            }
            for (int i = 0; i < this.treeModel.getChildCount(nodeRef2); ++i) {
                linkedList.addFirst(this.treeModel.getChild(nodeRef2, i));
            }
        }
        for (n = 0; n < this.treeModel.getNodeCount(); ++n) {
            if ((int)this.indicators.getParameterValue(n) != 1) continue;
            nArray[nArray3[n]] = nArray2[n];
        }
        return nArray;
    }

    int[] determine_from_membership_v2() {
        int[] nArray = new int[this.treeModel.getNodeCount()];
        for (int i = 0; i < this.treeModel.getNodeCount(); ++i) {
            nArray[i] = -1;
        }
        NodeRef nodeRef = this.treeModel.getRoot();
        int n = 1;
        LinkedList<NodeRef> linkedList = new LinkedList<NodeRef>();
        linkedList.addFirst(nodeRef);
        int[] nArray2 = new int[this.treeModel.getNodeCount()];
        for (int i = 0; i < this.treeModel.getNodeCount(); ++i) {
            nArray2[i] = -1;
        }
        nArray2[nodeRef.getNumber()] = 0;
        while (!linkedList.isEmpty()) {
            NodeRef nodeRef2 = (NodeRef)linkedList.pop();
            String string = "node #" + nodeRef2.getNumber() + ", taxon= ";
            string = this.treeModel.getNodeTaxon(nodeRef2) == null ? string + "internal node\t" : string + this.treeModel.getNodeTaxon(nodeRef2).getId() + "\t";
            if (this.treeModel.getParent(nodeRef2) == null) {
                // empty if block
            }
            if (!this.treeModel.isRoot(nodeRef2)) {
                if ((int)this.indicators.getParameterValue(nodeRef2.getNumber()) == 1) {
                    nArray2[nodeRef2.getNumber()] = ++n - 1;
                    nArray[n - 1] = nArray2[this.treeModel.getParent(nodeRef2).getNumber()];
                } else {
                    nArray2[nodeRef2.getNumber()] = nArray2[this.treeModel.getParent(nodeRef2).getNumber()];
                }
            }
            string = string + " cluster = " + nArray2[nodeRef2.getNumber()];
            for (int i = 0; i < this.treeModel.getChildCount(nodeRef2); ++i) {
                linkedList.addFirst(this.treeModel.getChild(nodeRef2, i));
            }
        }
        return nArray;
    }

    @Override
    public String getDimensionName(int n) {
        String string = "path" + n;
        return string;
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }
}

