/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.offheapstore.util;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.offheapstore.util.DebuggingUtils;

public class PhysicalMemory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhysicalMemory.class);
    private static final OperatingSystemMXBean OS_BEAN = ManagementFactory.getOperatingSystemMXBean();

    public static Long totalPhysicalMemory() {
        return (Long)PhysicalMemory.getAttribute("getTotalPhysicalMemorySize");
    }

    public static Long freePhysicalMemory() {
        return (Long)PhysicalMemory.getAttribute("getFreePhysicalMemorySize");
    }

    public static Long totalSwapSpace() {
        return (Long)PhysicalMemory.getAttribute("getTotalSwapSpaceSize");
    }

    public static Long freeSwapSpace() {
        return (Long)PhysicalMemory.getAttribute("getFreeSwapSpaceSize");
    }

    public static Long ourCommittedVirtualMemory() {
        return (Long)PhysicalMemory.getAttribute("getCommittedVirtualMemorySize");
    }

    private static <T> T getAttribute(String name) {
        LOGGER.trace("Bean lookup for {}", (Object)name);
        for (Class<?> s2 = OS_BEAN.getClass(); s2 != null; s2 = s2.getSuperclass()) {
            try {
                Object result = s2.getMethod(name, new Class[0]).invoke((Object)OS_BEAN, new Object[0]);
                LOGGER.trace("Bean lookup successful using {}, got {}", (Object)s2, result);
                return (T)result;
            }
            catch (SecurityException e2) {
                LOGGER.trace("Bean lookup failed on {}", (Object)s2, (Object)e2);
                continue;
            }
            catch (NoSuchMethodException e3) {
                LOGGER.trace("Bean lookup failed on {}", (Object)s2, (Object)e3);
                continue;
            }
            catch (IllegalAccessException e4) {
                LOGGER.trace("Bean lookup failed on {}", (Object)s2, (Object)e4);
                continue;
            }
            catch (IllegalArgumentException e5) {
                LOGGER.trace("Bean lookup failed on {}", (Object)s2, (Object)e5);
                continue;
            }
            catch (InvocationTargetException e6) {
                LOGGER.trace("Bean lookup failed on {}", (Object)s2, (Object)e6);
            }
        }
        for (Class<?> i : OS_BEAN.getClass().getInterfaces()) {
            try {
                Object result = i.getMethod(name, new Class[0]).invoke((Object)OS_BEAN, new Object[0]);
                LOGGER.trace("Bean lookup successful using {}, got {}", (Object)i, result);
                return (T)result;
            }
            catch (SecurityException e7) {
                LOGGER.trace("Bean lookup failed on {}", (Object)i, (Object)e7);
            }
            catch (NoSuchMethodException e8) {
                LOGGER.trace("Bean lookup failed on {}", (Object)i, (Object)e8);
            }
            catch (IllegalAccessException e9) {
                LOGGER.trace("Bean lookup failed on {}", (Object)i, (Object)e9);
            }
            catch (IllegalArgumentException e10) {
                LOGGER.trace("Bean lookup failed on {}", (Object)i, (Object)e10);
            }
            catch (InvocationTargetException e11) {
                LOGGER.trace("Bean lookup failed on {}", (Object)i, (Object)e11);
            }
        }
        LOGGER.trace("Returning null for {}", (Object)name);
        return null;
    }

    public static void main(String[] args) {
        System.out.println("Total Physical Memory: " + DebuggingUtils.toBase2SuffixedString(PhysicalMemory.totalPhysicalMemory()) + "B");
        System.out.println("Free Physical Memory: " + DebuggingUtils.toBase2SuffixedString(PhysicalMemory.freePhysicalMemory()) + "B");
        System.out.println("Total Swap Space: " + DebuggingUtils.toBase2SuffixedString(PhysicalMemory.totalSwapSpace()) + "B");
        System.out.println("Free Swap Space: " + DebuggingUtils.toBase2SuffixedString(PhysicalMemory.freeSwapSpace()) + "B");
        System.out.println("Committed Virtual Memory: " + DebuggingUtils.toBase2SuffixedString(PhysicalMemory.ourCommittedVirtualMemory()) + "B");
    }
}

