/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

final class FeatureReaderFeatureIterator
implements SimpleFeatureIterator {
    FeatureReader<SimpleFeatureType, SimpleFeature> reader;

    public FeatureReaderFeatureIterator(FeatureReader<SimpleFeatureType, SimpleFeature> reader) {
        this.reader = reader;
    }

    public boolean hasNext() {
        try {
            if (this.reader == null) {
                return false;
            }
            if (this.reader.hasNext()) {
                return true;
            }
            this.close();
            return false;
        }
        catch (IOException e2) {
            this.close();
            return false;
        }
    }

    public SimpleFeature next() {
        if (this.reader == null) {
            throw new NoSuchElementException("Iterator has been closed");
        }
        try {
            return this.reader.next();
        }
        catch (IOException io) {
            this.close();
            NoSuchElementException problem = new NoSuchElementException("Could not obtain the next feature:" + io);
            problem.initCause(io);
            throw problem;
        }
        catch (IllegalAttributeException create) {
            this.close();
            NoSuchElementException problem = new NoSuchElementException("Could not create the next feature:" + create);
            problem.initCause(create);
            throw problem;
        }
    }

    public void remove() {
        throw new UnsupportedOperationException("Modification of contents is not supported");
    }

    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.reader = null;
        }
    }
}

