/*
 * Decompiled with CFR 0.152.
 */
package org.flsgen.cli;

import java.io.FileWriter;
import org.flsgen.grid.neighborhood.INeighborhood;
import org.flsgen.grid.neighborhood.Neighborhoods;
import org.flsgen.solver.LandscapeStructure;
import picocli.CommandLine;

@CommandLine.Command(name="extract_structure", mixinStandardHelpOptions=true, description={"Extracts a landscape structure from an existing raster."})
public class CLI_LandscapeStructureFromRaster
implements Runnable {
    @CommandLine.Parameters(description={"JSON output file -- Use \"-\" to write to STDOUT "}, index="1")
    String outputFile;
    @CommandLine.Parameters(description={"Raster (.tif) input file to extract the landscape structure from"}, index="0")
    String inputRaster;
    @CommandLine.Parameters(description={"Raster values of the focal classes"}, index="2..*")
    int[] focalClasses;
    @CommandLine.Option(names={"-c", "--connectivity"}, description={"Connectivity definition in the regular grid - '4' (4-connected) or '8' (8-connected) (default: 4)."}, defaultValue="4")
    int connectivity;

    @Override
    public void run() {
        if (this.connectivity != 4 && this.connectivity != 8) {
            System.err.println("\u001b[31mThe Connectivity definition must be either 4 or 8\u001b[0m");
        }
        try {
            INeighborhood neigh = this.connectivity == 4 ? Neighborhoods.FOUR_CONNECTED : Neighborhoods.HEIGHT_CONNECTED;
            LandscapeStructure s2 = LandscapeStructure.fromRaster(this.inputRaster, this.focalClasses, neigh);
            if (this.outputFile.equals("-")) {
                System.out.println(s2.toJSON());
            } else {
                FileWriter writer = new FileWriter(this.outputFile);
                writer.write(s2.toJSON());
                writer.close();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

