/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.tools;

import gnu.trove.map.hash.TIntIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.binary.PropEqualX_Y;
import org.chocosolver.solver.expression.discrete.arithmetic.ArExpression;
import org.chocosolver.solver.search.SearchState;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetType;

public class PreProcessing {
    private static final Predicate<Constraint> ARITHM = c2 -> c2.getName().equals("ARITHM");
    private static final Predicate<Constraint> POSTED = c2 -> c2.getStatus() == Constraint.Status.POSTED;
    private static final Predicate<Constraint> EQXY = c2 -> c2.getPropagator(0) instanceof PropEqualX_Y;

    public static List<List<IntVar>> detectIntEqualities(Model model) {
        if (model.getSolver().getSearchState() != SearchState.NEW) {
            return Collections.emptyList();
        }
        IntVar[] ivars = model.retrieveIntVars(true);
        int pos = 0;
        TIntIntHashMap id2pos = new TIntIntHashMap();
        for (IntVar i : ivars) {
            id2pos.put(i.getId(), pos++);
        }
        UndirectedGraph g2 = new UndirectedGraph(pos, SetType.LINKED_LIST, false);
        Arrays.stream(model.getCstrs()).filter(ARITHM.and(POSTED).and(EQXY)).map(c2 -> c2.getPropagator(0)).forEach(p -> {
            g2.addNode(id2pos.get(p.getVar(0).getId()));
            g2.addNode(id2pos.get(p.getVar(1).getId()));
            g2.addEdge(id2pos.get(p.getVar(0).getId()), id2pos.get(p.getVar(1).getId()));
        });
        ArrayList<List<IntVar>> components = new ArrayList<List<IntVar>>();
        BitSet visited = new BitSet(pos);
        Iterator<Integer> iterator = g2.getNodes().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (visited.get(n)) continue;
            ArrayList<IntVar> component = new ArrayList<IntVar>();
            PreProcessing.scc(n, visited, g2, component, ivars);
            assert (component.size() > 1) : "found a SCC of size 1";
            components.add(component);
        }
        model.unpost((Constraint[])Arrays.stream(model.getCstrs()).filter(ARITHM.and(POSTED).and(EQXY)).toArray(Constraint[]::new));
        for (List list : components) {
            if (list.size() > 2) {
                model.allEqual(list.toArray(new IntVar[0])).post();
                continue;
            }
            if (list.size() != 2) continue;
            ((IntVar)list.get(0)).eq((ArExpression)list.get(1)).post();
        }
        return components;
    }

    private static void scc(int v, BitSet visited, UndirectedGraph g2, ArrayList<IntVar> component, IntVar[] ivars) {
        component.add(ivars[v]);
        visited.set(v);
        ISetIterator iSetIterator = g2.getNeighborsOf(v).iterator();
        while (iSetIterator.hasNext()) {
            int x = (Integer)iSetIterator.next();
            if (visited.get(x)) continue;
            PreProcessing.scc(x, visited, g2, component, ivars);
        }
    }
}

