/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.sort;

import java.util.Comparator;
import org.chocosolver.util.sort.IntComparator;

public class ArraySort<T> {
    private int[] iint;
    private T[] iobj;

    public ArraySort(int nbMaxItems, boolean sortOjects, boolean sortInts) {
        if (sortOjects) {
            this.iobj = new Object[nbMaxItems];
        }
        if (sortInts) {
            this.iint = new int[nbMaxItems];
        }
    }

    public void sort(T[] items, int size, Comparator<T> sort) {
        System.arraycopy(items, 0, this.iobj, 0, size);
        this.mergeSort(items, this.iobj, 0, size, sort);
        System.arraycopy(this.iobj, 0, items, 0, size);
    }

    private void mergeSort(T[] src, T[] dest, int low, int high, Comparator<T> c2) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && c2.compare(dest[j - 1], dest[j]) > 0; --j) {
                    this.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int mid = low + high >>> 1;
        this.mergeSort(dest, src, low, mid, c2);
        this.mergeSort(dest, src, mid, high, c2);
        if (c2.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && c2.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
        }
    }

    private void swap(T[] x, int a2, int b2) {
        T t = x[a2];
        x[a2] = x[b2];
        x[b2] = t;
    }

    public void sort(int[] items, int size, IntComparator sort) {
        System.arraycopy(items, 0, this.iint, 0, size);
        this.mergeSort(items, this.iint, 0, size, sort);
        System.arraycopy(this.iint, 0, items, 0, size);
    }

    private void mergeSort(int[] src, int[] dest, int low, int high, IntComparator c2) {
        int length = high - low;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && c2.compare(dest[j - 1], dest[j]) > 0; --j) {
                    ArraySort.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int mid = low + high >>> 1;
        this.mergeSort(dest, src, low, mid, c2);
        this.mergeSort(dest, src, mid, high, c2);
        if (c2.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && c2.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
        }
    }

    private static void swap(int[] x, int a2, int b2) {
        int t = x[a2];
        x[a2] = x[b2];
        x[b2] = t;
    }
}

