/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view.integer;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.impl.scheduler.IntEvtScheduler;
import org.chocosolver.solver.variables.view.IntView;
import org.chocosolver.solver.variables.view.ViewDeltaMonitor;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.iterators.EvtScheduler;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;

public final class IntOffsetView<I extends IntVar>
extends IntView<I> {
    public final int cste;

    public IntOffsetView(I var, int cste) {
        super("(" + var.getName() + "+" + cste + ")", var);
        this.cste = cste;
    }

    @Override
    public IIntDeltaMonitor monitorDelta(ICause propagator) {
        this.var.createDelta();
        if (this.var.getDelta() == NoDelta.singleton) {
            return IIntDeltaMonitor.Default.NONE;
        }
        return new ViewDeltaMonitor(this.var.monitorDelta(propagator)){

            @Override
            protected int transform(int value) {
                return value + IntOffsetView.this.cste;
            }
        };
    }

    @Override
    protected boolean doInstantiateVar(int value) throws ContradictionException {
        return this.var.instantiateTo(value - this.cste, this);
    }

    @Override
    protected boolean doUpdateLowerBoundOfVar(int value) throws ContradictionException {
        return this.var.updateLowerBound(value - this.cste, this);
    }

    @Override
    protected boolean doUpdateUpperBoundOfVar(int value) throws ContradictionException {
        return this.var.updateUpperBound(value - this.cste, this);
    }

    @Override
    protected boolean doRemoveValueFromVar(int value) throws ContradictionException {
        return this.var.removeValue(value - this.cste, this);
    }

    @Override
    protected boolean doRemoveIntervalFromVar(int from, int to) throws ContradictionException {
        return this.var.removeInterval(from - this.cste, to - this.cste, this);
    }

    @Override
    public boolean contains(int value) {
        return this.var.contains(value - this.cste);
    }

    @Override
    public boolean isInstantiatedTo(int value) {
        return this.var.isInstantiatedTo(value - this.cste);
    }

    @Override
    public int getValue() {
        return this.var.getValue() + this.cste;
    }

    @Override
    public int getLB() {
        return this.var.getLB() + this.cste;
    }

    @Override
    public int getUB() {
        return this.var.getUB() + this.cste;
    }

    @Override
    public int nextValue(int v) {
        int value = this.var.nextValue(v - this.cste);
        if (value == Integer.MAX_VALUE) {
            return value;
        }
        return value + this.cste;
    }

    @Override
    public int nextValueOut(int v) {
        return this.var.nextValueOut(v - this.cste) + this.cste;
    }

    @Override
    public int previousValue(int v) {
        int value = this.var.previousValue(v - this.cste);
        if (value == Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return value + this.cste;
    }

    @Override
    public int previousValueOut(int v) {
        return this.var.previousValueOut(v - this.cste) + this.cste;
    }

    protected EvtScheduler createScheduler() {
        return new IntEvtScheduler();
    }

    @Override
    public String toString() {
        return "(" + this.var.toString() + (this.cste >= 0 ? " + " : " - ") + Math.abs(this.cste) + ") = [" + this.getLB() + "," + this.getUB() + "]";
    }

    @Override
    public DisposableValueIterator getValueIterator(boolean bottomUp) {
        if (this._viterator == null || this._viterator.isNotReusable()) {
            this._viterator = new DisposableValueIterator(){
                DisposableValueIterator vit;

                @Override
                public void bottomUpInit() {
                    super.bottomUpInit();
                    this.vit = IntOffsetView.this.var.getValueIterator(true);
                }

                @Override
                public void topDownInit() {
                    super.topDownInit();
                    this.vit = IntOffsetView.this.var.getValueIterator(false);
                }

                @Override
                public boolean hasNext() {
                    return this.vit.hasNext();
                }

                @Override
                public boolean hasPrevious() {
                    return this.vit.hasPrevious();
                }

                @Override
                public int next() {
                    return this.vit.next() + IntOffsetView.this.cste;
                }

                @Override
                public int previous() {
                    return this.vit.previous() + IntOffsetView.this.cste;
                }

                @Override
                public void dispose() {
                    super.dispose();
                    this.vit.dispose();
                }
            };
        }
        if (bottomUp) {
            this._viterator.bottomUpInit();
        } else {
            this._viterator.topDownInit();
        }
        return this._viterator;
    }

    @Override
    public DisposableRangeIterator getRangeIterator(boolean bottomUp) {
        if (this._riterator == null || this._riterator.isNotReusable()) {
            this._riterator = new DisposableRangeIterator(){
                DisposableRangeIterator vir;

                @Override
                public void bottomUpInit() {
                    super.bottomUpInit();
                    this.vir = IntOffsetView.this.var.getRangeIterator(true);
                }

                @Override
                public void topDownInit() {
                    super.topDownInit();
                    this.vir = IntOffsetView.this.var.getRangeIterator(false);
                }

                @Override
                public boolean hasNext() {
                    return this.vir.hasNext();
                }

                @Override
                public boolean hasPrevious() {
                    return this.vir.hasPrevious();
                }

                @Override
                public void next() {
                    this.vir.next();
                }

                @Override
                public void previous() {
                    this.vir.previous();
                }

                @Override
                public int min() {
                    return this.vir.min() + IntOffsetView.this.cste;
                }

                @Override
                public int max() {
                    return this.vir.max() + IntOffsetView.this.cste;
                }

                @Override
                public void dispose() {
                    super.dispose();
                    this.vir.dispose();
                }
            };
        }
        if (bottomUp) {
            this._riterator.bottomUpInit();
        } else {
            this._riterator.topDownInit();
        }
        return this._riterator;
    }

    @Override
    public void justifyEvent(IntEventType mask, int one, int two, int three) {
        switch (mask) {
            case DECUPP: {
                this.model.getSolver().getEventObserver().updateUpperBound(this, one + this.cste, two + this.cste, this);
                break;
            }
            case INCLOW: {
                this.model.getSolver().getEventObserver().updateLowerBound(this, one + this.cste, two + this.cste, this);
                break;
            }
            case REMOVE: {
                this.model.getSolver().getEventObserver().removeValue(this, one + this.cste, this);
                break;
            }
            case INSTANTIATE: {
                this.model.getSolver().getEventObserver().instantiateTo(this, one + this.cste, this, two + this.cste, three + this.cste);
            }
        }
    }

    @Override
    public void explain(int p, ExplanationForSignedClause explanation) {
        if (explanation.readVar(p) == this) {
            IntIterableRangeSet set1 = explanation.complement((IntVar)this.getVariable());
            IntIterableRangeSet set0 = explanation.domain((IntVar)this.getVariable());
            set0.plus(this.cste);
            this.intersectLit(set0, explanation);
            this.getVariable().unionLit(set1, explanation);
        } else {
            assert (explanation.readVar(p) == this.getVariable());
            IntIterableRangeSet set0 = explanation.complement(this);
            IntIterableRangeSet set1 = explanation.domain(this);
            set1.minus(this.cste);
            this.unionLit(set0, explanation);
            this.getVariable().intersectLit(set1, explanation);
        }
    }
}

