/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.trace;

import com.github.cpprofiler.Connector;
import java.io.IOException;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.trace.SearchViz;

public class CPProfiler
extends SearchViz {
    private Connector connector;

    public CPProfiler(Solver aSolver, boolean sendDomain) {
        super(aSolver, sendDomain);
    }

    @Override
    protected boolean connect(String label) {
        if (this.connector == null) {
            this.connector = new Connector();
        }
        try {
            this.connector.connect(6565);
            this.connector.restart(label, 0);
        }
        catch (IOException e2) {
            System.err.println("Unable to connect to CPProfiler, make sure it is started. No information will be sent.");
            return false;
        }
        return true;
    }

    @Override
    protected void disconnect() {
        if (this.connected) {
            try {
                this.connector.disconnect();
            }
            catch (IOException e2) {
                System.err.println("Unable to disconnect CPProfiler.");
            }
        }
    }

    @Override
    protected void sendNode(int nc, int pid, int alt, int kid, int rid, String label, String info) {
        this.send(nc, pid, alt, kid, rid, Connector.NodeStatus.BRANCH, label, info);
    }

    @Override
    protected void sendSolution(int nc, int pid, int alt, int kid, int rid, String label, String info) {
        this.send(nc, pid, alt, kid, rid, Connector.NodeStatus.SOLVED, label, info);
    }

    @Override
    protected void sendFailure(int nc, int pid, int alt, int kid, int rid, String label, String info) {
        this.send(nc, pid, alt, kid, rid, Connector.NodeStatus.FAILED, label, info);
    }

    @Override
    protected void sendRestart(int rid) {
        try {
            this.connector.restart(rid);
        }
        catch (IOException e2) {
            System.err.println("Lost connection with CPProfiler. No more information will be sent.");
            this.connected = false;
        }
    }

    private void send(int nc, int pid, int alt, int kid, int rid, Connector.NodeStatus status, String label, String info) {
        try {
            this.connector.createNode(nc, pid, alt, kid, status).setRestartId(rid).setLabel(label).setInfo(info).send();
        }
        catch (IOException e2) {
            System.err.println("Lost connection with CPProfiler. No more information will be sent.");
            this.connected = false;
        }
    }
}

