/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.selectors.values.graph.node;

import java.util.Random;
import org.chocosolver.solver.search.strategy.selectors.values.graph.node.GraphNodeSelector;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class GraphRandomNode
implements GraphNodeSelector {
    private final Random rd;

    public GraphRandomNode(long seed) {
        this.rd = new Random(seed);
    }

    public int selectNode(GraphVar g2) {
        ISet envNodes = g2.getPotentialNodes();
        ISet kerNodes = g2.getMandatoryNodes();
        int delta = envNodes.size() - kerNodes.size();
        if (delta != 0) {
            delta = this.rd.nextInt(delta);
            ISetIterator iSetIterator = envNodes.iterator();
            while (iSetIterator.hasNext()) {
                int i = (Integer)iSetIterator.next();
                if (kerNodes.contains(i)) continue;
                if (delta == 0) {
                    return i;
                }
                --delta;
            }
        }
        return -1;
    }
}

