/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.crop;

import it.geosolutions.jaiext.crop.CropCRIF;
import it.geosolutions.jaiext.range.Range;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.OperationRegistry;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;

public class CropDescriptor
extends OperationDescriptorImpl {
    static final Logger LOGGER = Logger.getLogger(CropDescriptor.class.getName());
    private static final long serialVersionUID = -2995031215260355215L;
    static final int X_ARG = 0;
    static final int Y_ARG = 1;
    static final int WIDTH_ARG = 2;
    static final int HEIGHT_ARG = 3;
    static final int ROI_ARG = 4;
    static final int NO_DATA_ARG = 5;
    static final int DEST_NO_DATA_ARG = 6;
    private static final String[] paramNames = new String[]{"x", "y", "width", "height", "ROI", "NoData", "destNoData"};
    private static final Class[] paramClasses = new Class[]{Float.class, Float.class, Float.class, Float.class, ROI.class, Range.class, double[].class};
    private static final Object[] paramDefaults = new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f), NO_PARAMETER_DEFAULT, NO_PARAMETER_DEFAULT, null, null, new double[]{0.0}};

    public CropDescriptor() {
        super(new String[][]{{"GlobalName", "Crop"}, {"LocalName", "Crop"}, {"Vendor", "it.geosolutions.jaiext"}, {"Description", "Crops the image to the specified bounds"}, {"DocURL", "Not Defined"}, {"Version", "1.0.0"}, {"arg0Desc", paramNames[0] + " (Integer, default = 0) min image X"}, {"arg1Desc", paramNames[1] + " (Integer, default = 0) min image Y"}, {"arg2Desc", paramNames[2] + " (Integer) image width"}, {"arg3Desc", paramNames[3] + " (Integer) image height"}, {"arg4Desc", paramNames[4] + " (ROI) eventual ROI object used"}, {"arg5Desc", paramNames[5] + " (Range) eventual NoData Range used"}, {"arg6Desc", paramNames[6] + " (double[]) eventual destination NoData values"}}, new String[]{"rendered"}, 1, paramNames, paramClasses, paramDefaults, null);
    }

    public static void register() {
        block3: {
            try {
                OperationRegistry opr = JAI.getDefaultInstance().getOperationRegistry();
                if (opr.getDescriptor("rendered", "Crop") == null) {
                    OperationRegistry registry = JAI.getDefaultInstance().getOperationRegistry();
                    CropDescriptor descriptor = new CropDescriptor();
                    String descName = descriptor.getName();
                    registry.registerDescriptor(descriptor);
                    registry.registerFactory("rendered", descName, "it.geosolutions.jaiext", new CropCRIF());
                }
            }
            catch (Exception e2) {
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.log(Level.FINE, e2.getLocalizedMessage());
            }
        }
    }

    public static RenderedOp create(RenderedImage source0, Float x, Float y, Float width, Float height, ROI roi, Range noData, double[] destNoData, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("Crop", "rendered");
        pb.setSource("source0", source0);
        pb.setParameter("x", x);
        pb.setParameter("y", y);
        pb.setParameter("width", width);
        pb.setParameter("height", height);
        pb.setParameter("ROI", roi);
        pb.setParameter("NoData", noData);
        pb.setParameter("destNoData", destNoData);
        return JAI.create("Crop", pb, hints);
    }
}

