/*
 * Decompiled with CFR 0.152.
 */
package de.rototor.pdfbox.graphics2d;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

class PrivateFieldAccessor {
    private static IAccessableSetter performSetAccessible = new IAccessableSetter(){

        @Override
        public void setAccessible(AccessibleObject obj) {
            obj.setAccessible(true);
        }
    };

    PrivateFieldAccessor() {
    }

    private static void setAccessible(AccessibleObject object) {
        performSetAccessible.setAccessible(object);
    }

    public static <T> T getPrivateField(Object object, String property) {
        for (Class<?> cls = object.getClass(); cls != null; cls = cls.getSuperclass()) {
            for (Field f : cls.getDeclaredFields()) {
                if (!f.getName().equals(property)) continue;
                PrivateFieldAccessor.setAccessible(f);
                try {
                    return (T)f.get(object);
                }
                catch (RuntimeException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    throw new RuntimeException("Error while accessing field " + property + " of " + cls, e3);
                }
            }
        }
        throw new NoSuchFieldError(property);
    }

    static {
        try {
            final Method setAccessible = AccessibleObject.class.getDeclaredMethod("setAccessible0", Boolean.TYPE);
            Field methodModifiers = Method.class.getDeclaredField("modifiers");
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Constructor<?> unsafeConstructor = unsafeClass.getDeclaredConstructor(new Class[0]);
            unsafeConstructor.setAccessible(true);
            Object unsafe = unsafeConstructor.newInstance(new Object[0]);
            Method objectFieldOffsetMethod = unsafeClass.getMethod("objectFieldOffset", Field.class);
            long methodModifiersOffset = (Long)objectFieldOffsetMethod.invoke(unsafe, methodModifiers);
            Method getAndSetInt = unsafeClass.getMethod("getAndSetInt", Object.class, Long.TYPE, Integer.TYPE);
            getAndSetInt.invoke(unsafe, setAccessible, methodModifiersOffset, 1);
            performSetAccessible = new IAccessableSetter(){

                @Override
                public void setAccessible(AccessibleObject obj) {
                    try {
                        setAccessible.invoke((Object)obj, true);
                    }
                    catch (Exception e2) {
                        throw new RuntimeException(e2);
                    }
                }
            };
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static interface IAccessableSetter {
        public void setAccessible(AccessibleObject var1);
    }
}

