/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageio.plugins.jpeg2000.J2KImageWriteParam;
import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.jpeg2000.I18N;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriteParamJava;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadata;
import com.sun.media.imageioimpl.plugins.jpeg2000.RenderedImageSrc;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import jj2000.j2k.codestream.writer.FileCodestreamWriter;
import jj2000.j2k.codestream.writer.HeaderEncoder;
import jj2000.j2k.entropy.encoder.EntropyCoder;
import jj2000.j2k.entropy.encoder.PostCompRateAllocator;
import jj2000.j2k.fileformat.writer.FileFormatWriter;
import jj2000.j2k.image.ImgDataConverter;
import jj2000.j2k.image.Tiler;
import jj2000.j2k.image.forwcomptransf.ForwCompTransf;
import jj2000.j2k.quantization.quantizer.Quantizer;
import jj2000.j2k.roi.encoder.ROIScaler;
import jj2000.j2k.util.CodestreamManipulator;
import jj2000.j2k.wavelet.analysis.ForwardWT;

public class J2KImageWriter
extends ImageWriter {
    public static String WRITE_ABORTED = "Write aborted.";
    private ImageOutputStream stream = null;

    public void processImageProgressWrapper(float percentageDone) {
        this.processImageProgress(percentageDone);
    }

    public J2KImageWriter(ImageWriterSpi originator) {
        super(originator);
    }

    public void setOutput(Object output) {
        super.setOutput(output);
        if (output != null) {
            if (!(output instanceof ImageOutputStream)) {
                throw new IllegalArgumentException(I18N.getString("J2KImageWriter0"));
            }
            this.stream = (ImageOutputStream)output;
        } else {
            this.stream = null;
        }
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new J2KImageWriteParam();
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return new J2KMetadata(imageType, param, this);
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        if (inData == null) {
            throw new IllegalArgumentException("inData == null!");
        }
        if (imageType == null) {
            throw new IllegalArgumentException("imageType == null!");
        }
        if (inData instanceof J2KMetadata) {
            return (IIOMetadata)((J2KMetadata)inData).clone();
        }
        try {
            J2KMetadata outData = new J2KMetadata();
            List<String> formats = Arrays.asList(inData.getMetadataFormatNames());
            String format = null;
            if (formats.contains("com_sun_media_imageio_plugins_jpeg2000_image_1.0")) {
                format = "com_sun_media_imageio_plugins_jpeg2000_image_1.0";
            } else if (inData.isStandardMetadataFormatSupported()) {
                format = "javax_imageio_1.0";
            }
            if (format != null) {
                outData.setFromTree(format, inData.getAsTree(format));
                return outData;
            }
        }
        catch (IIOInvalidTreeException e2) {
            return null;
        }
        return null;
    }

    public boolean canWriteRasters() {
        return true;
    }

    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        ImageTypeSpecifier type;
        ColorModel colorModel;
        int i;
        J2KImageWriteParamJava j2kwparam;
        if (this.stream == null) {
            throw new IllegalStateException(I18N.getString("J2KImageWriter7"));
        }
        if (image == null) {
            throw new IllegalArgumentException(I18N.getString("J2KImageWriter8"));
        }
        this.clearAbortRequest();
        this.processImageStarted(0);
        RenderedImage input = null;
        boolean writeRaster = image.hasRaster();
        Raster raster = null;
        SampleModel sampleModel = null;
        if (writeRaster) {
            raster = image.getRaster();
            sampleModel = raster.getSampleModel();
        } else {
            input = image.getRenderedImage();
            sampleModel = input.getSampleModel();
        }
        this.checkSampleModel(sampleModel);
        if (param == null) {
            param = this.getDefaultWriteParam();
        }
        if ((j2kwparam = new J2KImageWriteParamJava(image, param)).getPackPacketHeaderInTile() && j2kwparam.getPackPacketHeaderInMain()) {
            throw new IllegalArgumentException(I18N.getString("J2KImageWriter1"));
        }
        if (j2kwparam.getLossless() && j2kwparam.getEncodingRate() != Double.MAX_VALUE) {
            throw new IllegalArgumentException(I18N.getString("J2KImageWriter2"));
        }
        if (!writeRaster && input.getColorModel() instanceof IndexColorModel || writeRaster && raster.getSampleModel() instanceof MultiPixelPackedSampleModel) {
            j2kwparam.setDecompositionLevel("0");
            j2kwparam.setLossless(true);
            j2kwparam.setEncodingRate(Double.MAX_VALUE);
            j2kwparam.setQuantizationType("reversible");
            j2kwparam.setFilters("w5x3");
        } else if (j2kwparam.getEncodingRate() == Double.MAX_VALUE) {
            j2kwparam.setLossless(true);
            j2kwparam.setQuantizationType("reversible");
            j2kwparam.setFilters("w5x3");
        }
        boolean pphTile = j2kwparam.getPackPacketHeaderInTile();
        boolean pphMain = j2kwparam.getPackPacketHeaderInMain();
        boolean tempSop = false;
        boolean tempEph = false;
        int[] bands = param.getSourceBands();
        int ncomp = sampleModel.getNumBands();
        if (bands != null) {
            ncomp = bands.length;
        }
        RenderedImageSrc imgsrc = null;
        imgsrc = writeRaster ? new RenderedImageSrc(raster, j2kwparam, this) : new RenderedImageSrc(input, j2kwparam, this);
        boolean[] imsigned = new boolean[ncomp];
        if (bands != null) {
            for (i = 0; i < ncomp; ++i) {
                imsigned[i] = imgsrc.isOrigSigned(bands[i]);
            }
        } else {
            for (i = 0; i < ncomp; ++i) {
                imsigned[i] = imgsrc.isOrigSigned(i);
            }
        }
        int tw = j2kwparam.getTileWidth();
        int th = j2kwparam.getTileHeight();
        int refx = j2kwparam.getMinX();
        int refy = j2kwparam.getMinY();
        if (refx < 0 || refy < 0) {
            throw new IIOException(I18N.getString("J2KImageWriter3"));
        }
        int trefx = j2kwparam.getTileGridXOffset();
        int trefy = j2kwparam.getTileGridYOffset();
        if (trefx < 0 || trefy < 0 || trefx > refx || trefy > refy) {
            throw new IIOException(I18N.getString("J2KImageWriter4"));
        }
        Tiler imgtiler = new Tiler(imgsrc, refx, refy, trefx, trefy, tw, th);
        ForwCompTransf fctransf = new ForwCompTransf(imgtiler, j2kwparam);
        ImgDataConverter converter = new ImgDataConverter(fctransf);
        ForwardWT dwt = ForwardWT.createInstance(converter, j2kwparam);
        Quantizer quant = Quantizer.createInstance(dwt, j2kwparam);
        ROIScaler rois = ROIScaler.createInstance(quant, j2kwparam);
        EntropyCoder ecoder = EntropyCoder.createInstance(rois, j2kwparam, j2kwparam.getCodeBlockSize(), j2kwparam.getPrecinctPartition(), j2kwparam.getBypass(), j2kwparam.getResetMQ(), j2kwparam.getTerminateOnByte(), j2kwparam.getCausalCXInfo(), j2kwparam.getCodeSegSymbol(), j2kwparam.getMethodForMQLengthCalc(), j2kwparam.getMethodForMQTermination());
        File tmpFile = File.createTempFile("jiio-", ".tmp");
        tmpFile.deleteOnExit();
        FileCodestreamWriter bwriter = new FileCodestreamWriter(tmpFile, Integer.MAX_VALUE);
        float rate = (float)j2kwparam.getEncodingRate();
        PostCompRateAllocator ralloc = PostCompRateAllocator.createInstance(ecoder, rate, bwriter, j2kwparam);
        HeaderEncoder headenc = new HeaderEncoder(imgsrc, imsigned, dwt, imgtiler, j2kwparam, rois, ralloc);
        ralloc.setHeaderEncoder(headenc);
        headenc.encodeMainHeader();
        try {
            ralloc.initialize();
        }
        catch (RuntimeException e2) {
            if (WRITE_ABORTED.equals(e2.getMessage())) {
                bwriter.close();
                tmpFile.delete();
                this.processWriteAborted();
                return;
            }
            throw e2;
        }
        headenc.reset();
        headenc.encodeMainHeader();
        bwriter.commitBitstreamHeader(headenc);
        ralloc.runAndWrite();
        bwriter.close();
        int fileLength = bwriter.getLength();
        int pktspertp = j2kwparam.getPacketPerTilePart();
        int ntiles = imgtiler.getNumTiles();
        if (pktspertp > 0 || pphTile || pphMain) {
            CodestreamManipulator cm = new CodestreamManipulator(tmpFile, ntiles, pktspertp, pphMain, pphTile, tempSop, tempEph);
            fileLength += cm.doCodestreamManipulation();
        }
        int nc = imgsrc.getNumComps();
        int[] bpc = new int[nc];
        for (int comp = 0; comp < nc; ++comp) {
            bpc[comp] = imgsrc.getNomRangeBits(comp);
        }
        ColorModel colorModel2 = colorModel = input != null ? input.getColorModel() : null;
        if (bands != null && (type = param.getDestinationType()) != null) {
            colorModel = type.getColorModel();
        }
        if (colorModel == null) {
            colorModel = ImageUtil.createColorModel(sampleModel);
        }
        J2KMetadata metadata = null;
        if (param instanceof J2KImageWriteParam && !((J2KImageWriteParam)param).getWriteCodeStreamOnly()) {
            IIOMetadata inMetadata = image.getMetadata();
            J2KMetadata metadata1 = new J2KMetadata(colorModel, sampleModel, imgsrc.getImgWidth(), imgsrc.getImgHeight(), param, this);
            if (inMetadata == null) {
                metadata = metadata1;
            } else {
                if (colorModel != null) {
                    ImageTypeSpecifier imageType = new ImageTypeSpecifier(colorModel, sampleModel);
                    metadata = (J2KMetadata)this.convertImageMetadata(inMetadata, imageType, param);
                } else {
                    String metaFormat = null;
                    List<String> metaFormats = Arrays.asList(inMetadata.getMetadataFormatNames());
                    if (metaFormats.contains("com_sun_media_imageio_plugins_jpeg2000_image_1.0")) {
                        metaFormat = "com_sun_media_imageio_plugins_jpeg2000_image_1.0";
                    } else if (inMetadata.isStandardMetadataFormatSupported()) {
                        metaFormat = "javax_imageio_1.0";
                    }
                    metadata = new J2KMetadata();
                    if (metaFormat != null) {
                        metadata.setFromTree(metaFormat, inMetadata.getAsTree(metaFormat));
                    }
                }
                metadata.mergeTree("com_sun_media_imageio_plugins_jpeg2000_image_1.0", metadata1.getAsTree("com_sun_media_imageio_plugins_jpeg2000_image_1.0"));
            }
        }
        FileFormatWriter ffw = new FileFormatWriter(tmpFile, this.stream, imgsrc.getImgHeight(), imgsrc.getImgWidth(), nc, bpc, fileLength, colorModel, sampleModel, metadata);
        fileLength += ffw.writeFileFormat();
        tmpFile.delete();
        this.processImageComplete();
    }

    public synchronized void abort() {
        super.abort();
    }

    public void reset() {
        super.reset();
        this.stream = null;
    }

    public boolean getAbortRequest() {
        return this.abortRequested();
    }

    private void checkSampleModel(SampleModel sm) {
        int type = sm.getDataType();
        if (type < 0 || type > 3) {
            throw new IllegalArgumentException(I18N.getString("J2KImageWriter5"));
        }
        if (sm.getNumBands() > 16384) {
            throw new IllegalArgumentException(I18N.getString("J2KImageWriter6"));
        }
    }
}

