/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model.filters;

import org.dmg.pmml.Version;
import org.jpmml.model.filters.PMMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;

public class ImportFilter
extends PMMLFilter {
    private boolean extensions = true;

    public ImportFilter() {
        this(true);
    }

    public ImportFilter(boolean extensions) {
        super(Version.PMML_4_4);
        this.setExtensions(extensions);
    }

    public ImportFilter(XMLReader reader) {
        this(reader, true);
    }

    public ImportFilter(XMLReader reader, boolean extensions) {
        super(reader, Version.PMML_4_4);
        this.setExtensions(extensions);
    }

    @Override
    public String filterLocalName(String localName) {
        if ("Trend".equals(localName) && ImportFilter.compare(this.getSource(), Version.PMML_4_0) == 0) {
            return "Trend_ExpoSmooth";
        }
        return localName;
    }

    @Override
    public Attributes filterAttributes(String localName, Attributes attributes) {
        if ("Apply".equals(localName)) {
            String function;
            if (ImportFilter.compare(this.getSource(), Version.PMML_4_1) == 0) {
                attributes = ImportFilter.renameAttribute(attributes, "mapMissingTo", "defaultValue");
            }
            if (ImportFilter.compare(this.getSource(), Version.PMML_4_3) <= 0 && (function = ImportFilter.getAttribute(attributes, "function")) != null) {
                switch (function) {
                    case "x-acos": 
                    case "x-asin": 
                    case "x-atan": 
                    case "x-cos": 
                    case "x-cosh": 
                    case "x-expm1": 
                    case "x-hypot": 
                    case "x-ln1p": 
                    case "x-modulo": 
                    case "x-rint": 
                    case "x-sin": 
                    case "x-sinh": 
                    case "x-tan": 
                    case "x-tanh": {
                        attributes = ImportFilter.setAttribute(attributes, "function", function.substring("x-".length()));
                        break;
                    }
                }
            }
        } else if ("MiningField".equals(localName)) {
            if (ImportFilter.compare(this.getSource(), Version.PMML_4_3) <= 0) {
                attributes = ImportFilter.renameAttribute(attributes, "x-invalidValueReplacement", "invalidValueReplacement");
            }
        } else if ("PMML".equals(localName)) {
            Version target = this.getTarget();
            if (this.getExtensions()) {
                attributes = ImportFilter.renameAttribute(attributes, "version", "x-baseVersion");
            }
            attributes = ImportFilter.setAttribute(attributes, "version", target.getVersion());
        } else if ("Segmentation".equals(localName)) {
            if (ImportFilter.compare(this.getSource(), Version.PMML_4_3) <= 0) {
                String multipleModelMethod = ImportFilter.getAttribute(attributes, "multipleModelMethod");
                attributes = ImportFilter.renameAttribute(attributes, "x-missingPredictionTreatment", "missingPredictionTreatment");
                attributes = ImportFilter.renameAttribute(attributes, "x-missingThreshold", "missingThreshold");
                if (multipleModelMethod != null) {
                    switch (multipleModelMethod) {
                        case "x-weightedMedian": 
                        case "x-weightedSum": {
                            attributes = ImportFilter.setAttribute(attributes, "multipleModelMethod", multipleModelMethod.substring("x-".length()));
                            break;
                        }
                    }
                }
            }
        } else if ("TargetValue".equals(localName) && ImportFilter.compare(this.getSource(), Version.PMML_3_1) <= 0) {
            attributes = ImportFilter.renameAttribute(attributes, "rawDataValue", "displayValue");
        }
        return attributes;
    }

    public boolean getExtensions() {
        return this.extensions;
    }

    private void setExtensions(boolean extensions) {
        this.extensions = extensions;
    }
}

