/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing.file_chooser;

import com.qarks.util.ui.resources.ResourceKey;
import com.qarks.util.ui.resources.ResourceManager;
import com.qarks.util.ui.swing.file_chooser.DefaultFileView;
import com.qarks.util.ui.swing.file_chooser.DirectoryChooser;
import com.qarks.util.ui.swing.file_chooser.FileCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class FileSystemExplorer
extends JDialog
implements ActionListener {
    private DirectoryChooser dirChooser;
    private JList fileList;
    private DefaultListModel fileListModel;
    private boolean cancelled = false;
    private JButton ok;
    private JButton cancel;
    private String currentDir;

    public FileSystemExplorer(Window window, String string, String string2) {
        super(window, string, Dialog.ModalityType.APPLICATION_MODAL);
        this.currentDir = string2;
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        Container container = this.getContentPane();
        container.setLayout(new GridLayout(1, 1));
        container.add(jPanel);
        this.fileListModel = new DefaultListModel();
        this.fileList = new JList(this.fileListModel);
        DefaultFileView defaultFileView = new DefaultFileView();
        this.fileList.setCellRenderer(new FileCellRenderer(defaultFileView));
        this.dirChooser = new DirectoryChooser();
        if (string2 != null) {
            this.dirChooser.setCurrentDirectory(string2);
        }
        JSplitPane jSplitPane = new JSplitPane(1, this.dirChooser, new JScrollPane(this.fileList));
        jPanel.add((Component)jSplitPane, "Center");
        jSplitPane.setDividerLocation(300);
        this.ok = new JButton(ResourceManager.getString((Object)ResourceKey.OK));
        this.ok.setEnabled(false);
        this.cancel = new JButton(ResourceManager.getString((Object)ResourceKey.CANCEL));
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 5, 5));
        jPanel2.add(this.ok);
        jPanel2.add(this.cancel);
        jPanel.add((Component)jPanel2, "South");
        this.setSize(600, 500);
        this.dirChooser.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                FileSystemExplorer.this.onDirectorySelected(FileSystemExplorer.this.dirChooser.getSelectedDirectory());
            }
        });
        this.fileList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FileSystemExplorer.this.ok.setEnabled(FileSystemExplorer.this.fileList.getSelectedValue() != null);
            }
        });
    }

    private void onDirectorySelected(String string) {
        File[] fileArray;
        this.currentDir = string;
        this.fileListModel.clear();
        File file = new File(string);
        if (file.exists() && (fileArray = file.listFiles()) != null && fileArray.length > 0) {
            for (File file2 : fileArray) {
                this.fileListModel.insertElementAt(file2, this.getBestIndex(file2));
            }
        }
    }

    public String getCurrentDir() {
        return this.currentDir;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    private int getBestIndex(File file) {
        int n = 0;
        boolean bl = false;
        String string = file.getName();
        for (int i = 0; !bl && i < this.fileListModel.size(); ++i) {
            File file2 = (File)this.fileListModel.elementAt(i);
            if (file.isDirectory() == file2.isDirectory()) {
                String string2 = file2.getName();
                if (string.compareTo(string2) >= 0) continue;
                bl = true;
                n = Math.max(0, i);
                continue;
            }
            if (!file.isDirectory() || file2.isDirectory()) continue;
            bl = true;
            n = i;
        }
        if (!bl) {
            n = this.fileListModel.size();
        }
        return n;
    }

    public File[] getSelectedFiles() {
        File[] fileArray = new File[]{};
        Object[] objectArray = this.fileList.getSelectedValues();
        if (objectArray != null) {
            fileArray = new File[objectArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                fileArray[i] = (File)objectArray[i];
            }
        }
        return fileArray;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.ok) {
            this.dispose();
        } else {
            this.cancelled = true;
            this.dispose();
        }
    }
}

