/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.rosuda.ibase.MapSegment;
import org.rosuda.ibase.SVar;
import org.rosuda.ibase.SVarFixDouble;
import org.rosuda.ibase.SVarFixFact;
import org.rosuda.ibase.SVarFixInt;
import org.rosuda.ibase.SVarObj;
import org.rosuda.ibase.SVarSet;
import org.rosuda.util.Tools;

public class LoaderFLF {
    public int load(File file, SVarSet sVarSet) throws IOException {
        SVar[] sVarArray = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = bufferedReader.readLine();
        if (string == null || !string.equals("FLF1")) {
            throw new IOException("Unsupported file format (expecting FLF1)");
        }
        while ((string = bufferedReader.readLine()) != null && !string.equals("")) {
            if (string.substring(0, 3).equals("fs:")) {
                n3 = Tools.parseInt(string.substring(3));
                sVarArray = new SVar[n3];
            }
            if (!string.substring(0, 4).equals("rec:")) continue;
            n = Tools.parseInt(string.substring(4));
        }
        if (n3 < 1 || n < 1) {
            throw new IOException("File contains no data (at least 1x1 required)");
        }
        while (n2 < n3) {
            Object[] objectArray;
            SVar sVar = null;
            String string2 = bufferedReader.readLine();
            string = bufferedReader.readLine();
            if (string == null || string.length() < 3) {
                throw new IOException("Corrupted file");
            }
            String string3 = string.substring(0, 3);
            if (string3.equals("INT")) {
                int[] nArray = new int[n];
                int n4 = 0;
                while (n4 < n) {
                    string = bufferedReader.readLine();
                    if (string == null) {
                        throw new IOException("Corrupted file");
                    }
                    nArray[n4++] = string.equals("NA") ? SVar.int_NA : Tools.parseInt(string);
                }
                sVar = new SVarFixInt(string2, nArray, false);
            } else if (string3.equals("FLT")) {
                double[] dArray = new double[n];
                int n5 = 0;
                while (n5 < n) {
                    string = bufferedReader.readLine();
                    if (string == null) {
                        throw new IOException("Corrupted file");
                    }
                    dArray[n5++] = string.equals("NA") ? SVar.double_NA : Tools.parseDouble(string);
                }
                sVar = new SVarFixDouble(string2, dArray, false);
            } else if (string3.equals("PLN")) {
                sVar = new SVarObj(string2, false);
                sVar.setContentsType(8);
                for (int i = 0; i < n; ++i) {
                    string = bufferedReader.readLine();
                    if (string == null) {
                        throw new IOException("Corrupted file");
                    }
                    int n6 = Tools.parseInt(string);
                    if (n6 < 1) {
                        sVar.add(null);
                        continue;
                    }
                    MapSegment mapSegment = new MapSegment();
                    while (n6 > 0) {
                        int n7;
                        string = bufferedReader.readLine();
                        if (string == null) {
                            throw new IOException("Corrupted file");
                        }
                        int n8 = Tools.parseInt(string);
                        if (n8 < 0) {
                            throw new IOException("Corrupted file (PLN.points<0)");
                        }
                        objectArray = new double[n8];
                        double[] dArray = new double[n8];
                        string = bufferedReader.readLine();
                        for (n7 = 0; n7 < n8; ++n7) {
                            string = bufferedReader.readLine();
                            if (string == null) {
                                throw new IOException("Corrupted file");
                            }
                            objectArray[n7] = (int)Tools.parseDouble(string);
                        }
                        for (n7 = 0; n7 < n8; ++n7) {
                            string = bufferedReader.readLine();
                            if (string == null) {
                                throw new IOException("Corrupted file");
                            }
                            dArray[n7] = Tools.parseDouble(string);
                        }
                        mapSegment.add((double[])objectArray, dArray);
                        --n6;
                    }
                    sVar.add(mapSegment);
                }
            } else if (string3.equals("FAC")) {
                string = bufferedReader.readLine();
                if (string == null) {
                    throw new IOException("Corrupted file");
                }
                int n9 = Tools.parseInt(string);
                if (n9 < 1) {
                    throw new IOException("Invalid file (variable " + string2 + " has no levels anthough being a factor)");
                }
                String[] stringArray = new String[n9];
                int n10 = 0;
                while (n10 < n9) {
                    string = bufferedReader.readLine();
                    if (string == null) {
                        throw new IOException("Corrupted file");
                    }
                    stringArray[n10++] = string;
                }
                objectArray = new int[n];
                for (n10 = 0; n10 < n; ++n10) {
                    string = bufferedReader.readLine();
                    if (string == null) {
                        throw new IOException("Corrupted file");
                    }
                    try {
                        objectArray[n10] = Integer.parseInt(string);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        objectArray[n10] = -1;
                    }
                }
                sVar = new SVarFixFact(string2, (int[])objectArray, stringArray);
            }
            if (sVar == null) {
                throw new IOException("Unsupported field type (" + string3 + ").");
            }
            sVarArray[n2] = sVar;
            ++n2;
        }
        n2 = 0;
        while (n2 < n3) {
            sVarSet.add(sVarArray[n2++]);
        }
        bufferedReader.close();
        return n3;
    }
}

