/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Boosting;

import java.util.Vector;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Boosting.Fun;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Boosting.OPV;
import org.core.Randomize;

public class LinearSearchBrent {
    double[] dbus;
    double[] xbus;
    Fun f;
    private final double PASO_INI = 1.0;
    private final double TOL_BLIN = 0.01f;
    private final double TOL_CERO = 1.0E-9f;
    private final double MIN_DELTABLIN = 1.0E-6f;
    private final int MAX_ITERBLIN = 10;
    private final int MAX_ITERINI = 10;
    final int menor_y = 0;
    final int menor_x = 1;

    public LinearSearchBrent(Fun vf, double[] vdbus, double[] vxbus) {
        this.f = vf;
        this.dbus = vdbus;
        this.xbus = vxbus;
    }

    public double g(double alfa) {
        return this.f.evalua(OPV.Suma(this.xbus, OPV.Multiplica(alfa, this.dbus)));
    }

    private void sort(pair[] a, int size, int criterio) {
        for (int i = 1; i < size; ++i) {
            pair x = new pair(a[i].first, a[i].second);
            for (int j = i - 1; !(j < 0 || criterio == 0 && a[j].second <= x.second || criterio == 1 && a[j].first <= x.first); --j) {
                a[j + 1].first = a[j].first;
                a[j + 1].second = a[j].second;
            }
            a[j + 1].first = x.first;
            a[j + 1].second = x.second;
        }
    }

    private double q(double x, double x1, double x2, double x3, double f1, double f2, double f3) {
        return f1 * (x - x2) * (x - x3) / (x1 - x2) / (x1 - x3) + f2 * (x - x1) * (x - x3) / (x2 - x1) / (x2 - x3) + f3 * (x - x1) * (x - x2) / (x3 - x1) / (x3 - x2);
    }

    public double EncuentraMinimoPositivo(Randomize r) {
        int iteracion = 0;
        double x = -1.0;
        double yl = -1.0;
        double yr = -1.0;
        double y = -1.0;
        double xl = -1.0;
        double xr = -1.0;
        Vector<pair> tresp = new Vector<pair>();
        double fit0 = this.g(0.0);
        tresp.add(new pair(0.0, fit0));
        double PASODOBLE = 2.0;
        double PASOMITAD = 0.5;
        for (int i = 0; i < 10; ++i) {
            tresp.add(new pair(PASODOBLE, this.g(PASODOBLE)));
            tresp.add(new pair(PASOMITAD, this.g(PASOMITAD)));
            PASODOBLE *= 2.0;
            PASOMITAD /= 2.0;
            if (tresp.size() < 3) continue;
            int minj = 0;
            for (int j = 0; j < tresp.size(); ++j) {
                pair ptmp = (pair)tresp.get(j);
                if (!(ptmp.second < y) && j != 0) continue;
                y = ptmp.second;
                x = ptmp.first;
                minj = j;
            }
            xl = -1.0;
            xr = -1.0;
            boolean first1 = true;
            boolean first2 = true;
            for (int j = 0; j < tresp.size(); ++j) {
                if (j == minj) continue;
                pair ptmp = (pair)tresp.get(j);
                if (!(ptmp.second > y)) continue;
                if (ptmp.first < x) {
                    if (ptmp.first > xl || first1) {
                        xl = ptmp.first;
                        yl = ptmp.second;
                    }
                    first1 = false;
                }
                if (!(ptmp.first > x)) continue;
                if (ptmp.first < xr || first2) {
                    xr = ptmp.first;
                    yr = ptmp.second;
                }
                first2 = false;
            }
            if (xl != -1.0 && xr != -1.0) break;
        }
        if (xl == -1.0 || yr == -1.0) {
            return 0.0;
        }
        double fmin = y;
        while (xr - xl > (double)0.01f && iteracion < 10) {
            ++iteracion;
            double b12 = xl * xl - x * x;
            double b23 = x * x - xr * xr;
            double b31 = xr * xr - xl * xl;
            double a23 = x - xr;
            double a31 = xr - xl;
            double a12 = xl - x;
            double denominador = a23 * yl + a31 * y + a12 * yr;
            if (Math.abs(denominador) < (double)1.0E-9f) {
                System.out.println("Funcion no convexa en Brent " + this.g(x));
                return 0.0;
            }
            double x4 = 0.5 * (b23 * yl + b31 * y + b12 * yr) / denominador;
            double y4 = this.g(x4);
            if (!(xl <= x4) || !(x4 <= xr)) {
                System.out.println("Error en determinaci\u00c3\u00b3n de x4, ajustar tolerancias");
                System.out.println("xl=" + xl + " yl=" + yl);
                System.out.println("x=" + x + " y=" + y);
                System.out.println("xr=" + xr + " yr=" + yr);
                System.out.println("x4=" + x4 + " y4=" + y4);
                System.out.println("ql=" + this.q(xl, xl, x, xr, yl, y, yr));
                System.out.println("q0=" + this.q(x, xl, x, xr, yl, y, yr));
                System.out.println("qr=" + this.q(xr, xl, x, xr, yl, y, yr));
                System.out.println("q4=" + this.q(x4, xl, x, xr, yl, y, yr));
                return 0.0;
            }
            pair[] brent = new pair[]{new pair(xl, yl), new pair(x, y), new pair(xr, yr), new pair(x4, y4)};
            this.sort(brent, 4, 1);
            double minvy = brent[0].second;
            int iminvy = 0;
            for (int i = 0; i < 4; ++i) {
                if (!(minvy > brent[i].second)) continue;
                minvy = brent[i].second;
                iminvy = i;
            }
            if (iminvy == 1) {
                xl = brent[0].first;
                yl = brent[0].second;
                x = brent[1].first;
                y = brent[1].second;
                xr = brent[2].first;
                yr = brent[2].second;
            } else if (iminvy == 2) {
                xl = brent[1].first;
                yl = brent[1].second;
                x = brent[2].first;
                y = brent[2].second;
                xr = brent[3].first;
                yr = brent[3].second;
            } else {
                System.out.println("Puntos no estan en la configuracion correcta");
                return 0.0;
            }
            if (Math.abs(minvy - fmin) < (double)1.0E-6f) {
                return x;
            }
            fmin = minvy;
        }
        if (iteracion >= 10) {
            System.out.println("Demasiadas iteraciones en Brent");
            return 0.0;
        }
        return x;
    }

    public double EncuentraMinimoSimple() {
        int iteracion = 0;
        double x = -1.0;
        double yl = -1.0;
        double yr = -1.0;
        double y = -1.0;
        double xl = -1.0;
        double xr = -1.0;
        double xmin = 0.0;
        double ant_conv = 0.0;
        xl = -5.0;
        yl = this.g(xl);
        x = 0.0;
        y = this.g(0.0);
        xr = 5.0;
        yr = this.g(xr);
        while (xr - xl > (double)0.01f && iteracion < 10) {
            ++iteracion;
            double b12 = xl * xl - x * x;
            double b23 = x * x - xr * xr;
            double b31 = xr * xr - xl * xl;
            double a23 = x - xr;
            double a31 = xr - xl;
            double a12 = xl - x;
            double denominador = a23 * yl + a31 * y + a12 * yr;
            if (Math.abs(denominador) < (double)1.0E-9f) {
                return xmin;
            }
            double x4 = 0.5 * (b23 * yl + b31 * y + b12 * yr) / denominador;
            double y4 = this.g(x4);
            pair[] brent = new pair[]{new pair(xl, yl), new pair(x, y), new pair(xr, yr), new pair(x4, y4)};
            this.sort(brent, 4, 1);
            double maxvy = brent[0].second;
            int imaxvy = 0;
            double minvy = maxvy;
            int iminvy = imaxvy;
            for (int i = 1; i < 4; ++i) {
                if (maxvy < brent[i].second) {
                    maxvy = brent[i].second;
                    imaxvy = i;
                }
                if (!(minvy > brent[i].second)) continue;
                minvy = brent[i].second;
                iminvy = i;
            }
            if (imaxvy == 3) {
                xl = brent[0].first;
                yl = brent[0].second;
                x = brent[1].first;
                y = brent[1].second;
                xr = brent[2].first;
                yr = brent[2].second;
            } else if (imaxvy == 0) {
                xl = brent[1].first;
                yl = brent[1].second;
                x = brent[2].first;
                y = brent[2].second;
                xr = brent[3].first;
                yr = brent[3].second;
            } else if (imaxvy == 1) {
                xl = brent[0].first;
                yl = brent[0].second;
                x = brent[2].first;
                y = brent[2].second;
                xr = brent[3].first;
                yr = brent[3].second;
            } else if (imaxvy == 2) {
                xl = brent[0].first;
                yl = brent[0].second;
                x = brent[1].first;
                y = brent[1].second;
                xr = brent[3].first;
                yr = brent[3].second;
            }
            xmin = brent[iminvy].first;
            if (yl + y + yr >= ant_conv && iteracion > 1) {
                return xmin;
            }
            ant_conv = yl + y + yr;
        }
        if (iteracion >= 10) {
            return xmin;
        }
        return xmin;
    }

    class pair {
        double first;
        double second;

        pair() {
            this.first = 0.0;
            this.second = 0.0;
        }

        pair(double x, double y) {
            this.first = x;
            this.second = y;
        }
    }
}

