/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.C45_Binarization;

import java.util.ArrayList;
import keel.Algorithms.Decision_Trees.C45_Binarization.BTS;
import keel.Algorithms.Decision_Trees.C45_Binarization.ENN;
import keel.Algorithms.Decision_Trees.C45_Binarization.Multiclassifier;
import keel.Algorithms.Decision_Trees.C45_Binarization.Nesting;
import keel.Dataset.Attributes;
import org.core.Files;

public class OVO {
    Multiclassifier classifier;
    int nClasses;
    int count;
    String sOvo;
    BTS bts;
    Nesting nesting;
    double[][] tablas;
    int kvecinos;
    ENN metodo;
    boolean test;
    boolean dynOVO;

    public OVO(Multiclassifier classifier, String sOvo, boolean dynOVO) {
        this.classifier = classifier;
        this.nClasses = classifier.nClasses;
        this.sOvo = sOvo;
        this.dynOVO = dynOVO;
        System.out.println("go to computeClassScores");
        try {
            this.computeClassScores(null);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        System.out.println("finished computeClassScores");
        System.out.println("Finishing operations...");
        if (sOvo.equals("BTS")) {
            this.bts = new BTS(classifier, classifier.threshold, this);
        } else if (sOvo.equals("NESTING")) {
            this.nesting = new Nesting(classifier, this);
        }
        this.tablas = new double[classifier.train.getnData()][this.nClasses * this.nClasses];
        this.kvecinos = this.nClasses;
        this.createConfFile();
        this.metodo = new ENN("ENNConf.txt");
        System.out.println("OVO CREATED!");
    }

    private void createConfFile() {
        String content = new String();
        String train = this.classifier.input_validation_name;
        String test = this.classifier.input_test_name;
        content = content + "algorithm = Decremental Reduction Optimization Procedure 3\n";
        content = content + "inputData = \"" + train + "\" \"" + test + "\" \"tst.dat\"\n";
        content = content + "outputData = \"training.txt\" \"tstOutput.dat\"\n\n";
        content = content + "Number of Neighbors = 3\n";
        content = content + "Distance Function = HVDM\n";
        Files.writeFile("ENNConf.txt", content);
    }

    public void clearTables(boolean test) {
        this.count = 0;
        this.test = test;
    }

    public void classifierTrainFinished() {
        if (this.sOvo.equals("BTS")) {
            this.bts.initialize();
            this.bts.construct();
        }
    }

    protected String computeClassScores(double[] example) {
        String output = new String("?");
        if (this.sOvo.equals("DDAG")) {
            return this.computeClassDDAG(example);
        }
        if (this.sOvo.equals("BTS")) {
            return this.bts.computeClass(example);
        }
        double[][] tabla = this.classifier.ovo_table(example);
        for (int i = 0; i < this.nClasses; ++i) {
            for (int j = 0; j < this.nClasses; ++j) {
                this.tablas[this.count][j + i * this.nClasses] = tabla[i][j];
            }
        }
        double[] max = null;
        if (this.sOvo.equals("VOTE")) {
            max = this.computeClassScoresVote(tabla);
        } else if (this.sOvo.equals("WEIGHTED")) {
            max = this.computeClassScoresWeighted(this.tablas[this.count]);
        } else if (this.sOvo.equals("PC")) {
            max = this.computeClassScoresPC(tabla);
        } else if (this.sOvo.equals("ND")) {
            max = this.computeClassScoresND(tabla);
        } else if (this.sOvo.equals("LVPC")) {
            max = this.computeClassScoresLVPC(tabla);
        } else if (this.sOvo.equalsIgnoreCase("WuJMLR")) {
            max = this.method2WuJMLR(tabla);
        } else if (this.sOvo.equals("NESTING")) {
            max = this.computeClassScoresVote(tabla);
            int nMax = 1;
            double maxi = max[0];
            for (int i = 1; i < max.length; ++i) {
                if (maxi < max[i]) {
                    maxi = max[i];
                    nMax = 1;
                    continue;
                }
                if (maxi != max[i]) continue;
                ++nMax;
            }
            if (this.nesting.creating && nMax > 1) {
                System.out.println("There is a Tie!");
                return "tie";
            }
            if (nMax > 1) {
                output = this.nesting.method.ovo.computeClassScores(example);
                return output;
            }
        } else {
            System.out.println("The OVO method is not correct");
            System.exit(-1);
        }
        if (this.dynOVO) {
            return this.computeClassScoresDynamic(this.count++);
        }
        output = this.getOutputTies(max);
        return output;
    }

    protected String computeClassDDAG(double[] example) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < this.nClasses; ++i) {
            list.add(new Integer(i));
        }
        int eliminado = -1;
        while (list.size() != 1) {
            for (int i = 0; i < list.size() - 1 && eliminado == -1; ++i) {
                for (int j = list.size() - 1; j > i && eliminado == -1; --j) {
                    int y;
                    int x = (Integer)list.get(i);
                    int clase = this.classifier.obtainClass(x, y = ((Integer)list.get(j)).intValue(), example);
                    if (clase == x) {
                        eliminado = (Integer)list.remove(list.size() - 1);
                        continue;
                    }
                    if (clase != y) continue;
                    eliminado = (Integer)list.remove(0);
                }
            }
            if (eliminado == -1) {
                double[] max = new double[this.nClasses];
                for (int k = 1; k < this.nClasses; ++k) {
                    if (!list.contains(new Integer(k))) continue;
                    max[k] = 1.0;
                }
                return this.getOutputTies(max);
            }
            eliminado = -1;
        }
        return this.classifier.train.getOutputValue((Integer)list.get(0));
    }

    protected double[] computeClassScoresVote(double[][] tabla) {
        double[] max = new double[this.nClasses];
        for (int i = 0; i < this.nClasses; ++i) {
            double sum_clase = 0.0;
            for (int j = 0; j < this.nClasses; ++j) {
                sum_clase += tabla[i][j] > tabla[j][i] ? 1.0 : 0.0;
            }
            max[i] = sum_clase;
        }
        return max;
    }

    protected double[] computeClassScoresWeighted(double[][] tabla) {
        double[] max = new double[tabla.length];
        for (int i = 0; i < tabla.length; ++i) {
            double sum_clase = 0.0;
            for (int j = 0; j < tabla.length; ++j) {
                sum_clase += tabla[i][j];
            }
            max[i] = sum_clase / (double)tabla.length;
        }
        return max;
    }

    protected double[] computeClassScoresPC(double[][] r) {
        boolean changed;
        double[][] n = new double[this.nClasses][this.nClasses];
        for (int i = 0; i < r.length; ++i) {
            for (int j = 0; j < r.length; ++j) {
                n[i][j] = this.classifier.train.numberOfExamples(i) + this.classifier.train.numberOfExamples(j);
                if (r[i][j] != 0.0 || r[j][i] != 0.0 || i == j) continue;
                r[j][i] = 0.5;
                r[i][j] = 0.5;
            }
        }
        double[] p = new double[r.length];
        for (int i = 0; i < p.length; ++i) {
            for (int j = 0; j < p.length; ++j) {
                if (i == j) continue;
                int n2 = i;
                p[n2] = p[n2] + r[i][j];
            }
            p[i] = p[i] * (2.0 / (double)this.nClasses) / (double)(this.nClasses - 1);
        }
        double[][] u = new double[r.length][r.length];
        for (int i = 0; i < r.length; ++i) {
            for (int j = i + 1; j < r.length; ++j) {
                u[i][j] = p[i] / (p[i] + p[j]);
            }
        }
        double[] firstSum = new double[p.length];
        for (int i = 0; i < p.length; ++i) {
            for (int j = i + 1; j < p.length; ++j) {
                int n3 = i;
                firstSum[n3] = firstSum[n3] + n[i][j] * r[i][j];
                int n4 = j;
                firstSum[n4] = firstSum[n4] + n[i][j] * (1.0 - r[i][j]);
            }
        }
        do {
            int i;
            changed = false;
            double[] secondSum = new double[p.length];
            for (i = 0; i < p.length; ++i) {
                for (int j = i + 1; j < p.length; ++j) {
                    int n5 = i;
                    secondSum[n5] = secondSum[n5] + n[i][j] * u[i][j];
                    int n6 = j;
                    secondSum[n6] = secondSum[n6] + n[i][j] * (1.0 - u[i][j]);
                }
            }
            for (i = 0; i < p.length; ++i) {
                if (firstSum[i] == 0.0 || secondSum[i] == 0.0) {
                    if (p[i] > 0.0) {
                        changed = true;
                    }
                    p[i] = 0.0;
                    continue;
                }
                double factor = firstSum[i] / secondSum[i];
                double pOld = p[i];
                int n7 = i;
                p[n7] = p[n7] * factor;
                if (!(Math.abs(pOld - p[i]) > 0.001)) continue;
                changed = true;
            }
            OVO.normalize(p);
            for (i = 0; i < r.length; ++i) {
                for (int j = i + 1; j < r.length; ++j) {
                    u[i][j] = p[i] / (p[i] + p[j]);
                }
            }
        } while (changed);
        return p;
    }

    private double[] method2WuJMLR(double[][] r) {
        int j;
        int t;
        int k = this.nClasses;
        double[] p = new double[k];
        int iter = 0;
        int max_iter = Math.max(100, k);
        double[][] Q = new double[k][k];
        double[] Qp = new double[k];
        double eps = 0.005 / (double)k;
        for (int i = 0; i < r.length; ++i) {
            for (int i2 = 0; i2 < r.length; ++i2) {
                if (i != i2 && r[i][i2] == 0.0 & r[i2][i] == 0.0) {
                    r[i][i2] = 0.5;
                    r[i2][i] = 1.0 - r[i][i2];
                }
                if (i == i2 || r[i][i2] != 0.0) continue;
                r[i][i2] = 1.0E-15;
                r[i2][i] = 1.0 - r[i][i2];
            }
        }
        for (t = 0; t < k; ++t) {
            p[t] = 1.0 / (double)k;
            Q[t][t] = 0.0;
            for (j = 0; j < t; ++j) {
                double[] dArray = Q[t];
                int n = t;
                dArray[n] = dArray[n] + r[j][t] * r[j][t];
                Q[t][j] = Q[j][t];
            }
            for (j = t + 1; j < k; ++j) {
                double[] dArray = Q[t];
                int n = t;
                dArray[n] = dArray[n] + r[j][t] * r[j][t];
                Q[t][j] = -r[j][t] * r[t][j];
            }
        }
        for (iter = 0; iter < max_iter; ++iter) {
            double pQp = 0.0;
            for (t = 0; t < k; ++t) {
                Qp[t] = 0.0;
                for (j = 0; j < k; ++j) {
                    int n = t;
                    Qp[n] = Qp[n] + Q[t][j] * p[j];
                }
                pQp += p[t] * Qp[t];
            }
            double max_error = 0.0;
            for (t = 0; t < k; ++t) {
                double error = Math.abs(Qp[t] - pQp);
                if (!(error > max_error)) continue;
                max_error = error;
            }
            if (max_error < eps) break;
            for (t = 0; t < k; ++t) {
                double diff = (-Qp[t] + pQp) / Q[t][t];
                int n = t;
                p[n] = p[n] + diff;
                pQp = (pQp + diff * (diff * Q[t][t] + 2.0 * Qp[t])) / (1.0 + diff) / (1.0 + diff);
                j = 0;
                while (j < k) {
                    Qp[j] = (Qp[j] + diff * Q[t][j]) / (1.0 + diff);
                    int n2 = j++;
                    p[n2] = p[n2] / (1.0 + diff);
                }
            }
        }
        if (iter >= max_iter) {
            System.out.println("Exceeds max_iter in multiclass_prob\n");
        }
        return p;
    }

    protected double[] computeClassScoresND(double[][] tabla) {
        for (int x = 0; x < this.nClasses; ++x) {
            for (int y = x + 1; y < this.nClasses; ++y) {
                double aux_tabla = tabla[x][y];
                double[] dArray = tabla[x];
                int n = y;
                dArray[n] = dArray[n] - tabla[y][x];
                double[] dArray2 = tabla[y];
                int n2 = x;
                dArray2[n2] = dArray2[n2] - aux_tabla;
                if (tabla[x][y] < 0.0) {
                    tabla[x][y] = 0.0;
                }
                if (!(tabla[y][x] < 0.0)) continue;
                tabla[y][x] = 0.0;
            }
        }
        double[] max = new double[this.nClasses];
        for (int i = 0; i < this.nClasses; ++i) {
            double max_clase = -1.0;
            for (int j = 0; j < this.nClasses; ++j) {
                if (!(tabla[j][i] > max_clase)) continue;
                max_clase = tabla[j][i];
            }
            max[i] = 1.0 - max_clase;
        }
        return max;
    }

    protected double[] computeClassScoresLVPC(double[][] tabla) {
        double[][][] relationSet = this.relationsForInstance(tabla);
        double[][] preferenceRelation = relationSet[0];
        double[][] conflictRelation = relationSet[1];
        double[][] ignoranceRelation = relationSet[2];
        double[] classScores = new double[preferenceRelation.length];
        for (int i = 0; i < preferenceRelation.length; ++i) {
            for (int j = 0; j < preferenceRelation[i].length; ++j) {
                if (i == j) continue;
                int n = i;
                classScores[n] = classScores[n] + (preferenceRelation[i][j] + conflictRelation[i][j] * 0.5 + ignoranceRelation[i][j] * (this.classifier.aprioriClassDistribution[i] / (this.classifier.aprioriClassDistribution[i] + this.classifier.aprioriClassDistribution[j])));
            }
            if (!Double.isNaN(classScores[i])) continue;
            classScores[i] = 0.0;
        }
        if (this.sum(classScores) == 0.0) {
            return classScores;
        }
        OVO.normalize(classScores);
        return classScores;
    }

    protected double[] computeClassScoresWeighted(double[] tabla) {
        double[] max = new double[this.nClasses];
        for (int i = 0; i < this.nClasses; ++i) {
            double sum_clase = 0.0;
            for (int j = 0; j < this.nClasses; ++j) {
                sum_clase += tabla[i * this.nClasses + j];
            }
            max[i] = sum_clase / (double)this.nClasses;
        }
        return max;
    }

    protected String computeClassScoresDynamic(int i) {
        double[] max;
        int j;
        String output = "?";
        double[] tabla = this.tablas[i];
        boolean distEu = true;
        if (Attributes.hasNominalAttributes()) {
            distEu = false;
        }
        if (Attributes.hasRealAttributes() || Attributes.hasIntegerAttributes()) {
            distEu = true;
        }
        int kvecinosAux = this.kvecinos = this.nClasses * 3;
        this.metodo.setK(this.kvecinos);
        int[] vecinos = null;
        int[] votos = null;
        double[] distancias = null;
        int classesInNeighborhood = 0;
        double limit = 1.0;
        while ((double)classesInNeighborhood <= limit && kvecinosAux <= this.kvecinos * 2) {
            vecinos = new int[kvecinosAux];
            distancias = new double[kvecinosAux];
            votos = new int[this.nClasses];
            this.metodo.evaluaKNN(i, vecinos, distancias, votos, this.test, distEu);
            classesInNeighborhood = 0;
            for (int j2 = 0; j2 < votos.length; ++j2) {
                if (votos[j2] <= 0) continue;
                ++classesInNeighborhood;
            }
            this.metodo.setK(++kvecinosAux);
        }
        double[] probs = new double[this.nClasses];
        double sum_probs = 0.0;
        int nClassesTest = 0;
        for (j = 0; j < vecinos.length; ++j) {
            if (vecinos[j] == -1) continue;
            int n = this.classifier.train.getOutputAsInteger()[vecinos[j]];
            probs[n] = probs[n] + 1.0 / distancias[j];
            sum_probs += 1.0 / distancias[j];
        }
        if (sum_probs > 0.0) {
            j = 0;
            while (j < this.nClasses) {
                if (votos[j] > 0) {
                    ++nClassesTest;
                }
                int n = j++;
                probs[n] = probs[n] / sum_probs;
            }
        }
        double[][] tablaNew = new double[nClassesTest][nClassesTest];
        int fila = 0;
        if (sum_probs > 0.0) {
            max = new double[this.nClasses];
            for (int j3 = 0; j3 < this.nClasses; ++j3) {
                double sum_clase = 0.0;
                double tot = 0.0;
                if (votos[j3] > 0) {
                    int columna = 0;
                    for (int k = 0; k < this.nClasses; ++k) {
                        if (votos[k] > 0) {
                            sum_clase += tabla[j3 * this.nClasses + k];
                            tot += 1.0;
                            tablaNew[fila][columna] = tabla[j3 * this.nClasses + k];
                            ++columna;
                            continue;
                        }
                        tabla[j3 * this.nClasses + k] = 0.0;
                    }
                    ++fila;
                } else {
                    for (int k = 0; k < this.nClasses; ++k) {
                        tabla[j3 * this.nClasses + k] = 0.0;
                    }
                }
                max[j3] = tot != 0.0 ? sum_clase / tot : -1.0;
            }
            double[] max2 = null;
            max2 = this.computeClassScoresWeighted(tablaNew);
            fila = 0;
            max = new double[this.nClasses];
            for (int j4 = 0; j4 < this.nClasses; ++j4) {
                if (votos[j4] > 0) {
                    max[j4] = max2[fila];
                    ++fila;
                    continue;
                }
                max[j4] = -1.0;
            }
        } else {
            max = this.computeClassScoresWeighted(tabla);
        }
        output = this.getOutputTies(max);
        return output;
    }

    protected String computeClassScoresOVA(double[] example) {
        String output = new String("?");
        double[] grado_asoc = this.classifier.ova_table(example);
        output = this.getOutputTies(grado_asoc);
        return output;
    }

    public double[][][] relationsForInstance(double[][] tabla) {
        double[][] prefRelation = new double[this.nClasses][this.nClasses];
        double[][] conflictRelation = new double[this.nClasses][this.nClasses];
        double[][] ignoranceRelation = new double[this.nClasses][this.nClasses];
        for (int x = 0; x < this.nClasses; ++x) {
            for (int y = 0; y < this.nClasses; ++y) {
                double s0 = tabla[x][y];
                double s1 = tabla[y][x];
                double min = s0 < s1 ? s0 : s1;
                double max = s0 > s1 ? s0 : s1;
                prefRelation[x][y] = s0 - min;
                prefRelation[y][x] = s1 - min;
                conflictRelation[x][y] = min;
                conflictRelation[y][x] = min;
                ignoranceRelation[x][y] = 1.0 - max;
                ignoranceRelation[y][x] = 1.0 - max;
            }
        }
        return new double[][][]{prefRelation, conflictRelation, ignoranceRelation};
    }

    String getOutputTies(double[] max) {
        double maxValue = max[this.maxIndex(max)];
        double[] ties = new double[max.length];
        for (int i = 0; i < max.length; ++i) {
            if (max[i] != maxValue) continue;
            ties[i] = this.classifier.aprioriClassDistribution[i];
        }
        max = new double[max.length];
        max[this.maxIndex((double[])ties)] = 1.0;
        int tieValues = 0;
        maxValue = ties[this.maxIndex(ties)];
        for (int i = 0; i < ties.length; ++i) {
            if (ties[i] != maxValue) continue;
            ++tieValues;
        }
        if (tieValues > 1) {
            tieValues = 0;
            maxValue = ties[this.maxIndex(ties)];
            int[] stillTying = new int[ties.length];
            for (int i = 0; i < max.length; ++i) {
                if (ties[i] != maxValue) continue;
                stillTying[tieValues] = i;
                ++tieValues;
            }
            return this.classifier.train.getOutputValue(stillTying[0]);
        }
        return this.classifier.train.getOutputValue(this.maxIndex(max));
    }

    public static void normalize(double[] doubles) {
        double sum = 0.0;
        for (int i = 0; i < doubles.length; ++i) {
            if (Double.isNaN(doubles[i])) continue;
            sum += doubles[i];
        }
        OVO.normalize(doubles, sum);
    }

    public static void normalize(double[] doubles, double sum) {
        if (Double.isNaN(sum)) {
            throw new IllegalArgumentException("Can't normalize array. Sum is NaN.");
        }
        if (sum == 0.0) {
            return;
        }
        int i = 0;
        while (i < doubles.length) {
            int n = i++;
            doubles[n] = doubles[n] / sum;
        }
    }

    double sum(double[] array) {
        double sum = 0.0;
        for (int i = 0; i < array.length; ++i) {
            sum += array[i];
        }
        return sum;
    }

    int maxIndex(double[] array) {
        double max = array[0];
        int index = 0;
        for (int i = 1; i < array.length; ++i) {
            if (!(array[i] > max)) continue;
            max = array[i];
            index = i;
        }
        return index;
    }
}

