/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.Instance_Selection.POP;

import java.util.Arrays;
import java.util.StringTokenizer;
import keel.Algorithms.Preprocess.Basic.Metodo;
import keel.Algorithms.Preprocess.Basic.OutputIS;
import keel.Algorithms.Preprocess.Basic.Referencia;
import keel.Dataset.Attributes;
import org.core.Fichero;

public class POP
extends Metodo {
    public POP(String ficheroScript) {
        super(ficheroScript);
    }

    public void ejecutar() {
        int l;
        int j;
        int i;
        long tiempo = System.currentTimeMillis();
        int nClases = 0;
        for (i = 0; i < this.clasesTrain.length; ++i) {
            if (this.clasesTrain[i] <= nClases) continue;
            nClases = this.clasesTrain[i];
        }
        ++nClases;
        boolean[] marcas = new boolean[this.datosTrain.length];
        int[] weakness = new int[this.datosTrain.length];
        Object[] linea = new Referencia[this.datosTrain.length];
        for (i = 0; i < this.datosTrain.length; ++i) {
            marcas[i] = true;
            weakness[i] = 0;
        }
        int nSel = this.datosTrain.length;
        for (i = 0; i < this.datosTrain[0].length; ++i) {
            if (Attributes.getInputAttribute(i).getType() == 0) continue;
            for (j = 0; j < this.datosTrain.length; ++j) {
                linea[j] = new Referencia(j, this.realTrain[j][i]);
            }
            Arrays.sort(linea);
            for (j = 1; j < this.datosTrain.length - 1; ++j) {
                if (this.clasesTrain[((Referencia)linea[j - 1]).entero] != this.clasesTrain[((Referencia)linea[j]).entero] || this.clasesTrain[((Referencia)linea[j + 1]).entero] != this.clasesTrain[((Referencia)linea[j]).entero]) continue;
                int n = ((Referencia)linea[j]).entero;
                weakness[n] = weakness[n] + 1;
            }
        }
        for (i = 0; i < this.datosTrain[0].length; ++i) {
            if (Attributes.getInputAttribute(i).getType() != 0) continue;
            for (j = 0; j < Attributes.getInputAttribute(i).getNumNominalValues(); ++j) {
                int minWeak = Integer.MAX_VALUE;
                for (l = 0; l < this.datosTrain.length; ++l) {
                    if (this.nominalTrain[l][i] != j || weakness[l] >= minWeak) continue;
                    minWeak = weakness[l];
                }
                for (l = 0; l < this.datosTrain.length; ++l) {
                    if (this.nominalTrain[l][i] != j || weakness[l] <= minWeak) continue;
                    int n = l;
                    weakness[n] = weakness[n] + 1;
                }
            }
        }
        for (i = 0; i < this.datosTrain.length; ++i) {
            if (weakness[i] != this.datosTrain[0].length) continue;
            marcas[i] = false;
            --nSel;
        }
        double[][] conjS = new double[nSel][this.datosTrain[0].length];
        double[][] conjR = new double[nSel][this.datosTrain[0].length];
        int[][] conjN = new int[nSel][this.datosTrain[0].length];
        boolean[][] conjM = new boolean[nSel][this.datosTrain[0].length];
        int[] clasesS = new int[nSel];
        l = 0;
        for (i = 0; i < this.datosTrain.length; ++i) {
            if (!marcas[i]) continue;
            for (j = 0; j < this.datosTrain[0].length; ++j) {
                conjS[l][j] = this.datosTrain[i][j];
                conjR[l][j] = this.realTrain[i][j];
                conjN[l][j] = this.nominalTrain[i][j];
                conjM[l][j] = this.nulosTrain[i][j];
            }
            clasesS[l] = this.clasesTrain[i];
            ++l;
        }
        System.out.println("POP " + this.relation + " " + (double)(System.currentTimeMillis() - tiempo) / 1000.0 + "s");
        OutputIS.escribeSalida(this.ficheroSalida[0], conjR, conjN, conjM, clasesS, this.entradas, this.salida, this.nEntradas, this.relation);
        OutputIS.escribeSalida(this.ficheroSalida[1], this.test, this.entradas, this.salida, this.nEntradas, this.relation);
    }

    @Override
    public void leerConfiguracion(String ficheroScript) {
        this.ficheroSalida = new String[2];
        String fichero = Fichero.leeFichero(ficheroScript);
        StringTokenizer lineasFichero = new StringTokenizer(fichero, "\n\r");
        lineasFichero.nextToken();
        String linea = lineasFichero.nextToken();
        StringTokenizer tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        String token = tokens.nextToken();
        byte[] line = token.getBytes();
        int i = 0;
        while (line[i] != 34) {
            ++i;
        }
        int j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroTraining = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroTest = new String(line, i, j - i);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        token = tokens.nextToken();
        line = token.getBytes();
        i = 0;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroSalida[0] = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroSalida[1] = new String(line, i, j - i);
    }
}

