/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.Slipper;

import java.io.IOException;
import keel.Algorithms.Rule_Learning.Slipper.Mask;
import keel.Algorithms.Rule_Learning.Slipper.Rule;
import keel.Algorithms.Rule_Learning.Slipper.Ruleset;
import keel.Algorithms.Rule_Learning.Slipper.SimpleRule;
import keel.Algorithms.Rule_Learning.Slipper.Utilities;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;

public class MyDataset {
    public static final int REAL = 0;
    public static final int INTEGER = 1;
    public static final int NOMINAL = 2;
    private double[][] X = null;
    private boolean[][] missing = null;
    private int[] outputInteger = null;
    private double[] outputReal = null;
    private String[] output = null;
    private double[] emax;
    private double[] emin;
    private int nData;
    private int nVars;
    private int nInputs;
    private int nClasses;
    private InstanceSet IS = new InstanceSet();
    private double[] stdev;
    private double[] average;
    private int[] instancesCl;

    public double[][] getX() {
        return this.X;
    }

    public double[] getExample(int pos) {
        return this.X[pos];
    }

    public double[] getExample(Mask mask) {
        return this.X[mask.getIndex()];
    }

    public int[] getOutputAsInteger() {
        int[] output = new int[this.outputInteger.length];
        for (int i = 0; i < this.outputInteger.length; ++i) {
            output[i] = this.outputInteger[i];
        }
        return output;
    }

    public double[] getOutputAsReal() {
        double[] output = new double[this.outputReal.length];
        for (int i = 0; i < this.outputReal.length; ++i) {
            output[i] = this.outputInteger[i];
        }
        return output;
    }

    public String[] getOutputAsString() {
        String[] output = new String[this.output.length];
        for (int i = 0; i < this.output.length; ++i) {
            output[i] = this.output[i];
        }
        return output;
    }

    public String getOutputAsString(int pos) {
        return this.output[pos];
    }

    public int getOutputAsInteger(int pos) {
        return this.outputInteger[pos];
    }

    public double getOutputAsReal(int pos) {
        return this.outputReal[pos];
    }

    public double[] getemax() {
        return this.emax;
    }

    public double[] getemin() {
        return this.emin;
    }

    public double getMax(int variable) {
        return this.emax[variable];
    }

    public double getMin(int variable) {
        return this.emin[variable];
    }

    public int getnData() {
        return this.nData;
    }

    public int getnVars() {
        return this.nVars;
    }

    public int getnInputs() {
        return this.nInputs;
    }

    public int getnClasses() {
        return this.nClasses;
    }

    public boolean isMissing(int i, int j) {
        return this.missing[i][j];
    }

    public boolean isMissing(Mask mask, int j) {
        return this.missing[mask.getIndex()][j];
    }

    public void readClassificationSet(String datasetFile, boolean train) throws IOException {
        try {
            this.IS.readSet(datasetFile, train);
            this.nData = this.IS.getNumInstances();
            this.nInputs = Attributes.getInputNumAttributes();
            this.nVars = this.nInputs + Attributes.getOutputNumAttributes();
            if (Attributes.getOutputNumAttributes() > 1) {
                System.out.println("This algorithm can not process MIMO datasets");
                System.out.println("All outputs but the first one will be removed");
                System.exit(1);
            }
            boolean noOutputs = false;
            if (Attributes.getOutputNumAttributes() < 1) {
                System.out.println("This algorithm can not process datasets without outputs");
                System.out.println("Zero-valued output generated");
                noOutputs = true;
                System.exit(1);
            }
            this.X = new double[this.nData][this.nInputs];
            this.missing = new boolean[this.nData][this.nInputs];
            this.outputInteger = new int[this.nData];
            this.outputReal = new double[this.nData];
            this.output = new String[this.nData];
            this.emax = new double[this.nInputs];
            this.emin = new double[this.nInputs];
            this.nClasses = 0;
            for (int i = 0; i < this.nData; ++i) {
                Instance inst = this.IS.getInstance(i);
                for (int j = 0; j < this.nInputs; ++j) {
                    this.X[i][j] = this.IS.getInputNumericValue(i, j);
                    this.missing[i][j] = inst.getInputMissingValues(j);
                    if (this.X[i][j] > this.emax[j] || i == 0) {
                        this.emax[j] = this.X[i][j];
                    }
                    if (!(this.X[i][j] < this.emin[j]) && i != 0) continue;
                    this.emin[j] = this.X[i][j];
                }
                if (noOutputs) {
                    this.outputInteger[i] = 0;
                    this.output[i] = "";
                } else {
                    this.outputInteger[i] = (int)this.IS.getOutputNumericValue(i, 0);
                    this.output[i] = this.IS.getOutputNominalValue(i, 0);
                }
                if (this.outputInteger[i] <= this.nClasses) continue;
                this.nClasses = this.outputInteger[i];
            }
            ++this.nClasses;
            System.out.println("Number of classes=" + this.nClasses);
        }
        catch (Exception e) {
            System.out.println("DBG: Exception in readSet");
            e.printStackTrace();
        }
        this.computeStatistics();
        this.computeInstancesPerClass();
    }

    public void readRegressionSet(String datasetFile, boolean train) throws IOException {
        try {
            this.IS.readSet(datasetFile, train);
            this.nData = this.IS.getNumInstances();
            this.nInputs = Attributes.getInputNumAttributes();
            this.nVars = this.nInputs + Attributes.getOutputNumAttributes();
            if (Attributes.getOutputNumAttributes() > 1) {
                System.out.println("This algorithm can not process MIMO datasets");
                System.out.println("All outputs but the first one will be removed");
                System.exit(1);
            }
            boolean noOutputs = false;
            if (Attributes.getOutputNumAttributes() < 1) {
                System.out.println("This algorithm can not process datasets without outputs");
                System.out.println("Zero-valued output generated");
                noOutputs = true;
                System.exit(1);
            }
            this.X = new double[this.nData][this.nInputs];
            this.missing = new boolean[this.nData][this.nInputs];
            this.outputInteger = new int[this.nData];
            this.emax = new double[this.nInputs];
            this.emin = new double[this.nInputs];
            this.nClasses = 0;
            for (int i = 0; i < this.nData; ++i) {
                Instance inst = this.IS.getInstance(i);
                for (int j = 0; j < this.nInputs; ++j) {
                    this.X[i][j] = this.IS.getInputNumericValue(i, j);
                    this.missing[i][j] = inst.getInputMissingValues(j);
                    if (this.X[i][j] > this.emax[j] || i == 0) {
                        this.emax[j] = this.X[i][j];
                    }
                    if (!(this.X[i][j] < this.emin[j]) && i != 0) continue;
                    this.emin[j] = this.X[i][j];
                }
                if (noOutputs) {
                    this.outputInteger[i] = 0;
                    this.outputReal[i] = 0;
                    continue;
                }
                this.outputReal[i] = this.IS.getOutputNumericValue(i, 0);
                this.outputInteger[i] = (int)this.outputReal[i];
            }
        }
        catch (Exception e) {
            System.out.println("DBG: Exception in readSet");
            e.printStackTrace();
        }
        this.computeStatistics();
    }

    public String copyHeader() {
        String p = new String("");
        p = "@relation " + Attributes.getRelationName() + "\n";
        p = p + Attributes.getInputAttributesHeader();
        p = p + Attributes.getOutputAttributesHeader();
        p = p + Attributes.getInputHeader() + "\n";
        p = p + Attributes.getOutputHeader() + "\n";
        p = p + "@data\n";
        return p;
    }

    public void normalize() {
        int atts = this.getnInputs();
        double[] maxs = new double[atts];
        for (int j = 0; j < atts; ++j) {
            maxs[j] = 1.0 / (this.emax[j] - this.emin[j]);
        }
        for (int i = 0; i < this.getnData(); ++i) {
            for (int j = 0; j < atts; ++j) {
                if (this.isMissing(i, j)) continue;
                this.X[i][j] = (this.X[i][j] - this.emin[j]) * maxs[j];
            }
        }
    }

    public boolean hasRealAttributes() {
        return Attributes.hasRealAttributes();
    }

    public boolean hasNumericalAttributes() {
        return Attributes.hasIntegerAttributes() || Attributes.hasRealAttributes();
    }

    public boolean hasMissingAttributes() {
        return this.sizeWithoutMissing() < this.getnData();
    }

    public int sizeWithoutMissing() {
        int tam = 0;
        for (int i = 0; i < this.nData; ++i) {
            int j;
            for (j = 1; j < this.nInputs && !this.isMissing(i, j); ++j) {
            }
            if (j != this.nInputs) continue;
            ++tam;
        }
        return tam;
    }

    public int size() {
        return this.nData;
    }

    private void computeStatistics() {
        this.stdev = new double[this.getnVars()];
        this.average = new double[this.getnVars()];
        int i = 0;
        while (i < this.getnInputs()) {
            this.average[i] = 0.0;
            for (int j = 0; j < this.getnData(); ++j) {
                if (this.isMissing(j, i)) continue;
                int n = i;
                this.average[n] = this.average[n] + this.X[j][i];
            }
            int n = i++;
            this.average[n] = this.average[n] / (double)this.getnData();
        }
        this.average[this.average.length - 1] = 0.0;
        for (int j = 0; j < this.outputReal.length; ++j) {
            int n = this.average.length - 1;
            this.average[n] = this.average[n] + this.outputReal[j];
        }
        int n = this.average.length - 1;
        this.average[n] = this.average[n] / (double)this.outputReal.length;
        for (i = 0; i < this.getnInputs(); ++i) {
            double sum = 0.0;
            for (int j = 0; j < this.getnData(); ++j) {
                if (this.isMissing(j, i)) continue;
                sum += (this.X[j][i] - this.average[i]) * (this.X[j][i] - this.average[i]);
            }
            this.stdev[i] = Math.sqrt(sum /= (double)this.getnData());
        }
        double sum = 0.0;
        for (int j = 0; j < this.outputReal.length; ++j) {
            sum += (this.outputReal[j] - this.average[this.average.length - 1]) * (this.outputReal[j] - this.average[this.average.length - 1]);
        }
        this.stdev[this.stdev.length - 1] = Math.sqrt(sum /= (double)this.outputReal.length);
    }

    public double stdDev(int position) {
        return this.stdev[position];
    }

    public double average(int position) {
        return this.average[position];
    }

    public void computeInstancesPerClass() {
        this.instancesCl = new int[this.nClasses];
        for (int i = 0; i < this.getnData(); ++i) {
            int n = this.outputInteger[i];
            this.instancesCl[n] = this.instancesCl[n] + 1;
        }
    }

    public int numberInstances(int clas) {
        return this.instancesCl[clas];
    }

    public int numberValues(int attribute) {
        return Attributes.getInputAttribute(attribute).getNumNominalValues();
    }

    public String getOutputValue(int intValue) {
        return Attributes.getOutputAttribute(0).getNominalValue(intValue);
    }

    public double[][] devuelveRangos() {
        double[][] rangos = new double[this.getnVars()][2];
        for (int i = 0; i < this.getnInputs(); ++i) {
            if (Attributes.getInputAttribute(i).getNumNominalValues() > 0) {
                rangos[i][0] = 0.0;
                rangos[i][1] = Attributes.getInputAttribute(i).getNumNominalValues() - 1;
                continue;
            }
            rangos[i][0] = Attributes.getInputAttribute(i).getMinAttribute();
            rangos[i][1] = Attributes.getInputAttribute(i).getMaxAttribute();
        }
        rangos[this.getnVars() - 1][0] = Attributes.getOutputAttribute(0).getMinAttribute();
        rangos[this.getnVars() - 1][1] = Attributes.getOutputAttribute(0).getMaxAttribute();
        return rangos;
    }

    public void filter(Mask mask, int A, double V, int operator) {
        mask.resetIndex();
        while (mask.next()) {
            if (this.isMissing(mask, A)) {
                mask.reset();
                continue;
            }
            if (operator == Rule.EQUAL && this.X[mask.getIndex()][A] != V) {
                mask.reset();
            }
            if (operator == Rule.GREATER && this.X[mask.getIndex()][A] <= V) {
                mask.reset();
            }
            if (operator != Rule.LOWER || !(this.X[mask.getIndex()][A] > V)) continue;
            mask.reset();
        }
    }

    public void filter(Mask mask, SimpleRule sr) {
        this.filter(mask, sr.getAttribute(), sr.getValue(), sr.getOperator());
    }

    public void filter(Mask mask, Rule rule) {
        for (int i = 0; i < rule.size(); ++i) {
            this.filter(mask, rule.getSimpleRule(i));
        }
    }

    public void filter(Mask mask, Ruleset rules) {
        int i;
        double[] confidence = new double[this.size()];
        for (i = 0; i < this.size(); ++i) {
            confidence[i] = rules.getDefaultCr();
        }
        for (i = 0; i < rules.size(); ++i) {
            Mask current = mask.copy();
            this.filter(current, rules.getRule(i));
            current.resetIndex();
            while (current.next()) {
                int n = current.getIndex();
                confidence[n] = confidence[n] + rules.getRule(i).getCr();
            }
        }
        Mask filtered = new Mask(this.size(), false);
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (!Utilities.gr(confidence[i2], 0.0) || !mask.isActive(i2)) continue;
            filtered.set(i2, true);
        }
        filtered.copyTo(mask);
    }

    public void filterByClass(Mask mask, String value) {
        mask.resetIndex();
        while (mask.next()) {
            if (this.output[mask.getIndex()].equals(value)) continue;
            mask.reset();
        }
    }

    public void substract(Mask mask, int A, double V, int operator) {
        mask.resetIndex();
        while (mask.next()) {
            if (this.isMissing(mask, A)) continue;
            if (operator == Rule.EQUAL && this.X[mask.getIndex()][A] == V) {
                mask.reset();
            }
            if (operator == Rule.GREATER && this.X[mask.getIndex()][A] > V) {
                mask.reset();
            }
            if (operator != Rule.LOWER || !(this.X[mask.getIndex()][A] <= V)) continue;
            mask.reset();
        }
    }

    public void substract(Mask mask, SimpleRule sr) {
        this.substract(mask, sr.getAttribute(), sr.getValue(), sr.getOperator());
    }

    public void substract(Mask mask, Rule rule) {
        mask.resetIndex();
        while (mask.next()) {
            boolean seguir = true;
            for (int i = 0; i < rule.size() && seguir; ++i) {
                int A = rule.getSimpleRule(i).getAttribute();
                double V = rule.getSimpleRule(i).getValue();
                int operator = rule.getSimpleRule(i).getOperator();
                if (this.isMissing(mask, A)) {
                    seguir = false;
                    continue;
                }
                if (operator == Rule.EQUAL) {
                    boolean bl = seguir = this.X[mask.getIndex()][A] == V;
                }
                if (rule.getSimpleRule(i).getOperator() == Rule.GREATER) {
                    boolean bl = seguir = this.X[mask.getIndex()][A] > V;
                }
                if (rule.getSimpleRule(i).getOperator() != Rule.LOWER) continue;
                seguir = this.X[mask.getIndex()][A] <= V;
            }
            if (!seguir) continue;
            mask.reset();
        }
    }

    public void substract(Mask mask, Ruleset rules) {
        int i;
        double[] confidence = new double[this.size()];
        for (i = 0; i < this.size(); ++i) {
            confidence[i] = rules.getDefaultCr();
        }
        for (i = 0; i < rules.size(); ++i) {
            Mask current = mask.copy();
            this.filter(current, rules.getRule(i));
            current.resetIndex();
            while (current.next()) {
                int n = current.getIndex();
                confidence[n] = confidence[n] + rules.getRule(i).getCr();
            }
        }
        Mask substracted = mask.copy();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (!Utilities.gr(confidence[i2], 0.0) || !mask.isActive(i2)) continue;
            substracted.set(i2, false);
        }
        substracted.copyTo(mask);
    }

    public void substract(Mask mask, Ruleset rules, int ignore) {
        for (int i = 0; i < rules.size(); ++i) {
            if (i == ignore) continue;
            this.substract(mask, rules.getRule(i));
        }
    }

    public String[] classify(Mask actives, Ruleset[] rulesets, int length) {
        int i;
        String[] classification = new String[this.getnData()];
        for (i = 0; i < classification.length; ++i) {
            if (!actives.isActive(i)) continue;
            classification[i] = rulesets[length - 1].getType();
        }
        for (i = 0; i < length - 1; ++i) {
            Mask filtered = actives.copy();
            this.filter(filtered, rulesets[i]);
            filtered.resetIndex();
            while (filtered.next()) {
                int ind = filtered.getIndex();
                classification[ind] = rulesets[i].getType();
            }
            this.substract(actives, rulesets[i]);
        }
        return classification;
    }

    public String[] classify(Ruleset[] rulesets, int length) {
        return this.classify(new Mask(this.size()), rulesets, length);
    }

    public String toString() {
        String salida = "";
        for (int i = 0; i < this.nData; ++i) {
            salida = Attributes.getInputAttribute(0).getType() == 0 ? salida + i + ".- (" + Attributes.getInputAttribute(0).getNominalValue((int)this.X[i][0]) : salida + i + ".- (" + this.X[i][0];
            for (int j = 1; j < this.nInputs; ++j) {
                salida = Attributes.getInputAttribute(j).getType() == 0 ? salida + "," + Attributes.getInputAttribute(j).getNominalValue((int)this.X[i][j]) : salida + "," + this.X[i][j];
            }
            salida = salida + ") ->" + this.output[i] + "\n";
        }
        return salida;
    }

    public String toString(Mask mask) {
        String salida = "";
        mask.resetIndex();
        while (mask.next()) {
            int i = mask.getIndex();
            salida = Attributes.getInputAttribute(0).getType() == 0 ? salida + i + ".- (" + Attributes.getInputAttribute(0).getNominalValue((int)this.X[i][0]) : salida + i + ".- (" + this.X[i][0];
            for (int j = 1; j < this.nInputs; ++j) {
                salida = Attributes.getInputAttribute(j).getType() == 0 ? salida + "," + Attributes.getInputAttribute(j).getNominalValue((int)this.X[i][j]) : salida + "," + this.X[i][j];
            }
            salida = salida + ")->" + this.output[i] + "\n";
        }
        return salida;
    }

    public String toString(Mask mask, double[] distribution) {
        String salida = "";
        mask.resetIndex();
        while (mask.next()) {
            int i = mask.getIndex();
            salida = Attributes.getInputAttribute(0).getType() == 0 ? salida + i + ".- (" + Attributes.getInputAttribute(0).getNominalValue((int)this.X[i][0]) : salida + i + ".- (" + this.X[i][0];
            for (int j = 1; j < this.nInputs; ++j) {
                salida = Attributes.getInputAttribute(j).getType() == 0 ? salida + "," + Attributes.getInputAttribute(j).getNominalValue((int)this.X[i][j]) : salida + "," + this.X[i][j];
            }
            salida = salida + ")->" + this.output[i] + " w: " + distribution[i] + "\n";
        }
        return salida;
    }
}

