/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.algorithm;

import ec.tstoolkit.design.IntValue;

public enum ProcQuality implements IntValue
{
    Accepted(-1),
    Undefined(0),
    Error(1),
    Severe(2),
    Bad(3),
    Uncertain(4),
    Good(5);

    private final int value;

    public static ProcQuality valueOf(int value) {
        return IntValue.valueOf(ProcQuality.class, value).orElse(null);
    }

    public boolean isAtLeast(ProcQuality quality) {
        return this.value > 0 && this.value >= quality.value;
    }

    public boolean isLower(ProcQuality quality) {
        return this.value > 0 && this.value < quality.value;
    }

    private ProcQuality(int value) {
        this.value = value;
    }

    @Override
    public int intValue() {
        return this.value;
    }
}

