/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import org.h2.mvstore.MVMap;
import org.h2.mvstore.Page;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.ObjectDataType;

public class MVMapConcurrent<K, V>
extends MVMap<K, V> {
    public MVMapConcurrent(DataType dataType, DataType dataType2) {
        super(dataType, dataType2);
    }

    @Override
    protected Page copyOnWrite(Page page, long l) {
        return page.copy(l);
    }

    @Override
    protected void checkConcurrentWrite() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K k, V v) {
        this.beforeWrite();
        try {
            this.get(k);
            long l = this.writeVersion;
            MVMapConcurrent mVMapConcurrent = this;
            synchronized (mVMapConcurrent) {
                Page page = this.copyOnWrite(this.root, l);
                page = this.splitRootIfNeeded(page, l);
                Object object = this.put(page, l, k, v);
                this.newRoot(page);
                Object object2 = object;
                return (V)object2;
            }
        }
        finally {
            this.afterWrite();
        }
    }

    @Override
    protected void waitUntilWritten(long l) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object object) {
        this.beforeWrite();
        try {
            Object object2 = this.get(object);
            if (object2 == null) {
                V v = null;
                return v;
            }
            long l = this.writeVersion;
            Object object3 = this;
            synchronized (object3) {
                Page page = this.copyOnWrite(this.root, l);
                object2 = this.remove(page, l, object);
                if (!page.isLeaf() && page.getTotalCount() == 0L) {
                    page.removePage();
                    page = Page.createEmpty(this, page.getVersion());
                }
                this.newRoot(page);
            }
            object3 = object2;
            return (V)object3;
        }
        finally {
            this.afterWrite();
        }
    }

    public static class Builder<K, V>
    implements MVMap.MapBuilder<MVMapConcurrent<K, V>, K, V> {
        protected DataType keyType;
        protected DataType valueType;

        public Builder<K, V> keyType(DataType dataType) {
            this.keyType = dataType;
            return this;
        }

        public Builder<K, V> valueType(DataType dataType) {
            this.valueType = dataType;
            return this;
        }

        @Override
        public MVMapConcurrent<K, V> create() {
            if (this.keyType == null) {
                this.keyType = new ObjectDataType();
            }
            if (this.valueType == null) {
                this.valueType = new ObjectDataType();
            }
            return new MVMapConcurrent(this.keyType, this.valueType);
        }
    }
}

